import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface UserBaseSchemaPropertyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Subschema unique string identifier.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema_property.html#index UserBaseSchemaProperty#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * SubSchema profile manager, if not set it will inherit its setting.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema_property.html#master UserBaseSchemaProperty#master}
     *
     * @stability stable
     */
    readonly master?: string;
    /**
     * The validation pattern to use for the subschema. Must be in form of '.+', or '[<pattern>]+' if present.'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema_property.html#pattern UserBaseSchemaProperty#pattern}
     *
     * @stability stable
     */
    readonly pattern?: string;
    /**
     * SubSchema permissions: HIDE, READ_ONLY, or READ_WRITE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema_property.html#permissions UserBaseSchemaProperty#permissions}
     *
     * @stability stable
     */
    readonly permissions?: string;
    /**
     * Whether the subschema is required.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema_property.html#required UserBaseSchemaProperty#required}
     *
     * @stability stable
     */
    readonly required?: boolean | cdktf.IResolvable;
    /**
     * Subschema title (display name).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema_property.html#title UserBaseSchemaProperty#title}
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * Subschema type: string, boolean, number, integer, array, or object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema_property.html#type UserBaseSchemaProperty#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Custom subschema user type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema_property.html#user_type UserBaseSchemaProperty#user_type}
     *
     * @stability stable
     */
    readonly userType?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema_property.html okta_user_base_schema_property}.
 *
 * @stability stable
 */
export declare class UserBaseSchemaProperty extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_base_schema_property.html okta_user_base_schema_property} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: UserBaseSchemaPropertyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _master?;
    /**
     * @stability stable
     */
    get master(): string;
    /**
     * @stability stable
     */
    set master(value: string);
    /**
     * @stability stable
     */
    resetMaster(): void;
    /**
     * @stability stable
     */
    get masterInput(): string | undefined;
    private _pattern?;
    /**
     * @stability stable
     */
    get pattern(): string;
    /**
     * @stability stable
     */
    set pattern(value: string);
    /**
     * @stability stable
     */
    resetPattern(): void;
    /**
     * @stability stable
     */
    get patternInput(): string | undefined;
    private _permissions?;
    /**
     * @stability stable
     */
    get permissions(): string;
    /**
     * @stability stable
     */
    set permissions(value: string);
    /**
     * @stability stable
     */
    resetPermissions(): void;
    /**
     * @stability stable
     */
    get permissionsInput(): string | undefined;
    private _required?;
    /**
     * @stability stable
     */
    get required(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set required(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequired(): void;
    /**
     * @stability stable
     */
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userType?;
    /**
     * @stability stable
     */
    get userType(): string;
    /**
     * @stability stable
     */
    set userType(value: string);
    /**
     * @stability stable
     */
    resetUserType(): void;
    /**
     * @stability stable
     */
    get userTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
