import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface UserFactorQuestionConfig extends cdktf.TerraformMetaArguments {
    /**
     * User password security answer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_factor_question.html#answer UserFactorQuestion#answer}
     *
     * @stability stable
     */
    readonly answer: string;
    /**
     * Unique key for question.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_factor_question.html#key UserFactorQuestion#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * ID of a Okta User.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_factor_question.html#user_id UserFactorQuestion#user_id}
     *
     * @stability stable
     */
    readonly userId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_factor_question.html okta_user_factor_question}.
 *
 * @stability stable
 */
export declare class UserFactorQuestion extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_factor_question.html okta_user_factor_question} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: UserFactorQuestionConfig);
    private _answer?;
    /**
     * @stability stable
     */
    get answer(): string;
    /**
     * @stability stable
     */
    set answer(value: string);
    /**
     * @stability stable
     */
    get answerInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get text(): string;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    set userId(value: string);
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
