import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface UserGroupMembershipsConfig extends cdktf.TerraformMetaArguments {
    /**
     * The list of Okta group IDs which the user should have membership managed for.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_group_memberships.html#groups UserGroupMemberships#groups}
     *
     * @stability stable
     */
    readonly groups: string[];
    /**
     * ID of a Okta User.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_group_memberships.html#user_id UserGroupMemberships#user_id}
     *
     * @stability stable
     */
    readonly userId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_group_memberships.html okta_user_group_memberships}.
 *
 * @stability stable
 */
export declare class UserGroupMemberships extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_group_memberships.html okta_user_group_memberships} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: UserGroupMembershipsConfig);
    private _groups?;
    /**
     * @stability stable
     */
    get groups(): string[];
    /**
     * @stability stable
     */
    set groups(value: string[]);
    /**
     * @stability stable
     */
    get groupsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    set userId(value: string);
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
