import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface UserSchemaConfig extends cdktf.TerraformMetaArguments {
    /**
     * Custom Subschema enumerated value of a property of type array.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#array_enum UserSchema#array_enum}
     *
     * @stability stable
     */
    readonly arrayEnum?: string[];
    /**
     * Subschema array type: string, number, integer, reference. Type field must be an array.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#array_type UserSchema#array_type}
     *
     * @stability stable
     */
    readonly arrayType?: string;
    /**
     * Custom Subschema description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#description UserSchema#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Custom Subschema enumerated value of the property. see: developer.okta.com/docs/api/resources/schemas#user-profile-schema-property-object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#enum UserSchema#enum}
     *
     * @stability stable
     */
    readonly enum?: string[];
    /**
     * Subschema external name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#external_name UserSchema#external_name}
     *
     * @stability stable
     */
    readonly externalName?: string;
    /**
     * Subschema external namespace.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#external_namespace UserSchema#external_namespace}
     *
     * @stability stable
     */
    readonly externalNamespace?: string;
    /**
     * Subschema unique string identifier.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#index UserSchema#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * SubSchema profile manager, if not set it will inherit its setting.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#master UserSchema#master}
     *
     * @stability stable
     */
    readonly master?: string;
    /**
     * Subschema of type string maximum length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#max_length UserSchema#max_length}
     *
     * @stability stable
     */
    readonly maxLength?: number;
    /**
     * Subschema of type string minimum length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#min_length UserSchema#min_length}
     *
     * @stability stable
     */
    readonly minLength?: number;
    /**
     * The validation pattern to use for the subschema. Must be in form of '.+', or '[<pattern>]+' if present.'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#pattern UserSchema#pattern}
     *
     * @stability stable
     */
    readonly pattern?: string;
    /**
     * SubSchema permissions: HIDE, READ_ONLY, or READ_WRITE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#permissions UserSchema#permissions}
     *
     * @stability stable
     */
    readonly permissions?: string;
    /**
     * Whether the subschema is required.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#required UserSchema#required}
     *
     * @stability stable
     */
    readonly required?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#scope UserSchema#scope}.
     *
     * @stability stable
     */
    readonly scope?: string;
    /**
     * Subschema title (display name).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#title UserSchema#title}
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * Subschema type: string, boolean, number, integer, array, or object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#type UserSchema#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Subschema unique restriction.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#unique UserSchema#unique}
     *
     * @stability stable
     */
    readonly unique?: string;
    /**
     * Custom subschema user type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#user_type UserSchema#user_type}
     *
     * @stability stable
     */
    readonly userType?: string;
    /**
     * array_one_of block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#array_one_of UserSchema#array_one_of}
     *
     * @stability stable
     */
    readonly arrayOneOf?: UserSchemaArrayOneOf[];
    /**
     * master_override_priority block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#master_override_priority UserSchema#master_override_priority}
     *
     * @stability stable
     */
    readonly masterOverridePriority?: UserSchemaMasterOverridePriority[];
    /**
     * one_of block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#one_of UserSchema#one_of}
     *
     * @stability stable
     */
    readonly oneOf?: UserSchemaOneOf[];
}
/**
 * @stability stable
 */
export interface UserSchemaArrayOneOf {
    /**
     * Enum value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#const UserSchema#const}
     *
     * @stability stable
     */
    readonly const: string;
    /**
     * Enum title.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#title UserSchema#title}
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function userSchemaArrayOneOfToTerraform(struct?: UserSchemaArrayOneOf): any;
/**
 * @stability stable
 */
export interface UserSchemaMasterOverridePriority {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#type UserSchema#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#value UserSchema#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function userSchemaMasterOverridePriorityToTerraform(struct?: UserSchemaMasterOverridePriority): any;
/**
 * @stability stable
 */
export interface UserSchemaOneOf {
    /**
     * Enum value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#const UserSchema#const}
     *
     * @stability stable
     */
    readonly const: string;
    /**
     * Enum title.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html#title UserSchema#title}
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function userSchemaOneOfToTerraform(struct?: UserSchemaOneOf): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html okta_user_schema}.
 *
 * @stability stable
 */
export declare class UserSchema extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_schema.html okta_user_schema} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: UserSchemaConfig);
    private _arrayEnum?;
    /**
     * @stability stable
     */
    get arrayEnum(): string[];
    /**
     * @stability stable
     */
    set arrayEnum(value: string[]);
    /**
     * @stability stable
     */
    resetArrayEnum(): void;
    /**
     * @stability stable
     */
    get arrayEnumInput(): string[] | undefined;
    private _arrayType?;
    /**
     * @stability stable
     */
    get arrayType(): string;
    /**
     * @stability stable
     */
    set arrayType(value: string);
    /**
     * @stability stable
     */
    resetArrayType(): void;
    /**
     * @stability stable
     */
    get arrayTypeInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enum?;
    /**
     * @stability stable
     */
    get enum(): string[];
    /**
     * @stability stable
     */
    set enum(value: string[]);
    /**
     * @stability stable
     */
    resetEnum(): void;
    /**
     * @stability stable
     */
    get enumInput(): string[] | undefined;
    private _externalName?;
    /**
     * @stability stable
     */
    get externalName(): string;
    /**
     * @stability stable
     */
    set externalName(value: string);
    /**
     * @stability stable
     */
    resetExternalName(): void;
    /**
     * @stability stable
     */
    get externalNameInput(): string | undefined;
    private _externalNamespace?;
    /**
     * @stability stable
     */
    get externalNamespace(): string;
    /**
     * @stability stable
     */
    set externalNamespace(value: string);
    /**
     * @stability stable
     */
    resetExternalNamespace(): void;
    /**
     * @stability stable
     */
    get externalNamespaceInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _master?;
    /**
     * @stability stable
     */
    get master(): string;
    /**
     * @stability stable
     */
    set master(value: string);
    /**
     * @stability stable
     */
    resetMaster(): void;
    /**
     * @stability stable
     */
    get masterInput(): string | undefined;
    private _maxLength?;
    /**
     * @stability stable
     */
    get maxLength(): number;
    /**
     * @stability stable
     */
    set maxLength(value: number);
    /**
     * @stability stable
     */
    resetMaxLength(): void;
    /**
     * @stability stable
     */
    get maxLengthInput(): number | undefined;
    private _minLength?;
    /**
     * @stability stable
     */
    get minLength(): number;
    /**
     * @stability stable
     */
    set minLength(value: number);
    /**
     * @stability stable
     */
    resetMinLength(): void;
    /**
     * @stability stable
     */
    get minLengthInput(): number | undefined;
    private _pattern?;
    /**
     * @stability stable
     */
    get pattern(): string;
    /**
     * @stability stable
     */
    set pattern(value: string);
    /**
     * @stability stable
     */
    resetPattern(): void;
    /**
     * @stability stable
     */
    get patternInput(): string | undefined;
    private _permissions?;
    /**
     * @stability stable
     */
    get permissions(): string;
    /**
     * @stability stable
     */
    set permissions(value: string);
    /**
     * @stability stable
     */
    resetPermissions(): void;
    /**
     * @stability stable
     */
    get permissionsInput(): string | undefined;
    private _required?;
    /**
     * @stability stable
     */
    get required(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set required(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequired(): void;
    /**
     * @stability stable
     */
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _unique?;
    /**
     * @stability stable
     */
    get unique(): string;
    /**
     * @stability stable
     */
    set unique(value: string);
    /**
     * @stability stable
     */
    resetUnique(): void;
    /**
     * @stability stable
     */
    get uniqueInput(): string | undefined;
    private _userType?;
    /**
     * @stability stable
     */
    get userType(): string;
    /**
     * @stability stable
     */
    set userType(value: string);
    /**
     * @stability stable
     */
    resetUserType(): void;
    /**
     * @stability stable
     */
    get userTypeInput(): string | undefined;
    private _arrayOneOf?;
    /**
     * @stability stable
     */
    get arrayOneOf(): UserSchemaArrayOneOf[];
    /**
     * @stability stable
     */
    set arrayOneOf(value: UserSchemaArrayOneOf[]);
    /**
     * @stability stable
     */
    resetArrayOneOf(): void;
    /**
     * @stability stable
     */
    get arrayOneOfInput(): UserSchemaArrayOneOf[] | undefined;
    private _masterOverridePriority?;
    /**
     * @stability stable
     */
    get masterOverridePriority(): UserSchemaMasterOverridePriority[];
    /**
     * @stability stable
     */
    set masterOverridePriority(value: UserSchemaMasterOverridePriority[]);
    /**
     * @stability stable
     */
    resetMasterOverridePriority(): void;
    /**
     * @stability stable
     */
    get masterOverridePriorityInput(): UserSchemaMasterOverridePriority[] | undefined;
    private _oneOf?;
    /**
     * @stability stable
     */
    get oneOf(): UserSchemaOneOf[];
    /**
     * @stability stable
     */
    set oneOf(value: UserSchemaOneOf[]);
    /**
     * @stability stable
     */
    resetOneOf(): void;
    /**
     * @stability stable
     */
    get oneOfInput(): UserSchemaOneOf[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
