import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface UserTypeConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description of the type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_type.html#description UserType#description}
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * The display name for the type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_type.html#display_name UserType#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The display name for the type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_type.html#name UserType#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_type.html okta_user_type}.
 *
 * @stability stable
 */
export declare class UserType extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_type.html okta_user_type} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: UserTypeConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
