import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
     * User Okta admin roles - ie. ['APP_ADMIN', 'USER_ADMIN'].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#admin_roles User#admin_roles}
     *
     * @stability stable
     */
    readonly adminRoles?: string[];
    /**
     * User city.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#city User#city}
     *
     * @stability stable
     */
    readonly city?: string;
    /**
     * User cost center.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#cost_center User#cost_center}
     *
     * @stability stable
     */
    readonly costCenter?: string;
    /**
     * User country code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#country_code User#country_code}
     *
     * @stability stable
     */
    readonly countryCode?: string;
    /**
     * JSON formatted custom attributes for a user. It must be JSON due to various types Okta allows.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#custom_profile_attributes User#custom_profile_attributes}
     *
     * @stability stable
     */
    readonly customProfileAttributes?: string;
    /**
     * User department.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#department User#department}
     *
     * @stability stable
     */
    readonly department?: string;
    /**
     * User display name, suitable to show end users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#display_name User#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * User division.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#division User#division}
     *
     * @stability stable
     */
    readonly division?: string;
    /**
     * User primary email address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#email User#email}
     *
     * @stability stable
     */
    readonly email: string;
    /**
     * User employee number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#employee_number User#employee_number}
     *
     * @stability stable
     */
    readonly employeeNumber?: string;
    /**
     * User first name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#first_name User#first_name}
     *
     * @stability stable
     */
    readonly firstName: string;
    /**
     * The groups that you want this user to be a part of.
     *
     * This can also be done via the group using the `users` property.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#group_memberships User#group_memberships}
     *
     * @stability stable
     */
    readonly groupMemberships?: string[];
    /**
     * User honorific prefix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#honorific_prefix User#honorific_prefix}
     *
     * @stability stable
     */
    readonly honorificPrefix?: string;
    /**
     * User honorific suffix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#honorific_suffix User#honorific_suffix}
     *
     * @stability stable
     */
    readonly honorificSuffix?: string;
    /**
     * User last name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#last_name User#last_name}
     *
     * @stability stable
     */
    readonly lastName: string;
    /**
     * User default location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#locale User#locale}
     *
     * @stability stable
     */
    readonly locale?: string;
    /**
     * User Okta login.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#login User#login}
     *
     * @stability stable
     */
    readonly login: string;
    /**
     * Manager of User.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#manager User#manager}
     *
     * @stability stable
     */
    readonly manager?: string;
    /**
     * Manager ID of User.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#manager_id User#manager_id}
     *
     * @stability stable
     */
    readonly managerId?: string;
    /**
     * User middle name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#middle_name User#middle_name}
     *
     * @stability stable
     */
    readonly middleName?: string;
    /**
     * User mobile phone number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#mobile_phone User#mobile_phone}
     *
     * @stability stable
     */
    readonly mobilePhone?: string;
    /**
     * User nickname.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#nick_name User#nick_name}
     *
     * @stability stable
     */
    readonly nickName?: string;
    /**
     * Old User Password. Should be only set in case the password was not changed using the provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#old_password User#old_password}
     *
     * @stability stable
     */
    readonly oldPassword?: string;
    /**
     * User organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#organization User#organization}
     *
     * @stability stable
     */
    readonly organization?: string;
    /**
     * User Password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#password User#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * When specified, the Password Inline Hook is triggered to handle verification of the end user's password the first time the user tries to sign in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#password_inline_hook User#password_inline_hook}
     *
     * @stability stable
     */
    readonly passwordInlineHook?: string;
    /**
     * User mailing address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#postal_address User#postal_address}
     *
     * @stability stable
     */
    readonly postalAddress?: string;
    /**
     * User preferred language.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#preferred_language User#preferred_language}
     *
     * @stability stable
     */
    readonly preferredLanguage?: string;
    /**
     * User primary phone number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#primary_phone User#primary_phone}
     *
     * @stability stable
     */
    readonly primaryPhone?: string;
    /**
     * User online profile (web page).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#profile_url User#profile_url}
     *
     * @stability stable
     */
    readonly profileUrl?: string;
    /**
     * User Password Recovery Answer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#recovery_answer User#recovery_answer}
     *
     * @stability stable
     */
    readonly recoveryAnswer?: string;
    /**
     * User Password Recovery Question.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#recovery_question User#recovery_question}
     *
     * @stability stable
     */
    readonly recoveryQuestion?: string;
    /**
     * User secondary email address, used for account recovery.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#second_email User#second_email}
     *
     * @stability stable
     */
    readonly secondEmail?: string;
    /**
     * User state or region.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#state User#state}
     *
     * @stability stable
     */
    readonly state?: string;
    /**
     * The status of the User in Okta - remove to set user back to active/provisioned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#status User#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * User street address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#street_address User#street_address}
     *
     * @stability stable
     */
    readonly streetAddress?: string;
    /**
     * User default timezone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#timezone User#timezone}
     *
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * User title.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#title User#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * User employee type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#user_type User#user_type}
     *
     * @stability stable
     */
    readonly userType?: string;
    /**
     * User zipcode or postal code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#zip_code User#zip_code}
     *
     * @stability stable
     */
    readonly zipCode?: string;
    /**
     * password_hash block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#password_hash User#password_hash}
     *
     * @stability stable
     */
    readonly passwordHash?: UserPasswordHash;
}
/**
 * @stability stable
 */
export interface UserPasswordHash {
    /**
     * The algorithm used to generate the hash using the password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#algorithm User#algorithm}
     *
     * @stability stable
     */
    readonly algorithm: string;
    /**
     * Only required for salted hashes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#salt User#salt}
     *
     * @stability stable
     */
    readonly salt?: string;
    /**
     * Specifies whether salt was pre- or postfixed to the password before hashing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#salt_order User#salt_order}
     *
     * @stability stable
     */
    readonly saltOrder?: string;
    /**
     * For SHA-512, SHA-256, SHA-1, MD5, This is the actual base64-encoded hash of the password (and salt, if used).
     *
     * This is the Base64 encoded value of the SHA-512/SHA-256/SHA-1/MD5 digest that was computed by either pre-fixing or post-fixing the salt to the password, depending on the saltOrder. If a salt was not used in the source system, then this should just be the the Base64 encoded value of the password's SHA-512/SHA-256/SHA-1/MD5 digest. For BCRYPT, This is the actual radix64-encoded hashed password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#value User#value}
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * Governs the strength of the hash and the time required to compute it. Only required for BCRYPT algorithm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user.html#work_factor User#work_factor}
     *
     * @stability stable
     */
    readonly workFactor?: number;
}
export declare function userPasswordHashToTerraform(struct?: UserPasswordHashOutputReference | UserPasswordHash): any;
/**
 * @stability stable
 */
export declare class UserPasswordHashOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): UserPasswordHash | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: UserPasswordHash | undefined);
    private _algorithm?;
    /**
     * @stability stable
     */
    get algorithm(): string;
    /**
     * @stability stable
     */
    set algorithm(value: string);
    /**
     * @stability stable
     */
    get algorithmInput(): string | undefined;
    private _salt?;
    /**
     * @stability stable
     */
    get salt(): string;
    /**
     * @stability stable
     */
    set salt(value: string);
    /**
     * @stability stable
     */
    resetSalt(): void;
    /**
     * @stability stable
     */
    get saltInput(): string | undefined;
    private _saltOrder?;
    /**
     * @stability stable
     */
    get saltOrder(): string;
    /**
     * @stability stable
     */
    set saltOrder(value: string);
    /**
     * @stability stable
     */
    resetSaltOrder(): void;
    /**
     * @stability stable
     */
    get saltOrderInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
    private _workFactor?;
    /**
     * @stability stable
     */
    get workFactor(): number;
    /**
     * @stability stable
     */
    set workFactor(value: number);
    /**
     * @stability stable
     */
    resetWorkFactor(): void;
    /**
     * @stability stable
     */
    get workFactorInput(): number | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/user.html okta_user}.
 *
 * @stability stable
 */
export declare class User extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user.html okta_user} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: UserConfig);
    private _adminRoles?;
    /**
     * @stability stable
     */
    get adminRoles(): string[];
    /**
     * @stability stable
     */
    set adminRoles(value: string[]);
    /**
     * @stability stable
     */
    resetAdminRoles(): void;
    /**
     * @stability stable
     */
    get adminRolesInput(): string[] | undefined;
    private _city?;
    /**
     * @stability stable
     */
    get city(): string;
    /**
     * @stability stable
     */
    set city(value: string);
    /**
     * @stability stable
     */
    resetCity(): void;
    /**
     * @stability stable
     */
    get cityInput(): string | undefined;
    private _costCenter?;
    /**
     * @stability stable
     */
    get costCenter(): string;
    /**
     * @stability stable
     */
    set costCenter(value: string);
    /**
     * @stability stable
     */
    resetCostCenter(): void;
    /**
     * @stability stable
     */
    get costCenterInput(): string | undefined;
    private _countryCode?;
    /**
     * @stability stable
     */
    get countryCode(): string;
    /**
     * @stability stable
     */
    set countryCode(value: string);
    /**
     * @stability stable
     */
    resetCountryCode(): void;
    /**
     * @stability stable
     */
    get countryCodeInput(): string | undefined;
    private _customProfileAttributes?;
    /**
     * @stability stable
     */
    get customProfileAttributes(): string;
    /**
     * @stability stable
     */
    set customProfileAttributes(value: string);
    /**
     * @stability stable
     */
    resetCustomProfileAttributes(): void;
    /**
     * @stability stable
     */
    get customProfileAttributesInput(): string | undefined;
    private _department?;
    /**
     * @stability stable
     */
    get department(): string;
    /**
     * @stability stable
     */
    set department(value: string);
    /**
     * @stability stable
     */
    resetDepartment(): void;
    /**
     * @stability stable
     */
    get departmentInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _division?;
    /**
     * @stability stable
     */
    get division(): string;
    /**
     * @stability stable
     */
    set division(value: string);
    /**
     * @stability stable
     */
    resetDivision(): void;
    /**
     * @stability stable
     */
    get divisionInput(): string | undefined;
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    private _employeeNumber?;
    /**
     * @stability stable
     */
    get employeeNumber(): string;
    /**
     * @stability stable
     */
    set employeeNumber(value: string);
    /**
     * @stability stable
     */
    resetEmployeeNumber(): void;
    /**
     * @stability stable
     */
    get employeeNumberInput(): string | undefined;
    private _firstName?;
    /**
     * @stability stable
     */
    get firstName(): string;
    /**
     * @stability stable
     */
    set firstName(value: string);
    /**
     * @stability stable
     */
    get firstNameInput(): string | undefined;
    private _groupMemberships?;
    /**
     * @stability stable
     */
    get groupMemberships(): string[];
    /**
     * @stability stable
     */
    set groupMemberships(value: string[]);
    /**
     * @stability stable
     */
    resetGroupMemberships(): void;
    /**
     * @stability stable
     */
    get groupMembershipsInput(): string[] | undefined;
    private _honorificPrefix?;
    /**
     * @stability stable
     */
    get honorificPrefix(): string;
    /**
     * @stability stable
     */
    set honorificPrefix(value: string);
    /**
     * @stability stable
     */
    resetHonorificPrefix(): void;
    /**
     * @stability stable
     */
    get honorificPrefixInput(): string | undefined;
    private _honorificSuffix?;
    /**
     * @stability stable
     */
    get honorificSuffix(): string;
    /**
     * @stability stable
     */
    set honorificSuffix(value: string);
    /**
     * @stability stable
     */
    resetHonorificSuffix(): void;
    /**
     * @stability stable
     */
    get honorificSuffixInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _lastName?;
    /**
     * @stability stable
     */
    get lastName(): string;
    /**
     * @stability stable
     */
    set lastName(value: string);
    /**
     * @stability stable
     */
    get lastNameInput(): string | undefined;
    private _locale?;
    /**
     * @stability stable
     */
    get locale(): string;
    /**
     * @stability stable
     */
    set locale(value: string);
    /**
     * @stability stable
     */
    resetLocale(): void;
    /**
     * @stability stable
     */
    get localeInput(): string | undefined;
    private _login?;
    /**
     * @stability stable
     */
    get login(): string;
    /**
     * @stability stable
     */
    set login(value: string);
    /**
     * @stability stable
     */
    get loginInput(): string | undefined;
    private _manager?;
    /**
     * @stability stable
     */
    get manager(): string;
    /**
     * @stability stable
     */
    set manager(value: string);
    /**
     * @stability stable
     */
    resetManager(): void;
    /**
     * @stability stable
     */
    get managerInput(): string | undefined;
    private _managerId?;
    /**
     * @stability stable
     */
    get managerId(): string;
    /**
     * @stability stable
     */
    set managerId(value: string);
    /**
     * @stability stable
     */
    resetManagerId(): void;
    /**
     * @stability stable
     */
    get managerIdInput(): string | undefined;
    private _middleName?;
    /**
     * @stability stable
     */
    get middleName(): string;
    /**
     * @stability stable
     */
    set middleName(value: string);
    /**
     * @stability stable
     */
    resetMiddleName(): void;
    /**
     * @stability stable
     */
    get middleNameInput(): string | undefined;
    private _mobilePhone?;
    /**
     * @stability stable
     */
    get mobilePhone(): string;
    /**
     * @stability stable
     */
    set mobilePhone(value: string);
    /**
     * @stability stable
     */
    resetMobilePhone(): void;
    /**
     * @stability stable
     */
    get mobilePhoneInput(): string | undefined;
    private _nickName?;
    /**
     * @stability stable
     */
    get nickName(): string;
    /**
     * @stability stable
     */
    set nickName(value: string);
    /**
     * @stability stable
     */
    resetNickName(): void;
    /**
     * @stability stable
     */
    get nickNameInput(): string | undefined;
    private _oldPassword?;
    /**
     * @stability stable
     */
    get oldPassword(): string;
    /**
     * @stability stable
     */
    set oldPassword(value: string);
    /**
     * @stability stable
     */
    resetOldPassword(): void;
    /**
     * @stability stable
     */
    get oldPasswordInput(): string | undefined;
    private _organization?;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    set organization(value: string);
    /**
     * @stability stable
     */
    resetOrganization(): void;
    /**
     * @stability stable
     */
    get organizationInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _passwordInlineHook?;
    /**
     * @stability stable
     */
    get passwordInlineHook(): string;
    /**
     * @stability stable
     */
    set passwordInlineHook(value: string);
    /**
     * @stability stable
     */
    resetPasswordInlineHook(): void;
    /**
     * @stability stable
     */
    get passwordInlineHookInput(): string | undefined;
    private _postalAddress?;
    /**
     * @stability stable
     */
    get postalAddress(): string;
    /**
     * @stability stable
     */
    set postalAddress(value: string);
    /**
     * @stability stable
     */
    resetPostalAddress(): void;
    /**
     * @stability stable
     */
    get postalAddressInput(): string | undefined;
    private _preferredLanguage?;
    /**
     * @stability stable
     */
    get preferredLanguage(): string;
    /**
     * @stability stable
     */
    set preferredLanguage(value: string);
    /**
     * @stability stable
     */
    resetPreferredLanguage(): void;
    /**
     * @stability stable
     */
    get preferredLanguageInput(): string | undefined;
    private _primaryPhone?;
    /**
     * @stability stable
     */
    get primaryPhone(): string;
    /**
     * @stability stable
     */
    set primaryPhone(value: string);
    /**
     * @stability stable
     */
    resetPrimaryPhone(): void;
    /**
     * @stability stable
     */
    get primaryPhoneInput(): string | undefined;
    private _profileUrl?;
    /**
     * @stability stable
     */
    get profileUrl(): string;
    /**
     * @stability stable
     */
    set profileUrl(value: string);
    /**
     * @stability stable
     */
    resetProfileUrl(): void;
    /**
     * @stability stable
     */
    get profileUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    get rawStatus(): string;
    private _recoveryAnswer?;
    /**
     * @stability stable
     */
    get recoveryAnswer(): string;
    /**
     * @stability stable
     */
    set recoveryAnswer(value: string);
    /**
     * @stability stable
     */
    resetRecoveryAnswer(): void;
    /**
     * @stability stable
     */
    get recoveryAnswerInput(): string | undefined;
    private _recoveryQuestion?;
    /**
     * @stability stable
     */
    get recoveryQuestion(): string;
    /**
     * @stability stable
     */
    set recoveryQuestion(value: string);
    /**
     * @stability stable
     */
    resetRecoveryQuestion(): void;
    /**
     * @stability stable
     */
    get recoveryQuestionInput(): string | undefined;
    private _secondEmail?;
    /**
     * @stability stable
     */
    get secondEmail(): string;
    /**
     * @stability stable
     */
    set secondEmail(value: string);
    /**
     * @stability stable
     */
    resetSecondEmail(): void;
    /**
     * @stability stable
     */
    get secondEmailInput(): string | undefined;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    resetState(): void;
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _streetAddress?;
    /**
     * @stability stable
     */
    get streetAddress(): string;
    /**
     * @stability stable
     */
    set streetAddress(value: string);
    /**
     * @stability stable
     */
    resetStreetAddress(): void;
    /**
     * @stability stable
     */
    get streetAddressInput(): string | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _userType?;
    /**
     * @stability stable
     */
    get userType(): string;
    /**
     * @stability stable
     */
    set userType(value: string);
    /**
     * @stability stable
     */
    resetUserType(): void;
    /**
     * @stability stable
     */
    get userTypeInput(): string | undefined;
    private _zipCode?;
    /**
     * @stability stable
     */
    get zipCode(): string;
    /**
     * @stability stable
     */
    set zipCode(value: string);
    /**
     * @stability stable
     */
    resetZipCode(): void;
    /**
     * @stability stable
     */
    get zipCodeInput(): string | undefined;
    private _passwordHash;
    /**
     * @stability stable
     */
    get passwordHash(): UserPasswordHashOutputReference;
    /**
     * @stability stable
     */
    putPasswordHash(value: UserPasswordHash): void;
    /**
     * @stability stable
     */
    resetPasswordHash(): void;
    /**
     * @stability stable
     */
    get passwordHashInput(): UserPasswordHash | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
