# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IpToSgtMappingArgs', 'IpToSgtMapping']

@pulumi.input_type
class IpToSgtMappingArgs:
    def __init__(__self__, *,
                 deploy_to: Optional[pulumi.Input[_builtins.str]] = None,
                 deploy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_group: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sgt: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IpToSgtMapping resource.
        :param pulumi.Input[_builtins.str] deploy_to: Mandatory unless `mapping_group` is set or unless `deploy_type` is `ALL`
        :param pulumi.Input[_builtins.str] deploy_type: Deploy Type
                 - Choices: `ALL`, `ND`, `NDG`
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] host_ip: Mandatory if `host_name` is empty
        :param pulumi.Input[_builtins.str] host_name: Mandatory if `host_ip` is empty
        :param pulumi.Input[_builtins.str] mapping_group: IP to SGT Mapping Group ID. Mandatory unless `sgt` and `deploy_to` and `deploy_type` are set
        :param pulumi.Input[_builtins.str] name: The name of the IP to SGT mapping
        :param pulumi.Input[_builtins.str] sgt: Trustsec Security Group ID. Mandatory unless `mapping_group` is set
        """
        if deploy_to is not None:
            pulumi.set(__self__, "deploy_to", deploy_to)
        if deploy_type is not None:
            pulumi.set(__self__, "deploy_type", deploy_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host_ip is not None:
            pulumi.set(__self__, "host_ip", host_ip)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if mapping_group is not None:
            pulumi.set(__self__, "mapping_group", mapping_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sgt is not None:
            pulumi.set(__self__, "sgt", sgt)

    @_builtins.property
    @pulumi.getter(name="deployTo")
    def deploy_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mandatory unless `mapping_group` is set or unless `deploy_type` is `ALL`
        """
        return pulumi.get(self, "deploy_to")

    @deploy_to.setter
    def deploy_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deploy_to", value)

    @_builtins.property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deploy Type
          - Choices: `ALL`, `ND`, `NDG`
        """
        return pulumi.get(self, "deploy_type")

    @deploy_type.setter
    def deploy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deploy_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="hostIp")
    def host_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mandatory if `host_name` is empty
        """
        return pulumi.get(self, "host_ip")

    @host_ip.setter
    def host_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_ip", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mandatory if `host_ip` is empty
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="mappingGroup")
    def mapping_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP to SGT Mapping Group ID. Mandatory unless `sgt` and `deploy_to` and `deploy_type` are set
        """
        return pulumi.get(self, "mapping_group")

    @mapping_group.setter
    def mapping_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mapping_group", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IP to SGT mapping
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def sgt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trustsec Security Group ID. Mandatory unless `mapping_group` is set
        """
        return pulumi.get(self, "sgt")

    @sgt.setter
    def sgt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sgt", value)


@pulumi.input_type
class _IpToSgtMappingState:
    def __init__(__self__, *,
                 deploy_to: Optional[pulumi.Input[_builtins.str]] = None,
                 deploy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_group: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sgt: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IpToSgtMapping resources.
        :param pulumi.Input[_builtins.str] deploy_to: Mandatory unless `mapping_group` is set or unless `deploy_type` is `ALL`
        :param pulumi.Input[_builtins.str] deploy_type: Deploy Type
                 - Choices: `ALL`, `ND`, `NDG`
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] host_ip: Mandatory if `host_name` is empty
        :param pulumi.Input[_builtins.str] host_name: Mandatory if `host_ip` is empty
        :param pulumi.Input[_builtins.str] mapping_group: IP to SGT Mapping Group ID. Mandatory unless `sgt` and `deploy_to` and `deploy_type` are set
        :param pulumi.Input[_builtins.str] name: The name of the IP to SGT mapping
        :param pulumi.Input[_builtins.str] sgt: Trustsec Security Group ID. Mandatory unless `mapping_group` is set
        """
        if deploy_to is not None:
            pulumi.set(__self__, "deploy_to", deploy_to)
        if deploy_type is not None:
            pulumi.set(__self__, "deploy_type", deploy_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host_ip is not None:
            pulumi.set(__self__, "host_ip", host_ip)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if mapping_group is not None:
            pulumi.set(__self__, "mapping_group", mapping_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sgt is not None:
            pulumi.set(__self__, "sgt", sgt)

    @_builtins.property
    @pulumi.getter(name="deployTo")
    def deploy_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mandatory unless `mapping_group` is set or unless `deploy_type` is `ALL`
        """
        return pulumi.get(self, "deploy_to")

    @deploy_to.setter
    def deploy_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deploy_to", value)

    @_builtins.property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deploy Type
          - Choices: `ALL`, `ND`, `NDG`
        """
        return pulumi.get(self, "deploy_type")

    @deploy_type.setter
    def deploy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deploy_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="hostIp")
    def host_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mandatory if `host_name` is empty
        """
        return pulumi.get(self, "host_ip")

    @host_ip.setter
    def host_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_ip", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mandatory if `host_ip` is empty
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="mappingGroup")
    def mapping_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP to SGT Mapping Group ID. Mandatory unless `sgt` and `deploy_to` and `deploy_type` are set
        """
        return pulumi.get(self, "mapping_group")

    @mapping_group.setter
    def mapping_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mapping_group", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IP to SGT mapping
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def sgt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trustsec Security Group ID. Mandatory unless `mapping_group` is set
        """
        return pulumi.get(self, "sgt")

    @sgt.setter
    def sgt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sgt", value)


@pulumi.type_token("ise:trustsec/ipToSgtMapping:IpToSgtMapping")
class IpToSgtMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deploy_to: Optional[pulumi.Input[_builtins.str]] = None,
                 deploy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_group: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sgt: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a TrustSec IP to SGT Mapping.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.trustsec.IpToSgtMapping("example",
            name="10.0.0.1/32",
            deploy_type="ALL",
            host_ip="10.0.0.1/32",
            sgt="93e1bf00-8c01-11e6-996c-525400b48521")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:trustsec/ipToSgtMapping:IpToSgtMapping example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] deploy_to: Mandatory unless `mapping_group` is set or unless `deploy_type` is `ALL`
        :param pulumi.Input[_builtins.str] deploy_type: Deploy Type
                 - Choices: `ALL`, `ND`, `NDG`
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] host_ip: Mandatory if `host_name` is empty
        :param pulumi.Input[_builtins.str] host_name: Mandatory if `host_ip` is empty
        :param pulumi.Input[_builtins.str] mapping_group: IP to SGT Mapping Group ID. Mandatory unless `sgt` and `deploy_to` and `deploy_type` are set
        :param pulumi.Input[_builtins.str] name: The name of the IP to SGT mapping
        :param pulumi.Input[_builtins.str] sgt: Trustsec Security Group ID. Mandatory unless `mapping_group` is set
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[IpToSgtMappingArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a TrustSec IP to SGT Mapping.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.trustsec.IpToSgtMapping("example",
            name="10.0.0.1/32",
            deploy_type="ALL",
            host_ip="10.0.0.1/32",
            sgt="93e1bf00-8c01-11e6-996c-525400b48521")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:trustsec/ipToSgtMapping:IpToSgtMapping example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param IpToSgtMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpToSgtMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deploy_to: Optional[pulumi.Input[_builtins.str]] = None,
                 deploy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_group: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sgt: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpToSgtMappingArgs.__new__(IpToSgtMappingArgs)

            __props__.__dict__["deploy_to"] = deploy_to
            __props__.__dict__["deploy_type"] = deploy_type
            __props__.__dict__["description"] = description
            __props__.__dict__["host_ip"] = host_ip
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["mapping_group"] = mapping_group
            __props__.__dict__["name"] = name
            __props__.__dict__["sgt"] = sgt
        super(IpToSgtMapping, __self__).__init__(
            'ise:trustsec/ipToSgtMapping:IpToSgtMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deploy_to: Optional[pulumi.Input[_builtins.str]] = None,
            deploy_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            host_ip: Optional[pulumi.Input[_builtins.str]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            mapping_group: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            sgt: Optional[pulumi.Input[_builtins.str]] = None) -> 'IpToSgtMapping':
        """
        Get an existing IpToSgtMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] deploy_to: Mandatory unless `mapping_group` is set or unless `deploy_type` is `ALL`
        :param pulumi.Input[_builtins.str] deploy_type: Deploy Type
                 - Choices: `ALL`, `ND`, `NDG`
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] host_ip: Mandatory if `host_name` is empty
        :param pulumi.Input[_builtins.str] host_name: Mandatory if `host_ip` is empty
        :param pulumi.Input[_builtins.str] mapping_group: IP to SGT Mapping Group ID. Mandatory unless `sgt` and `deploy_to` and `deploy_type` are set
        :param pulumi.Input[_builtins.str] name: The name of the IP to SGT mapping
        :param pulumi.Input[_builtins.str] sgt: Trustsec Security Group ID. Mandatory unless `mapping_group` is set
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpToSgtMappingState.__new__(_IpToSgtMappingState)

        __props__.__dict__["deploy_to"] = deploy_to
        __props__.__dict__["deploy_type"] = deploy_type
        __props__.__dict__["description"] = description
        __props__.__dict__["host_ip"] = host_ip
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["mapping_group"] = mapping_group
        __props__.__dict__["name"] = name
        __props__.__dict__["sgt"] = sgt
        return IpToSgtMapping(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deployTo")
    def deploy_to(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mandatory unless `mapping_group` is set or unless `deploy_type` is `ALL`
        """
        return pulumi.get(self, "deploy_to")

    @_builtins.property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Deploy Type
          - Choices: `ALL`, `ND`, `NDG`
        """
        return pulumi.get(self, "deploy_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hostIp")
    def host_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mandatory if `host_name` is empty
        """
        return pulumi.get(self, "host_ip")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mandatory if `host_ip` is empty
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="mappingGroup")
    def mapping_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IP to SGT Mapping Group ID. Mandatory unless `sgt` and `deploy_to` and `deploy_type` are set
        """
        return pulumi.get(self, "mapping_group")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the IP to SGT mapping
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def sgt(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Trustsec Security Group ID. Mandatory unless `mapping_group` is set
        """
        return pulumi.get(self, "sgt")

