PDFServices Python SDK
=======================

Adobe PDF Services SDK allows you to access RESTful APIs to create, convert, and manipulate PDFs within your applications. [Adobe PDF Services API](https://www.adobe.io/apis/documentcloud/dcsdk/pdf-tools.html) provides access to over 15 different services including:
- [Document Generation](https://www.adobe.io/apis/documentcloud/dcsdk/doc-generation.html): Build PDF and Word documents from Word templates and your own data
- Tag PDF files to make them more accessible.
- Electronically seal PDF documents for authenticity and origin
- Create PDF from HTML files, Microsoft Office docs (DOC, DOCX, XLS, SLX, PPT, PPTX), text files and images
- Convert PDF to DOC/DOCX, XLS, PPTX, RTF, PNG, and JPEG formats
- OCR PDF files to make the text editable and searchable
- Compress and linearize PDF files to reduce file size for better performance
- Password protect PDF files and secure them to restrict printing, editing, and copying content
- Combine and split PDF files
- Insert, replace, delete, rotate, and reorder pages in PDF files
- Extract text, images, tables, and more from native and scanned PDFs into a structured JSON file
- Get the properties of a PDF file like page count, PDF version, file size, compliance levels, font info, permissions and more
<br>


[Get started](https://www.adobe.com/go/dcsdks_credentials) for free now. For more details, please see our [usage limits and licensing page](https://www.adobe.com/go/pdfservices-licensing-and-usage-limits). If you are interested in scaling your operations, please see our [pricing page](https://www.adobe.com/go/pdfservices-pricing-page) for purchase options and volume discounts.

Learn more at our [documentation](https://www.adobe.com/go/pdfservicesapi_doc).

Installation
------------

* Install [Python](https://www.python.org/) 3.10 or higher. 
* pip install pdfservices-sdk

Resources
------------

* [QuickStart](https://www.adobe.com/go/pdftoolsapi_doc)
* [Samples](https://www.adobe.com/go/pdfservices_python_samples)
* [API Reference](https://www.adobe.com/go/pdfservices_python_docs)