<a id="mypy-boto3-route53resolver"></a>

# mypy-boto3-route53resolver

[![PyPI - mypy-boto3-route53resolver](https://img.shields.io/pypi/v/mypy-boto3-route53resolver.svg?color=blue)](https://pypi.org/project/mypy-boto3-route53resolver)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-route53resolver.svg?color=blue)](https://pypi.org/project/mypy-boto3-route53resolver)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-route53resolver?color=blue)](https://pypistats.org/packages/mypy-boto3-route53resolver)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Route53Resolver 1.18.43](https://boto3.amazonaws.com/v1/documentation/api/1.18.43/reference/services/route53resolver.html#Route53Resolver)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.3.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-route53resolver docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_route53resolver/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-route53resolver](#mypy-boto3-route53resolver)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Route53Resolver` service.

```bash
python -m pip install boto3-stubs[route53resolver]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[route53resolver]` in your environment:
  `python -m pip install 'boto3-stubs[route53resolver]'`

Both type checking and auto-complete should work for `Route53Resolver` service.
No explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[route53resolver]` in your environment:
  `python -m pip install 'boto3-stubs[route53resolver]'`

Both type checking and auto-complete should work for `Route53Resolver` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[route53resolver]` in your environment:
  `python -m pip install 'boto3-stubs[route53resolver]'`
- Run `mypy` as usual

Type checking should work for `Route53Resolver` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[route53resolver]` in your environment:
  `python -m pip install 'boto3-stubs[route53resolver]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Route53Resolver` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`Route53ResolverClient` provides annotations for
`boto3.client("route53resolver")`.

```python
import boto3

from mypy_boto3_route53resolver import Route53ResolverClient

client: Route53ResolverClient = boto3.client("route53resolver")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: Route53ResolverClient = session.client("route53resolver")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_route53resolver.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_route53resolver import Route53ResolverClient
from mypy_boto3_route53resolver.paginator import (
    ListFirewallConfigsPaginator,
    ListFirewallDomainListsPaginator,
    ListFirewallDomainsPaginator,
    ListFirewallRuleGroupAssociationsPaginator,
    ListFirewallRuleGroupsPaginator,
    ListFirewallRulesPaginator,
    ListResolverDnssecConfigsPaginator,
    ListResolverEndpointIpAddressesPaginator,
    ListResolverEndpointsPaginator,
    ListResolverQueryLogConfigAssociationsPaginator,
    ListResolverQueryLogConfigsPaginator,
    ListResolverRuleAssociationsPaginator,
    ListResolverRulesPaginator,
    ListTagsForResourcePaginator,
)

client: Route53ResolverClient = boto3.client("route53resolver")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_firewall_configs_paginator: ListFirewallConfigsPaginator = client.get_paginator("list_firewall_configs")
list_firewall_domain_lists_paginator: ListFirewallDomainListsPaginator = client.get_paginator("list_firewall_domain_lists")
list_firewall_domains_paginator: ListFirewallDomainsPaginator = client.get_paginator("list_firewall_domains")
list_firewall_rule_group_associations_paginator: ListFirewallRuleGroupAssociationsPaginator = client.get_paginator("list_firewall_rule_group_associations")
list_firewall_rule_groups_paginator: ListFirewallRuleGroupsPaginator = client.get_paginator("list_firewall_rule_groups")
list_firewall_rules_paginator: ListFirewallRulesPaginator = client.get_paginator("list_firewall_rules")
list_resolver_dnssec_configs_paginator: ListResolverDnssecConfigsPaginator = client.get_paginator("list_resolver_dnssec_configs")
list_resolver_endpoint_ip_addresses_paginator: ListResolverEndpointIpAddressesPaginator = client.get_paginator("list_resolver_endpoint_ip_addresses")
list_resolver_endpoints_paginator: ListResolverEndpointsPaginator = client.get_paginator("list_resolver_endpoints")
list_resolver_query_log_config_associations_paginator: ListResolverQueryLogConfigAssociationsPaginator = client.get_paginator("list_resolver_query_log_config_associations")
list_resolver_query_log_configs_paginator: ListResolverQueryLogConfigsPaginator = client.get_paginator("list_resolver_query_log_configs")
list_resolver_rule_associations_paginator: ListResolverRuleAssociationsPaginator = client.get_paginator("list_resolver_rule_associations")
list_resolver_rules_paginator: ListResolverRulesPaginator = client.get_paginator("list_resolver_rules")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
```

<a id="literals"></a>

### Literals

`mypy_boto3_route53resolver.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_route53resolver.literals import (
    ActionType,
    BlockOverrideDnsTypeType,
    BlockResponseType,
    FirewallDomainImportOperationType,
    FirewallDomainListStatusType,
    FirewallDomainUpdateOperationType,
    FirewallFailOpenStatusType,
    FirewallRuleGroupAssociationStatusType,
    FirewallRuleGroupStatusType,
    IpAddressStatusType,
    ListFirewallConfigsPaginatorName,
    ListFirewallDomainListsPaginatorName,
    ListFirewallDomainsPaginatorName,
    ListFirewallRuleGroupAssociationsPaginatorName,
    ListFirewallRuleGroupsPaginatorName,
    ListFirewallRulesPaginatorName,
    ListResolverDnssecConfigsPaginatorName,
    ListResolverEndpointIpAddressesPaginatorName,
    ListResolverEndpointsPaginatorName,
    ListResolverQueryLogConfigAssociationsPaginatorName,
    ListResolverQueryLogConfigsPaginatorName,
    ListResolverRuleAssociationsPaginatorName,
    ListResolverRulesPaginatorName,
    ListTagsForResourcePaginatorName,
    MutationProtectionStatusType,
    ResolverDNSSECValidationStatusType,
    ResolverEndpointDirectionType,
    ResolverEndpointStatusType,
    ResolverQueryLogConfigAssociationErrorType,
    ResolverQueryLogConfigAssociationStatusType,
    ResolverQueryLogConfigStatusType,
    ResolverRuleAssociationStatusType,
    ResolverRuleStatusType,
    RuleTypeOptionType,
    ShareStatusType,
    SortOrderType,
    ValidationType,
    ServiceName,
)

def check_value(value: ActionType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_route53resolver.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_route53resolver.type_defs import (
    AssociateFirewallRuleGroupRequestRequestTypeDef,
    AssociateFirewallRuleGroupResponseTypeDef,
    AssociateResolverEndpointIpAddressRequestRequestTypeDef,
    AssociateResolverEndpointIpAddressResponseTypeDef,
    AssociateResolverQueryLogConfigRequestRequestTypeDef,
    AssociateResolverQueryLogConfigResponseTypeDef,
    AssociateResolverRuleRequestRequestTypeDef,
    AssociateResolverRuleResponseTypeDef,
    CreateFirewallDomainListRequestRequestTypeDef,
    CreateFirewallDomainListResponseTypeDef,
    CreateFirewallRuleGroupRequestRequestTypeDef,
    CreateFirewallRuleGroupResponseTypeDef,
    CreateFirewallRuleRequestRequestTypeDef,
    CreateFirewallRuleResponseTypeDef,
    CreateResolverEndpointRequestRequestTypeDef,
    CreateResolverEndpointResponseTypeDef,
    CreateResolverQueryLogConfigRequestRequestTypeDef,
    CreateResolverQueryLogConfigResponseTypeDef,
    CreateResolverRuleRequestRequestTypeDef,
    CreateResolverRuleResponseTypeDef,
    DeleteFirewallDomainListRequestRequestTypeDef,
    DeleteFirewallDomainListResponseTypeDef,
    DeleteFirewallRuleGroupRequestRequestTypeDef,
    DeleteFirewallRuleGroupResponseTypeDef,
    DeleteFirewallRuleRequestRequestTypeDef,
    DeleteFirewallRuleResponseTypeDef,
    DeleteResolverEndpointRequestRequestTypeDef,
    DeleteResolverEndpointResponseTypeDef,
    DeleteResolverQueryLogConfigRequestRequestTypeDef,
    DeleteResolverQueryLogConfigResponseTypeDef,
    DeleteResolverRuleRequestRequestTypeDef,
    DeleteResolverRuleResponseTypeDef,
    DisassociateFirewallRuleGroupRequestRequestTypeDef,
    DisassociateFirewallRuleGroupResponseTypeDef,
    DisassociateResolverEndpointIpAddressRequestRequestTypeDef,
    DisassociateResolverEndpointIpAddressResponseTypeDef,
    DisassociateResolverQueryLogConfigRequestRequestTypeDef,
    DisassociateResolverQueryLogConfigResponseTypeDef,
    DisassociateResolverRuleRequestRequestTypeDef,
    DisassociateResolverRuleResponseTypeDef,
    FilterTypeDef,
    FirewallConfigTypeDef,
    FirewallDomainListMetadataTypeDef,
    FirewallDomainListTypeDef,
    FirewallRuleGroupAssociationTypeDef,
    FirewallRuleGroupMetadataTypeDef,
    FirewallRuleGroupTypeDef,
    FirewallRuleTypeDef,
    GetFirewallConfigRequestRequestTypeDef,
    GetFirewallConfigResponseTypeDef,
    GetFirewallDomainListRequestRequestTypeDef,
    GetFirewallDomainListResponseTypeDef,
    GetFirewallRuleGroupAssociationRequestRequestTypeDef,
    GetFirewallRuleGroupAssociationResponseTypeDef,
    GetFirewallRuleGroupPolicyRequestRequestTypeDef,
    GetFirewallRuleGroupPolicyResponseTypeDef,
    GetFirewallRuleGroupRequestRequestTypeDef,
    GetFirewallRuleGroupResponseTypeDef,
    GetResolverDnssecConfigRequestRequestTypeDef,
    GetResolverDnssecConfigResponseTypeDef,
    GetResolverEndpointRequestRequestTypeDef,
    GetResolverEndpointResponseTypeDef,
    GetResolverQueryLogConfigAssociationRequestRequestTypeDef,
    GetResolverQueryLogConfigAssociationResponseTypeDef,
    GetResolverQueryLogConfigPolicyRequestRequestTypeDef,
    GetResolverQueryLogConfigPolicyResponseTypeDef,
    GetResolverQueryLogConfigRequestRequestTypeDef,
    GetResolverQueryLogConfigResponseTypeDef,
    GetResolverRuleAssociationRequestRequestTypeDef,
    GetResolverRuleAssociationResponseTypeDef,
    GetResolverRulePolicyRequestRequestTypeDef,
    GetResolverRulePolicyResponseTypeDef,
    GetResolverRuleRequestRequestTypeDef,
    GetResolverRuleResponseTypeDef,
    ImportFirewallDomainsRequestRequestTypeDef,
    ImportFirewallDomainsResponseTypeDef,
    IpAddressRequestTypeDef,
    IpAddressResponseTypeDef,
    IpAddressUpdateTypeDef,
    ListFirewallConfigsRequestRequestTypeDef,
    ListFirewallConfigsResponseTypeDef,
    ListFirewallDomainListsRequestRequestTypeDef,
    ListFirewallDomainListsResponseTypeDef,
    ListFirewallDomainsRequestRequestTypeDef,
    ListFirewallDomainsResponseTypeDef,
    ListFirewallRuleGroupAssociationsRequestRequestTypeDef,
    ListFirewallRuleGroupAssociationsResponseTypeDef,
    ListFirewallRuleGroupsRequestRequestTypeDef,
    ListFirewallRuleGroupsResponseTypeDef,
    ListFirewallRulesRequestRequestTypeDef,
    ListFirewallRulesResponseTypeDef,
    ListResolverDnssecConfigsRequestRequestTypeDef,
    ListResolverDnssecConfigsResponseTypeDef,
    ListResolverEndpointIpAddressesRequestRequestTypeDef,
    ListResolverEndpointIpAddressesResponseTypeDef,
    ListResolverEndpointsRequestRequestTypeDef,
    ListResolverEndpointsResponseTypeDef,
    ListResolverQueryLogConfigAssociationsRequestRequestTypeDef,
    ListResolverQueryLogConfigAssociationsResponseTypeDef,
    ListResolverQueryLogConfigsRequestRequestTypeDef,
    ListResolverQueryLogConfigsResponseTypeDef,
    ListResolverRuleAssociationsRequestRequestTypeDef,
    ListResolverRuleAssociationsResponseTypeDef,
    ListResolverRulesRequestRequestTypeDef,
    ListResolverRulesResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    PutFirewallRuleGroupPolicyRequestRequestTypeDef,
    PutFirewallRuleGroupPolicyResponseTypeDef,
    PutResolverQueryLogConfigPolicyRequestRequestTypeDef,
    PutResolverQueryLogConfigPolicyResponseTypeDef,
    PutResolverRulePolicyRequestRequestTypeDef,
    PutResolverRulePolicyResponseTypeDef,
    ResolverDnssecConfigTypeDef,
    ResolverEndpointTypeDef,
    ResolverQueryLogConfigAssociationTypeDef,
    ResolverQueryLogConfigTypeDef,
    ResolverRuleAssociationTypeDef,
    ResolverRuleConfigTypeDef,
    ResolverRuleTypeDef,
    ResponseMetadataTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    TargetAddressTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateFirewallConfigRequestRequestTypeDef,
    UpdateFirewallConfigResponseTypeDef,
    UpdateFirewallDomainsRequestRequestTypeDef,
    UpdateFirewallDomainsResponseTypeDef,
    UpdateFirewallRuleGroupAssociationRequestRequestTypeDef,
    UpdateFirewallRuleGroupAssociationResponseTypeDef,
    UpdateFirewallRuleRequestRequestTypeDef,
    UpdateFirewallRuleResponseTypeDef,
    UpdateResolverDnssecConfigRequestRequestTypeDef,
    UpdateResolverDnssecConfigResponseTypeDef,
    UpdateResolverEndpointRequestRequestTypeDef,
    UpdateResolverEndpointResponseTypeDef,
    UpdateResolverRuleRequestRequestTypeDef,
    UpdateResolverRuleResponseTypeDef,
)

def get_structure() -> AssociateFirewallRuleGroupRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-route53resolver` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-route53resolver docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_route53resolver/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
