"""
Type annotations for route53resolver service literal definitions.

[Open documentation](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_route53resolver/literals.html)

Usage::

    ```python
    from mypy_boto3_route53resolver.literals import ActionType

    data: ActionType = "ALERT"
    ```
"""
import sys

if sys.version_info >= (3, 8):
    from typing import Literal
else:
    from typing_extensions import Literal


__all__ = (
    "ActionType",
    "BlockOverrideDnsTypeType",
    "BlockResponseType",
    "FirewallDomainImportOperationType",
    "FirewallDomainListStatusType",
    "FirewallDomainUpdateOperationType",
    "FirewallFailOpenStatusType",
    "FirewallRuleGroupAssociationStatusType",
    "FirewallRuleGroupStatusType",
    "IpAddressStatusType",
    "ListFirewallConfigsPaginatorName",
    "ListFirewallDomainListsPaginatorName",
    "ListFirewallDomainsPaginatorName",
    "ListFirewallRuleGroupAssociationsPaginatorName",
    "ListFirewallRuleGroupsPaginatorName",
    "ListFirewallRulesPaginatorName",
    "ListResolverDnssecConfigsPaginatorName",
    "ListResolverEndpointIpAddressesPaginatorName",
    "ListResolverEndpointsPaginatorName",
    "ListResolverQueryLogConfigAssociationsPaginatorName",
    "ListResolverQueryLogConfigsPaginatorName",
    "ListResolverRuleAssociationsPaginatorName",
    "ListResolverRulesPaginatorName",
    "ListTagsForResourcePaginatorName",
    "MutationProtectionStatusType",
    "ResolverDNSSECValidationStatusType",
    "ResolverEndpointDirectionType",
    "ResolverEndpointStatusType",
    "ResolverQueryLogConfigAssociationErrorType",
    "ResolverQueryLogConfigAssociationStatusType",
    "ResolverQueryLogConfigStatusType",
    "ResolverRuleAssociationStatusType",
    "ResolverRuleStatusType",
    "RuleTypeOptionType",
    "ShareStatusType",
    "SortOrderType",
    "ValidationType",
    "ServiceName",
)


ActionType = Literal["ALERT", "ALLOW", "BLOCK"]
BlockOverrideDnsTypeType = Literal["CNAME"]
BlockResponseType = Literal["NODATA", "NXDOMAIN", "OVERRIDE"]
FirewallDomainImportOperationType = Literal["REPLACE"]
FirewallDomainListStatusType = Literal[
    "COMPLETE", "COMPLETE_IMPORT_FAILED", "DELETING", "IMPORTING", "UPDATING"
]
FirewallDomainUpdateOperationType = Literal["ADD", "REMOVE", "REPLACE"]
FirewallFailOpenStatusType = Literal["DISABLED", "ENABLED"]
FirewallRuleGroupAssociationStatusType = Literal["COMPLETE", "DELETING", "UPDATING"]
FirewallRuleGroupStatusType = Literal["COMPLETE", "DELETING", "UPDATING"]
IpAddressStatusType = Literal[
    "ATTACHED",
    "ATTACHING",
    "CREATING",
    "DELETE_FAILED_FAS_EXPIRED",
    "DELETING",
    "DETACHING",
    "FAILED_CREATION",
    "FAILED_RESOURCE_GONE",
    "REMAP_ATTACHING",
    "REMAP_DETACHING",
]
ListFirewallConfigsPaginatorName = Literal["list_firewall_configs"]
ListFirewallDomainListsPaginatorName = Literal["list_firewall_domain_lists"]
ListFirewallDomainsPaginatorName = Literal["list_firewall_domains"]
ListFirewallRuleGroupAssociationsPaginatorName = Literal["list_firewall_rule_group_associations"]
ListFirewallRuleGroupsPaginatorName = Literal["list_firewall_rule_groups"]
ListFirewallRulesPaginatorName = Literal["list_firewall_rules"]
ListResolverDnssecConfigsPaginatorName = Literal["list_resolver_dnssec_configs"]
ListResolverEndpointIpAddressesPaginatorName = Literal["list_resolver_endpoint_ip_addresses"]
ListResolverEndpointsPaginatorName = Literal["list_resolver_endpoints"]
ListResolverQueryLogConfigAssociationsPaginatorName = Literal[
    "list_resolver_query_log_config_associations"
]
ListResolverQueryLogConfigsPaginatorName = Literal["list_resolver_query_log_configs"]
ListResolverRuleAssociationsPaginatorName = Literal["list_resolver_rule_associations"]
ListResolverRulesPaginatorName = Literal["list_resolver_rules"]
ListTagsForResourcePaginatorName = Literal["list_tags_for_resource"]
MutationProtectionStatusType = Literal["DISABLED", "ENABLED"]
ResolverDNSSECValidationStatusType = Literal["DISABLED", "DISABLING", "ENABLED", "ENABLING"]
ResolverEndpointDirectionType = Literal["INBOUND", "OUTBOUND"]
ResolverEndpointStatusType = Literal[
    "ACTION_NEEDED", "AUTO_RECOVERING", "CREATING", "DELETING", "OPERATIONAL", "UPDATING"
]
ResolverQueryLogConfigAssociationErrorType = Literal[
    "ACCESS_DENIED", "DESTINATION_NOT_FOUND", "INTERNAL_SERVICE_ERROR", "NONE"
]
ResolverQueryLogConfigAssociationStatusType = Literal[
    "ACTION_NEEDED", "ACTIVE", "CREATING", "DELETING", "FAILED"
]
ResolverQueryLogConfigStatusType = Literal["CREATED", "CREATING", "DELETING", "FAILED"]
ResolverRuleAssociationStatusType = Literal[
    "COMPLETE", "CREATING", "DELETING", "FAILED", "OVERRIDDEN"
]
ResolverRuleStatusType = Literal["COMPLETE", "DELETING", "FAILED", "UPDATING"]
RuleTypeOptionType = Literal["FORWARD", "RECURSIVE", "SYSTEM"]
ShareStatusType = Literal["NOT_SHARED", "SHARED_BY_ME", "SHARED_WITH_ME"]
SortOrderType = Literal["ASCENDING", "DESCENDING"]
ValidationType = Literal["DISABLE", "ENABLE"]
ServiceName = Literal[
    "accessanalyzer",
    "acm",
    "acm-pca",
    "alexaforbusiness",
    "amp",
    "amplify",
    "amplifybackend",
    "apigateway",
    "apigatewaymanagementapi",
    "apigatewayv2",
    "appconfig",
    "appflow",
    "appintegrations",
    "application-autoscaling",
    "application-insights",
    "applicationcostprofiler",
    "appmesh",
    "apprunner",
    "appstream",
    "appsync",
    "athena",
    "auditmanager",
    "autoscaling",
    "autoscaling-plans",
    "backup",
    "batch",
    "braket",
    "budgets",
    "ce",
    "chime",
    "chime-sdk-identity",
    "chime-sdk-messaging",
    "cloud9",
    "clouddirectory",
    "cloudformation",
    "cloudfront",
    "cloudhsm",
    "cloudhsmv2",
    "cloudsearch",
    "cloudsearchdomain",
    "cloudtrail",
    "cloudwatch",
    "codeartifact",
    "codebuild",
    "codecommit",
    "codedeploy",
    "codeguru-reviewer",
    "codeguruprofiler",
    "codepipeline",
    "codestar",
    "codestar-connections",
    "codestar-notifications",
    "cognito-identity",
    "cognito-idp",
    "cognito-sync",
    "comprehend",
    "comprehendmedical",
    "compute-optimizer",
    "config",
    "connect",
    "connect-contact-lens",
    "connectparticipant",
    "cur",
    "customer-profiles",
    "databrew",
    "dataexchange",
    "datapipeline",
    "datasync",
    "dax",
    "detective",
    "devicefarm",
    "devops-guru",
    "directconnect",
    "discovery",
    "dlm",
    "dms",
    "docdb",
    "ds",
    "dynamodb",
    "dynamodbstreams",
    "ebs",
    "ec2",
    "ec2-instance-connect",
    "ecr",
    "ecr-public",
    "ecs",
    "efs",
    "eks",
    "elastic-inference",
    "elasticache",
    "elasticbeanstalk",
    "elastictranscoder",
    "elb",
    "elbv2",
    "emr",
    "emr-containers",
    "es",
    "events",
    "finspace",
    "finspace-data",
    "firehose",
    "fis",
    "fms",
    "forecast",
    "forecastquery",
    "frauddetector",
    "fsx",
    "gamelift",
    "glacier",
    "globalaccelerator",
    "glue",
    "greengrass",
    "greengrassv2",
    "groundstation",
    "guardduty",
    "health",
    "healthlake",
    "honeycode",
    "iam",
    "identitystore",
    "imagebuilder",
    "importexport",
    "inspector",
    "iot",
    "iot-data",
    "iot-jobs-data",
    "iot1click-devices",
    "iot1click-projects",
    "iotanalytics",
    "iotdeviceadvisor",
    "iotevents",
    "iotevents-data",
    "iotfleethub",
    "iotsecuretunneling",
    "iotsitewise",
    "iotthingsgraph",
    "iotwireless",
    "ivs",
    "kafka",
    "kafkaconnect",
    "kendra",
    "kinesis",
    "kinesis-video-archived-media",
    "kinesis-video-media",
    "kinesis-video-signaling",
    "kinesisanalytics",
    "kinesisanalyticsv2",
    "kinesisvideo",
    "kms",
    "lakeformation",
    "lambda",
    "lex-models",
    "lex-runtime",
    "lexv2-models",
    "lexv2-runtime",
    "license-manager",
    "lightsail",
    "location",
    "logs",
    "lookoutequipment",
    "lookoutmetrics",
    "lookoutvision",
    "machinelearning",
    "macie",
    "macie2",
    "managedblockchain",
    "marketplace-catalog",
    "marketplace-entitlement",
    "marketplacecommerceanalytics",
    "mediaconnect",
    "mediaconvert",
    "medialive",
    "mediapackage",
    "mediapackage-vod",
    "mediastore",
    "mediastore-data",
    "mediatailor",
    "memorydb",
    "meteringmarketplace",
    "mgh",
    "mgn",
    "migrationhub-config",
    "mobile",
    "mq",
    "mturk",
    "mwaa",
    "neptune",
    "network-firewall",
    "networkmanager",
    "nimble",
    "opensearch",
    "opsworks",
    "opsworkscm",
    "organizations",
    "outposts",
    "personalize",
    "personalize-events",
    "personalize-runtime",
    "pi",
    "pinpoint",
    "pinpoint-email",
    "pinpoint-sms-voice",
    "polly",
    "pricing",
    "proton",
    "qldb",
    "qldb-session",
    "quicksight",
    "ram",
    "rds",
    "rds-data",
    "redshift",
    "redshift-data",
    "rekognition",
    "resource-groups",
    "resourcegroupstaggingapi",
    "robomaker",
    "route53",
    "route53-recovery-cluster",
    "route53-recovery-control-config",
    "route53-recovery-readiness",
    "route53domains",
    "route53resolver",
    "s3",
    "s3control",
    "s3outposts",
    "sagemaker",
    "sagemaker-a2i-runtime",
    "sagemaker-edge",
    "sagemaker-featurestore-runtime",
    "sagemaker-runtime",
    "savingsplans",
    "schemas",
    "sdb",
    "secretsmanager",
    "securityhub",
    "serverlessrepo",
    "service-quotas",
    "servicecatalog",
    "servicecatalog-appregistry",
    "servicediscovery",
    "ses",
    "sesv2",
    "shield",
    "signer",
    "sms",
    "sms-voice",
    "snow-device-management",
    "snowball",
    "sns",
    "sqs",
    "ssm",
    "ssm-contacts",
    "ssm-incidents",
    "sso",
    "sso-admin",
    "sso-oidc",
    "stepfunctions",
    "storagegateway",
    "sts",
    "support",
    "swf",
    "synthetics",
    "textract",
    "timestream-query",
    "timestream-write",
    "transcribe",
    "transfer",
    "translate",
    "waf",
    "waf-regional",
    "wafv2",
    "wellarchitected",
    "workdocs",
    "worklink",
    "workmail",
    "workmailmessageflow",
    "workspaces",
    "xray",
]
