import os
from dotenv import load_dotenv
load_dotenv()

hex_color_dict = {
    "red": "FF0000",
    "green": "00FF00",
    "blue": "0000FF",
    "yellow": "FFFF00",
    "purple": "800080",
    "cyan": "00FFFF",
    "magenta": "FF00FF",
    "lime": "00FF00",
    "pink": "FFC0CB",
    "teal": "008080",
    "lavender": "E6E6FA",
    "brown": "A52A2A",
    "beige": "F5F5DC",
    "maroon": "800000",
    "mint": "98FF98",
    "olive": "808000",
    "coral": "FF7F50",
    "navy": "000080",
    "grey": "808080",
    "white": "FFFFFF",
    "black": "000000",
    "orange": "FFA500",
    "indigo": "4B0082",
    "violet": "EE82EE",
    "gold": "FFD700",
    "silver": "C0C0C0",
    "rose": "FF007F",
    "emerald": "50C878",
    "ruby": "E0115F",
    "sapphire": "0F52BA",
    "amber": "FFBF00",
    "crimson": "DC143C",
    "darkgreen": "006400",
    "darkblue": "00008B",
    "darkred": "8B0000",
    "lightgreen": "90EE90",
    "lightblue": "ADD8E6",
    "lightyellow": "FFFFE0",
    "lightpink": "FFB6C1",
    "darkpurple": "800080",
    "lightpurple": "D8BFD8",
    "turquoise": "40E0D0",
    "tan": "D2B48C",
    "lightgrey": "D3D3D3",
    "darkgrey": "A9A9A9",
    "ivory": "FFFFF0",
    "khaki": "F0E68C",
    "lavenderblush": "FFF0F5",
    "lightcoral": "F08080",
    "salmon": "FA8072",
    "darksalmon": "E9967A",
    "lightsalmon": "FFA07A",
    "darkorange": "FF8C00",
    "linen": "FAF0E6",
    "peachpuff": "FFDAB9",
    "seashell": "FFF5EE",
    "snow": "FFFAFA",
    "wheat": "F5DEB3",
    "mistyrose": "FFE4E1",
    "azure": "F0FFFF",
    "aliceblue": "F0F8FF",
    "honeydew": "F0FFF0",
    "mintcream": "F5FFFA"
}


all_forex_pairs = {
'United States/Canada': 'USD/CAD',
'Japan/Euro': 'JPY/EUR',
'Denmark/Canada': 'DKK/CAD',
'Czech Republic/Japan': 'CZK/JPY',
'Euro/China': 'EUR/CNH',
'China/Singapore': 'CNY/SGD',
'Norway/United States': 'NOK/USD',
'Denmark/Mexico': 'DKK/MXN',
'Switzerland/South Africa': 'CHF/ZAR',
'Brazil/Japan': 'BRL/JPY',
'New Zealand/Indonesia': 'NZD/IDR',
'Bermuda/Canada': 'BMD/CAD',
'Silver/Turkey': 'XAG/TRY',
'Australia/South Africa': 'AUD/ZAR',
'Switzerland/Poland': 'CHF/PLN',
'Hong Kong/India': 'HKD/INR',
'Australia/New Zealand': 'AUD/NZD',
'South Africa/United Kingdom': 'ZAR/GBP',
'Malaysia/Australia': 'MYR/AUD',
'India/Taiwan': 'INR/TWD',
'South Korea/Switzerland': 'KRW/CHF',
'New Zealand/Switzerland': 'NZD/CHF',
'Israel/Japan': 'ILS/JPY',
'United States/South Africa': 'USD/ZAR',
'Hungary/Denmark': 'HUF/DKK',
'United States/China': 'USD/CNY',
'British Pound/Canada': 'GBP/CAD',
'Gold/Turkey': 'XAU/TRY',
'Mexican Peso/United States': 'MXN/USD',
'Hong Kong/Thailand': 'HKD/THB',
'Japanese Yen/British Pound': 'JPY/GBP',
'Euro/Singapore': 'EUR/SGD',
'Chilean Peso/British Pound': 'CLP/GBP',
'Colombian Peso/Mexican Peso': 'COP/MXN',
'Colombian Peso/United States': 'COP/USD',
'Brazilian Real/Mexican Peso': 'BRL/MXN',
'New Zealand/Czech Republic': 'NZD/CZK',
'South Korean Won/Australia': 'KRW/AUD',
'New Zealand/Hong Kong': 'NZD/HKD',
'British Pound/Costa Rican Colón': 'GBP/CRC',
'Turkish Lira/United States': 'TRY/USD',
'Silver/Russian Ruble': 'XAG/RUB',
'Silver/Euro': 'XAG/EUR',
'Australian Dollar/Poland': 'AUD/PLN',
'Australian Dollar/China': 'AUD/CNH',
'Euro/Australian Dollar': 'EUR/AUD',
'Japanese Yen/Taiwan': 'JPY/TWD',
'South African Rand/Thailand': 'ZAR/THB',
'New Zealand/Thailand': 'NZD/THB',
'British Pound/Indonesian Rupiah': 'GBP/IDR',
'Australian Dollar/Denmark': 'AUD/DKK',
'Silver/South African Rand': 'XAG/ZAR',
'Silver/Chinese Yuan': 'XAG/CNY',
'Australian Dollar/Hungary': 'AUD/HUF',
'Bulgarian Lev/Chinese Yuan': 'BGN/CNY',
'Singapore Dollar/British Pound': 'SGD/GBP',
'Hong Kong Dollar/Switzerland': 'HKD/CHF',
'Malaysian Ringgit/Singapore Dollar': 'MYR/SGD',
'Silver/United States Dollar': 'XAG/USD',
'United States Dollar/Taiwan Dollar': 'USD/TWD',
'Swedish Krona/Danish Krone': 'SEK/DKK',
'Bermuda/British Pound': 'BMD/GBP',
'British Pound/Euro': 'GBP/EUR',
'Moroccan Dirham/Australian Dollar': 'MAD/AUD',
'Israeli Shekel/Norwegian Krone': 'ILS/NOK',
'British Pound/Singapore Dollar': 'GBP/SGD',
'Singapore Dollar/South African Rand': 'SGD/ZAR',
'Indian Rupee/Singapore Dollar': 'INR/SGD',
'Japanese Yen/Indonesian Rupiah': 'JPY/IDR',
'Japanese Yen/Polish Złoty': 'JPY/PLN',
'British Pound/Danish Krone': 'GBP/DKK',
'Polish Złoty/Hungarian Forint': 'PLN/HUF',
'Turkish Lira/South African Rand': 'TRY/ZAR',
'South African Rand/Egyptian Pound': 'ZAR/EGP',
'Gold/South Korean Won': 'XAU/KRW',
'Egyptian Pound/Japanese Yen': 'EGP/JPY',
'South African Rand/Indian Rupee': 'ZAR/INR',
'Australian Dollar/Indian Rupee': 'AUD/INR',
'Gold/Mexican Peso': 'XAU/MXN',
'Japanese Yen/Canadian Dollar': 'JPY/CAD',
'Gold/British Pound': 'XAU/GBP',
'Danish Krone/Polish Złoty': 'DKK/PLN',
'South African Rand/Singapore Dollar': 'ZAR/SGD',
'Chinese Yuan/Swiss Franc': 'CNY/CHF',
'Chilean Peso/Australian Dollar': 'CLP/AUD',
'Japanese Yen/Indian Rupee': 'JPY/INR',
'Swiss Franc/Hong Kong Dollar': 'CHF/HKD',
'Hong Kong Dollar/Argentine Peso': 'HKD/ARS',
'Swiss Franc/Singapore Dollar': 'CHF/SGD',
'Czech Koruna/United States Dollar': 'CZK/USD',
'Chinese Yuan/South African Rand': 'CNY/ZAR',
'New Zealand/Euro': 'NZD/EUR',
'Australian Dollar/Swedish Krona': 'AUD/SEK',
'Swedish Krona/Polish Złoty': 'SEK/PLN',
'New Zealand/Indian Rupee': 'NZD/INR',
'South African Rand/Swiss Franc': 'ZAR/CHF',
'Indian Rupee/Swedish Krona': 'INR/SEK',
'Polish Złoty/British Pound': 'PLN/GBP',
'Danish Krone/Pakistani Rupee': 'DKK/PKR',
'Swedish Krona/British Pound': 'SEK/GBP',
'Canadian Dollar/Swiss Franc': 'CAD/CHF',
'New Zealand/Polish Złoty': 'NZD/PLN',
'South Korean Won/United States Dollar': 'KRW/USD',
'United States Dollar/Hong Kong Dollar': 'USD/HKD',
'Danish Krone/Thai Baht': 'DKK/THB',
'Gold/Thai Baht': 'XAU/THB',
'Philippine Peso/Danish Krone': 'PHP/DKK',
'Russian Ruble/Swiss Franc': 'RUB/CHF',
'Indian Rupee/Euro': 'INR/EUR',
'Argentine Peso/Euro': 'ARS/EUR',
'Polish Złoty/Czech Koruna': 'PLN/CZK',
'Norwegian Krone/Swedish Krona': 'NOK/SEK',
'Malaysian Ringgit/Swiss Franc': 'MYR/CHF',
'Canadian Dollar/United Arab Emirates Dirham': 'CAD/AED',
'Danish Krone/Swiss Franc': 'DKK/CHF',
'Silver/South Korean Won': 'XAG/KRW',
'Japanese Yen/Thai Baht': 'JPY/THB',
'Silver/Brazilian Real': 'XAG/BRL',
'Swiss Franc/Japanese Yen': 'CHF/JPY',
'Singapore Dollar/Indian Rupee': 'SGD/INR',
'Argentine Peso/Hong Kong Dollar': 'ARS/HKD',
'United States Dollar/Swedish Krona': 'USD/SEK',
'Cayman Islands Dollar/Canadian Dollar': 'KYD/CAD',
'British Pound/New Zealand Dollar': 'GBP/NZD',
'Taiwan Dollar/Danish Krone': 'TWD/DKK',
'Taiwan Dollar/Thai Baht': 'TWD/THB',
'Australian Dollar/Czech Koruna': 'AUD/CZK',
'Swiss Franc/United States Dollar': 'CHF/USD',
'United States Dollar/Danish Krone': 'USD/DKK',
'South African Rand/Philippine Peso': 'ZAR/PHP',
'Euro/Swiss Franc': 'EUR/CHF',
'United States Dollar/Icelandic Króna': 'USD/ISK',
'South African Rand/Botswana Pula': 'ZAR/BWP',
'Australian Dollar/Euro': 'AUD/EUR',
'Japanese Yen/Norwegian Krone': 'JPY/NOK',
'Swiss Franc/Romanian Leu': 'CHF/RON',
'Euro/British Pound': 'EUR/GBP',
'South Korean Won/Singapore Dollar': 'KRW/SGD',
'Peruvian Sol/Canadian Dollar': 'PEN/CAD',
'New Zealand Dollar/Japanese Yen': 'NZD/JPY',
'Malaysian Ringgit/South African Rand': 'MYR/ZAR',
'Swedish Krona/South African Rand': 'SEK/ZAR',
'Cypriot Pound/South African Rand': 'CYP/ZAR',
'Turkish Lira/Japanese Yen': 'TRY/JPY',
'British Pound/Israeli Shekel': 'GBP/ILS',
'South African Rand/New Zealand Dollar': 'ZAR/NZD',
'Turkish Lira/Polish Złoty': 'TRY/PLN',
'South African Rand/United States Dollar': 'ZAR/USD',
'Nigerian Naira/Japanese Yen': 'NGN/JPY',
'Silver/Hong Kong Dollar': 'XAG/HKD',
'Hong Kong Dollar/New Zealand Dollar': 'HKD/NZD',
'Swiss Franc/Swedish Krona': 'CHF/SEK',
'Japanese Yen/Australian Dollar': 'JPY/AUD',
'British Pound/Honduran Lempira': 'GBP/HNL',
'Singapore Dollar/Danish Krone': 'SGD/DKK',
'Malaysian Ringgit/Canadian Dollar': 'MYR/CAD',
'Czech Koruna/Canadian Dollar': 'CZK/CAD',
'Gold/Chinese Yuan': 'XAU/CNY',
'Gold/Canadian Dollar': 'XAU/CAD',
'Australian Dollar/British Pound': 'AUD/GBP',
'Swedish Krona/Swiss Franc': 'SEK/CHF',
'Australian Dollar/Hong Kong Dollar': 'AUD/HKD',
'South Korean Won/British Pound': 'KRW/GBP',
'Taiwan Dollar/Australian Dollar': 'TWD/AUD',
'Taiwan Dollar/Canadian Dollar': 'TWD/CAD',
'Malaysian Ringgit/Indonesian Rupiah': 'MYR/IDR',
'South Korean Won/Hong Kong Dollar': 'KRW/HKD',
'Taiwan Dollar/South African Rand': 'TWD/ZAR',
'New Zealand Dollar/Swedish Krona': 'NZD/SEK',
'Australian Dollar/Moroccan Dirham': 'AUD/MAD',
'New Zealand Dollar/United States Dollar': 'NZD/USD',
'Taiwan Dollar/Swedish Krona': 'TWD/SEK',
'United States Dollar/Indian Rupee': 'USD/INR',
'Norwegian Krone/Danish Krone': 'NOK/DKK',
'Czech Koruna/Mexican Peso': 'CZK/MXN',
'Thai Baht/Indonesian Rupiah': 'THB/IDR',
'United States Dollar/Egyptian Pound': 'USD/EGP',
'Canadian Dollar/Turkish Lira': 'CAD/TRY',
'Indonesian Rupiah/South Korean Won': 'IDR/KRW',
'South African Rand/Swedish Krona': 'ZAR/SEK',
'Israeli Shekel/Swiss Franc': 'ILS/CHF',
'British Pound/Icelandic Króna': 'GBP/ISK',
'Indian Rupee/Thai Baht': 'INR/THB',
'Danish Krone/Czech Koruna': 'DKK/CZK',
'Euro/Mexican Peso': 'EUR/MXN',
'Silver/Swiss Franc': 'XAG/GBP',
'Silver/Australian Dollar': 'XAG/AUD',
'Thai Baht/Taiwan Dollar': 'THB/TWD',
'South Korean Won/Canadian Dollar': 'KRW/CAD',
'New Zealand Dollar/Danish Krone': 'NZD/DKK',
'British Pound/Hungarian Forint': 'GBP/HUF',
'Chinese Yuan/United States Dollar': 'CNH/USD',
'Switzerland/Thailand': 'CHF/THB',
'Australia/South Korea': 'AUD/KRW',
'Czech Republic/Eurozone': 'CZK/EUR',
'Switzerland/Taiwan': 'CHF/TWD',
'Denmark/United Kingdom': 'DKK/GBP',
'Gold/Eurozone': 'XAU/EUR',
'Thai Baht/New Zealand Dollar': 'THB/NZD',
'Japanese Yen/Czech Koruna': 'JPY/CZK',
'Canadian Dollar/Hong Kong Dollar': 'CAD/HKD',
'British Pound/Norwegian Krone': 'GBP/NOK',
'South African Rand/Australian Dollar': 'ZAR/AUD',
'South African Rand/Czech Koruna': 'ZAR/CZK',
'South African Rand/Pakistani Rupee': 'ZAR/PKR',
'British Pound/Czech Koruna': 'GBP/CZK',
'Chinese Yuan/Japanese Yen': 'CNH/JPY',
'United States Dollar/Thai Baht': 'USD/THB',
'Danish Krone/New Zealand Dollar': 'DKK/NZD',
'British Pound/United States Dollar': 'GBP/USD',
'New Taiwan Dollar/Indonesian Rupiah': 'TWD/IDR',
'Singapore Dollar/Mexican Peso': 'SGD/MXN',
'Silver Ounce/Indian Rupee': 'XAG/INR',
'Norwegian Krone/British Pound': 'NOK/GBP',
'Canadian Dollar/Indonesian Rupiah': 'CAD/IDR',
'Argentine Peso/South African Rand': 'ARS/ZAR',
'Singapore Dollar/New Zealand Dollar': 'SGD/NZD',
'Brazilian Real/Argentine Peso': 'BRL/ARS',
'Malaysian Ringgit/Hong Kong Dollar': 'MYR/HKD',
'Gold/Hong Kong Dollar': 'XAU/HKD',
'Norwegian Krone/Eurozone': 'NOK/EUR',
'United States Dollar/Chinese Yuan': 'USD/CNH',
'Singapore Dollar/Swedish Krona': 'SGD/SEK',
'New Zealand Dollar/South African Rand': 'NZD/ZAR',
'Hong Kong Dollar/Canadian Dollar': 'HKD/CAD',
'Swedish Krona/Czech Koruna': 'SEK/CZK',
'Danish Krone/United States Dollar': 'DKK/USD',
'Eastern Caribbean Dollar/British Pound': 'XCD/GBP',
'Australian Dollar/Turkish Lira': 'AUD/TRY',
'Hong Kong Dollar/Australian Dollar': 'HKD/AUD',
'Danish Krone/Eurozone': 'DKK/EUR',
'Canadian Dollar/Israeli New Shekel': 'CAD/ILS',
'Japanese Yen/New Zealand Dollar': 'JPY/NZD',
'Hong Kong Dollar/Danish Krone': 'HKD/DKK',
'Swiss Franc/Indonesian Rupiah': 'CHF/IDR',
'Mexican Peso/Singapore Dollar': 'MXN/SGD',
'British Pound/South African Rand': 'GBP/ZAR',
'Canadian Dollar/Czech Koruna': 'CAD/CZK',
'United States Dollar/Norwegian Krone': 'USD/NOK',
'Japanese Yen/Israeli New Shekel': 'JPY/ILS',
'Gold/United States Dollar': 'XAU/USD',
'New Zealand Dollar/Canadian Dollar': 'NZD/CAD',
'Argentine Peso/Swiss Franc': 'ARS/CHF',
'Canadian Dollar/Japanese Yen': 'CAD/JPY',
'South African Rand/Cypriot Pound': 'ZAR/CYP',
'Indonesian Rupiah/British Pound': 'IDR/GBP',
'British Pound/South Korean Won': 'GBP/KRW',
'Indonesian Rupiah/South African Rand': 'IDR/ZAR',
'South African Rand/Japanese Yen': 'ZAR/JPY',
'Romanian Leu/United States Dollar': 'RON/USD',
'Hong Kong Dollar/New Taiwan Dollar': 'HKD/TWD',
'South African Rand/Canadian Dollar': 'ZAR/CAD',
'Hungarian Forint/Polish Zloty': 'HUF/PLN',
'New Taiwan Dollar/Singapore Dollar': 'TWD/SGD',
'Euro/Philippine Peso': 'EUR/PHP',
'Gold/Australian Dollar': 'XAU/AUD',
'Euro/Norwegian Krone': 'EUR/NOK',
'Hong Kong Dollar/Singapore Dollar': 'HKD/SGD',
'Singapore Dollar/Norwegian Krone': 'SGD/NOK',
'South Korean Won/South African Rand': 'KRW/ZAR',
'United States Dollar/Australian Dollar': 'USD/AUD',
'Swiss Franc/Hungarian Forint': 'CHF/HUF',
'Bulgarian Lev/Canadian Dollar': 'BGN/CAD',
'Singapore Dollar/Australian Dollar': 'SGD/AUD',
'Euro/Turkish Lira': 'EUR/TRY',
'Canadian Dollar/Norwegian Krone': 'CAD/NOK',
'Canadian Dollar/New Zealand Dollar': 'CAD/NZD',
'South African Rand/Norwegian Krone': 'ZAR/NOK',
'Chilean Peso/Swiss Franc': 'CLP/CHF',
'South Korean Won/Brazilian Real': 'KRW/BRL',
'Thai Baht/South Korean Won': 'THB/KRW',
'Mexican Peso/Australian Dollar': 'MXN/AUD',
'Silver Ounce/Canadian Dollar': 'XAG/CAD',
'British Pound/Chinese Yuan': 'GBP/CNH',
'Norwegian Krone/Indian Rupee': 'NOK/INR',
'Canadian Dollar/Indonesian Rupiah': 'CAD/IDR',
'Argentine Peso/South African Rand': 'ARS/ZAR',
'Singapore Dollar/New Zealand Dollar': 'SGD/NZD',
'Brazilian Real/Argentine Peso': 'BRL/ARS',
'Malaysian Ringgit/Hong Kong Dollar': 'MYR/HKD',
'Gold/Hong Kong Dollar': 'XAU/HKD',
'Norwegian Krone/Eurozone': 'NOK/EUR',
'United States Dollar/Chinese Yuan': 'USD/CNH',
'Singapore Dollar/Swedish Krona': 'SGD/SEK',
'New Zealand Dollar/South African Rand': 'NZD/ZAR',
'Hong Kong Dollar/Canadian Dollar': 'HKD/CAD',
'Swedish Krona/Czech Koruna': 'SEK/CZK',
'Danish Krone/United States Dollar': 'DKK/USD',
'Eastern Caribbean Dollar/British Pound': 'XCD/GBP',
'Australian Dollar/Turkish Lira': 'AUD/TRY',
'Hong Kong Dollar/Australian Dollar': 'HKD/AUD',
'Danish Krone/Eurozone': 'DKK/EUR',
'Canadian Dollar/Israeli New Shekel': 'CAD/ILS',
'Japanese Yen/New Zealand Dollar': 'JPY/NZD',
'Hong Kong Dollar/Danish Krone': 'HKD/DKK',
'Swiss Franc/Indonesian Rupiah': 'CHF/IDR',
'Mexican Peso/Singapore Dollar': 'MXN/SGD',
'British Pound/South African Rand': 'GBP/ZAR',
'Canadian Dollar/Czech Koruna': 'CAD/CZK',
'United States Dollar/Norwegian Krone': 'USD/NOK',
'Japanese Yen/Israeli New Shekel': 'JPY/ILS',
'Gold/United States Dollar': 'XAU/USD',
'New Zealand Dollar/Canadian Dollar': 'NZD/CAD',
'Argentine Peso/Swiss Franc': 'ARS/CHF',
'Canadian Dollar/Japanese Yen': 'CAD/JPY',
'South African Rand/Cypriot Pound': 'ZAR/CYP',
'Indonesian Rupiah/British Pound': 'IDR/GBP',
'British Pound/South Korean Won': 'GBP/KRW',
'Indonesian Rupiah/South African Rand': 'IDR/ZAR',
'South African Rand/Japanese Yen': 'ZAR/JPY',
'Romanian Leu/United States Dollar': 'RON/USD',
'Hong Kong Dollar/New Taiwan Dollar': 'HKD/TWD',
'South African Rand/Canadian Dollar': 'ZAR/CAD',
'Hungarian Forint/Polish Zloty': 'HUF/PLN',
'New Taiwan Dollar/Singapore Dollar': 'TWD/SGD',
'Euro/Philippine Peso': 'EUR/PHP',
'Gold/Australian Dollar': 'XAU/AUD',
'Euro/Norwegian Krone': 'EUR/NOK',
'Hong Kong Dollar/Singapore Dollar': 'HKD/SGD',
'Singapore Dollar/Norwegian Krone': 'SGD/NOK',
'South Korean Won/South African Rand': 'KRW/ZAR',
'United States Dollar/Australian Dollar': 'USD/AUD',
'Swiss Franc/Hungarian Forint': 'CHF/HUF',
'Bulgarian Lev/Canadian Dollar': 'BGN/CAD',
'Singapore Dollar/Australian Dollar': 'SGD/AUD',
'Euro/Turkish Lira': 'EUR/TRY',
'Canadian Dollar/Norwegian Krone': 'CAD/NOK',
'Canadian Dollar/New Zealand Dollar': 'CAD/NZD',
'South African Rand/Norwegian Krone': 'ZAR/NOK',
'Chilean Peso/Swiss Franc': 'CLP/CHF',
'South Korean Won/Brazilian Real': 'KRW/BRL',
'Thai Baht/South Korean Won': 'THB/KRW',
'Mexican Peso/Australian Dollar': 'MXN/AUD',
'Silver Ounce/Canadian Dollar': 'XAG/CAD',
'British Pound/Chinese Yuan': 'GBP/CNH',
'Norwegian Krone/Indian Rupee': 'NOK/INR',
'Canadian Dollar/Indonesian Rupiah': 'CAD/IDR',
'Argentine Peso/South African Rand': 'ARS/ZAR',
'Singapore Dollar/New Zealand Dollar': 'SGD/NZD',
'Brazilian Real/Argentine Peso': 'BRL/ARS',
'Malaysian Ringgit/Hong Kong Dollar': 'MYR/HKD',
'Gold/Hong Kong Dollar': 'XAU/HKD',
'Norwegian Krone/Eurozone': 'NOK/EUR',
'United States Dollar/Chinese Yuan': 'USD/CNH',
'Singapore Dollar/Swedish Krona': 'SGD/SEK',
'New Zealand Dollar/South African Rand': 'NZD/ZAR',
'Hong Kong Dollar/Canadian Dollar': 'HKD/CAD',
'Swedish Krona/Czech Koruna': 'SEK/CZK',
'Danish Krone/United States Dollar': 'DKK/USD',
'Eastern Caribbean Dollar/British Pound': 'XCD/GBP',
'Australian Dollar/Turkish Lira': 'AUD/TRY',
'Hong Kong Dollar/Australian Dollar': 'HKD/AUD',
'Danish Krone/Eurozone': 'DKK/EUR',
'Canadian Dollar/Israeli New Shekel': 'CAD/ILS',
'Japanese Yen/New Zealand Dollar': 'JPY/NZD',
'Hong Kong Dollar/Danish Krone': 'HKD/DKK',
'Swiss Franc/Indonesian Rupiah': 'CHF/IDR',
'Mexican Peso/Singapore Dollar': 'MXN/SGD',
'British Pound/South African Rand': 'GBP/ZAR',
'Canadian Dollar/Czech Koruna': 'CAD/CZK',
'United States Dollar/Norwegian Krone': 'USD/NOK',
'Japanese Yen/Israeli New Shekel': 'JPY/ILS',
'Gold/United States Dollar': 'XAU/USD',
'New Zealand Dollar/Canadian Dollar': 'NZD/CAD',
'Argentine Peso/Swiss Franc': 'ARS/CHF',
'Canadian Dollar/Japanese Yen': 'CAD/JPY',
'South African Rand/Cypriot Pound': 'ZAR/CYP',
'Indonesian Rupiah/British Pound': 'IDR/GBP',
'British Pound/South Korean Won': 'GBP/KRW',
'Indonesian Rupiah/South African Rand': 'IDR/ZAR',
'South African Rand/Japanese Yen': 'ZAR/JPY',
'Romanian Leu/United States Dollar': 'RON/USD',
'Hong Kong Dollar/New Taiwan Dollar': 'HKD/TWD',
'South African Rand/Canadian Dollar': 'ZAR/CAD',
'Hungarian Forint/Polish Zloty': 'HUF/PLN',
'New Taiwan Dollar/Singapore Dollar': 'TWD/SGD',
'Euro/Philippine Peso': 'EUR/PHP',
'Gold/Australian Dollar': 'XAU/AUD',
'Euro/Norwegian Krone': 'EUR/NOK',
'Hong Kong Dollar/Singapore Dollar': 'HKD/SGD',
'Singapore Dollar/Norwegian Krone': 'SGD/NOK',
'South Korean Won/South African Rand': 'KRW/ZAR',
    'Indian Rupee/Swiss Franc': 'INR/CHF',
    'Swiss Franc/Australian Dollar': 'CHF/AUD',
    'Danish Krone/Swedish Krona': 'DKK/SEK',
    'United Arab Emirates Dirham/South African Rand': 'AED/ZAR',
    'New Taiwan Dollar/New Zealand Dollar': 'TWD/NZD',
    'Singapore Dollar/Argentine Peso': 'SGD/ARS',
    'Australian Dollar/Swiss Franc': 'AUD/CHF',
    'Swedish Krona/Israeli New Shekel': 'SEK/ILS',
    'Gold (XAU)/Argentine Peso': 'XAU/ARS',
    'Euro/Danish Krone': 'EUR/DKK',
    'Peruvian Sol/British Pound Sterling': 'PEN/GBP',
    'Singapore Dollar/Turkish Lira': 'SGD/TRY',
    'New Taiwan Dollar/Chinese Yuan': 'TWD/CNY',
    'British Pound Sterling/Chilean Peso': 'GBP/CLP',
    'Argentine Peso/Singapore Dollar': 'ARS/SGD',
    'Nigerian Naira/South African Rand': 'NGN/ZAR',
    'Czech Koruna/Swiss Franc': 'CZK/CHF',
    'Euro/Canadian Dollar': 'EUR/CAD',
    'Euro/Polish Złoty': 'EUR/PLN',
    'Nigerian Naira/British Pound Sterling': 'NGN/GBP',
    'Singapore Dollar/Hong Kong Dollar': 'SGD/HKD',
    'Danish Krone/Indian Rupee': 'DKK/INR',
    'Singapore Dollar/Euro': 'SGD/EUR',
    'Canadian Dollar/South Korean Won': 'CAD/KRW',
    'Australian Dollar/United States Dollar': 'AUD/USD',
    'Mexican Peso/Japanese Yen': 'MXN/JPY',
    'Brazilian Real/Swiss Franc': 'BRL/CHF',
    'Danish Krone/Hungarian Forint': 'DKK/HUF',
    'Chinese Yuan/United States Dollar': 'CNY/USD',
    'South African Rand/Euro': 'ZAR/EUR',
    'Euro/Czech Koruna': 'EUR/CZK',
    'Canadian Dollar/Australian Dollar': 'CAD/AUD',
    'Canadian Dollar/Kuwaiti Dinar': 'CAD/KWD',
    'New Zealand Dollar/Mexican Peso': 'NZD/MXN',
    'Nicaraguan Córdoba/British Pound Sterling': 'NIO/GBP',
    'South Korean Won/Swedish Krona': 'KRW/SEK',
    'Danish Krone/Hong Kong Dollar': 'DKK/HKD',
    'Canadian Dollar/New Taiwan Dollar': 'CAD/TWD',
    'Norwegian Krone/Polish Złoty': 'NOK/PLN',
    'New Taiwan Dollar/Swiss Franc': 'TWD/CHF',
    'New Zealand Dollar/British Pound Sterling': 'NZD/GBP',
    'Canadian Dollar/Danish Krone': 'CAD/DKK',
    'Canadian Dollar/Thai Baht': 'CAD/THB',
    'CFP Franc/British Pound Sterling': 'XPF/GBP',
    'Australian Dollar/Singapore Dollar': 'AUD/SGD',
    'Indonesian Rupiah/Indian Rupee': 'IDR/INR',
    'Polish Złoty/Mexican Peso': 'PLN/MXN',
    'British Pound Sterling/Mexican Peso': 'GBP/MXN',
    'Thai Baht/Swiss Franc': 'THB/CHF',
    'Euro/New Taiwan Dollar': 'EUR/TWD',
    'Australian Dollar/Japanese Yen': 'AUD/JPY',
    'Danish Krone/Norwegian Krone': 'DKK/NOK',
    'South African Rand/Hong Kong Dollar': 'ZAR/HKD',
    'British Pound Sterling/Indian Rupee': 'GBP/INR',
    'Egyptian Pound/Euro': 'EGP/EUR',
    'Gold (XAU)/Indian Rupee': 'XAU/INR',
    'New Taiwan Dollar/Hong Kong Dollar': 'TWD/HKD',
    'Argentine Peso/Brazilian Real': 'ARS/BRL',
    'United States Dollar/Singapore Dollar': 'USD/SGD',
    'South Korean Won/Chinese Yuan': 'KRW/CNY',
    'Costa Rican Colón/British Pound Sterling': 'CRC/GBP',
    'Mexican Peso/South African Rand': 'MXN/ZAR',
    'Thai Baht/Hong Kong Dollar': 'THB/HKD',
    'British Pound Sterling/East Caribbean Dollar': 'GBP/XCD',
    'Gold (XAU)/Japanese Yen': 'XAU/JPY',
    'Canadian Dollar/Euro': 'CAD/EUR',
    'Pakistani Rupee/South African Rand': 'PKR/ZAR',
    'Mexican Peso/Polish Złoty': 'MXN/PLN',
    'Australian Dollar/Bulgarian Lev': 'AUD/BGN',
    'Indian Rupee/United States Dollar': 'INR/USD',
    'South African Rand/New Taiwan Dollar': 'ZAR/TWD',
    'New Zealand Dollar/Australian Dollar': 'NZD/AUD',
    'Argentine Peso/Australian Dollar': 'ARS/AUD',
    'Qatari Rial/South African Rand': 'QAR/ZAR',
    'Hungarian Forint/Canadian Dollar': 'HUF/CAD',
    'Mexican Peso/Canadian Dollar': 'MXN/CAD',
    'Swedish Krona/Australian Dollar': 'SEK/AUD',
    'South African Rand/Romanian Leu': 'ZAR/RON',
    'Malaysian Ringgit/Indian Rupee': 'MYR/INR',
    'Honduran Lempira/British Pound Sterling': 'HNL/GBP',
    'Polish Złoty/Japanese Yen': 'PLN/JPY',
    'United States Dollar/Euro': 'USD/EUR',
    'Singapore Dollar/Indonesian Rupiah': 'SGD/IDR',
    'Gold (XAU)/Saudi Riyal': 'XAU/SAR',
    'Israeli New Shekel/Australian Dollar': 'ILS/AUD',
    'Canadian Dollar/British Pound Sterling': 'CAD/GBP',
    'United States Dollar/British Pound Sterling': 'USD/GBP',
    'Thai Baht/Singapore Dollar': 'THB/SGD',
    'Indian Rupee/South Korean Won': 'INR/KRW',
    'Indian Rupee/New Zealand Dollar': 'INR/NZD',
    'Indian Rupee/Australian Dollar': 'INR/AUD',
    'British Pound Sterling/Bermudian Dollar': 'GBP/BMD',
    'Australian Dollar/Philippine Peso': 'AUD/PHP',
    'Hungarian Forint/South African Rand': 'HUF/ZAR',
    'United States Dollar/Philippine Peso': 'USD/PHP',
    'Swedish Krona/Norwegian Krone': 'SEK/NOK',
    'Chinese Yuan/British Pound Sterling': 'CNY/GBP',
    'Canadian Dollar/Hungarian Forint': 'CAD/HUF',
    'Icelandic Króna/Swiss Franc': 'ISK/CHF',
    'Bulgarian Lev/Australian Dollar': 'BGN/AUD',
    'Indian Rupee/Canadian Dollar': 'INR/CAD',
    'Euro/New Zealand Dollar': 'EUR/NZD',
    'Thai Baht/Canadian Dollar': 'THB/CAD',
    'Singapore Dollar/South Korean Won': 'SGD/KRW',
    'Swiss Franc/Euro': 'CHF/EUR',
    'Gold (XAU)/South African Rand': 'XAU/ZAR',
    'Australian Dollar/Chilean Peso': 'AUD/CLP',
    'Swiss Franc/Chilean Peso': 'CHF/CLP',
    'Vietnamese Đồng/Euro': 'VND/EUR',
    'Swiss Franc/Pakistani Rupee': 'CHF/PKR',
    'Swiss Franc/South Korean Won': 'CHF/KRW',
    'Argentine Peso/Japanese Yen': 'ARS/JPY',
    'Sri Lankan Rupee/South African Rand': 'LKR/ZAR',
    'Japanese Yen/South African Rand': 'JPY/ZAR',
    'Thai Baht/South African Rand': 'THB/ZAR',
    'Australian Dollar/Israeli New Shekel': 'AUD/ILS',
    'Swedish Krona/Euro': 'SEK/EUR',
    'South African Rand/Indonesian Rupiah': 'ZAR/IDR',
    'United States Dollar/Swiss Franc': 'USD/CHF',
    'Australian Dollar/Thai Baht': 'AUD/THB',
    'Euro/Argentine Peso': 'EUR/ARS',
    'South African Rand/Argentine Peso': 'ZAR/ARS',
    'Norwegian Krone/Swiss Franc': 'NOK/CHF',
    'New Taiwan Dollar/South Korean Won': 'TWD/KRW',
    'Singapore Dollar/Canadian Dollar': 'SGD/CAD',
    'Canadian Dollar/Singapore Dollar': 'CAD/SGD',
    'British Pound Sterling/Polish Złoty': 'GBP/PLN',
    'Vietnamese Đồng/Canadian Dollar': 'VND/CAD',
    'Canadian Dollar/Mexican Peso': 'CAD/MXN',
    'Polish Złoty/Swedish Krona': 'PLN/SEK',
    'British Pound Sterling/Argentine Peso': 'GBP/ARS',
    'Chinese Yuan/Canadian Dollar': 'CNY/CAD',
    'British Pound Sterling/Australian Dollar': 'GBP/AUD',
    'Thai Baht/Indian Rupee': 'THB/INR',
    'Swiss Franc/British Pound Sterling': 'CHF/GBP',
    'Singapore Dollar/United States Dollar': 'SGD/USD',
    'Japanese Yen/United States Dollar': 'JPY/USD',
    'Peruvian Sol/Argentine Peso': 'PEN/ARS',
    'United States Dollar/Polish Złoty': 'USD/PLN',
    'Australian Dollar/Norwegian Krone': 'AUD/NOK',
    'South African Rand/Nigerian Naira': 'ZAR/NGN',
    'Canadian Dollar/Swedish Krona': 'CAD/SEK',
    'Swiss Franc/Danish Krone': 'CHF/DKK',
    'Polish Złoty/Euro': 'PLN/EUR',
    'Czech Koruna/Swedish Krona': 'CZK/SEK',
    'Canadian Dollar/Polish Złoty': 'CAD/PLN',
    'United States Dollar/Czech Koruna': 'USD/CZK',
    'British Pound Sterling/Guatemalan Quetzal': 'GBP/GTQ',
    'Mexican Peso/Czech Koruna': 'MXN/CZK',
    'Chinese Yuan (Offshore)/Hong Kong Dollar': 'CNH/HKD',
    'Indonesian Rupiah/United States Dollar': 'IDR/USD',
    'United States Dollar/Mexican Peso': 'USD/MXN',
    'Malaysian Ringgit/New Taiwan Dollar': 'MYR/TWD',
    'Hungarian Forint/United States Dollar': 'HUF/USD',
    'Lithuanian Litas/Australian Dollar': 'LTL/AUD',
    'Euro/Indian Rupee': 'EUR/INR',
    'Turkish Lira/Singapore Dollar': 'TRY/SGD',
    'Swedish Krona/Japanese Yen': 'SEK/JPY',
    'Canadian Dollar/Bulgarian Lev': 'CAD/BGN',
    'New Taiwan Dollar/Indian Rupee': 'TWD/INR',
    'Japanese Yen/Argentine Peso': 'JPY/ARS',
    'United States Dollar/New Zealand Dollar': 'USD/NZD',
    'British Pound Sterling/Egyptian Pound': 'GBP/EGP',
    'Swiss Franc/Turkish Lira': 'CHF/TRY',
    'British Pound Sterling/Philippine Peso': 'GBP/PHP',
    'Colombian Peso/Argentine Peso': 'COP/ARS',
    'Hungarian Forint/Swiss Franc': 'HUF/CHF',
    'Hungarian Forint/Japanese Yen': 'HUF/JPY',
    'British Pound Sterling/Nicaraguan Córdoba': 'GBP/NIO',
    'Australian Dollar/New Taiwan Dollar': 'AUD/TWD',
    'Australian Dollar/Canadian Dollar': 'AUD/CAD',
    'Czech Koruna/Polish Złoty': 'CZK/PLN',
    'Mexican Peso/Euro': 'MXN/EUR',
    'Danish Krone/Australian Dollar': 'DKK/AUD',
    'Gold (XAU)/Brazilian Real': 'XAU/BRL',
    'British Pound Sterling/Japanese Yen': 'GBP/JPY',
    'United States Dollar/Japanese Yen': 'USD/JPY',
    'Thai Baht/Australian Dollar': 'THB/AUD',
    'Swiss Franc/Norwegian Krone': 'CHF/NOK',
    'Chinese Yuan/New Zealand Dollar': 'CNY/NZD',
    'Hong Kong Dollar/South Korean Won': 'HKD/KRW',
    'Guatemalan Quetzal/British Pound Sterling': 'GTQ/GBP',
    'New Zealand Dollar/Hungarian Forint': 'NZD/HUF',
    'Hong Kong Dollar/Indonesian Rupiah': 'HKD/IDR',
    'Tanzanian Shilling/South African Rand': 'TZS/ZAR',
    'British Pound Sterling / Turkish Lira': 'GBP/TRY',
    'Swiss Franc / Russian Ruble': 'CHF/RUB',
    'Polish Złoty / Danish Krone': 'PLN/DKK',
    'Australian Dollar / Argentine Peso': 'AUD/ARS',
    'Silver (XAG) / Japanese Yen': 'XAG/JPY',
    'Romanian Leu / Swiss Franc': 'RON/CHF',
    'British Pound Sterling / Hong Kong Dollar': 'GBP/HKD',
    'Mexican Peso / Hong Kong Dollar': 'MXN/HKD',
    'Thai Baht / United States Dollar': 'THB/USD',
    'Japanese Yen / Mexican Peso': 'JPY/MXN',
    'New Taiwan Dollar / United States Dollar': 'TWD/USD',
    'Canadian Dollar / United States Dollar': 'CAD/USD',
    'Danish Krone / Turkish Lira': 'DKK/TRY',
    'Romanian Leu / South African Rand': 'RON/ZAR',
    'British Pound Sterling / Nigerian Naira': 'GBP/NGN',
    'United States Dollar / Indonesian Rupiah': 'USD/IDR',
    'South African Rand / Turkish Lira': 'ZAR/TRY',
    'British Pound Sterling / Swiss Franc': 'GBP/CHF',
    'Turkish Lira / Swiss Franc': 'TRY/CHF',
    'British Pound Sterling / Peruvian Nuevo Sol': 'GBP/PEN',
    'Indonesian Rupiah / New Zealand Dollar': 'IDR/NZD',
    'Danish Krone / Japanese Yen': 'DKK/JPY',
    'Singapore Dollar / Swiss Franc': 'SGD/CHF',
    'Australian Dollar / Indonesian Rupiah': 'AUD/IDR',
    'Swiss Franc / Canadian Dollar': 'CHF/CAD',
    'Hong Kong Dollar / Swedish Krona': 'HKD/SEK',
    'Norwegian Krone / South African Rand': 'NOK/ZAR',
    'Malaysian Ringgit / New Zealand Dollar': 'MYR/NZD',
    'Turkish Lira / Danish Krone': 'TRY/DKK',
    'Indian Rupee / Hong Kong Dollar': 'INR/HKD',
    'Danish Krone / Russian Ruble': 'DKK/RUB',
    'Singapore Dollar / Japanese Yen': 'SGD/JPY',
    'Euro / Japanese Yen': 'EUR/JPY',
    'Norwegian Krone / Israeli New Shekel': 'NOK/ILS',
    'Danish Krone / Singapore Dollar': 'DKK/SGD',
    'Philippine Peso / United States Dollar': 'PHP/USD',
    'Australian Dollar / Mexican Peso': 'AUD/MXN',
    'South African Rand / Danish Krone': 'ZAR/DKK',
    'United States Dollar / Hungarian Forint': 'USD/HUF',
    'Canadian Dollar / Cayman Islands Dollar': 'CAD/KYD',
    'Euro / United States Dollar': 'EUR/USD',
    'Chinese Yuan / Hong Kong Dollar': 'CNY/HKD',
    'South Korean Won / New Zealand Dollar': 'KRW/NZD',
    'Silver (XAG) / Mexican Peso': 'XAG/MXN',
    'Danish Krone / New Taiwan Dollar': 'DKK/TWD',
    'Swedish Krona / United States Dollar': 'SEK/USD',
    'Canadian Dollar / Argentine Peso': 'CAD/ARS',
    'Euro / South African Rand': 'EUR/ZAR',
    'Philippine Peso / Japanese Yen': 'PHP/JPY',
    'Polish Złoty / Norwegian Krone': 'PLN/NOK',
    'New Zealand Dollar / Singapore Dollar': 'NZD/SGD',
    'Euro / Hong Kong Dollar': 'EUR/HKD',
    'Euro / Egyptian Pound': 'EUR/EGP',
    'Japanese Yen / Swedish Krona': 'JPY/SEK',
    'Hong Kong Dollar / Mexican Peso': 'HKD/MXN',
    'Brazilian Real / Australian Dollar': 'BRL/AUD',
    'United States Dollar / Turkish Lira': 'USD/TRY',
    'Indian Rupee / South African Rand': 'INR/ZAR',
    'South Korean Won / Euro': 'KRW/EUR',
    'Canadian Dollar / Russian Ruble': 'CAD/RUB',
    'Hong Kong Dollar / Japanese Yen': 'HKD/JPY',
    'Chinese Yuan / Indian Rupee': 'CNY/INR',
    'Israeli New Shekel / Swedish Krona': 'ILS/SEK',
    'Canadian Dollar / Indian Rupee': 'CAD/INR',
    'Mexican Peso / Danish Krone': 'MXN/DKK',
    'Canadian Dollar / Bermudian Dollar': 'CAD/BMD',
    'New Zealand Dollar / South Korean Won': 'NZD/KRW',
    'New Zealand Dollar / New Taiwan Dollar': 'NZD/TWD',
    'Hungarian Forint / Euro': 'HUF/EUR',
    'South African Rand / Hungarian Forint': 'ZAR/HUF',
    'Polish Złoty / United States Dollar': 'PLN/USD',
    'Danish Krone / Chinese Yuan': 'DKK/CNY',
    'Japanese Yen / Danish Krone': 'JPY/DKK',
    'South African Rand / South Korean Won': 'ZAR/KRW',
    'Egyptian Pound / United States Dollar': 'EGP/USD',
    'Euro / Hungarian Forint': 'EUR/HUF'}



crypto_currency_pairs = {
    'COVAL-USD': 'Circuits of Value to US Dollar',
    'BTT-USD': 'BitTorrent to US Dollar',
    'SEI-USD': 'SatoExchange to US Dollar',
    'CLV-USD': 'Clover Finance to US Dollar',
    'ALCX-USD': 'Alchemix to US Dollar',
    'AUCTION-USD': 'Bounce to US Dollar',
    'TRU-USD': 'TrueFi to US Dollar',
    'EOS-USD': 'EOS to US Dollar',
    'BNT-USD': 'Bancor to US Dollar',
    'SNT-USD': 'Status to US Dollar',
    'DASH-USD': 'Dash to US Dollar',
    'DNT-USD': 'district0x to US Dollar',
    'SPELL-USD': 'Spell to US Dollar',
    'LCX-USD': 'LCX to US Dollar',
    'SWFTC-USD': 'SwftCoin to US Dollar',
    'XRP-AUD': 'XRP to Australian Dollar',
    'INJ-USD': 'Injective Protocol to US Dollar',
    'REQ-USD': 'Request to US Dollar',
    'FIS-USD': 'Stafi to US Dollar',
    'ATOM-USD': 'Cosmos to US Dollar',
    'VET-USD': 'VeChain to US Dollar',
    'FORTH-USD': 'Ampleforth Governance Token to US Dollar',
    'SAND-USD': 'Sandbox to US Dollar',
    'OGN-USD': 'Origin Protocol to US Dollar',
    'JST-USD': 'JUST to US Dollar',
    'IOT-USD': 'IOTA to US Dollar',
    'AVAX-USD': 'Avalanche to US Dollar',
    'SOL-USD': 'Solana to US Dollar',
    'HBAR-USD': 'Hedera Hashgraph to US Dollar',
    'LTC-USD': 'Litecoin to US Dollar',
    'BCH-EUR': 'Bitcoin Cash to Euro',
    'CRO-USD': 'Crypto.com Coin to US Dollar',
    'UST-USD': 'TerraUSD to US Dollar',
    'ZIL-USD': 'Zilliqa to US Dollar',
    'ICX-USD': 'ICON to US Dollar',
    'XVG-USD': 'Verge to US Dollar',
    'BTC-USD': 'Bitcoin to US Dollar',
    'CGLD-USD': 'Celo to US Dollar',
    'TVK-USD': 'Theta Fuel to US Dollar',
    'COMP-USD': 'Compound to US Dollar',
    'LYM-USD': 'Lympo to US Dollar',
    'RAI-USD': 'Rai Reflex Index to US Dollar',
    'STX-USD': 'Stacks to US Dollar',
    'ACH-USD': 'Alchemy Pay to US Dollar',
    'ETH-AUD': 'Ethereum to Australian Dollar',
    'ENJ-USD': 'Enjin Coin to US Dollar',
    'FARM-USD': 'Harvest Finance to US Dollar',
    'IMX-USD': 'Immutable X to US Dollar',
    'MLN-USD': 'Enzyme to US Dollar',
    'BADGER-USD': 'Badger DAO to US Dollar',
    'DOT-USD': 'Polkadot to US Dollar',
    'LTC-EUR': 'Litecoin to Euro',
    'ADA-USD': 'Cardano to US Dollar',
    'XMR-USD': 'Monero to US Dollar',
    'UTK-USD': 'Utrust to US Dollar',
    'NKN-USD': 'NKN to US Dollar',
    'XRP-BTC': 'XRP to Bitcoin',
    'C98-USD': 'Coin98 to US Dollar',
    'NEAR-USD': 'NEAR Protocol to US Dollar',
    'CSM-USD': 'Cryptosol to US Dollar',
    'FTM-USD': 'Fantom to US Dollar',
    'CVX-USD': 'Convex Finance to US Dollar',
    'RLC-USD': 'iExec RLC to US Dollar',
    'SHIB-USD': 'Shiba Inu to US Dollar',
    'NEO-USD': 'NEO to US Dollar',
    '1INCH-USD': '1inch to US Dollar',
    'ARPA-USD': 'ARPA Chain to US Dollar',
    'XLM-USD': 'Stellar Lumens to US Dollar',
    'MKR-USD': 'Maker to US Dollar',
    'GNO-USD': 'Gnosis to US Dollar',
    'IOTX-USD': 'IoTeX to US Dollar',
    'KNC-USD': 'Kyber Network to US Dollar',
    'APE-USD': 'ApeCoin to US Dollar',
    'CTSI-USD': 'Cartesi to US Dollar',
    'ETH-BTC': 'Ethereum to Bitcoin',
    'GLM-USD': 'Golem to US Dollar',
    'LUNA-USD': 'Terra to US Dollar',
    'USDT-USD': 'Tether to US Dollar',
    'LTC-BTC': 'Litecoin to Bitcoin',
    'BOND-USD': 'BarnBridge to US Dollar',
    'RARI-USD': 'Rarible to US Dollar',
    'COTI-USD': 'COTI to US Dollar',
    'GRT-USD': 'The Graph to US Dollar',
    'STORJ-USD': 'Storj to US Dollar',
    'GUSD-USD': 'Gemini Dollar to US Dollar',
    'UNI-USD': 'Uniswap to US Dollar',
    'UMA-USD': 'UMA to US Dollar',
    'OCEAN-USD': 'Ocean Protocol to US Dollar',
    'FIL-USD': 'Filecoin to US Dollar',
    'BTC-GBP': 'Bitcoin to British Pound',
    'USDC-USD': 'USD Coin to US Dollar',
    'API3-USD': 'API3 to US Dollar',
    'QNT-USD': 'Quant to US Dollar',
    'ALGO-USD': 'Algorand to US Dollar',
    'DYDX-USD': 'dYdX to US Dollar',
    'BTC-EUR': 'Bitcoin to Euro',
    'SUSHI-USD': 'SushiSwap to US Dollar',
    'BCH-USD': 'Bitcoin Cash to US Dollar',
    'CRV-USD': 'Curve DAO Token to US Dollar',
    'RUNE-USD': 'THORChain to US Dollar',
    'ZEC-USD': 'Zcash to US Dollar',
    'XRP-USD': 'XRP to US Dollar',
    'PAX-USD': 'Paxos Standard to US Dollar',
    'ZRX-USD': '0x to US Dollar',
    'ETC-USD': 'Ethereum Classic to US Dollar',
    'AMP-USD': 'Amp to US Dollar',
    'SUKU-USD': 'SUKU to US Dollar',
    'MANA-USD': 'Decentraland to US Dollar',
    'BCH-GBP': 'Bitcoin Cash to British Pound',
    'AVT-USD': 'Aventus to US Dollar',
    'QTF-USD': 'Quickswap to US Dollar',
    'ALICE-USD': 'MyNeighborAlice to US Dollar',
    'PERP-USD': 'Perpetual Protocol to US Dollar',
    'ROSE-USD': 'Oasis Network to US Dollar',
    'FET-USD': 'Fetch.ai to US Dollar',
    'TRX-USD': 'TRON to US Dollar',
    'NCT-USD': 'PolySwarm to US Dollar',
    'OXT-USD': 'Orchid to US Dollar',
    'BTRST-USD': 'Bitrue Coin to US Dollar',
    'PNK-USD': 'Kleros to US Dollar',
    'GTC-USD': 'Gitcoin to US Dollar',
    'TRAC-USD': 'OriginTrail to US Dollar',
    'PLA-USD': 'PlayDapp to US Dollar',
    'ZEN-USD': 'Horizen to US Dollar',
    'DSH-USD': 'Dashcoin to US Dollar',
    'AXS-USD': 'Axie Infinity to US Dollar',
    'SRM-USD': 'Serum to US Dollar',
    'RNDR-USD': 'Render Token to US Dollar',
    'XTZ-USD': 'Tezos to US Dollar',
    'SC-USD': 'Siacoin to US Dollar',
    'OMG-USD': 'OMG Network to US Dollar',
    'PAXG-USD': 'Paxos Gold to US Dollar',
    'FX-USD': 'Function X to US Dollar',
    'LRC-USD': 'Loopring to US Dollar',
    'ANKR-USD': 'Ankr to US Dollar',
    'ETH-USD': 'Ethereum to US Dollar',
    'KSM-USD': 'Kusama to US Dollar',
    'TRB-USD': 'Tellor to US Dollar',
    'NANO-USD': 'Nano to US Dollar',
    'CVC-USD': 'Civic to US Dollar',
    'QRDO-USD': 'Qredo to US Dollar',
    'XYO-USD': 'XYO Network to US Dollar',
    'WBTC-USD': 'Wrapped Bitcoin to US Dollar',
    'DOGE-USD': 'Dogecoin to US Dollar',
    'FCL-USD': 'Fractal to US Dollar',
    'GALA-USD': 'Gala to US Dollar',
    'JASMY-USD': 'JasmyCoin to US Dollar',
    'KAVA-USD': 'Kava to US Dollar',
    'TIA-USD': 'Tia Token to US Dollar',
    'BOSON-USD': 'Boson Protocol to US Dollar',
    'ICP-USD': 'Internet Computer to US Dollar',
    'WAVES-USD': 'Waves to US Dollar',
    'LINK-USD': 'Chainlink to US Dollar',
    'BOBA-USD': 'Boba Network to US Dollar',
    'DYDX-EUR': 'dYdX to Euro',
    'QTUM-USD': 'Qtum to US Dollar',
    'YFI-USD': 'yearn.finance to US Dollar',
    'ELA-USD': 'Elastos to US Dollar',
    'CHZ-USD': 'Chiliz to US Dollar',
    'BAND-USD': 'Band Protocol to US Dollar',
    'MASK-USD': 'Mask Network to US Dollar',
    'NEXO-USD': 'Nexo to US Dollar',
    'SEI-EUR': 'SatoExchange to Euro',
    'XRD-USD': 'Radix to US Dollar',
    'KEEP-USD': 'Keep3rV1 to US Dollar',
    'EGLD-USD': 'Elrond to US Dollar',
    'LPT-USD': 'Livepeer to US Dollar',
    'FOX-USD': 'ShapeShift FOX Token to US Dollar',
    'NMR-USD': 'Numeraire to US Dollar',
    'SGB-USD': 'Digital Silver to US Dollar',
    'DUSK-USD': 'Dusk Network to US Dollar',
    'BTC-AUD': 'Bitcoin to Australian Dollar',
    'FLOW-USD': 'Flow to US Dollar',
    'SNX-USD': 'Synthetix to US Dollar',
    'SKL-USD': 'Skale Network to US Dollar',
    'DAI-USD': 'Dai to US Dollar',
    'GHST-USD': 'Aavegotchi to US Dollar',
    'MATIC-USD': 'Polygon to US Dollar',
    'ORN-USD': 'Orion Protocol to US Dollar',
    'GYEN-USD': 'Digital Yen to US Dollar',
    'AAVE-USD': 'Aave to US Dollar',
    'UOS-USD': 'Ultra to US Dollar',
    'TLOS-USD': 'Telos to US Dollar',
    'ASM-USD': 'Assemble Protocol (ASM) to US Dollar',
    'BAL-USD': 'Balancer (BAL) to US Dollar',
    'KRL-USD': 'Kryll (KRL) to US Dollar',
    'BAT-USD': 'Basic Attention Token (BAT) to US Dollar'}


CRYPTO_HOOKS = {
    "1INCH-USD": os.environ.get('1INCH_USD'),
    "AAVE-USD": os.environ.get('AAVE_USD'),
    "ACH-USD": os.environ.get('ACH_USD'),
    "ALGO-USD": os.environ.get('ALGO_USD'),
    "ANKR-USD": os.environ.get('ANKR_USD'),
    "ATOM-USD": os.environ.get('ATOM_USD'),
    "AVA-USD": os.environ.get('AVA_USD'),
    "BAL-USD": os.environ.get('BAL_USD'),
    "BAND-USD": os.environ.get('BAND_USD'),
    "BAT-USD": os.environ.get('BAT_USD'),
    "BCH-USD": os.environ.get('BCH_USD'),
    "BNB-USD": os.environ.get('BNB_USD'),
    "BTC-USD": os.environ.get('BTC_USD'),
    "CELO-USD": os.environ.get('CELO_USD'),
    "CHZ-USD": os.environ.get('CHZ_USD'),
    "CRO-USD": os.environ.get('CRO_USD'),
    "CRV-USD": os.environ.get('CRV_USD'),
    "DAI-USD": os.environ.get('DAI_USD'),
    "DASH-USD": os.environ.get('DASH_USD'),
    "DOGE-USD": os.environ.get('DOGE_USD'),
    "DOT-USD": os.environ.get('DOT_USD'),
    "ENJ-USD": os.environ.get('ENJ_USD'),
    "EOS-USD": os.environ.get('EOS_USD'),
    "ETC-USD": os.environ.get('ETC_USD'),
    "ETH-USD": os.environ.get('ETH_USD'),
    "FIL-USD": os.environ.get('FIL_USD'),
    "FLOW-USD": os.environ.get('FLOW_USD'),
    "GRT-USD": os.environ.get('GRT_USD'),
    "ICP-USD": os.environ.get('ICP_USD'),
    "KNC-USD": os.environ.get('KNC_USD'),
    "LINK-USD": os.environ.get('LINK_USD'),
    "LRC-USD": os.environ.get('LRC_USD'),
    "LTC-USD": os.environ.get('LTC_USD'),
    "MANA-USD": os.environ.get('MANA_USD'),
    "MATIC-USD": os.environ.get('MATIC_USD'),
    "MKR-USD": os.environ.get('MKR_USD'),
    "NANO-USD": os.environ.get('NANO_USD'),
    "OMG-USD": os.environ.get('OMG_USD'),
    "PAX-USD": os.environ.get('PAX_USD'),
    "QTUM-USD": os.environ.get('QTUM_USD'),
    "REN-USD": os.environ.get('REN_USD'),
    "SOL-USD": os.environ.get('SOL_USD'),
    "STMX-USD": os.environ.get('STMX_USD'),
    "STORJ-USD": os.environ.get('STORJ_USD'),
    "SUSHI-USD": os.environ.get('SUSHI_USD'),
    "TRX-USD": os.environ.get('TRX_USD'),
    "UNI-USD": os.environ.get('UNI_USD'),
    "USDC-USD": os.environ.get('USDC_USD'),
    "USDT-USD": os.environ.get('USDT_USD'),
    "VET-USD": os.environ.get('VET_USD'),
    "WAVES-USD": os.environ.get('WAVES_USD'),
    "XLM-USD": os.environ.get('XLM_USD'),
    "XMR-USD": os.environ.get('XMR_USD'),
    "XRP-USD": os.environ.get('XRP_USD'),
    "XTZ-USD": os.environ.get('XTZ_USD'),
    "YFI-USD": os.environ.get('YFI_USD'),
    "ZEC-USD": os.environ.get('ZEC_USD'),
    "ZEN-USD": os.environ.get('ZEN_USD'),
    "ZRX-USD": os.environ.get('ZRX_USD'),
}




market_sectors = {
    "basic_materials": [
        "MOS", "DNN", "CARR", "KGC", "CLF", "NEM", "TECK", "X",
        "BVN", "RIO", "SBSW", "FCX", "GOLD", "AG", "DOW", "CCJ",
        "PAAS", "MP", "TMC", "AA", "ALB", "HL", "BTU", "AEM", "VALE",
        "BTG", "DD"
    ],
    "communication_services": [
        "GSAT", "LUMN", "T", "ASTS", "VZ", "TMUS", "ZM", "VOD"
    ],
    "consumer_cyclical": [
        "LVS", "NFLX", "SIRI", "ROKU", "MCD", "TSLA", "QS", "RIVN",
        "WYNN", "NIO", "PENN", "AMC", "M", "GME", "XPEV", "PARA",
        "LI", "ONON", "HD", "MLCO", "LOW", "STLA", "FSR", "CMCSA",
        "CROX", "DIS", "CHPT", "WBD", "LEVI", "NKE", "MGM", "JWN",
        "HBI", "FFIE", "CMG", "DKNG", "AAP", "LCID", "FUBO", "VFC",
        "CZR", "SBUX", "F", "LEN", "GOEV", "LULU", "GT", "NKLA",
        "MANU", "PTON", "GM", "DISH"
    ],
    "consumer_defensive": [
        "KO", "KHC", "BYND", "WMT", "PG", "COTY", "TSN", "MO",
        "PEP", "KR", "TGT", "COST", "BUD", "GIS", "WBA"
    ],
    "utilities": [
        'NEE', 'PCG', 'DUK'
    ],
    "energy": [
        "RIG", "WMB", "COP", "DK", "ETRN", "SLB", "APA", "CVX",
        "KMI", "BP", "SU", "PAA", "HAL", "SWN", "XOM", "DVN",
        "PBR", "TELL", "MRO", "EPD", "SHEL", "EQT", "AR", "ET",
        "VLO", "OXY", "CVE"
    ],
    "real_estate": [
        "BMY", "TLRY", "SNDL", "ACB", "BTAI", "AMGN", "DNA", "AZN",
        "CLOV", "MRK", "PFE", "CRBU", "HUM", "CVS", "CGC", "BBIO",
        "AUPH", "LLY", "MRNA", "NVAX", "SGEN", "MDT", "ABBV", "ABT",
        "JNJ", "TEVA", "PACB", "ACRS", "UNH", "GILD", "VBIV", "HZNP",
        "ISEE", "UPS", "RTX", "ENVX", "GE", "CCL", "UAL",
        "ZIM", "HTZ", "NCLH", "PSNY", "B", "RCL", "AAL", "GNRC", "MMM",
        "CAT", "PLUG", "DAL", "SAVE", "JBLU", "IEP", "JOBY", "SPCE",
        "EOSE", "FDX", "BA", "FCEL", "LUV", "BEKE", "NLY", "SLG",
        "CIM", "ABR", "OPEN", "AGNC", "MPW", "CBL"
    ],
    "industrials": [
        "UPS", "RTX", "ENVX", "GE", "CCL", "UAL", "ZIM", "HTZ",
        "NCLH", "PSNY", "B", "RCL", "AAL", "GNRC", "MMM", "CAT",
        "PLUG", "DAL", "SAVE", "JBLU", "IEP", "JOBY", "SPCE",
        "EOSE", "FDX", "BA", "FCEL", "LUV"
    ],
    "financial_services": [
        "WFC", "C", "MARA", "UPST", "BCS", "BITF", "BAC", "V",
        "COF", "BBD", "PYPL", "HUT", "SOFI", "GS", "JPM", "AXP",
        "XP", "MA", "USB", "NU", "TFC", "SCHW", "TRUP", "ZION",
        "KEY", "DB", "BX", "NYCB", "PACW", "UBS", "ALLY", "MS",
        "FUTU"
    ],
    "technology": [
        "AMD", "AFRM", "ENPH", "STNE", "OSTK", "SPWR", "MU", "W",
        "PATH", "DOCN", "SE", "QCOM", "ON", "FSLR", "DM", "META",
        "ADBE", "NNDM", "MSFT", "NOK", "WDC", "APLD", "MMAT",
        "MELI", "EBAY", "INTC", "MQ", "NET", "SIMO", "DASH", "CRWD",
        "ETSY", "PANW", "MVIS", "ATVI", "RBLX", "ABNB", "ORCL",
        "RIOT", "EBIX", "BILI", "IQ", "GOOGL", "AI", "LRCX", "U",
        "RUN", "MULN", "PDD", "OKTA", "CPNG", "MSTR", "CRM", "TTD",
        "MRVL", "HOOD", "BABA", "UBER", "SPLK", "BMBL", "IBM", "JD",
        "SNOW", "MDB", "CSCO", "CVNA", "TWLO", "GENI", "SOUN",
        "GOOG", "DDOG", "PLTR", "FIS", "CLSK", "Z", "BIDU", "AAPL",
        "CHWY", "JMIA", "ZS", "TDOC", "AMAT", "AMZN", "HPQ", "BB",
        "LAZR", "FTCH", "IONQ", "NVDA", "SHOP", "MTCH", "LYFT",
        "TXN", "SNAP",
        "SMCI", "DOCU", "TSM", "COIN", "SQ", "PINS", "AVGO"
    ],

    "etfs": [
        'XLF', 'XLK', 'EWU', 'UUP', 'TNA', 'EWZ', 'DIA', 'UPRO', 'TMF', 'TQQQ', 
        'XOP', 'TZA', 'UCO', 'SMH', 'EWG', 'SOXS', 'HYG', 'IWM', 'IWN', 'XLP', 'SPXL', 
        'LQD', 'EFA', 'USO', 'EEM', 'SPXS', 'KWEB', 'KOLD', 'FXI', 'QQQ', 'XLV', 
        'SPXU', 'IEI', 'XRT', 'EMB', 'TIP', 'SPY', 'BITO', 'MSOS', 'SOXL', 'UNG', 
        'FNGS', 'ARKK', 'LABU', 'GLD', 'XLE', 'XHB', 'XBI', 'KRE', 'TBT', 'BOIL', 
        'TSLL', 'DPST', 'IEF', 'SQQQ', 'EWJ', 'TLT', 'SLV', 'JETS', 'XLI', 'IYR', 
        'XLU', 'XLY',

    ],

    "indexes": [ 
        'I:SPX', 'I:VIX', 'I:RUT', 'I:NDX', 'I:DJI'
    ]
}




basic_materials= ['LIN', 'BHP', 'RIO', 'SHW', 'VALE', 'SCCO', 'FCX', 'APD', 'ECL', 'TT', 'CRH', 'CARR', 'NUE', 'JCI', 'DOW', 'PPG', 'DD', 'CTVA', 'MLM', 'LYB', 'GOLD', 'NEM', 'VMC', 'NTR', 'PKX', 'AEM', 'WPM', 'MT', 'BLDR', 'IFF', 'FNV', 'CCJ', 'TECK', 'STLD', 'WLK', 'JHX', 'RS', 'CE', 'LII', 'MAS', 'AVTR', 'ALB', 'SUZ', 'CF', 'CSL', 'SQM', 'RPM', 'OC', 'CX', 'GFI', 'MOS', 'X', 'EMN', 'WMS', 'FBIN', 'CLF', 'TREX', 'TX', 'RGLD', 'SSD', 'GGB', 'FMC', 'UFPI', 'AXTA', 'EXP', 'AU', 'WFG', 'KGC', 'OLN', 'CMC', 'AAON', 'AZEK', 'AA', 'AMR', 'ESI', 'NEU', 'PAAS', 'BCC', 'AGI', 'SID', 'LPX', 'BCPC', 'CC', 'AWI', 'SUM', 'FUL', 'CBT', 'ASH', 'HUN', 'NXE', 'WDFC', 'KNF', 'KWR', 'HMY', 'SBSW', 'AVNT', 'SMG', 'GMS', 'HCC', 'BTU', 'MP', 'ARCH', 'MEOH', 'CEIX', 'SGML', 'IOSP', 'ARLP', 'UEC', 'SXT', 'CSTM', 'HL', 'OR', 'TFPM', 'EGO', 'MTRN', 'ROCK', 'PGTI', 'MTX', 'SSRM', 'TGLS', 'JBI', 'TROX', 'SCL', 'SLVM', 'DOOR', 'HBM', 'ERO', 'JELD', 'AG', 'NGVT', 'EQX', 'OEC', 'HWKN', 'GPRE', 'NRP', 'NG', 'APOG', 'GSM', 'CGAU', 'UUUU', 'FSM', 'METC', 'ALTM', 'IE', 'CENX', 'KOP', 'KALU', 'CDE', 'NX', 'MAG', 'ASTL', 'ASPN', 'SA', 'LAAC', 'SILV', 'TMST', 'SXC', 'LAC', 'ARLO', 'BIOX', 'CMP', 'WLKP', 'LEU', 'REX', 'MATV', 'UAN', 'ASIX', 'TILE', 'ZEUS', 'DRD', 'NFGC', 'HDSN', 'LXU', 'CLW', 'LWLG', 'PLL', 'GATO', 'TMC', 'TGB', 'MUX', 'AVD', 'ATLX', 'HNRG', 'RYAM', 'IPI', 'FF', 'TSE', 'PPTA', 'ABAT', 'ALTO', 'USAP', 'MTA', 'CMCL', 'ACNT', 'ORGN', 'PPIH', 'APT', 'USAU', 'MSB', 'NEXA', 'BVN']


technology = ['AWIN','LYT','SOPA', 'CYN','MMAT', 'WISA', 'PHUN', 'TWKS', 'AAPL', 'MSFT', 'NVDA', 'TSM', 'AVGO', 'ORCL', 'ASML', 'ADBE', 'CRM', 'AMD', 'ACN', 'CSCO', 'INTC', 'SAP', 'INTU', 'QCOM', 'TXN', 'NOW', 'IBM', 'UBER', 'AMAT', 'SONY', 'SHOP', 'PANW', 'LRCX', 'ADI', 'MU', 'FI', 'ANET', 'INFY', 'KLAC', 'SNPS', 'WDAY', 'CDNS', 'ARM', 'CRWD', 'SNOW', 'TEAM', 'APH', 'MRVL', 'ROP', 'DELL', 'NXPI', 'MSI', 'ADSK', 'FTNT', 'MCHP', 'SQ', 'TEL', 'DDOG', 'CTSH', 'FIS', 'PLTR', 'IT', 'ZS', 'TTD', 'ON', 'GFS', 'ANSS', 'FICO', 'HPQ', 'CDW', 'HUBS', 'MDB', 'MPWR', 'NET', 'KEYS', 'GLW', 'SPLK', 'FTV', 'GIB', 'BR', 'GRMN', 'HPE', 'VRSN', 'TDY', 'ZM', 'ERIC', 'PTC', 'FLT', 'NOK', 'ASX', 'SMCI', 'CHKP', 'IOT', 'NTAP', 'TYL', 'AKAM', 'EPAM', 'FSLR', 'STX', 'ENTG', 'DT', 'SWKS', 'JBL', 'WDC', 'TER', 'ENPH', 'LOGI', 'LDOS', 'SSNC', 'GEN', 'GDDY', 'APP', 'OKTA', 'BSY', 'NICE', 'U', 'ZBRA', 'AFRM', 'TRMB', 'PATH', 'MANH', 'AZPN', 'SRAD', 'DOCU', 'GRAB', 'JKHY', 'PAYC', 'JNPR', 'NTNX', 'PSTG', 'OTEX', 'ESTC', 'DBX', 'DOX', 'FFIV', 'FLEX', 'CDAY', 'HOOD', 'QRVO', 'PCOR', 'GLOB', 'GTLB', 'SNX', 'GWRE', 'CYBR', 'DUOL', 'LSCC', 'PCTY', 'MNDY', 'WEX', 'OLED', 'INFA', 'BILL', 'TOST', 'MSTR', 'AMKR', 'CACI', 'S', 'WIX', 'DSGX', 'RMBS', 'QLYS', 'CIEN', 'ONTO', 'MKSI', 'FRSH', 'CFLT', 'FN', 'ALTR', 'CGNX', 'KVYO', 'PSN', 'SPSC', 'SAIC', 'CCCS', 'SMAR', 'NXT', 'COHR', 'APPF', 'ARW', 'ZI', 'CNXC', 'DV', 'FOUR', 'LFUS', 'MTSI', 'NSIT', 'FIVN', 'NOVT', 'VNT', 'TENB', 'STNE', 'ST', 'LYFT', 'ALGM', 'DLO', 'WK', 'VRNS', 'EXLS', 'BRZE', 'AUR', 'PWSC', 'KD', 'CWAN', 'IPGP', 'ALIT', 'DXC', 'EEFT', 'HCP', 'TDC', 'BLKB', 'BMI', 'DAVA', 'SEDG', 'POWI', 'SQSP', 'WOLF', 'AVT', 'ASGN', 'CRUS', 'PAGS', 'ASAN', 'SYNA', 'NCNO', 'PEGA', 'SLAB', 'NVMI', 'ACLS', 'BOX', 'LPL', 'INST', 'VERX', 'BL', 'PYCR', 'LITE', 'RUN', 'NVEI', 'CLS', 'FROG', 'AYX', 'CVLT', 'DIOD', 'RELY', 'ACIW', 'YOU', 'RPD', 'ITRI', 'SPT', 'MQ', 'AI', 'TSEM', 'CAMT', 'DOCN', 'VSH', 'RNG', 'ALRM', 'VSAT', 'WNS', 'BDC', 'FORM', 'CRDO', 'LSPD', 'KLIC', 'SANM', 'PLXS', 'CALX', 'INTA', 'ENV', 'GBTG', 'ESE', 'FLYW', 'SITM', 'APPN', 'EVTC', 'QTWO', 'JAMF', 'ODD', 'NABL', 'RAMP', 'ALKT', 'PD', 'IONQ', 'AMBA', 'AVDX', 'SHLS', 'PRGS', 'FSLY', 'VIAV', 'PRFT', 'VYX', 'PI', 'PAY', 'ROG', 'SIMO', 'ARRY', 'EXTR', 'OSIS', 'SONO', 'PLUS', 'AGYS', 'BB', 'XRX', 'SWI', 'BMBL', 'EVCM', 'PLAB', 'MLNK', 'UPBD', 'PAYO', 'DQ', 'MXL', 'VRNT', 'CNXN', 'JKS', 'PRO', 'VECO', 'COHU', 'NATL', 'NTCT', 'CLBT', 'KN', 'CSGS', 'TTMI', 'NOVA', 'SPNS', 'GRND', 'AVPT', 'CSIQ', 'AMPL', 'VZIO', 'UCTT', 'VTEX', 'RUM', 'DCBO', 'CRSR', 'HLIT', 'CRCT', 'SATS', 'CTS', 'SMTC', 'STER', 'INDI', 'ADEA', 'ZUO', 'PDFS', 'ACMR', 'PAR', 'BASE', 'ENFN', 'ETWO', 'TASK', 'HIMX', 'SGH', 'MODN', 'ATEN', 'GDYN', 'TTEC', 'SCSC', 'BHE', 'SSYS', 'ICHR', 'ASTS', 'EVBG', 'DGII', 'OLO', 'GCT', 'PSFE', 'RPAY', 'BELFB', 'CRNC', 'EB', 'PGY', 'WEAV', 'PUBM', 'RDWR', 'AOSL', 'DMRC', 'DDD', 'MEI', 'IMXI', 'MTTR', 'YEXT', 'IIIV', 'SNPO', 'BIGC', 'AAOI', 'TIXT', 'SPWR', 'HCKT', 'LASR', 'APPS', 'ADTN', 'MITK', 'STEM', 'AEHR', 'ITRN', 'CEVA', 'LAW', 'GPRO', 'XPER', 'NNDM', 'MVIS', 'ALNT', 'NN', 'BKKT', 'CGNT', 'EGHT', 'UIS', 'VPG', 'CLFD', 'SKYT', 'FARO', 'NTGR', 'DSP', 'OSPN', 'AMSWA', 'VNET', 'CCSI', 'AVNW', 'DAKT', 'AUDC', 'MTLS', 'DOMO', 'BAND', 'GILT', 'IBEX', 'SSTI', 'LPSN', 'RMNI', 'ONTF', 'MAXN', 'KOPN', 'RDVT', 'EGAN', 'TCX', 'LTRX', 'LSAK', 'CMTL', 'INOD', 'IMMR', 'MIXT', 'ASUR', 'TRAK', 'VOXX', 'QUIK', 'AIP', 'MRAM', 'INVE', 'HEAR', 'ATOM', 'INTT', 'RELL', 'PSQH', 'WRAP', 'QBTS', 'TSAT', 'UEIC', 'DHX', 'SURG', 'KVHI', 'BEEM', 'SNCR', 'BTCM', 'XELA', 'STM', 'SMWB', 'WKME']

industrials = ['LUNR','RVSN','MNTS','GLLI','CISS', 'VSME', 'CAT', 'UNP', 'GE', 'UPS', 'BA', 'HON', 'BKNG', 'RTX', 'LMT', 'DE', 'ETN', 'ADP', 'ABNB', 'CNI', 'ITW', 'RELX', 'WM', 'CP', 'NOC', 'CSX', 'GD', 'TRI', 'FDX', 'MMM', 'CTAS', 'PH', 'TDG', 'EMR', 'RSG', 'NSC', 'PCAR', 'CPRT', 'PAYX', 'ODFL', 'GWW', 'LHX', 'WCN', 'FERG', 'AME', 'URI', 'FAST', 'OTIS', 'ROK', 'GPN', 'VRSK', 'CMI', 'RCL', 'IR', 'EFX', 'PWR', 'RYAAY', 'DAL', 'XYL', 'TCOM', 'HEI', 'SYM', 'HWM', 'WAB', 'EXPE', 'DOV', 'JBHT', 'CCL', 'VRT', 'HEI.A', 'VLTO', 'AXON', 'EXPD', 'LUV', 'HUBB', 'J', 'BAH', 'WSO', 'IEX', 'AER', 'TXT', 'SNA', 'POOL', 'SWK', 'UAL', 'NDSN', 'GGG', 'RTO', 'TRU', 'UHAL', 'ACM', 'GFL', 'LECO', 'RBA', 'AOS', 'PNR', 'BLD', 'SAIA', 'ZTO', 'TFII', 'ALLE', 'EME', 'CHRW', 'HII', 'XPO', 'ITT', 'AAL', 'NVT', 'TTC', 'RRX', 'STN', 'ESLT', 'CLH', 'KNX', 'AGCO', 'CNM', 'WCC', 'TTEK', 'RHI', 'ASR', 'CW', 'WWD', 'WSC', 'DLB', 'RBC', 'MIDD', 'ARMK', 'GNRC', 'NCLH', 'APG', 'KBR', 'FIX', 'BWXT', 'SITE', 'GXO', 'FCN', 'OSK', 'AYI', 'LSTR', 'CAE', 'WTS', 'AIT', 'MSA', 'FLR', 'HXL', 'CAR', 'TNET', 'ADT', 'MTZ', 'GTLS', 'BZ', 'ATKR', 'TKR', 'MSM', 'ATI', 'BECN', 'FLS', 'MLI', 'ESAB', 'MMYT', 'DRS', 'R', 'CWST', 'FTAI', 'MMS', 'ZWS', 'VMI', 'ALK', 'KEX', 'SPXC', 'EXPO', 'SRCL', 'AL', 'MOG.A', 'FSS', 'NSP', 'SNDR', 'FELE', 'GATX', 'JOBY', 'ATS', 'ENS', 'MDU', 'HRI', 'MATX', 'CPA', 'ACA', 'TEX', 'AEIS', 'MAN', 'BCO', 'AZUL', 'VRRM', 'GTES', 'AVAV', 'WIRE', 'DY', 'CRS', 'ERJ', 'CSWI', 'OMAB', 'HI', 'UNF', 'ENOV', 'CXT', 'CBZ', 'GFF', 'KAI', 'NPO', 'JBT', 'KFY', 'SPR', 'BE', 'BRC', 'TNL', 'ARCB', 'HUBG', 'HTZ', 'TRIP', 'VSTS', 'WOR', 'MGRC', 'HAYW', 'ABM', 'CAAP', 'RXO', 'WERN', 'REZI', 'RKLB', 'ICFI', 'STRL', 'ALG', 'KTOS', 'ENR', 'FA', 'MYRG', 'PLUG', 'ROAD', 'MWA', 'SBLK', 'AIR', 'GVA', 'SKYW', 'LZ', 'UPWK', 'TRN', 'GOGL', 'KMT', 'HURN', 'ENVX', 'HNI', 'MRCY', 'ATMU', 'HEES', 'PRIM', 'JBLU', 'SXI', 'NVEE', 'TNC', 'SAVE', 'ZIM', 'SABR', 'MRTN', 'HOLI', 'B', 'EPAC', 'IESC', 'CXW', 'ACHR', 'DAC', 'CTOS', 'ALGT', 'FWRD', 'GIC', 'BBU', 'DSGR', 'LNN', 'AZZ', 'SCS', 'GBX', 'ZIP', 'HLIO', 'GEO', 'XMTR', 'AMRC', 'PRG', 'CDRE', 'KFRC', 'VVX', 'NSSC', 'TGI', 'ULCC', 'HY', 'RYI', 'WNC', 'ATSG', 'CMCO', 'MATW', 'HTLD', 'THR', 'REVG', 'SP', 'BLDP', 'BXC', 'CVII', 'ERII', 'POWL', 'TH', 'VSEC', 'PRLB', 'NAT', 'EH', 'SPCE', 'GRC', 'NMM', 'MEG', 'KRNT', 'GOL', 'ASTE', 'VLRS', 'BV', 'SNCY', 'PBI', 'BBSI', 'GSL', 'CYRX', 'DCO', 'KELYA', 'CRAI', 'NVRI', 'HA', 'VVI', 'IIIN', 'NPWR', 'HAYN', 'GNK', 'CECO', 'EVLV', 'KAMN', 'DESP', 'ASC', 'DWAC', 'TITN', 'SWBI', 'KE', 'AGX', 'CVLG', 'ASLE', 'ACCO', 'CASS', 'ATRO', 'FCEL', 'MTW', 'FC', 'HSII', 'EBF', 'SMR', 'EGLE', 'CRESY', 'LIND', 'DXPE', 'FORR', 'TPC', 'RGP', 'TBI', 'LMB', 'BBCP', 'TRC', 'CMPO', 'PCT', 'AMPX', 'SHYF', 'DSKE', 'ALTG', 'FIP', 'PANL', 'DSX', 'AAN', 'PKOH', 'ALCC', 'CVEO', 'AMSC', 'SMHI', 'RLGT', 'NWPX', 'PKE', 'KODK', 'MEC', 'QUAD', 'MTRX', 'NL', 'WLDN', 'FSTR', 'MG', 'LXFR', 'RCMT', 'BLDE', 'DLHC', 'FREY', 'TWIN', 'KNOP', 'GHM', 'BLNK', 'TG', 'MNTX', 'ISSC', 'SPIR', 'SHIP', 'ARC', 'VTSI', 'BYRN', 'NSTB', 'PESI', 'BW', 'TORO', 'BGSF', 'ALTU', 'OMEX', 'PPSI', 'LTBR', 'RAIL', 'IDEX', 'GENC', 'GRIN', 'CYD']



energy=['XOM', 'CVX', 'SHEL', 'TTE', 'COP', 'PBR', 'PBR.A', 'BP', 'EQNR', 'CNQ', 'SLB', 'EOG', 'MPC', 'EPD', 'E', 'PSX', 'PXD', 'OXY', 'ET', 'VLO', 'HES', 'WMB', 'SU', 'OKE', 'TRP', 'LNG', 'MPLX', 'BKR', 'IMO', 'HAL', 'CVE', 'DVN', 'FANG', 'CQP', 'EC', 'WDS', 'TS', 'CTRA', 'PBA', 'TRGP', 'EQT', 'MRO', 'OVV', 'CHK', 'PR', 'APA', 'DINO', 'FTI', 'NOV', 'SWN', 'HESM', 'RRC', 'IEP', 'AR', 'WFRD', 'MTDR', 'CHRD', 'NE', 'YPF', 'UGP', 'CIVI', 'MUR', 'SUN', 'AM', 'ENLC', 'VNOM', 'CHX', 'DTM', 'PBF', 'KNTK', 'FRO', 'VAL', 'ETRN', 'VVV', 'NFG', 'RIG', 'SM', 'PTEN', 'MGY', 'NOG', 'STNG', 'CRC', 'STR', 'TDW', 'HP', 'WHD', 'CNX', 'CVI', 'KOS', 'ERF', 'LBRT', 'VIST', 'TRMD', 'BTE', 'INSW', 'CRK', 'NS', 'USAC', 'GPOR', 'CPE', 'SDRL', 'CRGY', 'TGS', 'PARR', 'OII', 'VET', 'TNK', 'GLNG', 'HPK', 'XPRO', 'DHT', 'LPG', 'TALO', 'AESI', 'KGS', 'DK', 'GEL', 'GLP', 'HLX', 'CLMT', 'WKC', 'DO', 'VTLE', 'ACDC', 'NVGS', 'NEXT', 'DNOW', 'CAPL', 'MRC', 'PUMP', 'SLCA', 'PDS', 'CLNE', 'VTOL', 'CLB', 'GRNT', 'TK', 'NGL', 'NBR', 'DRQ', 'SBOW', 'TNP', 'PBT', 'VTS', 'NOA', 'TTI', 'NR', 'OBE', 'BRY', 'SD', 'REPX', 'WTI', 'SGU', 'OIS', 'OSG', 'BOOM', 'AMPY', 'FET', 'VTNR', 'NGS', 'SMLP', 'GEOS', 'GTE', 'KLXE', 'AMTX', 'PHX', 'NINE', 'ICD', 'FLNG', 'EURN' ]


consumer_defensive = ['BRSH','WMT', 'PG', 'COST', 'KO', 'PEP', 'PM', 'UL', 'BUD', 'MDLZ', 'DEO', 'MO', 'CL', 'TGT', 'BTI', 'MNST', 'EL', 'STZ', 'KHC', 'KDP', 'ABEV', 'KVUE', 'KMB', 'HSY', 'SYY', 'ADM', 'GIS', 'KR', 'CCEP', 'DLTR', 'DG', 'BF.A', 'BF.B', 'CHD', 'WBA', 'TSN', 'CLX', 'MKC', 'HRL', 'LW', 'BG', 'CAG', 'TAP', 'CELH', 'SJM', 'ACI', 'EDU', 'CPB', 'USFD', 'PFGC', 'COTY', 'ELF', 'BJ', 'TAL', 'DAR', 'INGR', 'BRBR', 'PPC', 'POST', 'SFM', 'FLO', 'FIZZ', 'LANC', 'IPAR', 'OLLI', 'SAM', 'FRPT', 'SMPL', 'ASAI', 'LOPE', 'NWL', 'NOMD', 'JJSF', 'COUR', 'HELE', 'SPB', 'GO', 'CALM', 'CENT', 'LRN', 'TR', 'PRMW', 'DNUT', 'CCU', 'ATGE', 'UTZ', 'PSMT', 'THS', 'SOVO', 'CENTA', 'STRA', 'UDMY', 'MGPI', 'LAUR', 'AFYA', 'EPC', 'HIMS', 'ANDE', 'VGR', 'IMKTA', 'UVV', 'COCO', 'HLF', 'CHGG', 'FDP', 'JBSS', 'CHEF', 'AGRO', 'PRDO', 'KLG', 'HAIN', 'EWCZ', 'USNA', 'GOTU', 'NUS', 'UNFI', 'WEST', 'BRCC', 'BGS', 'SPTN', 'AVO', 'OTLY', 'STKL', 'VITL', 'ISPR', 'BYND', 'CVGW', 'TPB', 'UTI', 'SKIN', 'NGVC', 'NATR', 'LMNR', 'HFFG', 'BIG', 'APEI', 'LFVN', 'K', 'KOF', 'FMX', 'WMK']


consumer_cyclical = ['PRPL','QRTEA','VRM','WKHS','KNDI', 'OCTO', 'AMZN', 'TSLA', 'HD', 'TM', 'MCD', 'PDD', 'BABA', 'NKE', 'LOW', 'TJX', 'SBUX', 'MELI', 'STLA', 'MAR', 'CMG', 'LULU', 'ORLY', 'HMC', 'DHI', 'GM', 'F', 'HLT', 'ROST', 'LEN', 'AZO', 'LVS', 'YUM', 'JD', 'LI', 'CPNG', 'DKNG', 'MBLY', 'QSR', 'TSCO', 'APTV', 'ULTA', 'PHM', 'EBAY', 'ROL', 'SE', 'GPC', 'DRI', 'DECK', 'ONON', 'RIVN', 'BALL', 'MGA',  'AVY', 'YUMC', 'PKG', 'MGM', 'DPZ', 'AMCR', 'H', 'IP', 'WSM', 'NIO', 'LKQ', 'BURL', 'DKS', 'KMX', 'FND', 'CCK', 'HTHT', 'TOL', 'WRK', 'CASY', 'WYNN', 'XPEV', 'FIVE', 'PAG', 'SCI', 'VIPS', 'SKX', 'BBWI', 'CZR', 'CHDN', 'RL', 'CVNA', 'BIRK', 'ALV', 'TPX', 'ETSY', 'CHWY', 'TPR', 'PSO', 'LAD', 'MTN', 'NYT', 'MUSA', 'BWA', 'TXRH', 'GPK', 'LEA', 'GPS', 'WING', 'BERY', 'GNTX', 'LCID', 'PVH', 'LNW', 'MNSO', 'HAS', 'SN', 'HRB', 'WH', 'MHK', 'GLBE', 'WHR', 'VFC', 'CART', 'W', 'PLNT', 'MAT', 'LEVI', 'MTH', 'CROX', 'BC', 'BYD', 'THO', 'AN', 'CPRI', 'CHH', 'REYN', 'SON', 'BFAM', 'TMHC', 'GIL', 'SEE', 'IBP', 'DOOO', 'RRR', 'ALSN', 'IGT', 'M', 'RH', 'PII', 'BROS', 'ANF', 'KBH', 'CAVA', 'SLGN', 'HOG', 'COLM', 'ASO', 'GME', 'SIG', 'HGV', 'ABG', 'AEO', 'MDC', 'GOLF', 'WEN', 'YETI', 'QS', 'SKY', 'PSNY', 'GPI', 'GT', 'MLCO', 'AAP', 'MHO', 'URBN', 'UAA', 'PENN', 'RUSHA', 'UA', 'LEG', 'TPH', 'MOD', 'SEAS', 'KTB', 'VC', 'ADNT', 'SHOO', 'DFH', 'LCII', 'VAC', 'GEF', 'JWN', 'LGIH', 'KSS', 'CUK', 'SHAK', 'AIN', 'FOXF', 'SVV', 'CCS', 'FL', 'CRI', 'ZGN', 'MCW', 'CVCO', 'MODG', 'FTDR', 'CARG', 'DORM', 'OI', 'PZZA', 'GRBK', 'ACVA', 'BOOT', 'BLMN', 'PATK', 'DRVN', 'PTON', 'GTX', 'CWH', 'SIX', 'BKE', 'FUN', 'WGO', 'ROVR', 'DAN', 'ODP', 'MLKN', 'VSCO', 'MBC', 'BOWL', 'SAH', 'EAT', 'WLY', 'CAKE', 'VSTO', 'CBRL', 'EYE', 'THRM', 'LZB', 'KAR', 'OLPX', 'JACK', 'OXM', 'ARHS', 'AMWD', 'HBI', 'CNNE', 'GIII', 'XPEL', 'PHIN', 'OSW', 'SHCO', 'SBH', 'MSGE', 'MCRI', 'GES', 'SG', 'GOOS', 'LESL', 'FWRG', 'CARS', 'LAZR', 'PLYA', 'SCHL', 'BYON', 'GDEN', 'CAL', 'MBUU', 'RVLV', 'FIGS', 'HSAI', 'BZH', 'TRS', 'ARKO', 'AXL', 'NGMS', 'EVRI', 'MNRO', 'WOOF', 'IRBT', 'EVGO', 'ACEL', 'CHPT', 'PTLO', 'BLBD', 'HIBB', 'HZO', 'BJRI', 'ETD', 'SCVL', 'DIN', 'WWW', 'MYE', 'MED', 'FLWS', 'MOV', 'CURV', 'PLOW', 'RICK', 'CHUY', 'XPOF', 'LEGH', 'HVT', 'DENN', 'LQDT', 'BALY', 'DBI', 'SRI', 'ONEW', 'BWMX', 'WW', 'TAST', 'MLR', 'GAMB', 'SFIX', 'FNKO', 'MPX', 'LOVE', 'MCFT', 'ZUMZ', 'FSR', 'PBPB', 'CSV', 'GCI', 'JAKK', 'INVZ', 'JMIA', 'GCO', 'BBW', 'COOK', 'AGS', 'CPS', 'LOCO', 'LE', 'PLCE', 'HBB', 'ESCA', 'SNBR', 'HOFT', 'DXLG', 'INSE', 'CTRN', 'KFS', 'SGC', 'CLAR', 'CVGI', 'REAL', 'MPAA', 'STKS', 'RRGB', 'LCUT', 'DLTH', 'GRWG', 'BSET', 'BGFV', 'UFI', 'AOUT', 'WISH', 'WPRT', 'LL', 'TUP', 'SUP', 'LAZY', 'REE', 'KIRK', 'RACE', 'VFS', 'UCON', ]



utilities=['NEE', 'SO', 'DUK', 'NGG', 'SRE', 'PCG', 'AEP', 'D', 'CEG', 'EXC', 'XEL', 'ED', 'PEG', 'EIX', 'WEC', 'AWK', 'DTE', 'FE', 'ETR', 'FTS', 'ES', 'PPL', 'AEE', 'CNP', 'ATO', 'CMS', 'VST', 'BIP', 'LNT', 'AGR', 'EVRG', 'AES', 'NRG', 'NI', 'PNW', 'BEP', 'NFE', 'BEPC', 'CWEN', 'UGI', 'IDA', 'ELP', 'SWX', 'AQN', 'ORA', 'POR', 'NJR', 'ENIC', 'FLNC', 'BKH', 'ALE', 'OTTR', 'OGS', 'PNM', 'SR', 'AWR', 'CWT', 'AVA', 'RNW', 'MGEE', 'PAM', 'TAC', 'AY', 'ENLT', 'SJW', 'CPK', 'EE', 'HE', 'KEN', 'CEPU', 'MNTK', 'SPH', 'MSEX', 'AMPS', 'OPAL', 'UTL', 'GNE', 'YORW', 'CWCO', 'ARIS', 'GWRS', 'RGCO', 'SBS' ]


healthcare=['APTO', 'REVB', 'ARQT','GYRE','KTRA','RSLS','QYLD','RNAZ','SGMT','AVTX','ENSC', 'BIOL','CPHI','IKNA','FOXO','RDHL', 'AGEN', 'EVAX', 'LLY', 'UNH', 'NVO', 'JNJ', 'MRK', 'ABBV', 'NVS', 'AZN', 'TMO', 'ABT', 'DHR', 'AMGN', 'PFE', 'SNY', 'ISRG', 'SYK', 'MDT', 'ELV', 'VRTX', 'GILD', 'BMY', 'CVS', 'REGN', 'ZTS', 'CI', 'BSX', 'GSK', 'HCA', 'BDX', 'MCK', 'HUM', 'DXCM', 'TAK', 'IDXX', 'EW', 'COR', 'CNC', 'MRNA', 'HLN', 'ALC', 'IQV', 'A', 'BIIB', 'GEHC', 'VEEV', 'WST', 'RMD', 'CAH', 'MTD', 'ZBH', 'BNTX', 'ALNY', 'ARGX', 'ILMN', 'MOH', 'PHG', 'STE', 'ALGN', 'GMAB', 'ICLR', 'BAX', 'LH', 'COO', 'BMRN', 'WAT', 'HOLX', 'RPRX', 'BGNE', 'DGX', 'PODD', 'VTRS', 'INCY', 'RVTY', 'NBIX', 'TEVA', 'EXAS', 'KRTX', 'SNN', 'FMS', 'TFX', 'TECH', 'RDY', 'CRL', 'SRPT', 'UHS', 'LEGN', 'UTHR', 'QGEN', 'DVA', 'RGEN', 'PEN', 'BRKR', 'HSIC', 'BIO', 'CTLT', 'ROIV', 'CHE', 'MEDP', 'ATR', 'CYTK', 'THC', 'STVN', 'SWAV', 'IMGN', 'APLS', 'ACHC', 'ASND', 'GMED', 'XRAY', 'CERE', 'IONS', 'ELAN', 'JAZZ', 'NTRA', 'EXEL', 'EHC', 'BBIO', 'ITCI', 'ENSG', 'MASI', 'HQY', 'IMVT', 'PCVX', 'OPCH', 'TXG', 'INSP', 'DOCS', 'BLCO', 'CRSP', 'BPMC', 'QDEL', 'MDGL', 'ACAD', 'ALKS', 'NUVL', 'MMSI', 'HALO', 'PRGO', 'SHC', 'OGN', 'GKOS', 'NVST', 'HAE', 'SGRY', 'AXSM', 'INSM', 'ARWR', 'NEOG', 'FOLD', 'LNTH', 'RCM', 'RARE', 'EVH', 'BHVN', 'PGNY', 'IMCR', 'MLTX', 'AZTA', 'KRYS', 'AXNX', 'TDOC', 'CNMD', 'SEM', 'ITGR', 'IART', 'NARI', 'IRTC', 'AGL', 'OLK', 'RVMD', 'AMED', 'BHC', 'GH', 'XENE', 'PBH', 'HCM', 'AMN', 'DNA', 'LIVN', 'PDCO', 'CBAY', 'TMDX', 'LFST', 'FTRE', 'IBRX', 'PINC', 'ACLX', 'GLPG', 'TGTX', 'DNLI', 'AMPH', 'CERT', 'PRVA', 'SWTX', 'RCKT', 'RDNT', 'OSCR', 'NTLA', 'ZLAB', 'CRNX', 'RYTM', 'RXRX', 'CORT', 'IDYA', 'PRCT', 'IOVA', 'NMRA', 'ICUI', 'AMEH', 'PTCT', 'BEAM', 'SDGR', 'GPCR', 'VKTX', 'ARVN', 'SMMT', 'TWST', 'ATEC', 'ARDX', 'NEO', 'VCYT', 'CLDX', 'IRWD', 'SNDX', 'PACB', 'PRTA', 'HRMY', 'MRUS', 'DVAX', 'VCEL', 'AMAM', 'INMD', 'INBX', 'CPRX', 'TNDM', 'RXST', 'AMRX', 'ATRC', 'MRVI', 'MYGN', 'SAGE', 'STAA', 'ABCL', 'ALHC', 'OMCL', 'KROS', 'KYMR', 'PCRX', 'SUPN', 'VRNA', 'OMI', 'IRON', 'NHC', 'RLAY', 'NVCR', 'ADUS', 'USPH', 'PTGX', 'VIR', 'TLRY', 'MORF', 'WRBY', 'KNSA', 'UFPT', 'PHR', 'BCRX', 'AVDL', 'SANA', 'MOR', 'RCUS', 'SLNO', 'AGIO', 'AKRO', 'MIRM', 'LGND', 'XNCR', 'LMAT', 'DAWN', 'VRDN', 'DCPH', 'KURA', 'SRRK', 'ALPN', 'ANIP', 'AUPH', 'CTKB', 'ACCD', 'SAVA', 'AMLX', 'DH', 'GERN', 'TNGX', 'COLL', 'BKD', 'INVA', 'ETNB', 'PLRX', 'MDRX', 'EMBC', 'DYN', 'ZNTL', 'NRC', 'EYPT', 'MDXG', 'MNKD', 'IMTX', 'CABA', 'FNA', 'QTRX', 'ESTA', 'ARCT', 'VERA', 'MD', 'RNA', 'FLGT', 'VERV', 'RAPT', 'VREX', 'HSTM', 'LQDA', 'EXAI', 'CCRN', 'FDMT', 'TMCI', 'PRME', 'SIBN', 'SLP', 'ZYME', 'CALT', 'BLFS', 'EDIT', 'AORT', 'GRCL', 'TARS', 'ALXO', 'SLRN', 'KIDS', 'NVRO', 'TVTX', 'FUSN', 'HCAT', 'RGNX', 'ALEC', 'IGMS', 'MGNX', 'OLMA', 'ALT', 'CDNA', 'ANAB', 'EOLS', 'OSUR', 'EWTX', 'CVRX', 'MODV', 'IRMD', 'TYRA', 'SPRY', 'MRNS', 'CSTL', 'RVNC', 'PETQ', 'BCYC', 'BMEA', 'NVAX', 'CMPS', 'EHAB', 'SILK', 'REPL', 'OFIX', 'IMNM', 'CYH', 'LUNG', 'AVXL', 'WVE', 'TBPH', 'JANX', 'SRDX', 'NKTX', 'ZIMV', 'ELVN', 'CRBU', 'COGT', 'AIRS', 'PNTG', 'NRIX', 'KALV', 'FULC', 'PLSE', 'CGEM', 'THRD', 'PHAT', 'ORIC', 'CDMO', 'STTK', 'MGTX', 'ABUS', 'MRSN', 'SIGA', 'ITOS', 'BVS', 'NAUT', 'PRAX', 'EPIX', 'MLYS', 'RCEL', 'CGC', 'TERN', 'ZYXI', 'CCCC', 'DCGO', 'VYGR', 'HROW', 'CELC', 'LXRX', 'AXGN', 'ESPR', 'TCMD', 'ANIK', 'URGN', 'YMAB', 'AURA', 'HRTX', 'NNOX', 'TSHA', 'CBUS', 'GLUE', 'QURE', 'SPOK', 'RPTX', 'VMD', 'SENS', 'ATXS', 'LYRA', 'FENC', 'OPRX', 'VSTM', 'KMDA', 'QSI', 'SGHT', 'MASS', 'VRCA', 'OM', 'ANGO', 'XOMA', 'ENTA', 'STOK', 'OMER', 'LFMD', 'VNDA', 'ABOS', 'SCPH', 'ZVRA', 'AUGX', 'INMB', 'LFCR', 'EDAP', 'MACK', 'APLT', 'PROF', 'TELA', 'MNMD', 'SLDB', 'SYRS', 'MCRB', 'BLUE', 'VTGN', 'INGN', 'ATNM', 'CPSI', 'JYNT', 'XBIT', 'ABEO', 'ARMP', 'ANVS', 'CVM', 'MDWD', 'PLX', 'CRVS', 'RVPH', 'ELMD', 'JSPR', 'CSBR', 'LPTX', 'BTAI', 'SPRO', 'ACXP', 'CODX', 'MEIP', 'TXMD', 'TARO', 'GHRS', 'CLGN' ]


communication_services = ['FAZE','GOOG', 'GOOGL', 'META', 'NFLX', 'TMUS', 'CMCSA', 'DIS', 'VZ', 'T', 'NTES', 'AMX', 'CHTR', 'DASH', 'BIDU', 'SPOT', 'BCE', 'EA', 'CHT', 'SNAP', 'TTWO', 'TU', 'WBD', 'PINS', 'RCI', 'RBLX', 'VOD', 'LYV', 'SIRI', 'WMG', 'OMC', 'VIV', 'EDR', 'TME', 'FOXA', 'FWONK', 'NWS', 'TKO', 'NWSA', 'FOX', 'FWONA', 'TWLO', 'Z', 'IPG', 'ZG', 'ROKU', 'PARAA', 'LBRDK', 'LBRDA', 'MTCH', 'WPP', 'LSXMA', 'LSXMK', 'PARA', 'LBTYK', 'KT', 'NXST', 'FYBR', 'IRDM', 'BILI', 'MSGS', 'IQ', 'IAC', 'CCOI', 'USM', 'MANU', 'ATHM', 'LLYVA', 'TGNA', 'YELP', 'ZD', 'PLTK', 'IDCC', 'BATRA', 'LGF.A', 'BATRK', 'IAS', 'LGF.B', 'WB', 'GETY', 'YY', 'PLAY', 'TDS', 'CMPR', 'STGW', 'SSTK', 'CNK', 'LUMN', 'CRTO', 'VEON', 'PERI', 'MOMO', 'GENI', 'ATUS', 'SEAT', 'GOGO', 'TTGT', 'SPHR', 'OPRA', 'SHEN', 'FVRR', 'AMC', 'SBGI', 'GTN', 'DLX', 'HUYA', 'IDT', 'FUBO', 'AMCX', 'IMAX', 'MAX', 'SSP', 'THRY', 'QNST', 'ATEX', 'ATNI', 'BOC', 'RSVR', 'GRPN', 'EEX', 'EVER', 'NEXN', 'JFIN', 'SOHU', 'WOW', 'CDLX', 'OOMA', 'FNGR', 'TZOO', 'CXDO', 'BRAG', 'SKLZ', 'ZDGE', 'TEO', 'TIMB', 'SKM', 'TIGO', 'TKC' ]


financial_services = ['BRK.B', 'JPM', 'V', 'MA', 'BAC', 'WFC', 'HSBC', 'MS', 'RY', 'SPGI', 'AXP', 'GS', 'HDB', 'BLK', 'SCHW', 'TD', 'C', 'PGR', 'MMC', 'CB', 'BX', 'IBN', 'KKR', 'ICE', 'CME', 'MCO', 'BMO', 'PYPL', 'SAN', 'USB', 'BN', 'PNC', 'AON', 'BNS', 'APO', 'BBVA', 'ING', 'MET', 'AJG', 'TFC', 'COF', 'AFL', 'AIG', 'TRV', 'MSCI', 'CM', 'NU', 'BK', 'ALL', 'MFC', 'AMP', 'PRU', 'IBKR', 'LYG', 'ARES', 'BBD', 'COIN', 'NDAQ', 'SLF', 'PUK', 'ACGL', 'BCS', 'DFS', 'DB', 'WTW', 'HIG', 'RKT', 'TROW', 'NWG', 'FITB', 'STT', 'RJF', 'MTB', 'TW', 'OWL', 'BRO', 'FCNCA', 'PFG', 'MKL', 'WRB', 'HBAN', 'FDS', 'LPLA', 'ERIE', 'NTRS', 'RF', 'CINF', 'EG', 'BAM', 'L', 'SYF', 'KB', 'AEG', 'CFG', 'CRBG', 'SHG', 'BEN', 'XP', 'CG', 'KEY', 'TPG', 'BAP', 'MORN', 'ARCC', 'CNA', 'GL', 'EQH', 'BCH', 'RGA', 'RYAN', 'RNR', 'MKTX', 'EWBC', 'ALLY', 'AFG', 'UNM', 'BSAC', 'AIZ', 'KNSL', 'WBS', 'SEIC', 'JEF', 'ORI', 'IVZ', 'HLI', 'SOFI', 'FHN', 'PRI', 'VOYA', 'NYCB', 'FUTU', 'CMA', 'SF', 'WAL', 'CBSH', 'CFR', 'CACC', 'PNFP', 'ZION', 'FAF', 'EVR', 'RLI', 'SSB', 'PB', 'SIGI', 'OMF', 'HLNE', 'BPOP', 'OBDC', 'WTFC', 'FSK', 'ESNT', 'BOKF', 'OZK', 'SNV', 'COLB', 'VLY', 'FG', 'CADE', 'DNB', 'AMG', 'MARA', 'UBSI', 'FCFS', 'BXSL', 'ONB', 'FNB', 'HOMB', 'JHG', 'FRHC', 'AXS', 'LNC', 'ACT', 'GBCI', 'ESGR', 'WU', 'THG', 'AEL', 'RDN', 'PFSI', 'AGO', 'LAZ', 'SLM', 'COOP', 'FFIN', 'CRVL', 'JXN', 'HWC', 'UMBF', 'TFSL', 'MC', 'AB', 'MAIN', 'ABCB', 'STEP', 'UCBI', 'KMPR', 'APAM', 'SFBS', 'CNS', 'BGC', 'BHF', 'IBOC', 'WD', 'ASB', 'CATY', 'FIBK', 'NNI', 'VIRT', 'AX', 'TCBI', 'BANF', 'CNO', 'FHI', 'PIPR', 'GNW', 'UPST', 'BRP', 'FHB', 'INDB', 'GSHD', 'FBP', 'BOH', 'WSFS', 'RIOT', 'PPBI', 'HGTY', 'CBU', 'AUB', 'CVBF', 'HTGC', 'FULT', 'GBDC', 'PSEC', 'EBC', 'QFIN', 'NMIH', 'SFNC', 'PJT', 'SBCF', 'BKU', 'VCTR', 'AMK', 'HTH', 'FFBC', 'MCY', 'IBTX', 'TBBK', 'TOWN', 'FRME', 'PRK', 'NAVI', 'WAFD', 'CLBK', 'AGM', 'TSLX', 'SPNT', 'NBTB', 'LOB', 'FBK', 'MBIN', 'TFIN', 'RNST', 'DFIN', 'WSBC', 'CLSK', 'BANR', 'OFG', 'CUBI', 'ENVA', 'TRMK', 'EFSC', 'GCMG', 'GSBD', 'BFH', 'LKFN', 'HTLF', 'STC', 'NWBI', 'NTB', 'CHCO', 'FCF', 'PLMR', 'LU', 'WABC', 'FBNC', 'SYBT', 'HOPE', 'SNEX', 'CASH', 'NBHC', 'TCBK', 'BUSE', 'NMFC', 'PFS', 'SRCE', 'STBA', 'VBTX', 'TRUP', 'LMND', 'SASR', 'ECPG', 'NIC', 'PEBO', 'SAFT', 'NRDS', 'PFBC', 'BHLB', 'OBK', 'PX', 'OCFC', 'EIG', 'CSWC', 'DCOM', 'BY', 'RBCAA', 'BBDC', 'QCRH', 'PWP', 'LC', 'BRKL', 'GABC', 'BLX', 'PRAA', 'LBAI', 'MFIC', 'SBSI', 'LPRO', 'CIFR', 'CNOB', 'AMSF', 'BITF', 'FBMS', 'APLD', 'SLRC', 'EGBN', 'SII', 'PFC', 'PAX', 'WRLD', 'NOAH', 'AMTB', 'FMBH', 'CGBD', 'AMAL', 'TMP', 'TIPT', 'CTBI', 'BANC', 'PFLT', 'AMBC', 'HFWA', 'RILY', 'GSBC', 'OSBC', 'FCBC', 'CFB', 'AMRK', 'TRIN', 'HBT', 'CCAP', 'VINP', 'PRA', 'TIGR', 'MBWM', 'UWMC', 'CION', 'UVSP', 'IGIC', 'CRD.A', 'MCBS', 'HBNC', 'HTBK', 'BFST', 'FDUS', 'CCB', 'HAFC', 'MSBI', 'MCB', 'SMBC', 'TRST', 'NFBK', 'HONE', 'CATC', 'CAC', 'FFWM', 'KRNY', 'IBCP', 'UFCS', 'VEL', 'CPF', 'ATLC', 'LBC', 'WASH', 'EQBK', 'QD', 'FMNB', 'AMNB', 'HUT', 'PGC', 'UVE', 'THFF', 'CCBG', 'EZPW', 'WULF', 'SPFI', 'FFIC', 'HTBI', 'CCNE', 'AROW', 'SHBI', 'ACIC', 'ALRS', 'BHB', 'SMMF', 'OPY', 'BNRE', 'IREN', 'MOFG', 'GLRE', 'MPB', 'SMBK', 'CSTR', 'HIVE', 'TREE', 'GNTY', 'ACNB', 'MCBC', 'EBTC', 'BWB', 'RBB', 'WTBA', 'HBCP', 'BMRC', 'FISI', 'BRDG', 'CBNK', 'SUPV', 'CARE', 'SAR', 'NEWT', 'JRVR', 'SCM', 'FRST', 'BSRR', 'FBIZ', 'CZNC', 'FMAO', 'ORRF', 'SFST', 'WHF', 'FNLC', 'JMSB', 'FLIC', 'MVBF', 'MBI', 'WSBF', 'UNTY', 'FRBA', 'SBT', 'CIVB', 'BCML', 'PCB', 'RM', 'CVCY', 'HRTG', 'TSBK', 'SAMG', 'MFIN', 'INBK', 'CBAN', 'OCN', 'PKBK', 'EHTH', 'BCBP', 'HMST', 'HIPO', 'WNEB', 'ESSA', 'PVBC', 'ATLO', 'PTMN', 'LCNB', 'OPBK', 'OFS', 'ROOT', 'UBFO', 'BFIN', 'SRL', 'TBNK', 'ICMB', 'GGAL', 'BBAR', 'BUR', 'BCSF', 'BMA', 'TCPC', 'UBS', 'ITUB', 'CIB']



real_estate = ['AIRE', 'PLD', 'AMT', 'EQIX', 'PSA', 'WELL', 'CCI', 'SPG', 'O', 'DLR', 'CSGP', 'VICI', 'EXR', 'AVB', 'CBRE', 'SBAC', 'WY', 'EQR', 'ARE', 'INVH', 'IRM', 'VTR', 'BEKE', 'SUI', 'ESS', 'MAA', 'WPC', 'HST', 'ELS', 'AMH', 'KIM', 'UDR', 'GLPI', 'REG', 'REXR', 'PEAK', 'BXP', 'LAMR', 'CPT', 'CUBE', 'NLY', 'COLD', 'EGP', 'FRT', 'JLL', 'OHI', 'FSV', 'FR', 'STAG', 'BRX', 'AGNC', 'RHP', 'HR', 'STWD', 'ADC', 'TRNO', 'CIGI', 'AIRC', 'VNO', 'RITM', 'KRG', 'RYN', 'KRC', 'EPRT', 'PECO', 'HHH', 'PCH', 'APLE', 'BXMT', 'CUZ', 'IRT', 'PK', 'MAC', 'JOE', 'DBRG', 'SLG', 'SITC', 'SKT', 'CDP', 'ABR', 'HASI', 'IIPR', 'HIW', 'NHI', 'OPEN', 'DEI', 'OUT', 'FCPT', 'CWK', 'SHO', 'EXPI', 'MPW', 'UE', 'EQC', 'PEB', 'RLJ', 'ROIC', 'CMTG', 'RC', 'IVT', 'FOR', 'ARI', 'AKR', 'JBGS', 'KW', 'ESRT', 'SAFE', 'GTY', 'LADR', 'MMI', 'AAT', 'VRE', 'XHR', 'UNIT', 'ALEX', 'TWO', 'DEA', 'ELME', 'NTST', 'PMT', 'HPP', 'MFA', 'AIV', 'CIM', 'FBRT', 'AHH', 'UMH', 'PLYM', 'RDFN', 'ARR', 'BFS', 'KREF', 'PDM', 'EFC', 'RMR', 'NXRT', 'CSR', 'RWT', 'CBL', 'HOUS', 'NYMT', 'DX', 'INN', 'CHCT', 'GMRE', 'WSR', 'IRS', 'PKST', 'UHT', 'ACRE', 'FPI', 'SRG', 'CLDT', 'LAND', 'TRTX', 'LSEA', 'OLP', 'IVR', 'CTO', 'BRT', 'PSTL', 'GPMT', 'ONL', 'REFI', 'NREF', 'CIO', 'AFCG', 'OPAD', 'RMAX', 'STHO', 'AJX', 'MITT', 'ACR', 'CLPR', 'FTHM', 'LOAN']


etfs = ['INDA','ZSL', 'ZROZ', 'ZHDG', 'YXI', 'YLD', 'YINN', 'YCS', 'YANG', 'YALL', 'XYLG', 'XTN', 'XTL', 'XT', 'XSW', 'XSVM', 'XSOE', 'XSMO', 'XSLV', 'XSD', 'XRT', 'XRMI', 'XRLV', 'XPP', 'XPND', 'XPH', 'XOP', 'XNTK', 'XMVM', 'XMMO', 'XMLV', 'XMHQ', 'XME', 'XLY', 'XLV', 'XLU', 'XLRE', 'XLP', 'XLK', 'XLI', 'XLG', 'XLF', 'XLE', 'XLC', 'XLB', 'XITK', 'XHYT', 'XHYD', 'XHS', 'XHE', 'XHB', 'XES', 'XBI', 'XAR', 'WTV', 'WTRE', 'WTMF', 'WPS', 'WOOD', 'WIP', 'WGMI', 'WFH', 'WEBS', 'WEBL', 'WEAT', 'WDIV', 'WCLD', 'WCBR', 'WANT', 'VYMI', 'VYM', 'VXUS', 'VWOB', 'VWO', 'VV', 'VUG', 'VTWV', 'VTWO', 'VTWG', 'VTV', 'VTI', 'VTHR', 'VTC', 'VT', 'VSS', 'VSDA', 'VPU', 'VPN', 'VPL', 'VOX', 'VOT', 'VOOV', 'VOOG', 'VOO', 'VONV', 'VONG', 'VONE', 'VOE', 'VO', 'VNQI', 'VNQ', 'VNLA', 'VMBS', 'VLU', 'VIS', 'VIOV', 'VIOO', 'VIOG', 'VIGI', 'VIG', 'VICE', 'VHT', 'VGT', 'VGLT', 'VGK', 'VGIT', 'VEU', 'VERS', 'VEGI', 'VEA', 'VDE', 'VDC', 'VCR', 'VCLT', 'VCIT', 'VCAR', 'VBR', 'VBK', 'VB', 'VAW', 'VALQ', 'UYG', 'UXI', 'UWM', 'UTWY', 'UTSL', 'UTHY', 'UTEN', 'USXF', 'UST', 'USRT', 'USPX', 'USO', 'USMC', 'USL', 'USIG', 'USD', 'USCI', 'USAI', 'URTY', 'URTH', 'URNM', 'URNJ', 'URE', 'URA', 'UPW', 'UPV', 'UPRO', 'UPAR', 'UNG', 'UMDD', 'UGL', 'UGE', 'UGA', 'UDOW', 'UCYB', 'UCO', 'UCC', 'UBT', 'UBR', 'UBOT', 'TZA', 'TYO', 'TYLG', 'TWM', 'TWEB', 'TUR', 'TUA', 'TTT', 'TSLY', 'TSLS', 'TSLR', 'TSLQ', 'TSLL', 'TSL', 'TSDD', 'TQQQ', 'TPYP', 'TPOR', 'TOTL', 'TOLZ', 'TNA', 'TMV', 'TMF', 'TLT', 'TLH', 'TIP', 'TINY', 'TIME', 'THNQ', 'THLV', 'THD', 'THCX', 'TFLO', 'TFI', 'TECS', 'TECL', 'TECB', 'TDSC', 'TDIV', 'TCHI', 'TBT', 'TBIL', 'TBF', 'TARK', 'TAN', 'TAGS', 'SWAN', 'SVOL', 'SUSL', 'SUSB', 'SUSA', 'SSUS', 'SSO', 'SRVR', 'SRS', 'SRET', 'SQY', 'SQQQ', 'SPYX', 'SPYV', 'SPYG', 'SPYD', 'SPY', 'SPXU', 'SPXT', 'SPXS', 'SPXN', 'SPXL', 'SPXE', 'SPVU', 'SPVM', 'SPUU', 'SPTM', 'SPTL', 'SPSM', 'SPSB', 'SPRX', 'SPMO', 'SPMD', 'SPMB', 'SPLV', 'SPLG', 'SPHQ', 'SPHD', 'SPHB', 'SPGP', 'SPGM', 'SPFF', 'SPEU', 'SPEM', 'SPDW', 'SPDN', 'SPD', 'SPCX', 'SPC', 'SPBO', 'SOXX', 'SOXS', 'SOXQ', 'SOXL', 'SOCL', 'SNSR', 'SNPE', 'SMOG', 'SMN', 'SMLV', 'SMLF', 'SMH', 'SMDD', 'SLYV', 'SLYG', 'SLX', 'SLV', 'SLQD', 'SKYY', 'SKYU', 'SKF', 'SJB', 'SIZE', 'SIVR', 'SIMS', 'SILJ', 'SIL', 'SIJ', 'SHYG', 'SHV', 'SHE', 'SH', 'SGOL', 'SGDM', 'SGDJ', 'SFYX', 'SFYF', 'SFY', 'SEVN', 'SETH', 'SEF', 'SEA', 'SDY', 'SDVY', 'SDS', 'SDP', 'SDOW', 'SDOG', 'SDIV', 'SDEM', 'SCZ', 'SCO', 'SCJ', 'SCHY', 'SCHX', 'SCHV', 'SCHP', 'SCHO', 'SCHM', 'SCHK', 'SCHJ', 'SCHG', 'SCHF', 'SCHE', 'SCHD', 'SCHB', 'SCHA', 'SCC', 'SBIO', 'SBB', 'SARK', 'SAA', 'RZV', 'RZG', 'RYLG', 'RXL', 'RXI', 'RXD', 'RWX', 'RWR', 'RWO', 'RWM', 'RWL', 'RWK', 'RWJ', 'RUNN', 'RTH', 'RSPU', 'RSPT', 'RSPS', 'RSPR', 'RSPN', 'RSPM', 'RSPH', 'RSPG', 'RSPF', 'RSPD', 'RSPC', 'RSP', 'RPV', 'RPG', 'RPAR', 'ROM', 'RODM', 'ROBT', 'ROBO', 'RLY', 'RING', 'RINF', 'RINC', 'RIET', 'RFV', 'RFG', 'REZ', 'REW', 'RETL', 'REMX', 'REET', 'RDVY', 'RDVI', 'RDIV', 'RBLD', 'RAYS', 'RAAX', 'QYLG', 'QWLD', 'QUS', 'QTUM', 'QTEC', 'QRMI', 'QRFT', 'QQXT', 'QQQM', 'QQQJ', 'QQQE', 'QQQA', 'QQQ', 'QQH', 'QQEW', 'QMOM', 'QLD', 'QID', 'QGRO', 'QEMM', 'QEFA', 'QDPL', 'QDIV', 'QDF', 'QDEF', 'QCLN', 'QAI', 'QABA', 'PYZ', 'PYPY', 'PXJ', 'PXI', 'PXH', 'PXF', 'PXE', 'PWZ', 'PWV', 'PWB', 'PUTW', 'PULS', 'PUI', 'PTNQ', 'PTH', 'PTF', 'PTEC', 'PTBD', 'PST', 'PSR', 'PSQ', 'PSP', 'PSL', 'PSK', 'PSI', 'PSCT', 'PSCM', 'PSCI', 'PSCH', 'PSCF', 'PSCE', 'PSCC', 'PRN', 'PRF', 'PPH', 'PPA', 'PP', 'POWA', 'PNQI', 'PKW', 'PKB', 'PJP', 'PIZ', 'PIO', 'PINK', 'PIN', 'PILL', 'PIE', 'PHO', 'PHB', 'PGJ', 'PFXF', 'PFM', 'PFIX', 'PFI', 'PFFD', 'PFF', 'PEZ', 'PEY', 'PEO', 'PEJ', 'PDP', 'PDN', 'PDBC', 'PDBA', 'PCY', 'PBW', 'PBP', 'PBJ', 'PBE', 'PBD', 'PALC', 'OVT', 'OVLH', 'OUNZ', 'OOTO', 'ONLN', 'ONEY', 'ONEV', 'ONEQ', 'ONEO', 'OIH', 'OEF', 'ODDS', 'OBOR', 'OARK', 'OACP', 'NZAC', 'NXTG', 'NVDY', 'NVDU', 'NVDS', 'NVDL', 'NVDD', 'NVD', 'NUGT', 'NTSX', 'NLR', 'NFTY', 'NFRA', 'NFLY', 'NANR', 'NAN', 'NAIL', 'MZZ', 'MYY', 'MXI', 'MVV', 'MVPS', 'MVO', 'MSOX', 'MSOS', 'MSFU', 'MSFO', 'MSFD', 'MRNY', 'MOON', 'MOO', 'MNA', 'MMTM', 'MLPX', 'MLPA', 'MISL', 'MINT', 'MIDU', 'MGV', 'MGK', 'MGC', 'MEXX', 'METV', 'MDYV', 'MDYG', 'MDY', 'MDIV', 'MCHI', 'MBB', 'MAXI', 'MAKX', 'MAGS', 'LVHD', 'LTPZ', 'LTL', 'LRNZ', 'LRND', 'LRGF', 'LQDH', 'LQD', 'LOUP', 'LMBS', 'LIT', 'LGLV', 'LEMB', 'LEGR', 'LDEM', 'LCTU', 'LCTD', 'LABU', 'LABD', 'KXI', 'KWEB', 'KVLE', 'KURE', 'KTEC', 'KSTR', 'KSA', 'KROP', 'KRMA', 'KRE', 'KRBN', 'KORU', 'KOMP', 'KOLD', 'KOIN', 'KNCT', 'KMLM', 'KMET', 'KLXY', 'KLNE', 'KIE', 'KGRO', 'KGRN', 'KEUA', 'KEMX', 'KEMQ', 'KCE', 'KCCA', 'KBWY', 'KBWR', 'KBWP', 'KBWD', 'KBWB', 'KBE', 'KARS', 'JXI', 'JVAL', 'JUST', 'JSTC', 'JSML', 'JQUA', 'JPUS', 'JPST', 'JPSE', 'JPMO', 'JPIN', 'JPEM', 'JOET', 'JNUG', 'JNK', 'JMBS', 'JIRE', 'JHMM', 'JHML', 'JETS', 'JDST', 'JAAA', 'IYY', 'IYW', 'IYR', 'IYM', 'IYK', 'IYH', 'IYG', 'IYF', 'IYE', 'IYC', 'IXUS', 'IXP', 'IXN', 'IXJ', 'IXG', 'IXC', 'IWY', 'IWX', 'IWV', 'IWS', 'IWR', 'IWO', 'IWN', 'IWM', 'IWL', 'IWIN', 'IWFH', 'IWF', 'IWD', 'IWC', 'IWB', 'IVW', 'IVV', 'IVRS', 'IVOV', 'IVOO', 'IVOL', 'IVOG', 'IVLU', 'IVES', 'IVEG', 'IUSV', 'IUSG', 'IUSB', 'ITOT', 'ITEQ', 'ISTB', 'ISRA', 'IRBO', 'IQLT', 'IQDF', 'IPOS', 'IPO', 'IPKW', 'IPAY', 'IPAC', 'IOO', 'ION', 'INTF', 'INQQ', 'INFL', 'INDY', 'INCO', 'IMTM', 'IMCG', 'ILIT', 'ILF', 'ILCG', 'ILCB', 'IJT', 'IJS', 'IJR', 'IJK', 'IJJ', 'IJH', 'IHI', 'IHF', 'IHE', 'IHDG', 'IHAK', 'IGPT', 'IGOV', 'IGM', 'IGLB', 'IGF', 'IFV', 'IEZ', 'IEV', 'IEUR', 'IEMG', 'IEF', 'IDVO', 'IDUB', 'IDU', 'IDRV', 'IDNA', 'IDLV', 'IDHQ', 'IDGT', 'IDEV', 'IDAT', 'ICOP', 'ICLN', 'IBUY', 'IBRN', 'IBND', 'IBLC', 'IBBQ', 'IBB', 'IAT', 'IAK', 'IAI', 'HYZD', 'HYSA', 'HYS', 'HYLG', 'HYGH', 'HYG', 'HYEM', 'HYBB', 'HTEC', 'HRT', 'HOMZ', 'HJEN', 'HIBS', 'HIBL', 'HGER', 'HFND', 'HEZU', 'HEWJ', 'HEWG', 'HERO', 'HEQT', 'HEDJ', 'HDV', 'HDRO', 'HDGE', 'HDG', 'HDEF', 'HCOM', 'HAUZ', 'HARD', 'HAP', 'HAIL', 'HACK', 'GYLD', 'GXTG', 'GXG', 'GXC', 'GWX', 'GVLU', 'GVIP', 'GUSH', 'GURU', 'GUNR', 'GTEK', 'GSY', 'GSPY', 'GSLC', 'GSG', 'GRPM', 'GRN', 'GRID', 'GREK', 'GOEX', 'GOAU', 'GNR', 'GNOM', 'GMF', 'GMET', 'GLIN', 'GLDX', 'GLD', 'GK', 'GINN', 'GII', 'GIGB', 'GHYB', 'GGME', 'GGLS', 'GGLL', 'GFOF', 'GERM', 'GEM', 'GDXJ', 'GDX', 'GDVD', 'GDOC', 'GDEF', 'GCOR', 'GCC', 'GBLD', 'GBIL', 'GAMR', 'GAL', 'FYX', 'FYT', 'FYC', 'FXZ', 'FXY', 'FXU', 'FXR', 'FXP', 'FXO', 'FXL', 'FXI', 'FXH', 'FXG', 'FXF', 'FXE', 'FXD', 'FXB', 'FXA', 'FVD', 'FVAL', 'FV', 'FUTY', 'FUMB', 'FTXR', 'FTXO', 'FTXN', 'FTXL', 'FTXH', 'FTXG', 'FTSM', 'FTSL', 'FTRI', 'FTQI', 'FTLS', 'FTHI', 'FTGC', 'FTEC', 'FTC', 'FTA', 'FSZ', 'FSTA', 'FSMD', 'FSMB', 'FRI', 'FREL', 'FQAL', 'FPXI', 'FPX', 'FNY', 'FNX', 'FNK', 'FNGS', 'FNGG', 'FNDX', 'FNDE', 'FNDC', 'FNDB', 'FNDA', 'FNCL', 'FMET', 'FMAT', 'FM', 'FLRN', 'FLJP', 'FLJH', 'FLCH', 'FLBR', 'FLAX', 'FJP', 'FIXD', 'FIW', 'FIVG', 'FIVA', 'FITE', 'FINX', 'FILL', 'FIDU', 'FIDI', 'FID', 'FHLC', 'FGD', 'FFTY', 'FEZ', 'FEX', 'FEUZ', 'FEP', 'FENY', 'FEMS', 'FEM', 'FDVV', 'FDT', 'FDRR', 'FDNI', 'FDN', 'FDMO', 'FDLO', 'FDL', 'FDIS', 'FDIG', 'FDD', 'FCOM', 'FCG', 'FCA', 'FBZ', 'FBY', 'FBT', 'FBOT', 'FBND', 'FAZ', 'FAS', 'FAN', 'FALN', 'FAD', 'FAB', 'EZM', 'EZJ', 'EZA', 'EXI', 'EWZS', 'EWZ', 'EWY', 'EWX', 'EWW', 'EWV', 'EWU', 'EWT', 'EWS', 'EWQ', 'EWP', 'EWN', 'EWM', 'EWK', 'EWJ', 'EWI', 'EWH', 'EWG', 'EWD', 'EWC', 'EWA', 'EVX', 'EVAV', 'EUSA', 'EURL', 'EUO', 'EUM', 'EUFN', 'ESPO', 'ESGU', 'ESGE', 'ESGD', 'ERY', 'ERX', 'ERTH', 'EQWL', 'EQTY', 'EQL', 'EQAL', 'EPS', 'EPP', 'EPI', 'ENZL', 'ENRG', 'ENFR', 'EMXC', 'EMTY', 'EMQQ', 'EMLP', 'EMLC', 'EMFM', 'EMBD', 'EMB', 'ELD', 'EKG', 'EINC', 'EIDO', 'EFO', 'EFAX', 'EFAS', 'EFA', 'EETH', 'EES', 'EEMX', 'EEMS', 'EEM', 'EELV', 'EDZ', 'EDV', 'EDOW', 'EDOC', 'EDIV', 'EDC', 'ECOW', 'ECON', 'ECNS', 'ECLN', 'EBLU', 'EATV', 'EAGG', 'DYLG', 'DXJS', 'DXJ', 'DXD', 'DWM', 'DWAS', 'DVYE', 'DVY', 'DVOL', 'DUST', 'DUSL', 'DUHP', 'DUG', 'DTH', 'DTEC', 'DTD', 'DSTL', 'DSL', 'DSI', 'DRV', 'DRUP', 'DRN', 'DRIV', 'DRIP', 'DPST', 'DON', 'DOL', 'DNL', 'DMAT', 'DLS', 'DLN', 'DJP', 'DJD', 'DIVI', 'DIV', 'DISO', 'DIG', 'DIA', 'DHS', 'DGT', 'DGRW', 'DGRS', 'DGRO', 'DGIN', 'DFUV', 'DFUS', 'DFSV', 'DFSU', 'DFLV', 'DFJ', 'DFIV', 'DFIP', 'DFGR', 'DFEN', 'DFE', 'DFAX', 'DFAU', 'DFAT', 'DFAS', 'DFAR', 'DFAI', 'DFAC', 'DEW', 'DEUS', 'DESK', 'DES', 'DEM', 'DEEP', 'DDM', 'DBP', 'DBO', 'DBMF', 'DBJP', 'DBEU', 'DBEM', 'DBE', 'DBC', 'DBB', 'DAX', 'DAT', 'DAPP', 'CXSE', 'CWS', 'CWI', 'CWEB', 'CWB', 'CVY', 'CVSE', 'CVMC', 'CVLC', 'CVIE', 'CUT', 'CURE', 'CTEX', 'CTEC', 'CSD', 'CSB', 'CRUZ', 'CRPT', 'CRBN', 'CRAK', 'CR', 'CQQQ', 'CPER', 'COWS', 'CORN', 'COPX', 'CONY', 'CONL', 'COMT', 'COMB', 'COM', 'CNXT', 'CNBS', 'CN', 'CMDY', 'CLOU', 'CLIX', 'CLDL', 'CIBR', 'CHIX', 'CHIS', 'CHIR', 'CHIQ', 'CHIK', 'CHII', 'CHIH', 'CHIE', 'CHAU', 'CHAT', 'CGW', 'CGUS', 'CGGR', 'CGDV', 'CFO', 'CFA', 'CDL', 'CDC', 'CCRV', 'CCOR', 'CATH', 'CARZ', 'CANE', 'BZQ', 'BYOB', 'BWET', 'BUZZ', 'BUG', 'BTF', 'BTEK', 'BTAL', 'BSVO', 'BRZU', 'BRF', 'BOTZ', 'BOIL', 'BOAT', 'BNO', 'BNGE', 'BNDX', 'BNDD', 'BND', 'BLV', 'BLOK', 'BLCN', 'BKLC', 'BKF', 'BKCH', 'BJK', 'BIZD', 'BIV', 'BITS', 'BITQ', 'BITO', 'BITI', 'BIS', 'BIPC', 'BILS', 'BIBL', 'BIB', 'BFOR', 'BFIX', 'BFIT', 'BETZ', 'BDRY', 'BCIM', 'BCI', 'BCD', 'BBP', 'BBMC', 'BBH', 'BBC', 'BANX', 'BAB', 'AWAY', 'AVUV', 'AVUS', 'AVRE', 'AVLV', 'AVEM', 'AVDV', 'AVDE', 'ASHX', 'ASHR', 'ASA', 'ARKW', 'ARKK', 'ARKF', 'ARGT', 'AQWA', 'AOR', 'AOM', 'AOA', 'ANGL', 'ANEW', 'AMZY', 'AMZU', 'AMZD', 'AMZA', 'AMOM', 'AMLP', 'AMJ', 'AMDY', 'ALTY', 'ALTL', 'AIVL', 'AIVI', 'AIRR', 'AIEQ', 'AIA', 'AHOY', 'AGZ', 'AGQ', 'AGNG', 'AGG', 'ACWX', 'ACWI', 'ACES', 'AAXJ', 'AAPU', 'AAPD', 'AAPB', 'UVIX', 'VIXY', 'KLIP', 'BITX', 'XXXX', 'SPSK',]




stock_conditions_description_dictionary = { 
    'Corrected Consolidated Close (per listing market)':'Corrected Consolidated Close - per the Listing Market ("9"): This new modifier will be allowed to be used only by the Listing Market and may be used to adjust the consolidated last sale price. The Corrected Consolidated Close will be eligible to set the High, Low and Last for the consolidated statistics and will not update the participant records. Volume will always be reported as zero and will appear in Level 2 of the extended sale condition modifier field on the UTDF and CTS data feeds.',
    "Regular Sale": "A trade made without stated conditions is deemed regular way for settlement on the third business day following the transaction date.",
    "Acquisition": "A transaction made on the Exchange as a result of an Exchange acquisition.",
    "Average Price Trade": "A trade where the price reported is based upon an average of the prices for transactions in a security during all or any portion of the trading day.",
    "Automatic Execution": "A sale condition code that identifies a NYSE trade that has been automatically executed without the potential benefit of price improvement.",
    "Bunched Trade": "The combining of multiple odd-lot or round-lot orders for the same security so that they can all be executed at the same time. All affected clients must agree to the bunching before the order is submitted. Bunched trades may also be referred to as block trades.",
    "Bunched Sold Trade": "A bunched trade that is reported late.",
    "Cash Sale": "A transaction which requires delivery of securities and payment on the same day the trade takes place.",
    "Closing Prints": "The Participant Closing Price represents the last qualifying trade paid for a security by a Participant during the trading day.",
    "Cross Trade": "Indicates that the trade resulted from a Market Center’s crossing session.",
    "Derivatively Priced": "The transaction that constituted the trade-through was the execution of an order at a price that was not based, directly or indirectly, on the quoted price of the security at the time of execution, and for which the material terms were not reasonably determinable at the time the commitment to execute the order was made (REG NMS 611b7).",
    "Distribution": "Distribution stock refers to a large blocks of a security that are carefully sold into the market gradually in smaller blocks so as to inundate the market with sell orders for the security and driving down its price.",
    "Form T": "Identifies a trade that was executed outside of regular primary market hours and is reported as an extended hours trade.",
    "Extended Trading Hours (Sold Out of Sequence)": "Identifies a trade that takes place outside of regular market hours and is reported as an extended hours trade out of sequence and at a time different from the actual transaction time.",
    "Intermarket Sweep": "The transaction that constituted the trade-through was the execution of an order identified as an Intermarket Sweep Order.",
    "Market Center Official Close": "Indicates the ‘Official’ closing value as determined by a Market Center. This transaction report will contain the market center generated closing price.",
    "Market Center Official Open": "Indicates the ‘Official’ opening value as determined by a Market Center. This transaction report will contain the market center generated opening price.",
    "Market Center Opening Trade": "The trade that constituted the trade-through was a single priced opening transaction by the Market Center (REG NMS Rule 611b3).",
    "Market Center Reopening Trade": "The trade that constituted the trade-through was a single priced reopening transaction by the Market Center (REG NMS Rule 611b3).",
    "Market Center Closing Trade": "The transaction that constituted the trade-through was a single priced closing transaction by the Market Center (REG NMS Rule 611b3).",
    "Next Day": "A transaction that requires the delivery of securities on the first business day following the trade date.",
    "Price Variation Trade": "Indicates a regular market session trade transaction that carries a price that is significantly away from the prevailing consolidated or primary market value at the time of the transaction.",
    "Prior Reference Price": "A sale condition that identifies a trade based on a price at a prior point in time, i.e., more than 90 seconds prior to the time of the trade report. The execution time of the trade will be the time of the prior reference price.",
    "Rule 155 Trade (AMEX)": "A Seller’s Option transaction gives the seller the right to deliver the security at any time within a specific period, ranging from not less than two calendar days, to not more than sixty calendar days. A security offered “Seller’s Option” may command a lesser price than if offered “Regular Way”.",
    "Rule 127 NYSE": "To qualify as a NYSE Rule 127 the trade is executed outside the present quote and meets one or both of the following conditions: 1. has a volume of 10,000 shares or more and/or 2. has a dollar value of $200,000 or more.",
    "Opening Prints": "The trading day's first drawings of a symbol's candlestick charts.",
    "Stopped Stock (Regular Trade)": "A Seller’s Option transaction gives the seller the right to deliver the security at any time within a specific period, ranging from not less than two calendar days, to not more than sixty calendar days. A security offered “Seller’s Option” may command a lesser price than if offered “Regular Way”.",
    "Re-Opening Prints": "The transaction or group of transactions reported as a result of a single- priced re-opening event by the Market Center.",
    "Seller": "A Seller’s Option transaction gives the seller the right to deliver the security at any time within a specific period, ranging from not less than two calendar days, to not more than sixty calendar days. A security offered “Seller’s Option” may command a lesser price than if offered “Regular Way”.",
    "Sold Last": "Sold Last sale condition modifier is used when a trade prints in sequence but is reported late OR the trade is printed by Amex in conformance to the One or Two Point Rule. A Sold Last transaction should only impact the consolidated last sale price for an issue if the market center reporting the sold last transaction also reported the transaction setting the current last sale price.",
    "Sold (out of Sequence)": "Sold Out of Sequence is used when a trade is printed (reported) out of sequence and at a time different from the actual transaction time.",
    "Split Trade": "An execution in two markets when the specialist or Market Maker in the market first receiving the order agrees to execute a portion of it at whatever price is realized in another market to which the balance of the order is forwarded for execution.",
    "Stock Option Trade": "This is typically the stock portion of a delta neutral option trade executed by an option market maker.",
    "Yellow Flag Regular Trade": "Market Centers will have the ability to identify regular trades being reported during specific events as out of the ordinary by appending a new sale condition code Yellow Flag (“Y”) on each transaction reported to the UTP SIP. The new sale condition “.Y” will be eligible to update all market center and consolidated statistics. In certain instances, the UTP SIP will be required to append the .Y for the market center for trades reported as regular-way (Sale Condition @)",
    "Odd Lot Trade": "The Odd Lot Trade modifier will distinguish a trade resulting from a market center's execution in increments less than the defined round lot size.",
    "Corrected Consolidated Close (per listing market)": "A transaction executed by the Listing Market to establish the official Consolidated Last Price as indicated by the Listing Exchange.",
    "Held": "Trades received from a non-primary Participant during a primary market regulatory halt. These trades are held by the CTS Processor and are disseminated after the close of the primary market with an appropriate Held Trade Indicator code applicable to the trade.",
    "Trade Thru Exempt": "The Trade Through rule is a 20 year-old rule applied to NYSE-listed stocks that states that when a market receives an order, it cannot execute it at a price inferior to any found on another market. In modern electronic markets where trades are executed in milliseconds, this rule can prevent a broker’s ability to meet their “best execution” obligation--because speed provides certainty that the price that is advertised can be accessed.",
    "Correction": "Denotes a correction to the last indication or new indication. It will contain the corrected approximation of what that security's opening or reopening price range (Bid and Offer prices, no sizes) will be when trading resumes after a delayed opening or after a trading halt.",
    "Contingent Trade": "A Sale Condition code used to identify a transaction where the execution of the transaction is contingent upon some event.",
    "Qualified Contingent Trade ('QCT')": "A transaction consisting of two or more component orders executed as agent or principal where the execution of one component is contingent upon the execution of all other components at or near the same time and the price is determined by the relationship between the component orders and not the current market price for the security.",
    "Placeholder for 611 exempt": "Rule 611, which is the Trade Through Exemption of SEC Regulation NMS, is very lengthy to cover in detail. Parties interested in reading the rule in its entirely should type 'SEC Rule 611' into an internet search engine. This is the portion of the document that is pertinent to IB traders, in a nutshell: Typically the trades involved are a multi-component trade involving orders for a security and a related derivative, or, in the alternative, orders for related securities, that are executed at or near the same time. The SIA (Securities Industry Association) notes that the economics of a contingent trade are based on the relationship between the prices of the security and the related derivative or security, and that the execution of one order is contingent upon the execution of the other order.",
    "SSR in Effect": "Any stock that has dropped more than 10% intraday has SSR in effect for that day and the following."

}

option_conditions = {
    201: 'Canceled',
    202: 'Late and Out Of Sequence',
    203: 'Last and Canceled',
    204: 'Late',
    205: 'Opening Trade and Canceled',
    206: 'Opening Trade, Late, and Out Of Sequence',
    207: 'Only Trade and Canceled',
    208: 'Opening Trade and Late',
    209: 'Automatic Execution',
    210: 'Reopening Trade',
    219: 'Intermarket Sweep Order',
    227: 'Single Leg Auction Non ISO',
    228: 'Single Leg Auction ISO',
    229: 'Single Leg Cross Non ISO',
    230: 'Single Leg Cross ISO',
    231: 'Single Leg Floor Trade',
    232: 'Multi Leg auto-electronic trade',
    233: 'Multi Leg Auction',
    234: 'Multi Leg Cross',
    235: 'Multi Leg floor trade',
    236: 'Multi Leg auto-electronic trade against single leg(s)',
    237: 'Stock Options Auction',
    238: 'Multi Leg Auction against single leg(s)',
    239: 'Multi Leg floor trade against single leg(s)',
    240: 'Stock Options auto-electronic trade',
    241: 'Stock Options Cross',
    242: 'Stock Options floor trade',
    243: 'Stock Options auto-electronic trade against single leg(s)',
    244: 'Stock Options Auction against single leg(s)',
    245: 'Stock Options floor trade against single leg(s)',
    246: 'Multi Leg Floor Trade of Proprietary Products',
    247: 'Multilateral Compression Trade of Proprietary Products',
    248: 'Extended Hours Trade',
}

option_conditions_dict = { 
    "Corrected Consolidated Close (per listing market)": os.environ.get('corrected_close'),
    "Regular Sale": os.environ.get('regular_sale'),
    "Acquisition": os.environ.get('acquisition'),
    "Average Price Trade": os.environ.get('average_price_trade'),
    "Automatic Execution": os.environ.get('automatic_execution'),
    "Bunched Trade": os.environ.get('bunched_trade'),
    "Bunched Sold Trade": os.environ.get('bunched_sold_trade'),
    "Cash Sale": os.environ.get('cash_sale'),
    "Closing Prints": os.environ.get('closing_prints'),
    "Cross Trade": os.environ.get('cross_trade'),
    "Derivatively Priced": os.environ.get('derivatively_priced'),
    "Distribution": os.environ.get('distribution'),
    "Form T": os.environ.get('form_t'),
    "Extended Trading Hours (Sold Out of Sequence)": os.environ.get('extended_trading_hours_sold_out_of_sequence'),
    "Intermarket Sweep": os.environ.get('intermarket_sweep'),
    "Market Center Official Close": os.environ.get('market_center_official_close'),
    "Market Center Official Open": os.environ.get('market_center_official_open'),
    "Market Center Opening Trade": os.environ.get('market_center_opening_trade'),
    "Market Center Reopening Trade": os.environ.get('market_center_reopening_trade'),
    "Market Center Closing Trade": os.environ.get('market_center_closing_trade'),
    "Next Day": os.environ.get('next_day'),
    "Price Variation Trade": os.environ.get('price_variation_trade'),
    "Prior Reference Price": os.environ.get('prior_reference_price'),
    "Rule 155 Trade (AMEX)": os.environ.get('rule_155_trade_amex'),
    "Rule 127 NYSE": os.environ.get('rule_127_nyse'),
    "Opening Prints": os.environ.get('opening_prints'),
    "Stopped Stock (Regular Trade)": os.environ.get('stopped_stock_regular_trade'),
    "Re-Opening Prints": os.environ.get('re_opening_prints'),
    "Seller": os.environ.get('seller'),
    "Sold Last": os.environ.get('sold_last'),
    "Sold (out of Sequence)": os.environ.get('sold_out_of_sequence'),
    "Split Trade": os.environ.get('split_trade'),
    "Stock Option Trade": os.environ.get('stock_option_trade'),
    "Yellow Flag Regular Trade": os.environ.get('yellow_flag_regular_trade'),
    "Odd Lot Trade": os.environ.get('odd_lot_trade'),
    "Corrected Consolidated Close (per listing market)": os.environ.get('corrected_consolidated_close_per_listing_market'),
    "Held": os.environ.get('held'),
    "Trade Thru Exempt": os.environ.get('trade_thru_exempt'),
    "Correction": os.environ.get('correction'),
    "Contingent Trade": os.environ.get('contingent_trade'),
    "Qualified Contingent Trade ('QCT')": os.environ.get('qualified_contingent_trade_qct'),
    "Placeholder for 611 exempt": os.environ.get('placeholder_for_611_exempt'),
    "SSR in Effect": os.environ.get('ssr_in_effect')
}



FED_RESERVE_OIC_ENDPOINTS_DICT = {'Broad General Collateral Rate': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-BGCR-A&label=aggregation', 'Broad General Collateral Rate: 1st Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-BGCR_1Pctl-A&label=aggregation', 'Broad General Collateral Rate: 25th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-BGCR_25Pctl-A&label=aggregation', 'Broad General Collateral Rate: 75th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-BGCR_75Pctl-A&label=aggregation', 'Broad General Collateral Rate: 99th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-BGCR_99Pctl-A&label=aggregation', 'Broad General Collateral Rate: Underlying Volume': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-BGCR_UV-A&label=aggregation', 'Effective Federal Funds Rate': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-EFFR-A&label=aggregation', 'Effective Federal Funds Rate: 1st Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-EFFR_1Pctl-A&label=aggregation', 'Effective Federal Funds Rate: 25th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-EFFR_25Pctl-A&label=aggregation', 'Effective Federal Funds Rate: 75th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-EFFR_75Pctl-A&label=aggregation', 'Effective Federal Funds Rate: 99th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-EFFR_99Pctl-A&label=aggregation', 'Effective Federal Funds Rate: Underlying Volume': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-EFFR_UV-A&label=aggregation', 'Overnight Bank Funding Rate': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-OBFR-A&label=aggregation', 'Overnight Bank Funding Rate: 1st Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-OBFR_1Pctl-A&label=aggregation', 'Overnight Bank Funding Rate: 25th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-OBFR_25Pctl-A&label=aggregation', 'Overnight Bank Funding Rate: 75th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-OBFR_75Pctl-A&label=aggregation', 'Overnight Bank Funding Rate: 99th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-OBFR_99Pctl-A&label=aggregation', 'Overnight Bank Funding Rate: Underlying Volume': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-OBFR_UV-A&label=aggregation', 'Secured Overnight Financing Rate': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-SOFR-A&label=aggregation', 'Secured Overnight Financing Rate: 1st Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-SOFR_1Pctl-A&label=aggregation', 'Secured Overnight Financing Rate: 25th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-SOFR_25Pctl-A&label=aggregation', 'Secured Overnight Financing Rate: 75th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-SOFR_75Pctl-A&label=aggregation', 'Secured Overnight Financing Rate: 99th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-SOFR_99Pctl-A&label=aggregation', 'Secured Overnight Financing Rate: Underlying Volume': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-SOFR_UV-A&label=aggregation', 'Tri-Party General Collateral Rate': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-TGCR-A&label=aggregation', 'Tri-Party General Collateral Rate: 1st Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-TGCR_1Pctl-A&label=aggregation', 'Tri-Party General Collateral Rate: 25th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-TGCR_25Pctl-A&label=aggregation', 'Tri-Party General Collateral Rate: 75th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-TGCR_75Pctl-A&label=aggregation', 'Tri-Party General Collateral Rate: 99th Percentile': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-TGCR_99Pctl-A&label=aggregation', 'Tri-Party General Collateral Rate: Underlying Volume': 'https://data.financialresearch.gov/v1/series/timeseries?mnemonic=FNYR-TGCR_UV-A&label=aggregation'}




PATTERNS_TO_LEARN_DICT = { 
    'Megaphone Bottom': 'https://media.discordapp.net/attachments/1323691430694359061/1323691431088619520/broadening-bottom-pattern-white-black-600nw-2208900637.webp?ex=677ab536&is=677963b6&hm=a158a451c5eadcbe6da32cb6c1454297cc9145da62d9c5b7751923d8012a5b73&=&format=webp&width=600&height=800',
    'Bottomg Triangle / Bottom Wedge': 'https://media.discordapp.net/attachments/1323533375411060786/1323533375885021184/8696e1d0602b45c18d9dab078874e5df.gif?ex=677acac2&is=67797942&hm=a870316afa30cc8ad56454adc0e24a066da53e83bd9bed3ee09836b6e6645620&=&width=600&height=800',
    'Island Bottom': 'https://media.discordapp.net/attachments/1323533089074450503/1323533089258995722/3f93f2e5da594321b8968e8961ada42e.gif?ex=677aca7e&is=677978fe&hm=8407efa551612c8b0f36600946c8fce9d55d4c60ad8d5fe4b4fc06a7b648efe4&=&width=600&height=800',
    'Diamond Bottom': 'https://media.discordapp.net/attachments/1323532831393054731/1323532831749832714/ba0ae0f3233f492ba5351f713fe5c1a9.gif?ex=677aca41&is=677978c1&hm=62330288cc051f7fbd936767a36e4974eebeae87c384cd656e47f05d753e2e0c&=&width=600&height=800',
    'Triple Bottom': 'https://media.discordapp.net/attachments/1323532104633548901/1323532105547780187/add50eee33a54f2384578344b3b7ec15.gif?ex=677ac994&is=67797814&hm=81746a80462983b8e13150b16ab8e123fa9d23f5988dc05b108dd3b1f502d80c&=&width=600&height=800',
    'Rounded Bottom': 'https://media.discordapp.net/attachments/1323531702475296768/1323531703003648010/6614b983f9cc43ebb7f50cc5ff476519.gif?ex=677ac934&is=677977b4&hm=4b2091965658e1f5e63402297de1b3e353f1d91d6373337e608f587a082cc0fb&=&width=600&height=800',
    'Double Bottom': 'https://media.discordapp.net/attachments/1323531460040331354/1323531460657025074/10001a318a80438184f53f87838d9786.gif?ex=677ac8fa&is=6779777a&hm=87f1810cd9c8a82ff02b16861453c07c661bde9b09d97869c5112555a6b13464&=&width=600&height=800',
    'Head and Shoulders Bottom': 'https://media.discordapp.net/attachments/1323531201989971988/1323531202384363520/e1255ee1bded47dfb1ad5b149e5ae357.gif?ex=677ac8bc&is=6779773c&hm=71220ba9c49780a523fa28ee721e8a0ae2063a465beb952ed4513fd74407287d&=&width=600&height=800',
    'Top Triangle / Top Wedge': 'https://media.discordapp.net/attachments/1323530950860083362/1323530951409668148/abbe73257fbe460e97cc9cf7fc1d72e7.gif?ex=677ac880&is=67797700&hm=1dd94a5932d7376239004124848c1ccbb0836291e5797058637dda0a25f6844a&=&width=600&height=800',
    'Megaphone Top': 'https://media.discordapp.net/attachments/1323530591668535316/1323530591936974948/2a05e35dc14a4faeb7c63870230681ba.gif?ex=677ac82b&is=677976ab&hm=cb4539f887f819b0db92bbad7ce1c8460f5221205c82426b8e165db81cc6035e&=&width=600&height=800',
    'Island Top': 'https://media.discordapp.net/attachments/1323530217381433366/1323530217540812870/1ef92c2c9dda4797b811660ceb12ea63.gif?ex=677ac7d1&is=67797651&hm=a012c2d42659610ae7fd96e0cb0b029fa62c21e9500e4f963051452ee4767580&=&width=600&height=800',
    'Diamond Top': 'https://media.discordapp.net/attachments/1323529995628318761/1323529995812999242/a328d0c954fe465ab8a22eeb19f15b67.gif?ex=677ac79d&is=6779761d&hm=13871d49ce3ec6a19ed8b75be92df78a69535f63ab7297f07b6b6bd617c23c40&=&width=600&height=800',
    'Head and Shoulders Top': 'https://media.discordapp.net/attachments/1323529570950975528/1323529571714334761/98b1cd5c4ec04cfbacd6c9ac3c82b3c6.gif?ex=677ac737&is=677975b7&hm=97535dbff925e40a2b9e3b52c560bed33e657f924055bcbfcfbcc47b6dadd538&=&width=600&height=800',
    'Rounded Top': 'https://media.discordapp.net/attachments/1323529238342533217/1323529238963294219/533f3e4bbe2e414a93f8e99a1801657e.gif?ex=677ac6e8&is=67797568&hm=f34204d0f1ac8ba77d57b34c8519440b63ae6b89d355d98840bd62baef00a689&=&width=600&height=800',
    'Triple Top': 'https://media.discordapp.net/attachments/1323529012693176373/1323529012869595188/08c735d66b114ed9804ccb10303e3438.gif?ex=677ac6b2&is=67797532&hm=1bd639b3d1a198cfeb3b77242fa73a59feb41763df42bfb8cc557ed6fccf51cd&=&width=600&height=800',
    'Bearish Gravestone': 'https://media.discordapp.net/attachments/1323528570785497190/1323528571335086080/aea898d5550c46c39f8111677d89d0dd.gif?ex=677ac649&is=677974c9&hm=14d1ab1c1f6293ff1d600674225f6d954654b9221b1a145cf61283d61a1f2bb7&=&width=600&height=800',
    'Bearish Exhaustion Bar': 'https://media.discordapp.net/attachments/1323528076830703636/1323528077149605930/f45ef2a163d9491f89229dc3b63dd67f.gif?ex=677ac5d3&is=67797453&hm=1376d5a89104c4bf739079a6d7f4a24bc815a7d99e8e486f99a67d1b6a5d0d4a&=&width=600&height=800',
    'Bearish Pennant': 'https://media.discordapp.net/attachments/1323527672936267787/1323527673686921267/32694d0d2a2e423c82fcfa211e935f88.gif?ex=677ac573&is=677973f3&hm=4c97371ba88fbdcff92c346f0ae5359d9503deb075f4d04c334bb5fb816ac3f5&=&width=600&height=800',
    'Bearish Engulfing': 'https://media.discordapp.net/attachments/1323527017697902662/1323527017903427604/195f7d84aad247c283c54099097ff7cf.gif?ex=677ac4d7&is=67797357&hm=eb88650df64bda52544a33b94bfba04670e6f313c204a9673cef9b7bdaad906d&=&width=600&height=800',
    'The Hammer': 'https://media.discordapp.net/attachments/1323526656476057632/1323526657021050982/301763fef8714cbfa3a4fc01e727dc00.gif?ex=677ac480&is=67797300&hm=fd9db8d74b65d612c70f8f630849622bda5cdea3aa5337819e0b0e0f57ee3999&=&width=600&height=223',
    'Bearish Two-bar Reversal': 'https://media.discordapp.net/attachments/1323525319080280135/1323525319457505331/78973b12ba32491db844fdaefa621267.gif?ex=677ac342&is=677971c2&hm=f0fab8198313fe621e9c21458bcf070625054eb45d9fdcbc8d58f398613396f9&=&width=600&height=223',
    'Bearish Key-reversal Bar': 'https://media.discordapp.net/attachments/1323524685014761535/1323524685190795295/78973b12ba32491db844fdaefa621267.gif?ex=677ac2aa&is=6779712a&hm=eae58f8b4f24d13fb618b0da0bc7bc0fefda8d6e64052324a0c78b48c7895065&=&width=600&height=223',
    'Bearish Continuation Triangle': 'https://media.discordapp.net/attachments/1323524073472397384/1323524073694691328/141f20b1f1ef48949958fdc2c6836392.gif?ex=677ac219&is=67797099&hm=6704223c442c3ce683f5467e7cb145c38c09eafc85e5fdeaedcc3a208cf4449b&=&width=600&height=223',
    'Bearish Continuation Wedge': 'https://media.discordapp.net/attachments/1323523724368019547/1323523724627935312/be5ffc9b61ed4ce4b37946a7ed598dc8.gif?ex=677ac1c5&is=67797045&hm=163a95774807589371521b7beb6cb793567e68bccc45bf0f1fab832cbd22edea&=&width=600&height=223',
    'Bear Flag': 'https://media.discordapp.net/attachments/1323523124741931131/1323523125748437024/25d785328ed1428e9c86fdb8b6eec8ed_1.gif?ex=677ac137&is=67796fb7&hm=b370aef800a8955fdb57803f2afd9a7e3d44e9ed799cb74ed35f7a9975a932c8&=&width=600&height=223',
    'Downside Breakout': 'https://media.discordapp.net/attachments/1323522524071333989/1323522524226650283/0ae44b8c686e4d6d8e2332d8f18c86f2.gif?ex=677ac0a7&is=67796f27&hm=f115ce252e0d73f2790ed7ff4ca9fb8330d68a9005ac6d48ac39611e636572e6&=&width=600&height=223',
    'Bearish Continuation Diamond': 'https://media.discordapp.net/attachments/1323522048911212554/1323522049070858300/03167e0bc7424c939cf06973d75cb49a.gif?ex=677ac036&is=67796eb6&hm=93fbd9d4b752883bf6d2c5e3b4b8484ab04a4d4879bb57fdbd2f43ed366d00da&=&width=600&height=223',
    'Bullish Gravestone': 'https://media.discordapp.net/attachments/1323521424320630836/1323521424534802453/1bfb86dd27a64a3f9d26beb111d7ac6c.gif?ex=677abfa1&is=67796e21&hm=4cf2ed5f51aa6389e5b7f34db5d1402cdf5d7b42a5668e103d2a58ce1424e653&=&width=600&height=223',
    'Bullish Exhaustion Bar': 'https://media.discordapp.net/attachments/1323520909834981396/1323520910212337684/4e78e8498fc8474da42ec6160162fca0_1.gif?ex=677abf26&is=67796da6&hm=f70e709be13049ef7bc608a28b5ac30f76acafa125d77c22d8de19ab80c34e80&=&width=600&height=223',
    'Bullish Pennant': 'https://media.discordapp.net/attachments/1323520330215460957/1323520330509189220/5d4dab3f68ac464bbb35961dc6182edd.gif?ex=677abe9c&is=67796d1c&hm=dbfa038821c3b9843f64879b5c9123ef46b06cf1226227e2ad0352ad7eca011c&=&width=600&height=223',
    'Bullish Outside Bar': 'https://media.discordapp.net/attachments/1323520032902221845/1323520033078509619/359be57d6e684aaea20e40566849ddf6.gif?ex=677abe55&is=67796cd5&hm=19e8a175bf0261600914425a125fe190427af30eee5d4d812364efb6293b9b76&=&width=600&height=223',
    'Bullish Continuation Diamond': 'https://media.discordapp.net/attachments/1323519556253122652/1323519556500852786/c51a689703f74256b35f539dde2f001e.gif?ex=677abde4&is=67796c64&hm=211e10b68606f7f4b18136e67d75e483d9bac50bf2c8df7edd8a12ffb939c12a&=&width=600&height=223',
    'Bullish Engulfing': 'https://media.discordapp.net/attachments/1323518975459594341/1323518975682019468/010733f807914bf9aaec620aeddf065b.gif?ex=677abd59&is=67796bd9&hm=43ab80b51b1d2db6b038a6b7f7296048151da40200c90edf893b277db506a550&=&width=600&height=223',
    'Bullish Inside Bar': 'https://media.discordapp.net/attachments/1323518606314831922/1323518606511837244/bdf7f26d2a2a4797b286587eeeaa306f.gif?ex=677abd01&is=67796b81&hm=e803b0e80ccecfcf2ac64debd03bb44b15fa61d8bdfdeea1effc27c4a3199c36&=&width=600&height=223',
    'Bullish Two-bar Reversal': 'https://media.discordapp.net/attachments/1323518110828855326/1323518111143694346/b3bb4aa4cb5144119626bc7806cad224.gif?ex=677abc8b&is=67796b0b&hm=2398678ab835fa4d6dd75716394fa6a48171ea29ce57ee07aef96675637830e1&=&width=600&height=223',
    'Bullish Key-reversal Bar': 'https://media.discordapp.net/attachments/1323517431737618573/1323517431976824945/b2a6a707338e49c8889ce9784d81f0c4_1.gif?ex=677abbe9&is=67796a69&hm=bd4caab7e0afe1f93b72600a1ddb8f8173d95ee668def82cac68e29c5cdcf6e3&=&width=600&height=223',
    'Bullish Symmetrical Continuation Triangle': 'https://media.discordapp.net/attachments/1323516680567128064/1323516681091285022/da213bc32e4948ab9c5a1635f527e131.gif?ex=677abb36&is=677969b6&hm=bb7680db72a67663ed9a8a982572c2546dd69bafb5c0285f18a408049329624b&=&width=600&height=223',
    'Bullish Continuation Wedge': 'https://media.discordapp.net/attachments/1323516115145719839/1323516115724406827/6e2f3dae75d64fe09e15eab020896fea.gif?ex=677abaaf&is=6779692f&hm=f829337488d1f94da6ebd1f36faa4688fb61189068a24d9622aa9647f547f806&=&width=600&height=223',
    'Bull Flag': 'https://media.discordapp.net/attachments/1323515387970715660/1323515388197077022/62ce4a5c3a4c46559dd05f269a4096e2.gif?ex=677aba02&is=67796882&hm=c0bb8488d8852050a7360f9668eed5cfe4ff328cb1c62367d4cd22f3fd061794&=&width=600&height=223',
    'Upside Breakout': 'https://media.discordapp.net/attachments/1323512543494275072/1323512543641079848/4d2005ffc7a94476971d70f3dcfa6060.gif?ex=677ab75c&is=677965dc&hm=86b335c42df3c725d370136ab57c030d6c44f1f60b2bfcd8ca4b4cb6b17d4ce5&=&width=600&height=223',
    'Bullish Exhaustion Bar': 'https://media.discordapp.net/attachments/1323511401876164629/1323511402291269664/4e78e8498fc8474da42ec6160162fca0.gif?ex=677ab64b&is=677964cb&hm=36dac0d07f00970d84c0ed4239fe126273865ee47a20718bab8c55e8fd42276f&=&width=600&height=223',
    'Gap Down': 'https://media.discordapp.net/attachments/1323510134931980318/1323510135620108288/e3fc297d0ccb46f5b34059508d951b4f_1.gif?ex=677ab51d&is=6779639d&hm=e2844dac6900a25211b543000de34d87851a780c9c05632b11e477478e2f1328&=&width=600&height=223',
    'Gap Up': 'https://media.discordapp.net/attachments/1323509508982439946/1323509509200810076/8eb798b593d0477693474da93047eec5.gif?ex=677ab488&is=67796308&hm=932a88fb8f9bfe4dae8f53d403dc112df4828a91ab4f557b378a6be92ebbd85b&=&width=600&height=223',
    'Bearish Exhaustion Bar': 'https://media.discordapp.net/attachments/1323508715760123976/1323508715915186206/f45ef2a163d9491f89229dc3b63dd67f.gif?ex=677ab3cb&is=6779624b&hm=5455bde4c36b31ed2ebfef6bd3400b395861ac9f522754d6a2a6b1be369a7700&=&width=600&height=223',
    'MACD': 'https://media.discordapp.net/attachments/1323507537005510666/1323507537403842591/01745f9cf69e48a9a595d2483c06c12c.gif?ex=677ab2b2&is=67796132&hm=dcca3b6239e8033c98f07d949b4978f31d8cc5823bb27b9645abeaccd995c7a2&=&width=600&height=223'



    

}



MASTER_ATTRIBUTE_DICT = attributes_description = {
    "StockLoans": {
        "businessDate": "The date of the business transaction or loan.",
        "newMarketLoanCount": "Number of new market loans issued.",
        "totalMarketLoanVal": "Total value of all market loans.",
        "newBilateralLoanCount": "Number of new bilateral loans issued.",
        "totalBilateralLoanVal": "Total value of all bilateral loans."
    },
    "VolumeTotals": {
        "totalVolume": "Total trading volume across all instruments.",
        "optionsVolume": "Volume of options traded.",
        "futuresVolume": "Volume of futures contracts traded.",
        "fiftytwo_week_high": "Highest trading volume in the past 52 weeks.",
        "fiftytwo_week_low": "Lowest trading volume in the past 52 weeks.",
        "monthlyDailyAverage": "Average daily trading volume for the month.",
        "yearlyDailyAverage": "Average daily trading volume for the year.",
        "trade_dates": "List of trade dates extracted from weekly volume data.",
        "trade_volume": "List of trade volumes corresponding to the trade dates."
    },
    "DailyMarketShare": {
        "exchange": "Exchange where the trading occurred.",
        "calls": "Volume of call options traded.",
        "puts": "Volume of put options traded.",
        "ratio": "Ratio of call to put options traded.",
        "volume": "Total volume of options traded.",
        "market_share": "Market share percentage for the exchange."
    },
    "OCCMostActive": {
        "symbol": "The stock ticker symbol.",
        "companyName": "Name of the company.",
        "optVolCall": "Volume of call options traded for the symbol.",
        "optVolPut": "Volume of put options traded for the symbol.",
        "optVol": "Total options volume traded for the symbol.",
        "ivx30": "30-day implied volatility for the symbol.",
        "ivx30ChgPercent": "Percentage change in the 30-day implied volatility.",
        "stockType": "Type of stock (e.g., equity, ETF).",
        "optVolCallPercent": "Percentage of total options volume represented by call options.",
        "optVolPutPercent": "Percentage of total options volume represented by put options."
    },
    "StockInfo": {
        "dividendDate": "Date of the next dividend payment.",
        "dividendAmount": "Amount of dividend per share.",
        "dividendFrequency": "Frequency of dividend payments (e.g., quarterly, yearly).",
        "yield": "Dividend yield of the stock as a percentage.",
        "bid": "Current bid price for the stock.",
        "ask": "Current ask price for the stock.",
        "mid": "Midpoint of the bid-ask spread.",
        "bidSize": "Size of the bid (number of shares at the bid price).",
        "askSize": "Size of the ask (number of shares at the ask price).",
        "optVol": "Options trading volume.",
        "stockVol": "Stock trading volume.",
        "ivx7": "7-day implied volatility.",
        "ivx14": "14-day implied volatility.",
        "ivx21": "21-day implied volatility.",
        "ivx30": "30-day implied volatility.",
        "ivx60": "60-day implied volatility.",
        "ivx90": "90-day implied volatility.",
        "ivx120": "120-day implied volatility.",
        "ivx150": "150-day implied volatility.",
        "ivx180": "180-day implied volatility.",
        "ivx270": "270-day implied volatility.",
        "ivx360": "360-day implied volatility.",
        "ivx720": "720-day implied volatility.",
        "ivx1080": "1080-day implied volatility.",
        "ivx7Chg": "Change in 7-day implied volatility.",
        "ivx30ChgPercent": "Percentage change in 30-day implied volatility.",
        "high": "Highest price for the day.",
        "low": "Lowest price for the day.",
        "open": "Opening price.",
        "price": "Current stock price.",
        "prevClose": "Closing price from the previous day.",
        "marketCap": "Market capitalization of the company.",
        "spread": "Difference between ask and bid prices.",
        "dividendYield": "Dividend yield percentage.",
        "beta10D": "10-day beta value.",
        "betaRatio": "Ratio of 90-day beta to 30-day beta.",
        "earnings_yield": "Earnings yield as a percentage."
    },
    "OptionsMonitor": {
        "call_change_eod": "Change in call option price at end-of-day.",
        "call_ivbid": "Implied volatility at the bid price of the call option.",
        "call_ivask": "Implied volatility at the ask price of the call option.",
        "call_iv_eod": "End-of-day implied volatility for call options.",
        "call_delta_eod": "End-of-day delta for call options.",
        "put_iv": "Implied volatility for put options.",
        "put_delta_eod": "End-of-day delta for put options.",
        "call_bid": "Bid price for call options.",
        "call_ask": "Ask price for call options.",
        "strike": "Strike price of the option.",
        "expirationdate": "Expiration date of the option.",
        "put_gamma": "Gamma value for put options.",
        "put_rho": "Rho value for put options.",
        "put_openinterest_eod": "Open interest for put options at end-of-day."
    },
    "OICOptionsMonitor": {
        "call_changepercent_eod": "Percentage change in call option price at end-of-day.",
        "call_iv": "Implied volatility of the call option.",
        "call_rho": "Rho value for the call option.",
        "call_forwardprice": "Forward price for the call option.",
        "call_gamma": "Gamma value for the call option.",
        "put_bid": "Bid price for the put option.",
        "put_alpha": "Alpha value for the put option."
    },
    "ProbabilityMetrics": {
        "style": "Option style (e.g., American, European).",
        "price": "Current price of the underlying stock.",
        "priceStrike": "Strike price of the option.",
        "expDate": "Expiration date of the option.",
        "daysToExp": "Days remaining until the option expires.",
        "rate": "Risk-free rate used for option pricing.",
        "lastDividendDate": "Date of the last dividend payment.",
        "lastDividendAmount": "Amount of the last dividend.",
        "dividendFrequency": "Frequency of dividend payments."
    },
    "ExpiryDates": {
        "expDate": "Expiration date of an instrument.",
        "daysToExp": "Days remaining until expiration.",
        "hours": "Hours remaining until expiration.",
        "minutes": "Minutes remaining until expiration."
    },
    "VolaSnapshot": {
        "date": "Date of the volatility snapshot.",
        "stock_id": "ID of the stock.",
        "hv10": "10-day historical volatility.",
        "hv20": "20-day historical volatility.",
        "hv30": "30-day historical volatility.",
        "hv60": "60-day historical volatility.",
        "hv90": "90-day historical volatility.",
        "hv120": "120-day historical volatility.",
        "hv150": "150-day historical volatility.",
        "hv180": "180-day historical volatility."
    },
    "AllCompBoundVola": {
        "max_value_1": "Maximum value of the first volatility component.",
        "min_value_1": "Minimum value of the first volatility component.",
        "max_value_date_1": "Date of the maximum value of the first component.",
        "min_value_date_1": "Date of the minimum value of the first component.",
        "max_value_2": "Maximum value of the second volatility component.",
        "min_value_2": "Minimum value of the second volatility component.",
        "max_value_date_2": "Date of the maximum value of the second component.",
        "min_value_date_2": "Date of the minimum value of the second component."
    },
    "HistoricIVX": {
        "hv20": "20-day historical volatility.",
        "ivx30": "30-day implied volatility.",
        "date": "Date of the volatility snapshot."
    },
    "VolatilityScale": {
        "date": "Trade date for the data.",
        "price": "Price of the underlying asset.",
        "volume": "Trading volume for the asset."
    },
    "AuctionResult": {
        "auctionStatus": "Status of the auction (e.g., active, closed).",
        "operationId": "Unique identifier for the auction operation.",
        "operationDate": "Date of the auction operation.",
        "operationType": "Type of auction operation (e.g., primary, secondary).",
        "operationDirection": "Direction of the operation (e.g., purchase, sale).",
        "method": "Auction method used.",
        "releaseTime": "Time when the auction was released.",
        "closeTime": "Time when the auction was closed.",
        "classType": "Classification type of the auction.",
        "note": "Additional notes or remarks related to the auction.",
        "totalSubmittedOrigFace": "Total original face value submitted.",
        "totalAcceptedOrigFace": "Total original face value accepted.",
        "totalSubmittedCurrFace": "Total current face value submitted.",
        "totalAcceptedCurrFace": "Total current face value accepted.",
        "totalAmtSubmittedPar": "Total par amount submitted.",
        "totalAmtAcceptedPar": "Total par amount accepted.",
        "settlementDate": "Settlement date for the auction.",
        "lastUpdated": "Last updated timestamp for the auction."
    },
    "FXSwaps": {
        "operationType": "Type of FX swap operation (e.g., forward, spot).",
        "counterparty": "Counterparty involved in the FX swap.",
        "currency": "Currency used in the FX swap operation.",
        "tradeDate": "Date of the trade.",
        "settlementDate": "Settlement date for the FX swap.",
        "maturityDate": "Maturity date of the FX swap.",
        "termInDays": "Term of the FX swap in days.",
        "amount": "Amount involved in the FX swap.",
        "interestRate": "Interest rate applied to the FX swap.",
        "isSmallValue": "Indicator if the transaction is of small value.",
        "lastUpdated": "Last updated timestamp for the FX swap."
    },
    "TimeSeries": {
        "seriesbreak": "Indicator of a break in the time series.",
        "keyid": "Unique identifier for the time series.",
        "description": "Description of the time series."
    },
    "TimeSeriesData": {
        "asofdate": "Date as of which the time series value is recorded.",
        "keyid": "Key ID associated with the time series data.",
        "value": "Value recorded in the time series."
    },
    "AsOfDates": {
        "seriesbreak": "Indicator of a break in the time series.",
        "asof": "Date as of which the series is recorded."
    },
    "SecuredReferenceRates": {
        "effectiveDate": "Effective date of the reference rate.",
        "rate_type": "Type of the rate (e.g., secured, unsecured).",
        "average30day": "30-day average of the rate.",
        "average90day": "90-day average of the rate.",
        "average180day": "180-day average of the rate.",
        "index": "Index value associated with the rate.",
        "revisionIndicator": "Indicator if the rate was revised.",
        "percent": "Current percentage rate.",
        "percentPercentile1": "1st percentile of the rate.",
        "percentPercentile25": "25th percentile of the rate.",
        "percentPercentile75": "75th percentile of the rate.",
        "percentPercentile99": "99th percentile of the rate.",
        "TargetRateFrom": "Starting target rate.",
        "TargetRateTo": "Ending target rate.",
        "VolumeInBillions": "Volume traded in billions.",
        "FootNoteID": "Footnote identifier associated with the rate."
    },
    "RepoOperations": {
        "operationId": "Unique identifier for the repo operation.",
        "auctionStatus": "Status of the repo auction.",
        "operationDate": "Date of the repo operation.",
        "settlementDate": "Settlement date for the repo operation.",
        "maturityDate": "Maturity date of the repo operation.",
        "operationType": "Type of repo operation (e.g., overnight, term).",
        "operationMethod": "Method of operation (e.g., auction, fixed).",
        "settlementType": "Type of settlement (e.g., delivery versus payment).",
        "termCalenderDays": "Term of the repo in calendar days.",
        "term": "Term of the repo operation.",
        "releaseTime": "Time of release for the operation.",
        "closeTime": "Time of close for the operation.",
        "note": "Additional remarks related to the repo operation.",
        "lastUpdated": "Timestamp for the last update to the repo operation.",
        "participatingCpty": "Counterparties participating in the repo auction.",
        "acceptedCpty": "Counterparties accepted in the repo auction.",
        "totalAmtSubmitted": "Total amount submitted in the repo auction.",
        "totalAmtAccepted": "Total amount accepted in the repo auction.",
        "Details": {
            "securityType": "Type of security used in the repo.",
            "amtSubmitted": "Amount submitted for the security.",
            "amtAccepted": "Amount accepted for the security.",
            "minimumBidRate": "Minimum bid rate for the security.",
            "percentHighRate": "Highest percentage rate for the security.",
            "percentLowRate": "Lowest percentage rate for the security.",
            "percentStopOutRate": "Stop-out rate percentage for the security.",
            "percentWeightedAverageRat": "Weighted average rate percentage for the security."
        }
    },
    "SecuritiesLending": {
        "operationId": "Unique identifier for the securities lending operation.",
        "auctionStatus": "Status of the securities lending auction.",
        "operationType": "Type of securities lending operation.",
        "operationDate": "Date of the securities lending operation.",
        "settlementDate": "Settlement date for the securities lending operation.",
        "maturityDate": "Maturity date of the securities lending operation.",
        "releaseTime": "Time when the securities lending operation was released.",
        "closeTime": "Time when the securities lending operation was closed.",
        "note": "Additional notes or remarks related to the securities lending operation.",
        "lastUpdated": "Last updated timestamp for the securities lending operation.",
        "totalParAmtSubmitted": "Total par amount submitted in the securities lending operation.",
        "totalParAmtAccepted": "Total par amount accepted in the securities lending operation."
    },
    "Gex": {
        "timestamp": "Timestamp of the GEX data.",
        "ticker": "Ticker symbol associated with the data.",
        "spot": "Current spot price of the security.",
        "zero_gamma": "The zero gamma level for the security.",
        "major_pos_vol": "Volume of major positive gamma positions.",
        "major_pos_oi": "Open interest of major positive gamma positions.",
        "major_neg_vol": "Volume of major negative gamma positions.",
        "major_neg_oi": "Open interest of major negative gamma positions.",
        "sum_gex_vol": "Summation of GEX volumes.",
        "sum_gex_oi": "Summation of GEX open interests.",
        "delta_risk_reversal": "Delta risk reversal metric.",
        "max_priors": "Maximum priors in the data."
    },
    "GexMajorLevels": {
        "timestamp": "Original timestamp from the data.",
        "eastern_timestamp": "Converted timestamp in Eastern Time (ET).",
        "ticker": "Ticker symbol associated with the data.",
        "spot": "Current spot price of the security.",
        "mpos_vol": "Volume of major positive gamma levels.",
        "mneg_vol": "Volume of major negative gamma levels.",
        "mpos_oi": "Open interest of major positive gamma levels.",
        "mneg_oi": "Open interest of major negative gamma levels.",
        "zero_gamma": "The zero gamma level for the security.",
        "net_gex_vol": "Net gamma exposure volume.",
        "net_gex_oi": "Net gamma exposure open interest."
    },
    "MaxGex": {
        "timestamp": "Timestamp of the Max GEX data.",
        "ticker": "Ticker symbol associated with the Max GEX data.",
        "current": "Current GEX level.",
        "one": "GEX level one strike away.",
        "five": "GEX level five strikes away.",
        "ten": "GEX level ten strikes away.",
        "fifteen": "GEX level fifteen strikes away.",
        "thirty": "GEX level thirty strikes away."
    },
        "HistoricOptions": {
        "contractID": "Unique identifier for the option contract.",
        "symbol": "Symbol associated with the option.",
        "expiration": "Expiration date of the option.",
        "strike": "Strike price of the option.",
        "type": "Type of the option (call or put).",
        "last": "Last traded price of the option.",
        "mark": "Mark price of the option.",
        "bid": "Bid price of the option.",
        "bid_size": "Size of the bid.",
        "ask": "Ask price of the option.",
        "ask_size": "Size of the ask.",
        "volume": "Trading volume of the option.",
        "open_interest": "Open interest of the option.",
        "date": "Date associated with the option data.",
        "implied_volatility": "Implied volatility of the option.",
        "delta": "Delta value of the option.",
        "gamma": "Gamma value of the option.",
        "theta": "Theta value of the option.",
        "vega": "Vega value of the option.",
        "rho": "Rho value of the option."
    },
    "NewsSentiments": {
        "title": "Title of the news article.",
        "url": "URL of the news article.",
        "time_published": "Publication time of the news article.",
        "authors": "List of authors of the news article.",
        "summary": "Summary of the news article.",
        "banner_image": "URL of the banner image associated with the news article.",
        "source": "Source of the news article.",
        "category_within_source": "Category of the news within its source.",
        "source_domain": "Domain of the news source.",
        "topic": "Topic of the news article.",
        "relevance": "Relevance score of the topic.",
        "overall_sentiment_score": "Overall sentiment score of the news article.",
        "overall_sentiment_label": "Sentiment label of the news article (e.g., positive, negative).",
        "ticker": "Ticker symbol mentioned in the article.",
        "relevance_score": "Relevance score of the ticker in the article.",
        "ticker_sentiment_score": "Sentiment score associated with the ticker.",
        "ticker_sentiment_label": "Sentiment label associated with the ticker."
    },
    "InsiderTransactions": {
        "transaction_date": "Date of the insider transaction.",
        "ticker": "Ticker symbol of the company involved in the transaction.",
        "executive": "Name of the executive involved in the transaction.",
        "executive_title": "Title of the executive.",
        "security_type": "Type of security involved in the transaction.",
        "acquisition_or_disposal": "Whether the transaction was an acquisition or disposal.",
        "shares": "Number of shares involved in the transaction.",
        "share_price": "Price per share at which the transaction occurred."
    },
    "SpyData": {
        "quoteDate": "Date of the quote data.",
        "pOpen": "Pre-open price of SPY.",
        "high": "Highest price of SPY for the day.",
        "low": "Lowest price of SPY for the day.",
        "pClose": "Pre-close price of SPY.",
        "volume": "Trading volume for SPY.",
        "advance": "Number of advancing stocks.",
        "decline": "Number of declining stocks.",
        "upVol": "Volume of advancing stocks.",
        "downVol": "Volume of declining stocks.",
        "upMoney": "Amount of money flowing into advancing stocks.",
        "downMoney": "Amount of money flowing out of declining stocks.",
        "rollingEPS": "Rolling earnings per share.",
        "sentiment": "Overall sentiment data.",
        "na": "Net advancements.",
        "ai": "Aggregate indicator.",
        "netSentRatio": "Net sentiment ratio.",
        "netBuyRatio": "Net buy ratio.",
        "peakTroughShorts": "Peak and trough shorts data.",
        "avg20Day": "20-day moving average of SPY data.",
        "targetRatio": "Target ratio metric."
    },
    "TopSentimentHeatmap": {
        "ticker": "Ticker symbol of the company.",
        "total": "Total sentiment mentions.",
        "avg_sentiment": "Average sentiment score for the ticker.",
        "company": "Company name.",
        "next_eps_date": "Next expected earnings report date.",
        "release_time": "Earnings release time.",
        "confirm_date": "Confirmation date of the earnings report.",
        "sentiment": "Overall sentiment for the company."
    },
    "UpcomingRussellAndSectors": {
        "earningsDate": "Date of the upcoming earnings report.",
        "epsGrowth": "Expected EPS growth.",
        "maxDate": "Maximum expected date.",
        "revGrowth": "Expected revenue growth.",
        "secID": "Sector ID.",
        "sector": "Sector name.",
        "sectorName": "Full name of the sector.",
        "surprise": "Earnings surprise data.",
        "total": "Total records for the sector.",
        "week": "Week associated with the data."
    },
    "DatedChartData": {
        "quoteDate": "Date of the quote data.",
        "ticker": "Ticker symbol.",
        "name": "Name of the company or asset.",
        "pClose": "Previous close price.",
        "pOpen": "Previous open price.",
        "high": "Highest price of the day.",
        "low": "Lowest price of the day.",
        "volume": "Trading volume.",
        "fwdEPS": "Forward earnings per share.",
        "arrow": "Indicator arrow for movement direction.",
        "shortShares": "Number of shares sold short.",
        "sentiment": "Overall sentiment for the data.",
        "ewUserNo": "User number for earnings watch.",
        "traderStatus": "Status of the trader sentiment.",
        "investorStatus": "Status of the investor sentiment.",
        "epsOpenDate": "Earnings per share open date.",
        "avwap": "Aggregate volume-weighted average price."
    },
    "Messages": {
        "artDate": "Date of the article or message.",
        "artNo": "Article number or unique ID.",
        "artType": "Type of the article or message.",
        "imageName": "Name of the image associated with the article.",
        "summary": "Summary of the article or message.",
        "tickers": "List of ticker symbols mentioned in the article.",
        "title": "Title of the article or message."
    },
    "Pivots": {
        "ticker": "Ticker symbol of the company.",
        "company": "Company name.",
        "listType": "Type of list the ticker belongs to.",
        "lastTrade": "Last traded price.",
        "pivot_point": "Pivot point value.",
        "resistance_1": "First resistance level.",
        "support_1": "First support level.",
        "resistance_2": "Second resistance level.",
        "support_2": "Second support level.",
        "resistance_3": "Third resistance level.",
        "support_3": "Third support level."
    },
    "TodaysResults": {
        "earningsGrowth": "Earnings growth percentage.",
        "earningsSurprise": "Earnings surprise data.",
        "eps": "Earnings per share.",
        "epsDate": "Date of the earnings report.",
        "estimate": "Earnings estimate.",
        "ewGrade": "Earnings watch grade.",
        "fileName": "File name associated with the data.",
        "highEstimate": "High estimate for earnings or revenue.",
        "lowEstimate": "Low estimate for earnings or revenue.",
        "name": "Name of the company.",
        "prevEarningsGrowth": "Previous earnings growth percentage.",
        "prevRevenueGrowth": "Previous revenue growth percentage.",
        "pwrRating": "Power rating of the company.",
        "quarter": "Quarter of the earnings report.",
        "revenue": "Reported revenue.",
        "revenueEstimate": "Estimated revenue.",
        "revenueGrowth": "Revenue growth percentage.",
        "revenueSurprise": "Revenue surprise data.",
        "subject": "Subject or category of the data.",
        "summary": "Summary of the results.",
        "ticker": "Ticker symbol of the company.",
        "whisper": "Whisper number or unofficial estimate."
    },
    "CalData": {
        "company": "Name of the company.",
        "confirmDate": "Date of confirmation for earnings.",
        "epsTime": "Time of earnings per share report.",
        "nextEPSDate": "Next expected earnings per share report date.",
        "q1EstEPS": "Estimated Q1 earnings per share.",
        "q1RevEst": "Estimated Q1 revenue.",
        "qDate": "Quarterly date.",
        "qSales": "Quarterly sales.",
        "quarterDate": "Date of the quarter.",
        "releaseTime": "Time of the earnings release.",
        "ticker": "Ticker symbol of the company.",
        "total": "Total records or data points."
    },
    "ChartData": {
        "quoteDate": "Date of the quote data.",
        "ticker": "Ticker symbol of the company or asset.",
        "name": "Name of the company or asset.",
        "pClose": "Previous close price.",
        "pOpen": "Previous open price.",
        "high": "Highest price of the day.",
        "low": "Lowest price of the day.",
        "volume": "Trading volume.",
        "eps_date": "Earnings per share report date.",
        "vwap": "Volume-weighted average price."
    },
    "TickerATS": {
        "total_weekly_share_quantity": "Total number of shares traded weekly.",
        "issue_symbol_identifier": "Ticker symbol or identifier of the issue.",
        "issue_name": "Name of the issue or security.",
        "last_update_date": "Date of the last update to the data.",
        "last_reported_date": "Date when the data was last reported.",
        "tier_description": "Description of the trading tier for the issue.",
        "initial_published_date": "Date when the data was first published.",
        "tier_identifier": "Identifier for the trading tier.",
        "summary_start_date": "Start date for the summary period.",
        "total_notional_sum": "Total notional value of the trades for the week.",
        "total_weekly_trade_count": "Total number of trades executed weekly.",
        "week_start_date": "Start date of the trading week.",
        "mpid": "Market Participant Identifier (MPID).",
        "firm_crd_number": "Firm's Central Registration Depository (CRD) number.",
        "product_type_code": "Code representing the type of product traded.",
        "market_participant_name": "Name of the market participant or firm.",
        "summary_type_code": "Code representing the type of summary."
    },
    "Applications": {
        "id": "Unique identifier for the application.",
        "name": "Name of the application.",
        "description": "Description of the application.",
        "icon": "Icon URL or identifier for the application.",
        "username": "Username of the bot associated with the application.",
        "discriminator": "Discriminator (user tag) for the bot.",
        "bot": "Indicator if the user is a bot.",
        "public_flags": "Public flags associated with the bot.",
        "flags": "Flags associated with the bot.",
        "global_name": "Global name of the bot.",
        "avatar": "Avatar URL or identifier for the bot.",
        "accent_color": "Accent color used by the bot.",
        "avatar_decoration_data": "Avatar decoration data for the bot.",
        "banner": "Banner URL or identifier for the bot.",
        "banner_color": "Banner color used by the bot."
    },
    "ApplicationCommands": {
        "id": "Unique identifier for the command.",
        "type": "Type of command (e.g., slash, context menu).",
        "application_id": "Identifier for the application associated with the command.",
        "version": "Version of the command.",
        "name": "Name of the command.",
        "description": "Description of the command.",
        "integration_types": "Integration types associated with the command.",
        "option_name": "Name of the option in the command.",
        "option_desc": "Description of the option in the command.",
        "autocomplete": "Indicates if the option supports autocomplete.",
        "required": "Indicates if the option is required."
    },
    "FUDSTOPBotCommands": {
        "id": "Unique identifier for the bot command.",
        "application_id": "Application ID associated with the bot command.",
        "version": "Version of the bot command.",
        "default_member_permissions": "Default permissions required by the command for members.",
        "type": "Type of command (e.g., chat input, user command).",
        "nsfw": "Indicates if the command is marked as NSFW (Not Safe For Work).",
        "name": "Name of the command.",
        "description": "Description of the command.",
        "dm_permission": "Indicates if the command is allowed in direct messages.",
        "options": "Flattened string of the command options, including type, name, and description."
    },
    "OICOptionsMonitor": {
        "call_change_eod": "End-of-day change in call option price.",
        "call_ivbid": "Implied volatility of call options at the bid price.",
        "call_iv_eod": "End-of-day implied volatility for call options.",
        "put_theta_eod": "End-of-day theta value for put options.",
        "call_ivask": "Implied volatility of call options at the ask price.",
        "call_days": "Days remaining until the call option expires.",
        "call_mean_eod": "Mean value of call options at end-of-day.",
        "call_ivint": "Implied volatility for call options (interpolated).",
        "put_asksize": "Size of the ask for put options.",
        "call_delta_eod": "End-of-day delta value for call options.",
        "call_bid_eod": "End-of-day bid price for call options.",
        "call_theoprice_eod": "End-of-day theoretical price for call options.",
        "put_iv": "Implied volatility for put options.",
        "call_ivint_eod": "End-of-day interpolated implied volatility for call options.",
        "call_ask_eod": "End-of-day ask price for call options.",
        "call_iv": "Implied volatility for call options.",
        "put_days": "Days remaining until the put option expires.",
        "put_iv_eod": "End-of-day implied volatility for put options.",
        "call_volume_eod": "End-of-day trading volume for call options.",
        "put_change_eod": "End-of-day change in put option price.",
        "call_ask": "Ask price for call options.",
        "call_bidtime": "Timestamp of the last bid for call options.",
        "call_rho": "Rho value for call options.",
        "call_forwardprice_eod": "End-of-day forward price for call options.",
        "call_mean": "Mean value of call options.",
        "put_bid_eod": "End-of-day bid price for put options.",
        "call_bid": "Bid price for call options.",
        "call_volume": "Trading volume for call options.",
        "call_alpha": "Alpha value for call options.",
        "call_vega": "Vega value for call options.",
        "put_bidtime": "Timestamp of the last bid for put options.",
        "put_theta": "Theta value for put options.",
        "put_optionsymbol": "Option symbol for put options.",
        "put_ivask": "Implied volatility of put options at the ask price.",
        "put_changepercent_eod": "End-of-day percentage change in put option price.",
        "put_ask": "Ask price for put options.",
        "put_rho": "Rho value for put options.",
        "call_openinterest_eod": "End-of-day open interest for call options.",
        "put_ivint": "Implied volatility for put options (interpolated).",
        "put_theoprice": "Theoretical price for put options.",
        "call_asktime": "Timestamp of the last ask for call options.",
        "put_bid": "Bid price for put options.",
        "call_gamma_eod": "End-of-day gamma value for call options.",
        "put_ask_eod": "End-of-day ask price for put options.",
        "call_optionsymbol": "Option symbol for call options.",
        "put_paramvolapercent_eod": "End-of-day parametric volatility percentage for put options.",
        "call_asksize": "Size of the ask for call options.",
        "put_volume": "Trading volume for put options.",
        "call_alpha_eod": "End-of-day alpha value for call options.",
        "put_volume_eod": "End-of-day trading volume for put options.",
        "put_ivbid": "Implied volatility of put options at the bid price.",
        "call_pos": "Position size for call options.",
        "put_delta_eod": "End-of-day delta value for put options.",
        "put_changepercent": "Percentage change in put option price.",
        "put_mean_eod": "End-of-day mean value for put options.",
        "call_changepercent": "Percentage change in call option price.",
        "put_asktime": "Timestamp of the last ask for put options.",
        "put_pos": "Position size for put options.",
        "put_theoprice_eod": "End-of-day theoretical price for put options.",
        "put_gamma": "Gamma value for put options.",
        "call_days_eod": "End-of-day remaining days for call options.",
        "call_bidsize": "Size of the bid for call options.",
        "call_delta": "Delta value for call options.",
        "put_change": "Change in put option price.",
        "call_paramvolapercent_eod": "End-of-day parametric volatility percentage for call options.",
        "call_theta_eod": "End-of-day theta value for call options.",
        "call_change": "Change in call option price.",
        "put_ivint_eod": "End-of-day interpolated implied volatility for put options.",
        "call_theta": "Theta value for call options.",
        "put_vega": "Vega value for put options.",
        "put_days_eod": "End-of-day remaining days for put options.",
        "put_forwardprice": "Forward price for put options.",
        "call_rho_eod": "End-of-day rho value for call options.",
        "quotetime": "Timestamp of the last quote for options.",
        "put_vega_eod": "End-of-day vega value for put options.",
        "strike": "Strike price of the options.",
        "put_mean": "Mean value for put options.",
        "put_forwardprice_eod": "End-of-day forward price for put options.",
        "expirationdate": "Expiration date of the options.",
        "call_forwardprice": "Forward price for call options.",
        "call_gamma": "Gamma value for call options.",
        "put_alpha_eod": "End-of-day alpha value for put options.",
        "put_delta": "Delta value for put options.",
        "put_openinterest_eod": "End-of-day open interest for put options.",
        "call_changepercent_eod": "End-of-day percentage change in call option price.",
        "put_gamma_eod": "End-of-day gamma value for put options.",
        "put_bidsize": "Size of the bid for put options.",
        "call_vega_eod": "End-of-day vega value for call options.",
        "put_rho_eod": "End-of-day rho value for put options.",
        "put_alpha": "Alpha value for put options.",
        "call_theoprice": "Theoretical price for call options."
    },
    "Aggregates": {
        "ticker": "Ticker symbol for the aggregated data.",
        "volume": "Trading volume for the aggregate period.",
        "vwap": "Volume-weighted average price for the period.",
        "open": "Opening price for the aggregate period.",
        "close": "Closing price for the aggregate period.",
        "high": "Highest price for the aggregate period.",
        "low": "Lowest price for the aggregate period.",
        "timestamp": "Timestamp of the aggregate data (converted to Eastern Time).",
        "num_trades": "Number of trades during the aggregate period.",
        "dollar_cost": "Dollar cost (calculated as volume × VWAP)."
    },
    "CompanyResults": {
        "ticker": "Ticker symbol of the company.",
        "name": "Name of the company.",
        "market": "Market where the company is listed.",
        "locale": "Locale or region of the company.",
        "primary_exchange": "Primary exchange where the company is listed.",
        "type": "Type of security (e.g., common stock, ETF).",
        "active": "Indicates if the company is actively trading.",
        "currency_name": "Currency in which the company trades.",
        "cik": "Central Index Key (CIK) for the company.",
        "composite_figi": "Composite Financial Instrument Global Identifier.",
        "share_class_figi": "FIGI for the share class.",
        "market_cap": "Market capitalization of the company.",
        "phone_number": "Contact phone number of the company.",
        "address": "Address of the company.",
        "city": "City where the company is located.",
        "state": "State where the company is located.",
        "zip": "ZIP or postal code of the company.",
        "description": "Description of the company.",
        "sic_code": "Standard Industrial Classification code.",
        "sic_description": "Description of the SIC code.",
        "ticker_root": "Root ticker symbol for the company.",
        "homepage_url": "Homepage URL of the company.",
        "total_employees": "Total number of employees.",
        "list_date": "Date the company was listed.",
        "icon_url": "URL of the company icon.",
        "logo_url": "URL of the company logo.",
        "share_class_shares_outstanding": "Number of shares outstanding for the share class.",
        "weighted_shares_outstanding": "Weighted shares outstanding.",
        "round_lot": "Round lot size for trading."
    },
   "DailyOpenClose": {
        "ah": "After-hours trading price.",
        "pm": "Pre-market trading price.",
        "close": "Closing price of the asset.",
        "low": "Lowest price of the asset during the day.",
        "high": "Highest price of the asset during the day.",
        "open": "Opening price of the asset.",
        "date": "Date of the daily data.",
        "symbol": "Option or stock symbol.",
        "ticker": "Underlying ticker symbol for the option.",
        "strike": "Strike price for the option.",
        "expiry": "Expiration date for the option.",
        "call_put": "Indicates if the option is a call or put.",
        "volume": "Trading volume for the day."
    },
    "GainersLosers": {
        "ticker": "Ticker symbol of the asset.",
        "todaysChangePerc": "Percentage change in price for the day.",
        "todaysChange": "Change in price for the day.",
        "updated": "Timestamp of the last update.",
        "day_open": "Opening price for the day.",
        "day_high": "Highest price for the day.",
        "day_low": "Lowest price for the day.",
        "day_close": "Closing price for the day.",
        "day_vol": "Trading volume for the day.",
        "day_vwap": "VWAP for the day.",
        "ask": "Ask price for the asset.",
        "ask_size": "Size of the ask.",
        "bid": "Bid price for the asset.",
        "bid_size": "Size of the bid.",
        "quote_timestamp": "Timestamp of the last quote.",
        "conditions": "Conditions of the last trade.",
        "trade_id": "Trade ID for the last trade.",
        "trade_price": "Price of the last trade.",
        "trade_size": "Size of the last trade.",
        "trade_timestamp": "Timestamp of the last trade.",
        "trade_exchange": "Exchange where the last trade occurred.",
        "min_open": "Opening price for the minute.",
        "min_high": "Highest price for the minute.",
        "min_low": "Lowest price for the minute.",
        "min_close": "Closing price for the minute.",
        "min_vol": "Trading volume for the minute.",
        "min_vwap": "VWAP for the minute.",
        "prev_open": "Opening price for the previous day.",
        "prev_high": "Highest price for the previous day.",
        "prev_low": "Lowest price for the previous day.",
        "prev_close": "Closing price for the previous day.",
        "prev_vol": "Trading volume for the previous day.",
        "prev_vwap": "VWAP for the previous day."
    },
    "WorkingUniversal": {
        "risk_free_rate": "Risk-free rate used for calculations.",
        "break_even_price": "Break-even price for the option.",
        "change": "Change in price.",
        "change_percent": "Percentage change in price.",
        "close": "Closing price.",
        "high": "Highest price.",
        "low": "Lowest price.",
        "open": "Opening price.",
        "volume": "Trading volume.",
        "previous_close": "Previous day's closing price.",
        "contract_type": "Type of contract (call or put).",
        "exercise_style": "Exercise style (e.g., American, European).",
        "expiration_date": "Expiration date of the option.",
        "shares_per_contract": "Number of shares per contract.",
        "strike_price": "Strike price of the option.",
        "delta": "Delta value of the option.",
        "gamma": "Gamma value of the option.",
        "theta": "Theta value of the option.",
        "vega": "Vega value of the option.",
        "implied_volatility": "Implied volatility of the option.",
        "ask": "Ask price.",
        "ask_size": "Size of the ask.",
        "ask_exchange": "Exchange providing the ask.",
        "bid": "Bid price.",
        "bid_size": "Size of the bid.",
        "bid_exchange": "Exchange providing the bid.",
        "midpoint": "Midpoint price between bid and ask.",
        "sip_timestamp": "Timestamp of the last SIP trade.",
        "trade_conditions": "Conditions for the trade.",
        "trade_price": "Price of the trade.",
        "trade_size": "Size of the trade.",
        "trade_exchange": "Exchange where the trade occurred.",
        "open_interest": "Open interest in the option.",
        "underlying_price": "Price of the underlying asset.",
        "volume_oi_ratio": "Ratio of volume to open interest.",
        "intrinsic_value": "Intrinsic value of the option.",
        "extrinsic_value": "Extrinsic value of the option.",
        "premium_percent": "Premium as a percentage of the underlying price.",
        "dte": "Days to expiration.",
        "spread": "Bid-ask spread.",
        "spread_pct": "Percentage spread relative to the midpoint price.",
        "iv_skew": "Implied volatility skew (call/put skew).",
        "avg_iv": "Average implied volatility."
    },
    "Entries": {
        "title": "Title of the entry.",
        "type": "Type of the entry title detail.",
        "base": "Base URL for the title detail.",
        "value": "Value of the title detail.",
        "link": "Primary link associated with the entry.",
        "id": "Unique identifier for the entry.",
        "summary": "Summary of the entry.",
        "summary_type": "Type of the summary detail.",
        "summary_base": "Base URL for the summary detail.",
        "summary_value": "Value of the summary detail.",
        "published": "Published date of the entry.",
        "company_name": "Company name associated with the entry.",
        "form_type": "Form type (e.g., 10-K, 8-K).",
        "filingdate": "Filing date of the document.",
        "cik_number": "Central Index Key (CIK) of the company.",
        "accession_number": "Accession number of the filing.",
        "file_number": "File number of the filing.",
        "acceptance_datetime": "Acceptance date and time of the filing.",
        "period": "Reporting period for the filing.",
        "assistant_director": "Assistant director overseeing the filing.",
        "assigned_sic": "Assigned Standard Industrial Classification (SIC) code.",
        "fiscal_yearend": "Fiscal year-end date for the company.",
        "xrbl_sequence": "Sequence number for the XBRL file.",
        "xrbl_file": "File name of the XBRL document.",
        "xrbl_type": "Type of the XBRL document.",
        "xrbl_size": "Size of the XBRL document.",
        "xrbl_description": "Description of the XBRL document.",
        "xrbl_url": "URL of the XBRL document."
    },
    "DocumentParser": {
        "seq": "Sequence number of the document.",
        "description": "Description of the document.",
        "document_link": "URL link to the document on the SEC website.",
        "type": "Type of the document (e.g., PDF, HTML).",
        "size": "Size of the document."
    },
    "FilerInfo": {
        "mailing_address": "Mailing address of the filer.",
        "business_address": "Business address of the filer.",
        "company_name": "Name of the filing company.",
        "cik": "Central Index Key (CIK) of the filer."
    },
    "Submissions": {
        "cik": "Central Index Key (CIK) of the company.",
        "entityType": "Type of entity (e.g., corporation, partnership).",
        "sic": "Standard Industrial Classification (SIC) code.",
        "sicDescription": "Description of the SIC code.",
        "ownerOrg": "Indicates if the submission is for an owner organization.",
        "insiderTransactionForOwnerExists": "Indicates if insider transactions exist for the owner.",
        "insiderTransactionForIssuerExists": "Indicates if insider transactions exist for the issuer.",
        "name": "Name of the entity making the submission.",
        "tickers": "Comma-separated list of ticker symbols associated with the submission.",
        "exchanges": "Comma-separated list of exchanges where the entity is listed.",
        "ein": "Employer Identification Number (EIN) of the entity.",
        "description": "Description of the entity.",
        "website": "Official website of the entity.",
        "investorWebsite": "Investor relations website of the entity.",
        "category": "Category or industry classification of the entity.",
        "fiscalYearEnd": "Fiscal year-end date of the entity.",
        "stateOfIncorporation": "State where the entity is incorporated.",
        "stateOfIncorporationDescription": "Description of the state of incorporation.",
        "phone": "Contact phone number of the entity.",
        "flags": "Additional flags or notes associated with the submission.",
        "files_name": "List of file names associated with the submission."
    },
    "MarketTide": {
        "date": "Date of the market data.",
        "net_call_premium": "Net premium from call options.",
        "net_put_premium": "Net premium from put options.",
        "net_volume": "Net trading volume.",
        "timestamp": "Timestamp of the data."
    },
    "AllTide": {
        "date": "Date of the market data.",
        "price": "Price of the SPY index.",
        "net_call_premium": "Net premium from call options.",
        "net_put_premium": "Net premium from put options.",
        "net_volume": "Net trading volume.",
        "timestamp": "Timestamp of the data."
    },
    "ETFFlow": {
        "avg30_call_volume": "30-day average call option volume.",
        "avg30_put_volume": "30-day average put option volume.",
        "avg30_stock_volume": "30-day average stock volume.",
        "avg_30_day_call_volume": "Alternate key for 30-day call volume.",
        "avg_30_day_put_volume": "Alternate key for 30-day put volume.",
        "avg_7_day_call_volume": "7-day average call option volume.",
        "avg_7_day_put_volume": "7-day average put option volume.",
        "bearish_premium": "Premium from bearish options.",
        "bullish_premium": "Premium from bullish options.",
        "call_premium": "Premium from call options.",
        "call_volume": "Trading volume of call options.",
        "full_name": "Full name of the ETF.",
        "high": "Highest price of the ETF for the day.",
        "last": "Last traded price of the ETF.",
        "low": "Lowest price of the ETF for the day.",
        "marketcap": "Market capitalization of the ETF.",
        "open": "Opening price of the ETF for the day.",
        "prev_close": "Previous closing price of the ETF.",
        "prev_date": "Date of the previous data point.",
        "put_premium": "Premium from put options.",
        "put_volume": "Trading volume of put options.",
        "ticker": "Ticker symbol of the ETF.",
        "volume": "Total trading volume of the ETF.",
        "week52_high": "52-week high price of the ETF.",
        "week52_low": "52-week low price of the ETF."
    },
   "TopNetPremium": {
        "net_call_prem": "Net call option premium.",
        "net_call_prem_rank": "Rank of the net call premium.",
        "net_prem_rank": "Overall rank based on net premium.",
        "net_put_prem": "Net put option premium.",
        "net_put_prem_rank": "Rank of the net put premium.",
        "ticker": "Ticker symbol of the asset."
    },
    "TopSectorPremium": {
        "net_call_prem": "Net call option premium for the sector.",
        "net_call_prem_rank": "Rank of the net call premium for the sector.",
        "net_prem_rank": "Overall premium rank for the sector.",
        "net_put_prem": "Net put option premium for the sector.",
        "net_put_prem_rank": "Rank of the net put premium for the sector.",
        "ticker": "Ticker symbol representing the sector."
    },
    "DarkPools": {
        "avg30_volume": "30-day average volume for dark pool trades.",
        "canceled": "Indicates if the trade was canceled.",
        "created_at": "Timestamp when the trade was created.",
        "executed_at": "Timestamp when the trade was executed.",
        "ext_hour_sold_codes": "Extended hours sale codes.",
        "issue_type": "Type of the issue being traded.",
        "market_center": "Market center where the trade occurred.",
        "nbbo_ask": "National Best Bid and Offer (NBBO) ask price.",
        "nbbo_ask_quantity": "Quantity available at the NBBO ask price.",
        "nbbo_bid": "NBBO bid price.",
        "nbbo_bid_quantity": "Quantity available at the NBBO bid price.",
        "premium": "Premium associated with the trade.",
        "price": "Price of the trade.",
        "sale_cond_codes": "Sale condition codes for the trade.",
        "sector": "Sector associated with the trade.",
        "size": "Size of the trade.",
        "ticker": "Ticker symbol of the traded asset.",
        "tracking_id": "Unique tracking ID for the trade.",
        "trade_code": "Code representing the type of trade.",
        "trade_settlement": "Settlement information for the trade.",
        "volume": "Volume traded."
    },
    "TickerAggregates": {
        "call_amount_ask_side": "Call option amount on the ask side.",
        "call_amount_bid_side": "Call option amount on the bid side.",
        "call_premium": "Premium from call options.",
        "call_premium_ask_side": "Call option premium on the ask side.",
        "call_premium_bid_side": "Call option premium on the bid side.",
        "call_volume": "Volume of call options traded.",
        "call_volume_ask_side": "Call option volume on the ask side.",
        "call_volume_bid_side": "Call option volume on the bid side.",
        "date": "Date of the data.",
        "put_amount_ask_side": "Put option amount on the ask side.",
        "put_amount_bid_side": "Put option amount on the bid side.",
        "put_premium": "Premium from put options.",
        "put_premium_ask_side": "Put option premium on the ask side.",
        "put_premium_bid_side": "Put option premium on the bid side.",
        "put_volume": "Volume of put options traded.",
        "put_volume_ask_side": "Put option volume on the ask side.",
        "put_volume_bid_side": "Put option volume on the bid side.",
        "ticker_symbol": "Ticker symbol of the asset."
    },
    "AnalystResults": {
        "firm_name": "Name of the analyst's firm.",
        "total_recommendations": "Total number of recommendations made by the analyst.",
        "expert_uid": "Unique identifier for the analyst.",
        "analyst_name": "Name of the analyst.",
        "success_rate": "Success rate of the analyst's recommendations.",
        "stock_price": "Current stock price.",
        "added_on_timestamp": "Timestamp when the analyst's recommendation was added.",
        "analyst_rank": "Rank of the analyst.",
        "timestamp": "Timestamp of the analyst's data.",
        "sector": "Sector associated with the analyst's recommendation.",
        "url": "URL of the analyst's recommendation article.",
        "article_site": "Source website of the article.",
        "stock_ticker": "Ticker symbol of the stock.",
        "company_name": "Name of the company associated with the recommendation.",
        "action": "Recommended action (e.g., buy, sell).",
        "number_of_ranked_experts": "Number of experts ranked in this category.",
        "created_at": "Timestamp when the recommendation was created.",
        "recommendation_date": "Date of the recommendation.",
        "operation_id": "Operation ID for the recommendation.",
        "id": "Unique ID for the recommendation.",
        "article_title": "Title of the recommendation article.",
        "converted_price_target": "Converted price target for the stock.",
        "full_name": "Full name of the analyst.",
        "curr_stock_price": "Current stock price of the company.",
        "marketcap": "Market capitalization of the company.",
        "num_of_stars": "Number of stars awarded to the recommendation.",
        "quote": "Quote from the analyst.",
        "recommendation": "Analyst's recommendation.",
        "expert_picture_url": "URL of the analyst's picture.",
        "unique_operation_id": "Unique operation ID for the recommendation.",
        "price_target": "Price target set by the analyst.",
        "excess_return": "Excess return from the recommendation.",
        "good_recommendations": "Number of good recommendations made by the analyst."
    },
    "MarketState": {
        "avg_30_day_call_oi": "30-day average open interest for call options.",
        "avg_30_day_call_volume": "30-day average call option volume.",
        "avg_30_day_put_oi": "30-day average open interest for put options.",
        "avg_30_day_put_volume": "30-day average put option volume.",
        "avg_3_day_call_volume": "3-day average call option volume.",
        "avg_3_day_put_volume": "3-day average put option volume.",
        "avg_7_day_call_volume": "7-day average call option volume.",
        "avg_7_day_put_volume": "7-day average put option volume.",
        "bearish_premium": "Premium from bearish trades.",
        "bullish_premium": "Premium from bullish trades.",
        "call_open_interest": "Open interest for call options.",
        "call_premium": "Premium from call options.",
        "call_volume": "Volume of call options traded.",
        "call_volume_ask_side": "Call option volume on the ask side.",
        "call_volume_bid_side": "Call option volume on the bid side.",
        "close": "Closing price of the market.",
        "date": "Date of the market data.",
        "implied_move": "Implied market move.",
        "implied_move_perc": "Percentage of implied market move.",
        "iv_rank": "Implied volatility rank.",
        "net_premium": "Net premium for the market.",
        "open": "Opening price of the market.",
        "put_call_ratio": "Put-to-call ratio.",
        "put_open_interest": "Open interest for put options.",
        "put_premium": "Premium from put options.",
        "put_volume": "Volume of put options traded.",
        "put_volume_ask_side": "Put option volume on the ask side.",
        "put_volume_bid_side": "Put option volume on the bid side.",
        "ticker": "Ticker symbol of the market.",
        "total_open_interest": "Total open interest for the market.",
        "volatility": "Market volatility."
    },
    "CompanyData": {
        "annouce_time": "Announcement time of the data.",
        "year2_change_percent": "Percentage change over 2 years.",
        "week52_high": "52-week high price.",
        "day30_change_percent": "30-day percentage change.",
        "pe_ratio": "Price-to-earnings ratio.",
        "float_shares": "Number of floating shares.",
        "year1_change_percent": "Percentage change over 1 year.",
        "has_investment_arm": "Indicates if the company has an investment arm.",
        "month3_change_percent": "3-month percentage change.",
        "ttm_dividend_rate": "Trailing twelve months dividend rate.",
        "day50_moving_avg": "50-day moving average price.",
        "description": "Description of the company.",
        "beta": "Beta value of the stock.",
        "month1_change_percent": "1-month percentage change.",
        "ttm_eps": "Trailing twelve months earnings per share.",
        "week52_low": "52-week low price.",
        "symbol": "Ticker symbol of the company.",
        "max_change_percent": "Maximum percentage change.",
        "issue_type": "Type of issue (e.g., stock, bond).",
        "sector": "Sector of the company.",
        "week52_low_split_adjustonly": "52-week low adjusted for splits.",
        "avg30_volume": "30-day average trading volume.",
        "s_float": "Short float percentage.",
        "tags": "Comma-separated tags describing the company.",
        "insider_percent_ownership": "Percentage of insider ownership.",
        "avg10_volume": "10-day average trading volume.",
        "month6_change_percent": "6-month percentage change.",
        "ex_dividend_date": "Ex-dividend date for the stock.",
        "is_spac": "Indicates if the company is a SPAC.",
        "created_at": "Timestamp when the data was created.",
        "outstanding": "Number of shares outstanding.",
        "warrant_links": "Links to warrants associated with the company.",
        "id": "Unique ID of the company.",
        "next_dividend_date": "Next dividend date.",
        "week52_change": "Percentage change over 52 weeks.",
        "full_name": "Full name of the company.",
        "year5_change_percent": "Percentage change over 5 years.",
        "marketcap": "Market capitalization of the company.",
        "employees": "Number of employees in the company.",
        "ytd_change_percent": "Year-to-date percentage change.",
        "week52_high_split_adjustonly": "52-week high adjusted for splits.",
        "website": "Official website of the company.",
        "logo": "Logo URL of the company.",
        "day200_moving_avg": "200-day moving average price.",
        "industry_type": "Type of industry the company operates in.",
        "dividend_yield": "Dividend yield of the stock.",
        "day5_change_percent": "5-day percentage change.",
        "current_fiscal_period": "Current fiscal period of the company.",
        "short_int": "Short interest percentage.",
        "next_earnings_date": "Next earnings report date."
    },
    "HistoricChains": {
        "ask_volume": "Ask volume for options.",
        "avg_price": "Average price of options.",
        "bid_volume": "Bid volume for options.",
        "cross_volume": "Volume from cross trades.",
        "date": "Date of the data.",
        "floor_volume": "Volume from floor trades.",
        "high_price": "Highest price for options.",
        "implied_volatility": "Implied volatility for options.",
        "iv_high": "Highest implied volatility.",
        "iv_low": "Lowest implied volatility.",
        "last_price": "Last traded price of the option.",
        "last_tape_time": "Time of the last tape update.",
        "low_price": "Lowest price for options.",
        "mid_volume": "Midpoint volume for options.",
        "multi_leg_volume": "Volume from multi-leg trades.",
        "neutral_volume": "Volume classified as neutral.",
        "no_side_volume": "Volume with no clear side.",
        "open_interest": "Open interest for options.",
        "stock_multi_leg_volume": "Stock multi-leg trade volume.",
        "sweep_volume": "Sweep trade volume.",
        "total_premium": "Total premium from options.",
        "trades": "Number of trades.",
        "volume": "Total trading volume."
    },
    "DailyOptionBars": {
        "option_symbol": "Option symbol associated with the data.",
        "ask_volume": "Ask volume for options.",
        "bid_volume": "Bid volume for options.",
        "mid_volume": "Midpoint volume for options.",
        "no_volume": "Volume with no trades.",
        "tape_time": "Time of the tape update."
    },
        "OptionSummary": {
        "ffexern90_60": "Forward forecast implied earnings move (90-60 days).",
        "exerndlt25iv90d": "IV at 25-delta for 90-day options excluding earnings.",
        "exerndlt75iv30d": "IV at 75-delta for 30-day options excluding earnings.",
        "exerndlt75iv20d": "IV at 75-delta for 20-day options excluding earnings.",
        "exerndlt95iv10d": "IV at 95-delta for 10-day options excluding earnings.",
        "iv90d": "Implied volatility for 90-day options.",
        "exerndlt75iv6m": "IV at 75-delta for 6-month options excluding earnings.",
        "dlt25iv1y": "IV at 25-delta for 1-year options.",
        "iv30d": "Implied volatility for 30-day options.",
        "next_div": "Next dividend date implied by options."},
    "Analysis": {
        "rating": "Overall rating data for the analysis.",
        "rating_suggestion": "Suggested rating based on analysis.",
        "rating_totals": "Totals for the rating analysis.",
        "buy": "Buy recommendation count.",
        "underperform": "Underperform recommendation count.",
        "strongbuy": "Strong buy recommendation count.",
        "sell": "Sell recommendation count.",
        "hold": "Hold recommendation count."
    },
    "CapitalFlow": {
        "superLargeInflow": "Super large inflow in capital flow.",
        "superLargeOutflow": "Super large outflow in capital flow.",
        "superLargeNetFlow": "Net flow for super large capital.",
        "largeInflow": "Large inflow in capital flow.",
        "largeOutflow": "Large outflow in capital flow.",
        "largeNetFlow": "Net flow for large capital.",
        "newLargeInflow": "New large inflow in capital flow.",
        "newLargeOutflow": "New large outflow in capital flow.",
        "newLargeNetFlow": "Net flow for new large capital.",
        "mediumInflow": "Medium inflow in capital flow.",
        "mediumOutflow": "Medium outflow in capital flow.",
        "mediumNetFlow": "Net flow for medium capital.",
        "smallInflow": "Small inflow in capital flow.",
        "smallOutflow": "Small outflow in capital flow.",
        "smallNetFlow": "Net flow for small capital.",
        "majorInflow": "Major inflow in capital flow.",
        "majorOutflow": "Major outflow in capital flow.",
        "majorNetFlow": "Net flow for major capital.",
        "retailInflow": "Retail inflow in capital flow.",
        "retailOutflow": "Retail outflow in capital flow."
    },
    "CapitalFlowHistory": {
        "date": "Date of the historical data.",
        "superin": "Historical super large inflows.",
        "superout": "Historical super large outflows.",
        "supernet": "Historical super large net flows.",
        "largein": "Historical large inflows.",
        "largeout": "Historical large outflows.",
        "largenet": "Historical large net flows.",
        "mediumin": "Historical medium inflows.",
        "mediumout": "Historical medium outflows.",
        "mediumnet": "Historical medium net flows.",
        "smallin": "Historical small inflows.",
        "smallout": "Historical small outflows.",
        "smallnet": "Historical small net flows.",
        "majorin": "Historical major inflows.",
        "majorout": "Historical major outflows.",
        "majornet": "Historical major net flows.",
        "retailin": "Historical retail inflows.",
        "retailout": "Historical retail outflows."
    },
    "CostDistribution": {
        "avgCost": "Average cost for shareholders.",
        "closeProfitRatio": "Percentage of shareholders in profit.",
        "chip90Start": "Start of the 90th percentile cost distribution.",
        "chip90End": "End of the 90th percentile cost distribution.",
        "chip70Start": "Start of the 70th percentile cost distribution.",
        "chip70End": "End of the 70th percentile cost distribution.",
        "close": "Closing price of the stock.",
        "totalShares": "Total shares outstanding."
    },
    "NewCostDist": {
        "tickerId": "Ticker ID for the stock.",
        "avgCost": "Average cost of shares.",
        "closeProfitRatio": "Percentage of shareholders in profit.",
        "chip90Start": "Start of the 90th percentile distribution.",
        "chip90End": "End of the 90th percentile distribution.",
        "chip70Start": "Start of the 70th percentile distribution.",
        "chip70End": "End of the 70th percentile distribution.",
        "close": "Closing price of the stock.",
        "dates": "Trade dates."
    },
    "FinancialStatement": {
        "quote_id": "Quote ID associated with the financial statement.",
        "fiscal_year": "Fiscal year of the statement.",
        "fiscal_period": "Fiscal period of the statement.",
        "totalRevenue": "Total revenue of the company.",
        "netIncome": "Net income of the company.",
        "grossProfit": "Gross profit of the company.",
        "operatingIncome": "Operating income of the company.",
        "incomeTax": "Income tax paid by the company."
    },
    "CashFlow": {
        "cash_from_operating_activities": "Cash generated from operating activities.",
        "net_income": "Net income reported by the company.",
        "depreciation_and_amortization": "Depreciation and amortization expenses.",
        "capital_expenditures": "Capital expenditures made by the company.",
        "cash_from_investing_activities": "Cash generated from investing activities.",
        "cash_from_financing_activities": "Cash generated from financing activities.",
        "net_change_in_cash": "Net change in cash balance."
    },
    "BalanceSheet": {
        "totalAssets": "Total assets owned by the company.",
        "totalLiabilities": "Total liabilities of the company.",
        "totalEquity": "Total equity of the company.",
        "cashAndShortTermInvest": "Cash and short-term investments.",
        "accountsReceivable": "Accounts receivable balance.",
        "totalInventory": "Total inventory held by the company.",
        "totalDebt": "Total debt of the company."
    },
    "Forecast": {
        "id": "Unique identifier for the forecast.",
        "title": "Title of the forecast.",
        "currencyName": "Currency used in the forecast.",
        "points": "Forecast data points."
    },
    "ShortInterest": {
        "settlement_date": "Date when the short interest was settled.",
        "short_interest": "Number of shares sold short.",
        "average_volume": "Average daily trading volume.",
        "days_to_cover": "Number of days needed to cover all short positions."
    },
    "MultiQuote": {
        "ticker_id": "Unique identifier for the ticker.",
        "name": "Name of the company or asset.",
        "symbol": "Ticker symbol of the asset.",
        "mk_trade_time": "Timestamp of the last market trade.",
        "close": "Closing price of the asset.",
        "change": "Change in price since the last close.",
        "change_ratio": "Percentage change in price since the last close.",
        "market_value": "Total market value of the company.",
        "volume": "Trading volume of the asset.",
        "turnover_rate": "Turnover rate of the asset.",
        "overnight": "Overnight price change.",
        "pre_close": "Previous day's closing price.",
        "open": "Opening price of the asset.",
        "high": "Highest price of the asset during the trading session.",
        "low": "Lowest price of the asset during the trading session.",
        "vibrate_ratio": "Price fluctuation ratio.",
        "avg_vol_10d": "10-day average trading volume.",
        "avg_vol_3m": "3-month average trading volume.",
        "neg_market_value": "Negative market value.",
        "pe": "Price-to-earnings ratio.",
        "forward_pe": "Forward price-to-earnings ratio.",
        "indicated_pe": "Indicated price-to-earnings ratio.",
        "pe_ttm": "Trailing twelve months price-to-earnings ratio.",
        "eps": "Earnings per share.",
        "eps_ttm": "Trailing twelve months earnings per share.",
        "pb": "Price-to-book ratio.",
        "total_shares": "Total number of shares issued.",
        "outstanding_shares": "Number of shares outstanding.",
        "fifty_high": "52-week high price.",
        "fifty_low": "52-week low price.",
        "dividend": "Dividend per share.",
        "yield": "Dividend yield as a percentage.",
        "latest_dividend_date": "Date of the last dividend payment.",
        "latest_split_date": "Date of the last stock split.",
        "latest_earnings_date": "Date of the last earnings report.",
        "ps": "Price-to-sales ratio.",
        "bps": "Book value per share.",
        "estimate_earnings_date": "Estimated date of the next earnings report.",
        "next_earning_day": "Date of the next earnings report."
    },
    "InstitutionHolding": {
        "institution_holding": "Overall institutional holding data."
    },
    "InstitutionStat": {
        "holding_count": "Number of shares held by institutions.",
        "holding_count_change": "Change in the number of shares held by institutions.",
        "holding_ratio": "Percentage of the company's shares held by institutions.",
        "holding_ratio_change": "Change in the institutional holding ratio.",
        "institutional_count": "Number of institutional investors holding the shares."
    },
    "Position": {
        "holding_count_change": "Change in the number of shares held in the position.",
        "institutional_count": "Number of institutions holding the position."
    },
    "Event": {
        "actual": "Actual value reported for the event.",
        "comment": "Additional comments or notes about the event.",
        "country": "Country associated with the event.",
        "currency": "Currency used in the event data.",
        "date": "Date of the event.",
        "time": "Time of the event.",
        "forecast": "Forecasted value for the event.",
        "id": "Unique identifier for the event.",
        "importance": "Importance level of the event.",
        "indicator": "Economic or financial indicator associated with the event.",
        "link": "URL link to more details about the event.",
        "period": "Period the event data pertains to.",
        "previous": "Previous reported value for the event.",
        "scale": "Scale used for the event data.",
        "source": "Source of the event data.",
        "title": "Title or name of the event.",
        "unit": "Unit of measurement for the event data."
    },
   "Hilbert Transform Indicators": {
        "HT_DCPERIOD": "Hilbert Transform - Dominant Cycle Period. Measures the dominant cycle period in the price series.",
        "HT_DCPHASE": "Hilbert Transform - Dominant Cycle Phase. Represents the phase of the dominant cycle.",
        "HT_PHASOR": "Hilbert Transform - Phasor Components. Provides complex components (real and imaginary) of the phasor.",
        "HT_SINE": "Hilbert Transform - SineWave. Produces sine and lead sine wave values for trend identification.",
        "HT_TRENDMODE": "Hilbert Transform - Trend vs. Cycle Mode. Identifies if the market is in a trending or cyclic mode."
    },
    "Pattern Recognition Indicators": {
        "CDL2CROWS": "Two Crows - A bearish reversal pattern.",
        "CDL3BLACKCROWS": "Three Black Crows - A bearish reversal pattern with three consecutive long bearish candles.",
        "CDL3INSIDE": "Three Inside Up/Down - Indicates potential reversal.",
        "CDL3LINESTRIKE": "Three-Line Strike - A potential continuation pattern after a trend.",
        "CDL3OUTSIDE": "Three Outside Up/Down - Indicates reversal of the current trend.",
        "CDL3STARSINSOUTH": "Three Stars In The South - A rare bullish reversal pattern.",
        "CDL3WHITESOLDIERS": "Three Advancing White Soldiers - A strong bullish reversal pattern.",
        "CDLABANDONEDBABY": "Abandoned Baby - A reversal pattern with a gap on both sides of a doji.",
        "CDLADVANCEBLOCK": "Advance Block - A bearish reversal pattern with three candles showing weakening momentum.",
        "CDLBELTHOLD": "Belt-hold - A single candlestick pattern indicating reversal or continuation.",
        "CDLBREAKAWAY": "Breakaway - A five-candle reversal pattern.",
        "CDLCLOSINGMARUBOZU": "Closing Marubozu - A candlestick with no shadow on the closing side.",
        "CDLCONCEALBABYSWALL": "Concealing Baby Swallow - A bullish reversal pattern formed by four candles.",
        "CDLCOUNTERATTACK": "Counterattack - A reversal pattern with a strong opposing candle.",
        "CDLDARKCLOUDCOVER": "Dark Cloud Cover - A bearish reversal pattern with a strong bearish candle.",
        "CDLDOJI": "Doji - Indicates indecision in the market.",
        "CDLDOJISTAR": "Doji Star - A potential reversal pattern with a doji after a trend candle.",
        "CDLDRAGONFLYDOJI": "Dragonfly Doji - A bullish reversal pattern with a long lower shadow.",
        "CDLENGULFING": "Engulfing Pattern - A strong reversal pattern with a larger candle engulfing the previous one.",
        "CDLEVENINGDOJISTAR": "Evening Doji Star - A bearish reversal pattern with a doji star.",
        "CDLEVENINGSTAR": "Evening Star - A bearish reversal pattern.",
        "CDLGAPSIDESIDEWHITE": "Up/Down-gap side-by-side white lines - A continuation pattern.",
        "CDLGRAVESTONEDOJI": "Gravestone Doji - A bearish reversal pattern with a long upper shadow.",
        "CDLHAMMER": "Hammer - A bullish reversal pattern with a long lower shadow.",
        "CDLHANGINGMAN": "Hanging Man - A bearish reversal pattern with a long lower shadow.",
        "CDLHARAMI": "Harami Pattern - A two-candle reversal pattern.",
        "CDLHARAMICROSS": "Harami Cross Pattern - A Harami pattern with a doji as the second candle.",
        "CDLHIGHWAVE": "High-Wave Candle - Indicates market indecision.",
        "CDLHIKKAKE": "Hikkake Pattern - A trap pattern indicating reversal or continuation.",
        "CDLHIKKAKEMOD": "Modified Hikkake Pattern - A variation of the Hikkake pattern.",
        "CDLHOMINGPIGEON": "Homing Pigeon - A bullish reversal pattern with two candles.",
        "CDLIDENTICAL3CROWS": "Identical Three Crows - A bearish reversal pattern with three identical bearish candles.",
        "CDLINNECK": "In-Neck Pattern - A bearish continuation pattern.",
        "CDLINVERTEDHAMMER": "Inverted Hammer - A bullish reversal pattern with a long upper shadow.",
        "CDLPIERCING": "Piercing Pattern - A bullish reversal pattern with a strong upward move.",
        "CDLKICKING": "Kicking - A strong reversal pattern characterized by a gap between two opposite-colored marubozu candles.",
        "CDLKICKINGBYLENGTH": "Kicking by Length - Similar to Kicking but determined by the length of the marubozu.",
        "CDLLADDERBOTTOM": "Ladder Bottom - A bullish reversal pattern that occurs after a downtrend.",
        "CDLLONGLEGGEDDOJI": "Long-Legged Doji - Indicates market indecision with long upper and lower shadows.",
        "CDLLONGLINE": "Long Line Candle - A single candlestick with a long body, indicating strong momentum.",
        "CDLMARUBOZU": "Marubozu - A candlestick with no shadows, indicating strong directional momentum.",
        "CDLMATCHINGLOW": "Matching Low - A bullish reversal pattern with two candles having the same low.",
        "CDLMATHOLD": "Mat Hold - A continuation pattern that indicates strong trend persistence.",
        "CDLMORNINGDOJISTAR": "Morning Doji Star - A bullish reversal pattern with a doji and gap.",
        "CDLMORNINGSTAR": "Morning Star - A bullish reversal pattern with three candles.",
        "CDLONNECK": "On-Neck Pattern - A bearish continuation pattern.",
        "CDLPIERCING": "Piercing Pattern - A bullish reversal pattern with a strong upward move.",
        "CDLRICKSHAWMAN": "Rickshaw Man - A variation of the Doji with long upper and lower shadows.",
        "CDLRISEFALL3METHODS": "Rising/Falling Three Methods - A continuation pattern with small corrective candles.",
        "CDLSEPARATINGLINES": "Separating Lines - A continuation pattern with two strong candles.",
        "CDLSHOOTINGSTAR": "Shooting Star - A bearish reversal pattern with a long upper shadow.",
        "CDLSHORTLINE": "Short Line Candle - A candlestick with a short body, indicating low momentum.",
        "CDLSPINNINGTOP": "Spinning Top - A candlestick with small real body and long shadows.",
        "CDLSTALLEDPATTERN": "Stalled Pattern - A bearish reversal pattern in an uptrend.",
        "CDLSTICKSANDWICH": "Stick Sandwich - A bullish reversal pattern with two bearish candles sandwiching a bullish one.",
        "CDLTAKURI": "Takuri - A Dragonfly Doji with an exceptionally long lower shadow.",
        "CDLTASUKIGAP": "Tasuki Gap - A continuation pattern with a gap and corrective candle.",
        "CDLTHRUSTING": "Thrusting Pattern - A bearish continuation pattern with partial gap filling.",
        "CDLTRISTAR": "Tristar Pattern - A reversal pattern with three doji candles.",
        "CDLUNIQUE3RIVER": "Unique 3 River - A rare bullish reversal pattern.",
        "CDLUPSIDEGAP2CROWS": "Upside Gap Two Crows - A bearish reversal pattern with a gap and two bearish candles.",
        "CDLXSIDEGAP3METHODS": "Upside/Downside Gap Three Methods - A continuation pattern with a gap and corrective candles."
    },
    "Math Transform Indicators": {
        "ACOS": "Vector Trigonometric ACos - Calculates the arccosine of a vector's values.",
        "ASIN": "Vector Trigonometric ASin - Calculates the arcsine of a vector's values.",
        "ATAN": "Vector Trigonometric ATan - Calculates the arctangent of a vector's values.",
        "CEIL": "Vector Ceil - Rounds up each value in the vector to the nearest integer.",
        "COS": "Vector Trigonometric Cos - Calculates the cosine of a vector's values.",
        "COSH": "Vector Trigonometric Cosh - Calculates the hyperbolic cosine of a vector's values.",
        "EXP": "Vector Arithmetic Exp - Calculates the exponential (e^x) of a vector's values.",
        "FLOOR": "Vector Floor - Rounds down each value in the vector to the nearest integer.",
        "LN": "Vector Log Natural - Calculates the natural logarithm (log base e) of a vector's values.",
        "LOG10": "Vector Log10 - Calculates the base-10 logarithm of a vector's values.",
        "SIN": "Vector Trigonometric Sin - Calculates the sine of a vector's values.",
        "SINH": "Vector Trigonometric Sinh - Calculates the hyperbolic sine of a vector's values.",
        "SQRT": "Vector Square Root - Calculates the square root of a vector's values.",
        "TAN": "Vector Trigonometric Tan - Calculates the tangent of a vector's values.",
        "TANH": "Vector Trigonometric Tanh - Calculates the hyperbolic tangent of a vector's values."
    },
    "Statistical Indicators": {
        "BETA": "Beta - Measures the sensitivity between a security's returns and a benchmark index.",
        "CORREL": "Pearson's Correlation Coefficient (r) - Measures the strength of the linear relationship between two data sets.",
        "LINEARREG": "Linear Regression - Best-fit line over a specified period for trend analysis.",
        "LINEARREG_ANGLE": "Linear Regression Angle - The angle of the linear regression line, indicating the strength of the trend.",
        "LINEARREG_INTERCEPT": "Linear Regression Intercept - The Y-intercept of the linear regression line.",
        "LINEARREG_SLOPE": "Linear Regression Slope - The slope of the linear regression line.",
        "STDDEV": "Standard Deviation - Measures the dispersion of data points from the mean.",
        "TSF": "Time Series Forecast - Predicts future values based on past linear regression.",
        "VAR": "Variance - Measures the variability or spread of data points."
    },
    "Math Operators": {
        "ADD": "Addition - Adds two data series or constants.",
        "DIV": "Division - Divides one data series or constant by another.",
        "MAX": "Maximum - Finds the maximum value over a specified period.",
        "MAXINDEX": "Maximum Index - Returns the index of the maximum value in a period.",
        "MIN": "Minimum - Finds the minimum value over a specified period.",
        "MININDEX": "Minimum Index - Returns the index of the minimum value in a period.",
        "MINMAX": "Minimum and Maximum - Calculates both the minimum and maximum values over a period.",
        "MINMAXINDEX": "Minimum and Maximum Index - Returns the indices of the minimum and maximum values in a period.",
        "MULT": "Multiplication - Multiplies two data series or constants.",
        "SUB": "Subtraction - Subtracts one data series or constant from another.",
        "SUM": "Sum - Calculates the sum of values over a specified period."
    },
    "Volume Indicators": {
        "AD": "Chaikin A/D Line - Measures the cumulative flow of money into and out of a security.",
        "ADOSC": "Chaikin A/D Oscillator - Tracks momentum changes in the A/D Line.",
        "OBV": "On Balance Volume - Tracks cumulative volume flow to confirm price trends."
    },
    "Volatility Indicators": {
        "ATR": "Average True Range - Measures market volatility.",
        "NATR": "Normalized Average True Range - ATR expressed as a percentage of price.",
        "TRANGE": "True Range - Measures the absolute price range over a period."
    },
    "Price Transform Indicators": {
        "AVGPRICE": "Average Price - The average of open, high, low, and close prices.",
        "MEDPRICE": "Median Price - The average of the high and low prices.",
        "TYPPRICE": "Typical Price - The average of high, low, and close prices.",
        "WCLPRICE": "Weighted Close Price - Heavily weights the closing price for a more accurate central price."
    },
    "Overlap Studies Indicators": {
        "BBANDS": "Bollinger Bands - Measures volatility and identifies potential overbought/oversold conditions.",
        "DEMA": "Double Exponential Moving Average - A faster, smoother moving average.",
        "EMA": "Exponential Moving Average - Gives more weight to recent prices for trend tracking.",
        "HT_TRENDLINE": "Hilbert Transform - Instantaneous Trendline. A smoothed trendline for identifying price trends.",
        "KAMA": "Kaufman Adaptive Moving Average - Adjusts its speed based on market volatility.",
        "MA": "Moving Average - A standard average for smoothing price action.",
        "MAMA": "MESA Adaptive Moving Average - Adapts to market cycles for smoother trend detection.",
        "MAVP": "Moving Average with Variable Period - A moving average where the period changes dynamically.",
        "MIDPOINT": "MidPoint over period - Calculates the midpoint of prices over a specified period.",
        "MIDPRICE": "Midpoint Price over period - The average of the high and low prices over a period.",
        "SAR": "Parabolic SAR - A stop-and-reverse system to identify potential trend reversals.",
        "SMA": "Simple Moving Average - A basic average over a specified period.",
        "T3": "Triple Exponential Moving Average - A smoother version of EMA with less lag.",
        "TEMA": "Triple Exponential Moving Average - Reduces lag and reacts faster to price changes.",
        "TRIMA": "Triangular Moving Average - Gives more weight to the middle of the data series.",
        "WMA": "Weighted Moving Average - Assigns more weight to recent data points."
    },
    "Momentum Indicators": {
        "ADX": "Average Directional Movement Index - Measures the strength of a trend.",
        "ADXR": "Average Directional Movement Index Rating - Smoothed version of ADX.",
        "APO": "Absolute Price Oscillator - Shows the difference between two moving averages.",
        "AROON": "Aroon - Measures the strength and direction of a trend.",
        "AROONOSC": "Aroon Oscillator - The difference between Aroon-Up and Aroon-Down.",
        "BOP": "Balance Of Power - Measures the strength of buying vs selling pressure.",
        "CCI": "Commodity Channel Index - Identifies overbought and oversold levels.",
        "CMO": "Chande Momentum Oscillator - Measures momentum of a security.",
        "DX": "Directional Movement Index - Indicates trend direction and strength.",
        "MACD": "Moving Average Convergence/Divergence - Shows the relationship between two moving averages.",
        "MFI": "Money Flow Index - Measures buying and selling pressure using volume.",
        "MINUS_DI": "Minus Directional Indicator - Part of ADX, shows bearish pressure.",
        "MINUS_DM": "Minus Directional Movement - Measures downward movement strength.",
        "MOM": "Momentum - Measures price momentum.",
        "PLUS_DI": "Plus Directional Indicator - Part of ADX, shows bullish pressure.",
        "PLUS_DM": "Plus Directional Movement - Measures upward movement strength.",
        "PPO": "Percentage Price Oscillator - MACD in percentage terms.",
        "ROC": "Rate of Change - Measures price change percentage.",
        "RSI": "Relative Strength Index - Identifies overbought or oversold conditions.",
        "STOCH": "Stochastic - Measures momentum and potential reversals.",
        "STOCHRSI": "Stochastic Relative Strength Index - Combines Stochastic and RSI.",
        "TRIX": "Triple Smoothed EMA - Measures momentum.",
        "ULTOSC": "Ultimate Oscillator - Combines short, medium, and long-term momentum.",
        "WILLR": "Williams' %R - Measures overbought/oversold levels."
    }

}






tips_dict= [
"```py\n Did you know that you can easily navigate throughout the discord by using``` ```py\nnavigate``` ```py\nGo ahead! Give it a shot.```",
"```py\n Hey everyone! Dont forget - theres a plethora of new tools for you to use!  Here are the latest additions:  Technical Analysis In-depth Explanations:``` <#1022602221608775690> | <#1022599729802133514> | <#1022598659264753776> | <#1022598010678546552> are suggested to take a look at, if anything! \n\n ```py\n To easily navigate to these new channels:``` /navigate ta OR #ta in your message box. \n\n ```py\n Also: Be sure to check out /technicals for a dropdown of patterns with examples. \n\n ```py\n DICTIONARY! If you need to look up what something means - easily do so from discord by using /dictionary.```",
"```py\n Be sure to check out the new forum channels - a much better way to keep conversations organized and easily followed.  Forum channels and content:``` <#1022544320030572574> | <#1019739023192895559> | <#1019642125442363483> | <#1019711610949996644> | <#1019813473670139954> | <#1019809619457101964> | <#1020096195760234556> ```py\n Keep in mind - EVERY MEMBER CAN START THEIR OWN FORUM!```",
"```py\n To easily find the core screener - use``` ```/core``` ```py\nYou can find the login credentials by using  /fudstop```",
"```py\nIf you're on the PC - using Control + K is a very efficient way to navigate through notifications / search for channels.``` <#1019823111287345162> | <#1019822717203128361>",
"```py\nDid you know that the entire Discord is tagged for easy searches?  Learn about this here:``` <#1019824655240015943> | <#1019968826252738610>",
"```py\n Our discord acts as a data repository - anything that's ever been said, any image that's been sent, and any file can be retrieved. This means you can look up dark pools / option feeds/ quant alerts / and other data metrics that we pull in using the several APIs that we have access to.  To learn more, visit:``` <#1020410451491831882>",
"```py\nWhen one company decides to take over another one, it is referred to as an acquisition. The acquiring company will do this by purchasing either the majority or entirety of the ownership stake of the company being taken over.```",
"```py\nAggregate demand is the total demand for final goods and services in a market, sector or economy. Aggregate demand shows how current price levels relate to a nations real gross domestic product (GDP).```",
"```py\nAggregate supply is the total value of goods or services in a market, sector or economy. Aggregate supply is used to show the amount of goods that can be produced at different price levels in a given time period – usually one year.```",
"```py\nIG alerts – also known as trading alerts – allow you to set specific criteria and be notified immediately once that criteria has been met. There are three main types: economic announcements, price alerts and indicator alerts.```",
"```py\nAlpha is the measurement of an investment portfolios performance against a certain benchmark –usually a stock market index. In other words, its the degree to which a trader has managed to beat the market over a period of time. The alpha can be positive or negative, depending on its proximity to the market.```",
"```py\nAmortisation is the process of spreading the repayment of a loan, or the cost of an intangible asset, over a specific timeframe. This is usually a set number of months or years, depending on the conditions set by banks or copyright agencies. Amortisation will often incur interest payments, set at the discretion of the lender.```",
"```py\nAn annual general meeting (AGM) is a yearly gathering between the shareholders of a company and its board of directors. Generally, this is the only time that the directors and shareholders will meet throughout the year, so it is a chance for the directors to present the companys annual report.```",
"```py\nArbitrage in trading is the practice of simultaneously buying and selling an asset to take advantage of a difference in price. The asset will usually be sold in a different market, different form or with a different financial product, depending on how the discrepancy in the price occurs.```",
"```py\nAn asset class is a category of financial instrument - these can be physical assets or financial assets. The instruments are grouped into asset classes based on whether they show similar characteristics, behave in the same way on the market, or are governed by the same laws and regulations.```",
"```py\nAn asset is an economic resource which can be owned or controlled to return a profit, or a future benefit. In financial trading, the term asset relates to what is being exchanged on markets, such as stocks, bonds, currencies or commodities.```",
"```py\nAt the money (ATM) is a term used to describe an options contract with a strike price that is identical to the underlying market price. At the money options see a lot of trading activity, because they are so close to becoming profitable.```",
"```py\nAn auction market is an environment that facilitates competition between buyers and sellers. In an auction market, buyers indicate the maximum price that they are willing to pay for an asset, while sellers express the lowest price that they would be comfortable accepting.```",
"```py\nAutomated trading – also known as algorithmic trading – is the use of algorithms for making trade orders.```",
"```py\nAveraging down is when a market participant buys more of a stock they already own after the price has declined. In doing so, they will reduce the average price at which they purchased the stock and could stand to realise a greater profit if the market value recovers above the new average price.```",
"```py\nThe Bank of England (BoE) is the central bank for the United Kingdom. Sometimes known as the Old Lady of Threadneedle Street, the bank says its mission is to promote the good of the people of the United Kingdom by maintaining monetary and financial stability.```",
"```py\nIn trading the term base currency has two main definitions: the first currency quoted in a forex pair, or the accounting currency used by banks and other businesses.```",
"```py\nA base rate is the interest rate that a central bank – such as the Bank of England or Federal Reserve – will charge commercial banks for loans. The base rate is also known as the bank rate or the base interest rate.```",
"```py\nA basis point is a unit of measurement used to quantify the change between two percentages – it can also be referred to as bp, which is pronounced bip or beep. A basis point is equal to one hundredth of one percent, or 0.01%.```",
"```py\nWhen the market is on a sustained downward trajectory, with little optimism from traders to bring about a rally, it is referred to as a bear market.```",
"```py\nBeing bearish in trading means you believe that a market, asset or financial instrument is going to experience a downward trajectory. Being bearish is the opposite of being bullish, which means that you think the market is heading upwards.```",
"```py\nIn trading and investing, the bid is the amount a party is willing to pay in order to buy a financial instrument.```",
"```py\nBlue-chip stocks are the shares of companies that are reputable, financially stable and long-established within their sector. Over time, the companies that are considered blue chip tend to change, so the exact definition of what is required for blue-chip status can be vague. However, a company that is considered blue chip will tend to be at or near the very top of its sector, feature on a recognised index, and have a well-known brand.```",
"```py\nThe BoE is a popular shortening of the Bank of England, the central bank of the United Kingdom.```",
"```py\nBollinger bands are a popular form of technical price indicator. They are made up of an upper and lower band, set either side of a simple moving average (SMA). Each band is plotted two standard deviations away from the SMA of the market, and they are capable of highlighting areas of support and resistance.```",
"```py\nBond trading is one way of making profit from fluctuations in the value of corporate or government bonds. Many view it as an essential part of a diversified trading portfolio, alongside stocks and cash.```",
"```py\nBonds are a form of financial investment that involve lending money to an institution for a fixed period of time. They usually come in two varieties: corporate bonds and government bonds, depending on the type of institution you are lending to.```",
"```py\nWhile book value reflects what a business is worth according to its financials (its books), market value is the worth of a company according to financial markets – also known as its market capitalisation. The calculation for market value is the current market price per share multiplied by the total number of outstanding shares.```",
"```py\nThe book-to-market ratio assesses a companys value by comparing its book value to its market value. The book value is the value of a company on paper according to its common shareholder equity, while the market value of a company is determined by its market capitalisation.```",
"```py\nThe bottom line is a term used to describe a companys net income or earnings per share (EPS). If its referring to net income, it is the total profit made, minus any outgoings. And if its referring to EPS, it is the bottom line figure divided by the number of outstanding shares in the company.```",
"```py\nBrent crude – also referred to as Brent blend – is one of three major oil benchmarks used by those trading oil contracts, futures and derivatives. The other two major benchmarks are West Texas Intermediate (WTI) and Dubai/Oman, though there are many smaller oil varieties traded as well..```",
"```py\nBrexit is a contraction of British exit, and it is the word used to define the UKs departure from the EU. The initial referendum took place in June 2016, with 51.9% voting to leave, and 48.1% voting to remain.```",
"```py\nA broker is an independent person or a company that organises and executes financial transactions on behalf of another party. They can do this across a number of different asset classes, including stocks, forex, real estate and insurance. A broker will normally charge a commission for the order to be executed.```",
"```py\nBulls are speculators who believe that a market, instrument, or sector is going on an upward trajectory. This belief puts them at odds with bears, who take a pessimistic view on a markets direction.```",
"```py\nWhen a market, instrument or sector is on an upward trend, it is generally referred to as a bull market.```",
"```py\nBullish traders believe, based on their analysis, that a market will experience an upward price movement. Being bullish involves buying an underlying market in order to profit by selling the market in the future, once the price has risen.```",
"```py\nBuying a financial instrument means taking ownership of it from someone else, whether it is a commodity, stock or another asset.```",
"```py\nCable in forex is the nickname of the GBP/USD currency pair. It represents the British pound against the US dollar, and it is one of the most popular pairs on the currency market.```",
"```py\nA call option is a contract that gives the buyer the right but not the obligation to buy a specific asset at a specific price, on a specific date of expiry. The value of a call option appreciates if the assets market price increases.```",
"```py\nCash flow is the amount of money coming into and going out of a companys accounts, as reported in earnings announcements. It can refer to a single project or the entire business.```",
"```py\nChargeable gain refers to a profitable change in the price of an asset – measured between the time when the assets were purchased, and the time when they are sold. When applied to the financial markets, most profits – whether they are a result of going long or going short – are subject to capital gains tax (CGT).```",
"```py\nA chartist is a trader who relies predominantly on charts to help them understand a financial instruments historical price movements, in order to better predict and to speculate on its future performance. They are also commonly known as technical analysts, or technical traders.```",
"```py\nA closing price is the last level at which an asset was traded before the market closed on any given day. Closing prices are often used as a marker when looking at movements over a longer term. They can be compared to previous closing prices, or the opening price to measure an assets movement over a single day.```",
"```py\nCommission is the charge levied by an investment broker for making trades on a traders behalf.```",
"```py\nA commodity is a basic physical asset, often used as a raw material in the production of goods or services.```",
"```py\nContango and backwardation are two terms used to describe different conditions in the futures commodity market. They refer to whether the price of a commodity futures contract – known as the futures price – is trading above or below the price quoted for the physical commodity – known as the spot price.```",
"```py\nContracts for difference, or CFDs, are a type of financial derivative used in CFD trading. They can be used to trade a variety of financial markets like shares, forex, commodities, indices or bonds.```",
"```py\nBond convexity is a measure of the relationship between a bonds price and interest rates. It is used to assess the impact that a rise or fall in interest rates can have on a bonds price – which highlights a bond holders exposure to risk.```",
"```py\nCost of carry is the amount of additional money you might have to spend in order to maintain a position. This can come in the form of overnight funding charges, interest payments on margin accounts and forex transactions, or the costs of storing any commodities on the delivery of a futures contract.```",
"```py\nA covered call is a call option trading strategy. It involves holding an existing long position on a tradeable asset, and writing (selling) a call option against the same asset, with the aim of increasing the overall profit that a trader will receive.```",
"```py\nCPI stands for consumer price index, an average of several consumer goods and services that are used to give an indication of inflation.```",
"```py\nA credit default swap (CDS) is a financial agreement that enables a lender to swap their exposure to risk to another party. For a premium, the CDS seller takes on the credit risk of the lender, and they will compensate the lender if a borrower defaults on their loan.```",
"```py\nCrystallisation means selling an asset in order to realise capital gains or losses. When an investor buys an asset, any increase or decrease in the market price will not automatically translate to profit or loss – this is only realised after the position has been closed.```",
"```py\nCurrency appreciation is when one currency in a forex pair increases in value relative to the other currency in the pair. Forex traders often talk about one currency strengthening in relation to another, meaning that it would cost more to buy, or that it can buy more of another currency when sold.```",
"```py\nCurrency depreciation is the decline of a currencys value relative to another currency. It specifically refers to currencies in a floating exchange rate – a system in which a currencys value is set by the forex market, based on supply and demand.```",
"```py\nA currency future is a contract that details the price at which a currency could be bought or sold, and sets a specific date for the exchange.```",
"```py\nA currency option is a type of options contract that gives the holder the right, but not the obligation, to buy or sell a currency pair at a given price before a set time of expiry. To get this right, the holder of the option pays a premium to the seller (known as the options writer).```",
"```py\nThe current ratio is a measure used to establish a companys ability to sell its tangible assets to pay off its short-term debt. Companies normally have a limited time to settle short-term debt, so the current ratio is useful in establishing the liquidity position of a business.```",
"```py\nA day order is a type of order, or instruction from a trader to their broker, to buy or sell a certain asset.```",
"```py\nDay trading is a strategy of short-term investment that involves closing out all trades before the market closes.```",
"```py\nIn the UK, a debenture is an instrument used by a lender, such as a bank, when providing capital to companies and individuals. It enables the lender to secure loan repayments against the borrowers assets – even if they default on the payment.```",
"```py\nDelta is a measure used in options trading to assess how the price of an options contract changes as the price of the underlying asset moves. It can also sometimes be referred to as a hedge ratio.```",
"```py\nDerivatives are financial products that derive their value from the price of an underlying asset. Derivatives are often used by traders as a device to speculate on the future price movements of an asset, whether that be up or down, without having to buy the asset itself.```",
"```py\nDFB is the abbreviation of daily funded bet, a term used in spread betting to describe a position that remains open until you decide to close it. For each day that your bet remains open, an interest adjustment is made to your account to reflect the cost of funding your position – hence the term daily funded bet.```",
"```py\nA digital option – also known as a digital 100 – enables a trader to make a prediction about whether a statement about a given market is true or false. If a trader is correct in their prediction, they will make a profit. If they are wrong, they will incur a loss.```",
"```py\nA dividend is the portion of profit that a company chooses to return to its shareholders, usually expressed as a percentage.```",
"```py\nEarnings per share (EPS) is an important metric in a companys earnings figures. It is calculated by dividing the total amount of profit generated in a period, by the number of shares that the company has listed on the stock market.```",
"```py\nEBITDA is a way of evaluating a companys performance without factoring in financial decisions or the tax environment. The literal meaning of EBITDA is earnings before interest, taxes, depreciation and amortisation.```",
"```py\nEBITDAR is the abbreviation of 'earnings before interest, taxes, depreciation, amortisation and restructuring or rent costs. It is used to analyse a companys financial performance and profit potential where the company is undergoing a restructure or if its rent expenses are higher than average.```",
"```py\nECB stands for the European Central Bank, which is the organisation responsible for the monetary policy in the eurozone.```",
"```py\nThe Euro Short-Term Rate (ESTR) is an interest rate benchmark that reflects the overnight borrowing costs of banks within the eurozone. The rate is calculated and published by the European Central Bank (ECB).```",
"```py\nAn exchange is an open, organised marketplace for commodities, stocks, securities, derivatives and other financial instruments. The terms exchange and market are often used interchangeably, as they both describe an environment in which listed products can be traded.```",
"```py\nEDSP stands for exchange delivery settlement price, and refers to the price at which exchange-traded derivative contracts are settled. Stock exchanges use EDSP to calculate the amount that each party to an options or futures contract owes at the time of that contracts expiry.```",
"```py\nIn trading, execution is the completion of a buy or sell order from a trader. It is carried out by a broker.```",
"```py\nThe point when a trading position automatically closes is known as the expiry date (or expiration date).```",
"```py\nIn trading, exposure is a general term that can mean three things: the total market value of your trades at open, the total amount of possible risk at any given point, or the portion of a fund invested in a particular market or asset```",
"```py\nFair value has two meanings to investors. Generally, it is used to mean the value attributed to a stock by an individual investor or broker but in futures trading, it can refer to the predicted price of a market which is reflected in the cost to open a position.```",
"```py\nThe Financial Conduct Authority (FCA) is the organisation responsible for the regulation and oversight of the financial markets and financial service firms in the UK.```",
"```py\nThe Federal Reserve bank, or the 'Fed' for short, is the central bank in charge of monetary and financial stability in the United States. It is part of a wider system known as the Federal Reserve system – with 12 regional central banks located in major cities across the US.```",
"```py\nA fiat currency is a national currency that is not pegged to the price of a commodity such as gold or silver. The value of fiat money is largely based on the publics faith in the currencys issuer, which is normally that countrys government or central bank.```",
"```py\nA Fibonacci retracement is a key technical analysis tool that uses percentages and horizontal lines, drawn onto price charts, to identify possible areas of support and resistance. Identifying these areas is useful to traders since it can help them decide when to open and close a position, or when to apply stops and limits to their trades.```",
"```py\nFill is the term used to refer to the satisfying of an order to trade a financial asset. It is the basic act of any market transaction ' when an order has been completed, it is often referred to as filled or as the order having been executed. However, it is worth noting that there is no guarantee that every trade will become filled.```",
"```py\nA financial instrument is a monetary contract between two parties, which can be traded and settled. The contract represents an asset to one party (the buyer) and a financial liability to the other party (the seller).```",
"```py\nMarket can have several meanings within investments. Generally it is defined as a medium through which assets are traded, with their value determined by supply and demand.```",
"```py\nA fixed cost is a business expense which does not vary with production volumes. Fixed costs often include rent, contractual agreements or licences that are needed for the business to operate, which do not change in price if production increases or decreases. Instead, they are bound for the length of the contract or payment schedule.```",
"```py\nA floating exchange rate refers to a currency where the price is determined by supply and demand factors relative to other currencies. A floating exchange rate is different to a fixed – or pegged – exchange rate, which is entirely determined by the government of the currency in question.```",
"```py\nFOMC stands for the Federal Open Market Committee, which is the branch of the Federal Reserve responsible for reviewing and overseeing open market operations in the US. Through intervening in open market operations – buying or selling government securities – the FOMC can indirectly change the federal funds rate.```",
"```py\nThe 'force open' function on the trading platform allows you to enter a new bet in the opposite direction to an existing bet on the same market.```",
"```py\nForex is how market participants convert one currency to another. It can variously be referred to as foreign exchange, FX, or currencies.```",
"```py\nA forward contract is a contract that has a defined date of expiry. The contract can vary between different instances, making it a non-standardised entity that can be customised according to the asset being traded, expiry date and amount being traded.```",
"```py\nA French PEA refers to a Plan d'Epargne en Actions, which is a tax-efficient investment wrapper for residents of France. It allows French investors to buy and sell European securities with preferential conditions. In English, a PEA would be defined as a stock savings plan, similar to a stocks and shares ISA.```",
"```py\nFundamental analysis is a method of evaluating the intrinsic value of an asset and analysing the factors that could influence its price in the future. This form of analysis is based on external events and influences, as well as financial statements and industry trends.```",
"```py\nFunding charges, or interest charges, are the fees levied on leveraged positions that are held open overnight.```",
"```py\nFutures contracts represent an agreement between two parties to trade an asset at a defined price on a specified date in the future. They are also often referred to simply as futures.```",
"```py\nGamma is a term used in options trading to represent the rate of change in the options delta.```",
"```py\nGDP stands for gross domestic product, or the total value of the goods and services produced in a country over a specified period. It is used as an indicator of the size and health of a countrys economy.```",
"```py\nA gearing ratio is a measure used by investors to establish a companys financial leverage. In this context, leverage is the amount of funds acquired through creditor loans – or debt – compared to the funds acquired through equity capital.```",
"```py\nBy taking a position on a grey market, youre taking a position on a companys potential market cap ahead of its initial public offering (IPO). The price of a grey market is a prediction of what the companys total market capitalisation will be at the end of its first trading day.```",
"```py\nGross margin, or gross profit margin, is a way of measuring the amount of profit a company has left after subtracting the direct costs associated with selling its goods and services. It can illustrate if a company is generating revenue despite its outgoings.```",
"```py\nA guaranteed stop is a form of stop loss that offers an absolute guarantee of executing your trade at the level you specify.```",
"```py\nIn trading, the term 'handle' has two meanings, depending on which market you are referring to. In most markets, it means the whole numbers involved in a quote price, without the decimals included. In forex, it refers to the part of the quote that you see in both the buy and sell price.```",
"```py\nHawks and doves are terms used by analysts and traders to categorise members of Central Bank committee ahead of their votes on monetary policy.```",
"```py\nA hedge is an investment or trade designed to reduce your existing exposure to risk. The process of reducing risk via investments is called 'hedging'.```",
"```py\nHeikin Ashi is a type of chart pattern used in technical analysis. Heikin Ashi charts are similar to a candlestick charts, but the main difference is that a Heikin Ashi chart uses the daily price averages to show the median price movement of an asset.```",
"```py\nHelicopter money is the term used for a large sum of new money that is printed and distributed among the public, to stimulate the economy during a recession or when interest rates fall to zero. It is also referred to as a helicopter drop, in reference to a helicopter scattering supplies from the sky.```",
"```py\nHigh frequency trading (or HFT) is a form of advanced trading platform that processes a high numbers of trades very quickly using powerful computing technology. It can be used to either find the best price for a single large order, or to find opportunities for profit in the market in real time.```",
"```py\nThe Ichimoku Cloud is a technical analysis indicator that defines support and resistance levels, gauges momentum and provides trading signals. In Japanese, it is called the Ichimoku Kinko Hyo which roughly means one look equilibrium chart – because with just one look, traders can receive a range of information.```",
"```py\nIn the money (ITM) is defined by an options state of 'moneyness' or the underlying assets status when compared to the price at which it can be bought or sold (its strike price). Specifically, in the money means that an option* on an underlying asset has gone beyond its strike price, giving it an intrinsic value of more than £0.```",
"```py\nIn trading, an index is a grouping of financial assets that are used to give a performance indicator of a particular sector. The plural term is indices.```",
"```py\nIndices trading is the means by which traders attempt to make a profit from the price movements of indices.```",
"```py\nInflation is the increase in the cost of goods and services in an economy. As that in turn means that each unit of the currencys economy is worth less of any good or service, inflation can also be viewed as a devaluing of currency.```",
"```py\nIn finance, interest can have more than one . Firstly it refers to the charge levied against a party for borrowing money, which can be either a cost or a means of making profit for a trader. Secondly, it can mean the portion of a companys stocks held by a particular shareholder.```",
"```py\nThe amount that a lender charges to a borrower for the loan of an asset, usually expressed as a percentage of the amount borrowed. That percentage usually refers to the amount being paid each year (known as annual percentage rate, or APR) but can be used to express payments on a more or less regular basis.```",
"```py\nInternal rate of return (IRR) is a capital budgeting measurement used by companies to determine the profitability of a potential investment or project based on predicted cashflows. The IRR formula is complex and relies on a certain amount of trial and error to get correct.```",
"```py\nIntrinsic value is a way of describing the perceived or true value of an asset. This is not always identical to the current market price because assets can be over- or undervalued. Intrinsic value is a common part of fundamental analysis, which investors use to assess stocks, as well being used in options pricing.```",
"```py\nThe point when a trading position automatically closes is known as the expiry date (or expiration date).```",
"```py\nWhen a company embarks on an IPO (which stands for initial public offering) it goes public on a stock exchange. This can also be known as floating, flotation, or just going public.```",
"```py\nLeverage is a concept that can enable you to multiply your exposure to a financial market without committing extra investment capital.```",
"```py\nLeveraged products are financial instruments that enable traders to gain greater exposure to the market without increasing their capital investment. They do so by using leverage.```",
"```py\nLiabilities are the debts and obligations that detract from a companys total value, which have to be paid over a certain period of time. The form of the debt can vary – common examples include business expenses, loans, unearned revenues or legal obligations.```",
"```py\nA limit order is an instruction to your broker to execute a trade at a particular level that is more favourable than the current market price.```",
"```py\nA limit up is the maximum amount that the price of a stock index future or commodity future will be allowed to increase in a single trading session. A limit up is different to a limit down, but both are used to prevent certain assets reaching excessively high volatility levels.```",
"```py\nLiquidity is used in finance to describe how easily an asset can be bought or sold in the market without affecting its price – it can also be known as market liquidity. When there is a high demand for an asset, there is high liquidity, as it will be easier to find a buyer (or seller) for that asset.```",
"```py\nLIBOR, or the London Interbank Offered Rate, is a benchmark that dictates daily interest rates on loans and financial instruments around the world.```",
"```py\nWhen used in trading, long refers to a position that makes profit if an assets market price increases. Usually used in context as taking a long position, or going long.```",
"```py\nA lot is a standardised group of assets that is traded instead of a single asset.```",
"```py\nM2 is a classification of money supply. It includes M1 – which is comprised of cash outside of the private banking system plus current account deposits – while also including capital in savings accounts, money market accounts and retail mutual funds, and time deposits of under $100,000.```",
"```py\nMaintenance margin is the amount that must be available in funds in order to keep a margin trade open. It is also known as the variation margin.```",
"```py\nA margin call is the term for when a broker requests an increase maintenance margin from a trader, in order to keep a leveraged trade open.```",
"```py\nIn trading, margin is the funds required to open and maintain a leveraged position.```",
"```py\nDeposit margin is the amount a trader needs to put up in order to open a leveraged trading position. It can also be known as the initial margin, or just as the deposit.```",
"```py\nMarket capitalisation is the total market value of a companys shares on the market. It is often abbreviated to market cap. Market capitalisation is an easy way for investors to determine a companys size, which can help to assess the risk of investing in its shares.```",
"```py\nMarket data refers to the live streaming of trade-related data. It encompasses a range of information such as price, bid/ask quotes and market volume. Trading venues provide reports on various assets and financial instruments, which are then distributed to traders and firms. Market data is available across thousands of global markets, including stocks, indices, forex and commodities.```",
"```py\nA market maker is an individual or institution that buys and sells large amounts of a particular asset in order to facilitate liquidity.```",
"```py\nA market order is an instruction from a trader to a broker to execute a trade immediately at the best available price.```",
"```py\nWhile the market value reflects what a business is worth according to market participants, book value reflects what a business is worth according to its financials (its books). The calculation for the book value of a company is its total tangible assets minus its liabilities.```",
"```py\nWhen two or more companies decide to combine and become one entity, it is called a merger.```",
"```py\nMetaTrader is an electronic trading platform which is popular among traders around the world.```",
"```py\nModified internal rate of return (MIRR) is used to assess the cost and profitability of a future project for a company. Unlike the standard internal rate of return (IRR), MIRR assumes that positive cashflows are reinvested at the cost of capital, and that cash outlays are funded at the current financing cost.```",
"```py\nThe moving average convergence/divergence (MACD) is a technical analysis indicator that aims to identify changes in a share price's momentum. The MACD collects data from different moving averages to help traders identify possible opportunities around support and resistance levels.```",
"```py\nA moving average (often shortened to MA) is a common indicator in technical analysis, used to examine price movements of assets while lessening the impact of random price spikes.```",
"```py\nMultilateral trading facilities (MTFs) offer traders and investment firms an alternative to traditional exchanges. They allow trading of a wider variety of markets than most exchanges, including assets that may not have an official market.```",
"```py\nThe multiplier effect is the term used to describe the impact that changes in monetary supply can have on economic activity. When an individual, government or company spends money it has a trickle-down effect to businesses and individuals. The resulting impact can be much wider than the initial action.```",
"```py\nNegative balance protection ensures that traders do not lose more than the balance on their account – even if the market moves quickly or gaps.*```",
"```py\nNet change is the difference between the closing price of the current trading session, compared to the closing price of the previous trading session. Net change can be positive or negative, as it represents whether the markets are up or down on the previous day.```",
"```py\nNet income is the total amount of profit (often known as earnings) made by a company, listed in its earnings report.```",
"```py\nNon-current assets represent a companys long-term investments, for which the full value wont be realised during the accounting year. This can also include items that dont have an inherent value – intangible assets, for example – or assets with no fixed expiry such as property or land.```",
"```py\nNon-farm payrolls are a monthly statistic representing how many people are employed in the US, in manufacturing, construction and goods companies. They can also be known as non-farms, or NFP.```",
"```py\nAn off-book trade refers to the process of trading shares away from an exchange or regulated body. They are usually executed via the over-the-counter (OTC) market. Off-book transactions are made directly between two parties, outside or off of the order books.```",
"```py\nOffer is the term used when one trader expresses an intention to buy an asset or financial instrument from another trader or institution.```",
"```py\nOn exchange is a term used to mean that a trade is taking place directly on an order book. It differs from at quote, which is a trade made at the price quoted by a market maker.```",
"```py\nOn-balance volume (OBV) is a form of technical analysis which enables traders to make predictions about future price movements based on the assets previous trading volume. OBV is mostly used in shares trading, because the volume has an especially large influence on the way share prices move.```",
"```py\nOPEC is the Organisation of the Petroleum Exporting Countries. It was founded in 1960 by Saudi Arabia, Venezuela, Iraq, Iran and Kuwait. The other countries that have joined OPEC since are Libya, the United Arab Emirates, Algeria, Nigeria, Ecuador, Gabon, Angola, Equatorial Guinea and the Republic of the Congo – bringing OPECs membership to 14, as of January 2019.```",
"```py\nOpen has several s within investing. It can refer to the daily opening of an exchange, and an order or position that has not yet been filled or closed.```",
"```py\nAn open position is a trade which is still able to generate a profit or incur a loss. When a position is closed, all profits and losses are realised, and the trade is no longer active. Open positions can be either long or short – enabling you to profit from markets rising as well as falling.```",
"```py\nAn option is a financial instrument that offers you the right – but not the obligation – to buy or sell an asset when its price moves beyond a certain price with a set time period.```",
"```py\nThere are three main types of options spread strategy: vertical, horizontal and diagonal.```",
"```py\nIn trading, an order is a request sent to a broker or trading platform to make a trade on a financial instrument.```",
"```py\nIn trading, an order is a request sent to a broker or trading platform to make a trade on a financial instrument.```",
"```py\nOTC stands for over-the-counter, and refers to a trade that is not made on a formal exchange. It is often also referred to as off-exchange trading.```",
"```py\nOut of the money (OTM) is one of three terms used to address an options moneyness, with the other two being at the money and in the money. An out of the money options contract has not yet reached the value of its strike price, meaning it has no intrinsic value and will expire worthless.```",
"```py\nOverexposure in trading is the term used to describe the mistake of taking on too much risk. Typically, its when a trader makes the technical blunder of investing too much capital in a single position or market.```",
"```py\nThe price-to-earnings ratio, or P/E ratio for short, is a method of measuring a companys value. The P/E ratio is calculated by dividing the companys market value per share by the earnings per share (EPS).```",
"```py\nA parent company is one which has a controlling or majority interest in another company, which gives it the right to control the subsidiarys operations. Parent companies can be directly involved in the management of their subsidiaries, or they can have a more hands-off approach.```",
"```py\nThe term parity can be used in a few ways when trading, but always as an expression of equality.```",
"```py\nA pip is a measurement of movement in forex trading, defined as the smallest move that a currency can make.```",
"```py\nA position is the expression of a market commitment, or exposure, held by a trader. It is the financial term for a trade that is either currently able to incur a profit or a loss – known as an open position – or a trade that has recently been cancelled, known as a closed position. Profit or loss on a position can only be realised once it has been closed.```",
"```py\nPower of attorney gives another person the ability to act on your behalf. In trading, this means they can take over your trading accounts.```",
"```py\nA profit and loss (P&L) statement is a financial report that provides a summary of a companys revenue, expenses and profit. It gives investors and other interested parties an insight into how a company is operating and whether it has the ability to generate a profit.```",
"```py\nA pullback is a temporary pause or dip in an assets overall trend. The term is sometimes used interchangeably with retracement or consolidation. However, a pullback should not be confused with a reversal, which is a more permanent move against the prevailing trend.```",
"```py\nA purchasing managers index (PMI) is an economic indicator comprised of monthly reports and surveys from private sector manufacturing firms. The index surveys product managers, who are the individuals that buy the materials needed for a company to manufacture its products.```",
"```py\nA put option is a contract that gives the buyer the right but not the obligation to sell an asset at a specific price, at a specific date of expiry. The value of a put option increases if the asset's market price depreciates.```",
"```py\nQuantitative easing (or QE, for short) is an economic monetary policy intended to lower interest rates and increase money supply. It saw an increase in profile and use after the 2008 financial crash and subsequent recession.```",
"```py\nThe quote currency is the second currency listed in a forex pair. It is also known as the counter currency.```",
"```py\nA quote price is the price at which an asset was last traded. It is often defined as the point where supply meets demand, as its the price that buyers and sellers agree on.```",
"```py\nA rally is a period in which the price of an asset sees sustained upward momentum. Typically, a rally will occur after a period in which prices have been flat, trading in a narrow band, or experiencing a decline.```",
"```py\nRandom walk theory is a financial model which assumes that the stock market moves in a completely unpredictable way. The hypothesis suggests that the future price of each stock is independent of its own historical movement and the price of other securities.```",
"```py\nRange is the difference between a markets highest and lowest price in a given period. It is mostly used as an indicator of volatility: if a market has a wide range, its a sign that it was volatile over the period analysed.```",
"```py\nRate of return (RoR) is the loss or gain of an investment over a certain period, expressed as a percentage of the initial cost of the investment. A positive RoR means the position has made a profit, while a negative RoR means a loss. You will have a rate of return on any investment you make.```",
"```py\nA ratio spread is a strategy used in options* trading, in which a trader will hold an unequal number of buy and sell options positions on a single underlying asset at once.```",
"```py\nReserves are the liquid assets set aside for future use by an individual, central bank or business. Usually they are in the form of currency or a commodity, such as gold. For traders, reserves will usually be kept as cash that can be accessed quickly.```",
"```py\nA resistance level is the point on a price chart at which an upward price trajectory is impeded by an overwhelming inclination to sell the asset. If a market price is nearing a resistance level, a trader may opt to close their position and take the profit, rather than risk the price falling back.```",
"```py\nReturn on equity (ROE) is a measure of a companys profitability against its equity, expressed as a percentage. In other words, it is how much income the company is generating relative to the amount of capital received from shareholder investments.```",
"```py\nA reversal is a turnaround in the price movement of an asset: when an upward trend (or a rally) becomes a downward one (a correction), or vice versa. They can also often be referred to as trend reversals.```",
"```py\nRho is a term used in options trading to refer to how sensitive an options price is to any changes in interest rate levels. Rho can be either positive or negative depending on whether the position is long or short, and whether the option is a call or a put.```",
"```py\nA rights issue is when a company offers its existing shareholders the chance to buy additional shares for a reduced price. Usually the discounted price will stand for a specified time frame, after which it is returned to normal.```",
"```py\nRisk management is the process of identifying potential risks in your investment portfolio, and taking steps to mitigate accordingly.```",
"```py\nIn trading, risks are the ways in which an investment can end up losing you money.```",
"```py\nThe Regulatory News Service, or RNS, is responsible for disseminating regulatory and non-regulatory information on behalf of UK businesses and publicly listed companies. Operating as part of the London Stock Exchange (LSE), the RNS provides businesses with information that can help them to comply with their disclosure obligations.```",
"```py\nReturn on capital employed, or ROCE, is a long-term profitability ratio that measures how effectively a company uses its capital. The metric tells you the profit generated by each dollar (or other unit of currency) employed.```",
"```py\nIn trading, a rollover is the process of keeping a position open beyond its expiry.```",
"```py\nRSI stands for the relative strength index. It is a key tool used in technical analysis, assessing the momentum of assets to gauge whether they are in overbought or oversold territory.```",
"```py\nA run on the pound is a situation of increased nervousness towards the value of sterling and sterling-linked assets, including UK government bonds.```",
"```py\nA scalp in trading is the act of opening and then closing a position very quickly, in the hope of profiting from small price movements.```",
"```py\nThe SEC stands for the US Securities and Exchange Commission. It is a government agency set up to regulate markets and protect investors in the United States, as well as overseeing any mergers and acquisitions.```",
"```py\nSectors are divisions within an economy or market, useful for analysing performance or comparing companies with similar outputs and characteristics.```",
"```py\nThe Secured Overnight Financing Rate (SOFR) is the overnight interest rate for US dollar-denominated loans and derivatives.```",
"```py\nShare buyback, or share repurchase, is when a company buys back its own shares from investors. It can be seen as an alternative, tax-efficient way to return money to shareholders. Once shares are repurchased they are considered cancelled, but they can be kept for redistribution in the future.```",
"```py\nA share price – or a stock price – is the amount it would cost to buy one share in a company. The price of a share is not fixed, but fluctuates according to market conditions. It will likely increase if the company is perceived to be doing well, or fall if the company isnt meeting expectations.```",
"```py\nShares are the units of the ownership of a company, usually traded on the stock market. They are also known as stocks, or equities.```",
"```py\nShares trading is the buying and selling of company stock – or derivative products based on company stock – in the hope of making a profit.```",
"```py\nIn trading, short describes a trade that will incur a profit if the asset being traded falls in price. It is also often referred to as going short, shorting or sometimes selling.```",
"```py\nShort selling is the act of selling an asset that you do not currently own, in the hope that it will decrease in value and you can close the trade for a profit. It is also known as shorting.```",
"```py\nWhen the price at which an order is executed does not match the price at which it was made, it is referred to as slippage.```",
"```py\nA smart order router (SOR) is an automated process used in online trading that follows a set of rules when looking for trading liquidity. The goal of an SOR is to find the best way of executing a trade.```",
"```py\nSNB stands for Swiss National Bank, the central bank for Switzerland.```",
"```py\nSocially responsible investing is the process of selecting assets to buy based on their social impact as well as on their potential financial returns. It is also known as sustainable investing, socially conscious investing, green investing and ethical investing. Socially responsible investing is closely linked to impact investing, which seeks to make tangible positive change.```",
"```py\nIn trading, spot refers to the price of an asset for immediate delivery, or the value of an asset at any exact given time. It differs from an assets futures price, which is the price for delivery at some date in the future, or its expected price.```",
"```py\nThe spot price or spot rate is the current value of an underlying asset, for which it can be bought or sold with the expectation of immediate delivery. The term spot price is often used in commodities and forex markets.```",
"```py\nSpread betting is a leveraged financial derivative. When spread betting, you are making a bet on the direction in which a market will move. The accuracy of your bet determines the profit or loss when the position is closed.```",
"```py\nIn finance, the spread is the difference in price between the buy (bid) and sell (offer) prices quoted for an asset.```",
"```py\nThe Sterling Overnight Interbank Average rate (SONIA) is the effective overnight interest rate paid by banks for unsecured transactions in British sterling – these are loans that are not backed by collateral. It is the overnight funding charge for trades that occur in off-market hours and represents the amount of overnight business in the marketplace.```",
"```py\nSTIBOR has a particular significance in relation to IGs platform. Here, we define STIBOR in general investing and explain what it means to you when trading with IG.```",
"```py\nStock analysis is the method used by a trader or investor to examine and evaluate the stock market. It is then used to make informed decisions about buying and selling shares. Stock analysis can also be referred to as market analysis, or equity analysis.```",
"```py\nA stock exchange is a centralised location where the shares of publicly traded companies are bought and sold. Stock exchanges differ from other exchanges because the tradable assets are limited to stocks, bonds and exchange traded products (ETPs).```",
"```py\nA stock index is a group of shares that are used to give an indication of a sector, exchange or economy. Usually, a stock index is made up of a set number of the top shares from a given exchange.```",
"```py\nA stock symbol is an abbreviation used to identify publicly traded companies. When a company decides to go public, it will select the exchange to list on and then choose a unique stock symbol to differentiate itself from other companies on the exchange.```",
"```py\nStockbroking is a service which gives retail and institutional investors the opportunity to trade shares.```",
"```py\nStop orders are types of order that instruct your broker to execute a trade when it reaches a particular level: one which is less favourable than the current market price. They can also be known as stop-loss orders.```",
"```py\nA straddle in trading is a type of options strategy, which enables traders to speculate on whether a market is about to become volatile without having to predict a specific price movement. It involves either buying or selling simultaneous call and put options with matching strike prices and expiration dates.```",
"```py\nA strike price is the price at which an options contract can be exercised. It is a fixed price that the underlying asset can be bought or sold at under the pre-agreed contract.```",
"```py\nSuper-contango is when the spot price for a commodity is trading dramatically below the futures price. Super-contango usually occurs when the inventory space to store the physical commodity is running out due to excess supply – meaning that the cost of carry (the cost of storing a physical commodity) in a futures contract increases.```",
"```py\nSupport levels tell traders when the best time might be to enter and exit the market – enabling them to manage their risk by placing stops and limits.```",
"```py\nTangible assets are the assets on a company's balance sheet that have a physical form. This includes machinery, office equipment and property, as well as materials that are used in production.```",
"```py\nTechnical analysis is a means of examining and predicting price movements in the financial markets, by using historical price charts and market statistics. It is based on the idea that if a trader can identify previous market patterns, they can form a fairly accurate prediction of future price trajectories.```",
"```py\nhe term theta refers to the rate of decline in the value of an option due to the passage of time. It can also be referred to as the time decay of an option. This means an option loses value as time moves closer to its maturity, as long as everything is held constant.```",
"```py\nTime value is a term used in options trading to refer to the portion of an options premium that is attributable to the amount of time left until the option expires. An investor will pay more for an option with a longer time until expiry, because this increases the time available for an option to expire in the money.```",
"```py\nTom-next is short for tomorrow-next day, which is a short-term forex transaction that enables traders to simultaneously buy and sell a currency over two separate business days: tomorrow, and the next day.```",
"```py\nA trading floor is where financial instruments such as stocks, bonds and commodities are bought and sold. Trading floors are usually electronic, and they can be found in major exchanges around the world including the ICE Futures Exchange, the New York Stock Exchange (NYSE) and the London Stock Exchange (LSE).```",
"```py\nA trading plan is a strategy set by the individual trader in order to systemise evaluation of assets, risk management, types of trading, and objective setting. Most trading plans will comprise two parts: long-term trading objectives, and the route to achieving them.```",
"```py\nA markets volatility is its likelihood of making major, unforeseen short-term price movements at any given time.```",
"```py\nA trailing stop is a type of stop-loss that automatically follows positive market movements of an asset you are trading. If your position moves favourably but then reverses, a trailing stop can lock in your profits and close the position.```",
"```py\nTreasury stock is the portion of a companys shares that it keeps in reserve. In other words, the shares that are not available to the public and do not count towards the total amount of outstanding shares listed.```",
"```py\nWhen a market is making a clear, sustained move upwards or downwards, it is called a trend. Identifying the beginning and end of trends is a key part of market analysis. Trends can apply to individual assets, sectors, or even interest rates and bond yields.```",
"```py\nA trending share is the term for when a companys stock is undergoing a significant move in comparison to its underlying index. The trend can be either upwards or downwards.```",
"```py\nUnborrowable stock is the stock that no one is willing to lend out to short sellers. When shares in a company become unborrowable, the traditional means of short selling them is impossible.```",
"```py\nA markets volatility is its likelihood of making major, unforeseen short-term price movements at any given time.```",
"```py\nVariable cost is a business expense which is subject to change when sales volumes change. This could mean that variable costs either increase or decrease depending on a companys current output.```",
"```py\nVega in options trading measures how sensitive an options price is to changes in the implied volatility of an underlying market. It represents the extent to which an options premium will change given a 1% change in an assets implied volatility.```",
"```py\nVIX is short for the Chicago Board Options Exchange Volatility Index. It is a measure used to track volatility on the S&P 500 index, and is the most well-known volatility index on the markets.```",
"```py\nA markets volatility is its likelihood of making major, unforeseen short-term price movements at any given time.```",
"```py\nIn trading, volume is the amount of a particular asset that is being traded over a certain period of time. It is often presented alongside price information, as it offers an extra dimension when examining an assets price history.```",
"```py\nVWAP is the abbreviation for volume-weighted average price, which is a technical analysis tool that shows the ratio of an asset's price to its total trade volume. It provides traders and investors with a measure of the average price at which a stock is traded over a given period of time.```",
"```py\nWeekend trading is a service that enables you to speculate on several markets over the weekend.```",
"```py\nWTI stands for West Texas Intermediate (occasionally called Texas Light Sweet), an oil benchmark that is central to commodities trading. It is one of the three major oil benchmarks used in trading, the others being Brent crude and Dubai/Oman.```",
"```py\nA working order is a general term for either a stop or limit order to open. It is used to advise your broker to execute a trade when an asset reaches a specific price.```",
"```py\nYield is the income earned from an investment, most often in the form of interest or dividend payments. Yield is one of the ways in which investments can earn a trader money, with the other being the eventual closing of a position for profit.```",
"```py\nThe OUCH Order entry protocol is a proprietary protocol that allows subscribers to quickly enter orders into the System and receive executions. OUCH accepts limit Orders from members, and if there are matching Orders, they will execute. Non-matching Orders are added to the Limit Order Book, a database of available limit Orders, where they are matched in price-time priority. OUCH only provides a method for members to send Orders and receive status updates on those Orders.``` See https://www.nasdaqtrader.com/Trader.aspx?id=OUCH.",
"```py\n The RASH (Routing and Special Handling) Order entry protocol is a proprietary protocol that allows members to enter Orders, cancel existing Orders and receive executions. RASH allows participants to use advanced functionality, including discretion, random reserve, pegging and routing.``` See http://nasdaqtrader.com/content/technicalsupport/specifications/TradingProducts/rash_sb.",
"```py\n An Order Attribute is a further set of variable instructions that may be associated with an Order to further define how it will behave with respect to pricing, execution, and/or posting to the Exchange Book when submitted to the Exchange.```",
"```py\nPrimary Pegging as pegging with reference to the inside quotation on the same side of the market, Market Pegging as pegging with reference to the inside quotation on the opposite side of the market, and Midpoint Pegging as pegging with reference to the midpoint between the inside bid and the inside offer```",
"```py\nThe CPI-U is the statistical metric developed by the BLS to monitor the change in the price of a set list of products. \n\n The CPI-U represents changes in prices of all goods and services purchased for consumption by urban households.``` See Consumer Price Inde available at https://www.bls.gov/cpi.",
"```py\nFINRA ATS Transparency Data, available at ``` https://otctransparency.finra.org/otctransparency/AtsIssueData. ```py\nA list of alternative trading systems registered with the Commission is available at``` https://www.sec.gov/foia/docs/atslist.htm.",
"```py\nCboe Global Markets, U.S. Equities Market Volume Summary, available at``` http://markets.cboe.com/us/equities/market_share/. ```py\nSee generally``` https://www.sec.gov/fast-answers/divisionsmarketregmrexchangesshtml.html.",
"```py\nCS II runs on the Exchange from **4 p.m. to 6:30 p.m. eastern time and handles member organization crosses of baskets of securities of aggregate-priced buy and sell orders.**``` See NYSE Rule 7.39.",
"```py\nProposed Rule 7.39(c) would establish that only such NMS Stocks, as the Exchange may specify, including Exchange-listed securities and UTP Securities, would be eligible to trade in the Off-Hours Trading Facility. The proposed rule text is based on NYSE American Rule 7.39E(c) without difference.```",
"```py\nSelf-Regulatory Organizations; New York Stock Exchange LLC; Notice of Filing and Immediate Effectiveness of Proposed Rule Change to Adopt a **New Rule 7.39** and Delete Current Rules 900-907```", 
"```py\nOn a temporary basis, the results of the data for the SI calculations will be published on the ESMA website in spreadsheet format. Under the section Current data for the systematic internaliser calculations” the files with the calculations based on the most recent period will be published, while under the section “Historical data for the systematic internaliser calculations the previously published files based on previous periods will be available.  Equities:``` https://www.esma.europa.eu/sites/default/files/equity_si_calculations_-_publication_file_august_2022.xlsx ```py\n Bonds:``` https://www.esma.europa.eu/sites/default/files/bonds_si_calculations_-_publication_file_august_2022.xlsx \n ```py\n Link to ESMA:``` https://www.esma.europa.eu/data-systematic-internaliser-calculations",
"```py\n Alternative Trading Systems Issue Data:``` https://otctransparency.finra.org/otctransparency/AtsIssueData ```py\n Alternative Trading Systems Data:``` https://otctransparency.finra.org/otctransparency/AtsData ```py\n Alternative Trading Systems Statistics:``` https://otctransparency.finra.org/otctransparency/AtsStatistics ```py\n Alternative Trading Systems Download:``` https://otctransparency.finra.org/otctransparency/AtsDownload ```py\n Alternative Trading Systems Block Data:``` https://otctransparency.finra.org/otctransparency/AtsBlocksDownload ```py\n Over the Counter (NON ATS) Data Download: https://otctransparency.finra.org/otctransparency/OtcDownload \n ```py\n See more:``` https://otctransparency.finra.org/otctransparency/AtsIssueData", 
"```py\n View the full document here from the Bank of International Settlements:``` https://www.bis.org/bcbs/publ/d295.pdf",
"```py\n View the text here from the source: ``` https://www.ecfr.gov/current/title-12/chapter-I/part-50#p-50.3(Category%20III%20national%20bank%20or%20Federal%20savings%20association)",
"```py\n View this definition from the source:``` https://www.ecfr.gov/current/title-12/chapter-I/part-50#p-50.3(Client%20pool%20security)",
"```py\n View this definition from the source:``` https://www.ecfr.gov/current/title-12/chapter-I/part-50#p-50.3(Collateralized%20deposit)",
"```py\nA non-recourse loan that is extended as part of the Money Market Mutual Fund Liquidity Facility or Paycheck Protection Program Liquidity Facility authorized by the Board of Governors of the Federal Reserve System pursuant to section 13(3) of the Federal Reserve Act.  Source:``` https://www.ecfr.gov/current/title-12/chapter-I/part-50#p-50.3(Covered%20Federal%20Reserve%20Facility%20Funding)",
"```py\nA legally binding written agreement pursuant to which the customer must deliver to the national bank or Federal savings association a non-cash asset that the customer has already sold.  Source:``` https://www.ecfr.gov/current/title-12/chapter-I/part-50#p-50.3(Customer%20short%20position)",
"```py\nA financial contract whose value is derived from the values of one or more underlying assets, reference rates, or indices of asset values or reference rates. Derivative contracts include interest rate derivative contracts, exchange rate derivative contracts, equity derivative contracts, commodity derivative contracts, credit derivative contracts, forward contracts, and any other instrument that poses similar counterparty credit risks. Derivative contracts also include unsettled securities, commodities, and foreign currency exchange transactions with a contractual settlement or delivery lag that is longer than the lesser of the market standard for the particular instrument or five business days. A derivative does not include any identified banking product, as that term is defined in section 402(b) of the Legal Certainty for Bank Products Act of 2000 (7 U.S.C. 27(b)), that is subject to section 403(a) of that Act (7 U.S.C. 27a(a)).  Source:``` https://www.ecfr.gov/current/title-12/chapter-I/part-50#p-50.3(Derivative%20transaction)",
"```py\nSource:``` https://www.ecfr.gov/current/title-12/chapter-I/part-50#p-50.3(Encumbered) ```py\n with respect to an asset, that the asset: (1) Is subject to legal, regulatory, contractual, or other restriction on the ability of the national bank or Federal savings association to monetize the asset; or  (2) Is pledged, explicitly or implicitly, to secure or to provide credit enhancement to any transaction, not including when the asset is pledged to a central bank or a U.S. government-sponsored enterprise where: \n\n (i) Potential credit secured by the asset is not currently extended to the national bank or Federal savings association or its consolidated subsidiaries; ``` **and** ```py\n(ii) The pledged asset is not required to support access to the payment services of a central bank.```",
"```py\nA legally binding written agreement to extend funds at a future date to a counterparty that is made for the purpose of refinancing the debt of the counterparty when it is unable to obtain a primary or anticipated source of funding. A liquidity facility includes an agreement to provide liquidity support to asset-backed commercial paper by lending to, or purchasing assets from, any structure, program or conduit in the event that funds are required to repay maturing asset-backed commercial paper. Liquidity facilities exclude facilities that are established solely for the purpose of general working capital, such as revolving credit facilities for general corporate or working capital purposes.``` ```py\nIf a facility has characteristics of both credit and liquidity facilities, the facility must be classified as a liquidity facility.  See credit facility.```",
"```py\nSource:``` https://www.ecfr.gov/current/title-12/chapter-I/part-50#p-50.3(Credit%20facility) ```py\n A legally binding agreement to extend funds if requested at a future date, including a general working capital facility such as a revolving credit facility for general corporate or working capital purposes.``` ```py\nA credit facility does not include a legally binding written agreement to extend funds at a future date to a counterparty that is made for the purpose of refinancing the debt of the counterparty when it is unable to obtain a primary or anticipated source of funding. See liquidity facility.```",
"```py\nThe Financial Stability Oversight Council has a clear statutory mandate that creates for the first time collective accountability for identifying risks and responding to emerging threats to financial stability.``` https://home.treasury.gov/policy-issues/financial-markets-financial-institutions-and-fiscal-service/fsoc/about-fsoc",
"```py\nThe New York Fed undertakes certain small value open market transactions from time to time for the purpose of testing operational readiness to implement existing and potential policy directives from the Federal Open Market Committee (FOMC).``` https://www.newyorkfed.org/markets/operational-readiness",
"```py\nSummary of Commentary on Current Economic Conditions by Federal Reserve DistrictCommonly known as the Beige Book, this report is published eight times per year.``` ```py\nEach Federal Reserve Bank gathers anecdotal information on current economic conditions in its District through reports from Bank and Branch directors and interviews with key business contacts, economists, market experts, and other sources.``` ```py\nThe Beige Book summarizes this information by District and sector. An overall summary of the twelve district reports is prepared by a designated Federal Reserve Bank on a rotating basis.``` https://www.federalreserve.gov/monetarypolicy/beige-book-default.htm",
"```py\nA depositary receipt (DR) is a negotiable certificate issued by a bank representing shares in a foreign company traded on a local stock exchange.``` ```py\nThe depositary receipt gives investors the opportunity to hold shares in the equity of foreign countries and gives them an alternative to trading on an international market.``` https://www.adrbnymellon.com/directory/dr-directory",
"```py\nThe President of the United States manages the operations of the Executive branch of Government through Executive orders. After the President signs an Executive order, the White House sends it to the Office of the Federal Register (OFR).``` https://www.federalregister.gov/presidential-documents/executive-orders",
"```py\nRule 304 of Regulation ATS requires alternative trading systems (“ATSs”) that trade NMS stocks (“NMS Stock ATSs”) to publicly file with the Commission an initial Form ATS-N, amendments to initial Form ATS-N, and notices of cessations of operations.[1] Form ATS-N requires disclosures about the manner of operations of the NMS Stock ATS and the ATS-related activities of the broker-dealer operator and its affiliates, among other things.``` https://www.sec.gov/divisions/marketreg/form-ats-n-filings.htm",
"```py\nThis description was revised and updated on December 6, 2021.The Treasury's official yield curve is a par yield curve derived using a monotone convex method.``` ```py\nOur inputs are indicative, bid-side market price quotations (not actual transactions) for the most recently auctioned securities obtained by the Federal Reserve Bank of New York at or near 3:30 PM each trading day.``` https://home.treasury.gov/policy-issues/financing-the-government/interest-rate-statistics/treasury-yield-curve-methodology",
"```py\nBEA produces economic accounts statistics that enable government and business decision-makers, researchers, and the American public to follow and understand the performance of the nation's economy.``` https://www.bea.gov/",
"```py\nOn March 18, 2020, the Board authorized the Federal Reserve Bank of Boston (FRBB) to establish and operate the MMLF. The MMLF provides funding to U.S. depository institutions and bank holding companies to finance their purchases of certain types of assets from money market mutual funds under certain conditions.  The program is intended to assist money market mutual funds that hold such paper in meeting demands for redemptions by investors and to foster liquidity in the markets for the assets held by money market mutual funds, including the market for short-term municipal securities.  Additional information concerning the MMLF can be found on the Boards public website at:``` https://www.federalreserve.gov/monetarypolicy/mmlf.htm.",
"```py\nThe Federal Reserve established the Primary Market Corporate Credit Facility (PMCCF) on March 23, 2020, to support credit to employers through bond and loan issuances.``` ```py\nThe PMCCF provided companies access to credit so that they were better able to maintain business operations and capacity during the period of dislocations related to the pandemic. This facility was open to investment grade companies, as well as certain companies that were investment grade as of March 22, 2020. The Federal Reserve established a special purpose vehicle (SPV) through which the PMCCF was able to make loans and purchase bonds. The Treasury, using funds appropriated to the ESF through the CARES Act, made an equity investment in the SPV. The SPV will be used for the PMCCF and the Secondary Market Corporate Credit Facility.``` https://www.federalreserve.gov/monetarypolicy/pmccf.htm",
"```py\nThe Federal Reserve established the Secondary Market Corporate Credit Facility (SMCCF) on March 23, 2020, to support credit to employers by providing liquidity to the market for outstanding corporate bonds.``` ```py\nThe SMCCF supported market liquidity by purchasing in the secondary market corporate bonds issued by investment grade U.S. companies or certain U.S. companies that were investment grade as of March 22, 2020, as well as U.S.-listed exchange-traded funds whose investment objective is to provide broad exposure to the market for U.S. corporate bonds. The SMCCF's purchases of corporate bonds created a portfolio that tracked a broad, diversified market index of U.S. corporate bonds. The Treasury, using funds appropriated to the ESF through the CARES Act, made an equity investment in an SPV established by the Federal Reserve for the SMCCF and the Primary Market Corporate Credit Facility.``` ```py\nThe SMCCF was established by the Federal Reserve under the authority of Section 13(3) of the Federal Reserve Act, with approval of the Treasury Secretary. The SMCCF ceased purchasing eligible assets on December 31, 2020.``` https://www.federalreserve.gov/monetarypolicy/smccf.htm",
"```py\nThe Federal Reserve established the Term Asset-Backed Securities Loan Facility (TALF) on March 23, 2020 to support the flow of credit to consumers and businesses. The TALF enabled the issuance of asset-backed securities (ABS) backed by student loans, auto loans, credit card loans, loans guaranteed by the Small Business Administration (SBA), and certain other assets.``` ```py\nUnder the TALF, the Federal Reserve lent on a non-recourse basis to holders of certain AAA-rated ABS backed by newly and recently originated consumer and small business loans. The Federal Reserve lent an amount equal to the market value of the ABS less a haircut and was secured at all times by the ABS.``` ```py\nTreasury, using the ESF, also made an equity investment in the SPV established by the Federal Reserve for this facility. The TALF was established by the Federal Reserve under the authority of Section 13(3) of the Federal Reserve Act, with approval of the Treasury Secretary. The TALF ceased extending credit on December 31, 2020.``` https://www.federalreserve.gov/monetarypolicy/talf.htm",
"```py\nThe Federal Reserve established the Municipal Liquidity Facility to help state and local governments better manage cash flow pressures in order to continue to serve households and businesses in their communities. The facility was designed to purchase up to $500 billion of short term notes directly from U.S. states (including the District of Columbia), U.S. counties with a population of at least 500,000 residents, and U.S. cities with a population of at least 250,000 residents.``` ```py\nEligible state-level issuers were able to use the proceeds to support additional counties and cities. In addition to the actions described above, the Federal Reserve will continue to closely monitor conditions in the primary and secondary markets for municipal securities and will evaluate whether additional measures are needed to support the flow of credit and liquidity to state and local governments. The Municipal Liquidity Facility ceased purchasing eligible notes on December 31, 2020.``` https://www.federalreserve.gov/monetarypolicy/muni.htm",
"```py\nThreshold securities are equity securities that have an aggregate fail to deliver position for:Five consecutive settlement days at a registered clearing agency (e.g., National Securities Clearing Corporation (NSCC));totaling 10,000 shares or more; andequal to at least 0.5% of the issuer's total shares outstanding. ```py\nThreshold securities only include issuers registered or required to file reports with the Commission ('reporting companies'). ```https://www.investor.gov/introduction-investing/investing-basics/glossary/threshold-securities",
"```py\nA tender offer is typically an active and widespread solicitation by a company or third party (often called the “bidder” or “offeror”) to purchase a substantial percentage of the companys securities. Bidders may conduct tender offers to acquire equity (common stock) in a particular company or debt issued by the company. A tender offer where the company seeks to acquire its own securities is often referred to as an issuer tender offer. A tender offer where a third party seeks to acquire another companys securities is referred to as a third party tender offer. ``` https://www.investor.gov/introduction-investing/investing-basics/glossary/tender-offer",
"```py\nInvestors sometimes contact the SEC asking about the tax consequences when they sell securities. In particular, investors want to know whether they will have to pay a capital gains tax or can take a capital loss. The SEC does not regulate this area. The Internal Revenue Service does instead. ```https://www.investor.gov/introduction-investing/investing-basics/glossary/tax-questions",
"```py\nA diversified mutual fund that automatically shifts towards a more conservative mix of investments as it approaches a particular year in the future, known as its 'target date.' A target date fund investor picks a fund with the right target date based on his or her particular investment goal. The managers of the fund then make all decisions about asset allocation, diversification, and rebalancing. Target date funds also are known as lifecycle funds. ```https://www.investor.gov/introduction-investing/investing-basics/glossary/target-date-fund",
"```py\nA type of sales charge that applies if you withdraw money from a variable annuity within a certain period of time, usually six to ten years. This is known as the surrender period. The charge declines over time until it no longer applies. For example, a 7% surrender charge might apply in the first year after purchase. The charge may fall to 6% in the second year, 5% in the third year and so on, until the eighth year, when it no longer applies. ```https://www.investor.gov/introduction-investing/investing-basics/glossary/surrender-charge",
"```py\n stop order is an order to buy or sell a stock once the price of the stock reaches a specified price, known as the stop price. When the specified price is reached, your stop order becomes a market order. The advantage of a stop order is you don't have to monitor how a stock is performing on a daily basis. The disadvantage is that a stop price purchase or sale could be activated by a short-term fluctuation in a stock's price. In addition, the price at which your trade is executed may differ from the stop price, especially in a fast-moving market where stock prices can change rapidly. ```https://www.investor.gov/introduction-investing/investing-basics/glossary/stop-order",
"```py\nAn increase in the number of shares of a corporation's stock without a change in the shareholders' equity. Companies often split shares of their stock to make them more affordable to investors. Unlike issuing new shares, a stock split does not dilute the ownership interests of existing shareholders. For example, if you own 100 shares of a company that trades at $100 per share and the company declares a two-for-one stock split, you will own 200 shares at $50 per share immediately after the split. If the company pays a dividend, your dividends paid per share also will fall proportionately. ```https://www.investor.gov/introduction-investing/investing-basics/glossary/stock-split",
"```py\nListings of prices to buy and sell a specific stock. During trading, quotes show bids, the prices buyers are willing to pay, and offers, the prices sellers are willing to accept. Historical data provides the opening and closing price for each day of trading, and the daily high and low price for a stock, along with trading volume. ```https://www.investor.gov/introduction-investing/investing-basics/glossary/stock-quotes",
"```py\nA general term for the organized trading of stocks through exchanges, over-the-counter, and computerized trading venues.``` https://www.investor.gov/introduction-investing/investing-basics/glossary/stock-market",
"```py\n'Stock fund' and 'equity fund' describe a type of investment company (mutual fund, exchange-traded fund, closed-end fund, unit investment trust (UIT)) that invests primarily in stocks or 'equities' (as contrasted with 'bonds'). ```py\nThe types of stocks in which a stock fund will invest will depend upon the funds investment objectives, policies, and strategies. For example, one stock fund may invest in mostly established, 'blue chip' companies that pay regular dividends.``` ```py\nAnother stock fund may invest in newer, technology companies that pay no dividends but that may have more potential for growth. Another type of stock fund—an index fund—invests in stocks of companies contained in a particular market index. (There are also index funds that invest in bond indices.)``` https://www.investor.gov/introduction-investing/investing-basics/glossary/stock-fund",
"```py\nAn instrument that signifies an ownership position (called equity) in a corporation, and a claim on its proportional share in the corporation's assets and profits. Most stocks also provide voting rights, which give shareholders a proportional vote in certain corporate decisions, such as the election of corporate directors. ``` https://www.investor.gov/introduction-investing/investing-basics/glossary/stock",
"```py\nStatement of Additional Information (SAI) Conveys information about an open or closed-end fund that some investors find useful. Funds are not required to provide investors with the SAI, but they must provide it for free upon request. Also known as 'Part B' of the fund's registration statement.``` https://www.investor.gov/introduction-investing/investing-basics/glossary/statement-additional-information-sai",
"```py\nWhile the SEC regulates and enforces the federal securities laws, each state has its own securities regulator who enforces what are known as 'blue sky' laws. These laws cover many of the same activities the SEC regulates, such as the sale of securities and those who sell them, but are confined to securities sold or persons who sell them within each state. Your state securities regulator can confirm whether a company has been cleared to sell its securities in your state. Your regulator can also provide you information about a company doing business in the state. ``` https://www.investor.gov/introduction-investing/investing-basics/glossary/state-securities-regulators",
"```py\nIn addition to state securities regulators, there are a number of state agencies that may be able to assist you with your problems and questions. For example, if you have concerns about viatical settlements, you may want to speak to your state insurance regulator. If you've purchased a certificate of deposit from a bank and have problems or questions about your investment, you may want to direct them to your state banking regulator. ```https://www.investor.gov/introduction-investing/investing-basics/glossary/state-regulators",
"```py\nAn ETF designed to replicate the performance of the Standard & Poor's 500 Index. Because of its acronym, the SPDR instrument is referred to as a 'spider.'``` ```https://www.investor.gov/introduction-investing/investing-basics/glossary/standard-poors-depositary-receipts-spdr-trust",
"```py\nIn a 'spin-off,' a parent company distributes shares of a subsidiary to the parent company's shareholders so that the subsidiary becomes a separate, independent company. The shares are usually distributed on a pro rata basis. State law and the rules of the stock exchanges determine whether a company must seek shareholder approval for a spin-off.``` https://www.investor.gov/introduction-investing/investing-basics/glossary/spin-offs",
"```py\n'SPAC' stands for special purpose acquisition company, and it is a type of blank check company. SPACs have become a popular vehicle for various transactions, including transitioning a company from a private company to a publicly traded company. Certain market participants believe that, through a SPAC transaction, a private company can become a publicly traded company with more certainty as to pricing and control over deal terms as compared to traditional initial public offerings, or IPOs. https://www.investor.gov/introduction-investing/investing-basics/glossary/spacs",
"```py\nMost municipal securities offerings are exempt from the registration provisions of the federal securities laws. That means municipal issuers do not have to file a registration statement with the SEC. But you can still obtain information about municipal securities from the Municipal Securities Rulemaking Board (MSRB), through its Electronic Municipal Market Access (EMMA) website.``` https://www.investor.gov/introduction-investing/investing-basics/glossary/sources-municipal-securities-information", 
"```py\nA short sale generally involves the sale of a stock you do not own (or that you will borrow for delivery). Short sellers believe the price of the stock will fall, or are seeking to hedge against potential price volatility in securities that they own. If the price of the stock drops, short sellers buy the stock at the lower price and make a profit. If the price of the stock rises, short sellers will incur a loss.``` https://www.investor.gov/introduction-investing/investing-basics/glossary/short-sales-0",
"```py\nFees paid to respond to inquiries from investors and provide them with information about their investments. ```https://www.investor.gov/introduction-investing/investing-basics/glossary/shareholder-service-fees",
"```py\nAlthough investors sometimes ask the SEC for a list of a company's shareholders, the SEC does not maintain shareholder lists.Under SEC rules, a company must provide shareholders with a process for contacting other shareholders in two limited situations.  The first occurs during proxy solicitations – when shareholders solicit proxies in opposition to a company proposal or for a vote on a proposal they favor. The second occurs in connection with a tender offer where persons seek to acquire the company's securities from existing shareholders. In both cases, the company may choose to either give the list to the person who requested it or mail the shareholder's soliciting or tender offer materials to other shareholders at the requesting shareholder's expense.``` https://www.investor.gov/introduction-investing/investing-basics/glossary/shareholder-lists-when-you-can-get-them",
"```py\nInvestors must complete or 'settle' their security transactions within two business days. This settlement cycle is known as 'T+2,' shorthand for 'trade date plus two days.'  T+2 means that when you buy a security, your payment must be received by your brokerage firm no later than two business days after the trade is executed. When you sell a security, you must deliver to your brokerage firm your securities certificate no later than two business days after the sale. The two-day settlement date applies to most security transactions, including stocks, bonds, municipal securities, mutual funds traded through a brokerage firm, and limited partnerships that trade on an exchange. Government securities and stock options settle on the next business day following the trade.```` https://www.investor.gov/introduction-investing/investing-basics/glossary/settling-securities-transactions-t2",
"```py\nA bond that has a higher priority than another bonds claim to the same class of assets in case of a default or bankruptcy. Settlement Date -- The agreed date for the delivery of bonds and payment of funds. ```https://www.investor.gov/introduction-investing/investing-basics/glossary/senior-bond",
"```py\nAn investment instrument such as a stock or bond.https://www.investor.gov/introduction-investing/investing-basics/glossary/security",
"```py\nIf your brokerage firm goes out of business and is a member of the Securities Investor Protection Corporation (SIPC), then your cash and securities held by the brokerage firm may be protected up to $500,000, including a $250,000 limit for cash. When a SIPC member becomes insolvent, SIPC will ask a court to appoint a trustee to supervise the firm's liquidation and to process investors' claims.``` ```py\nSIPC, a non-government entity, covers most types of securities, such as stocks, bonds, and mutual funds. But SIPC does not protect you against losses caused by a decline in the market value of your securities. And it does not provide protection for investment contracts not registered with the SEC.``` https://www.investor.gov/introduction-investing/investing-basics/glossary/securities-investor-protection-corporation-sipc",
"```py\nAnalyst recommendations can have a significant effect on a companys stock price, especially when the recommendations are widely disseminated through television appearances or other electronic and print media. The SEC receives a number of complaints about analysts who recommend buying a stock in a company from investors who believe the analyst has a financial stake in the company or some other conflict of interest. ```https://www.investor.gov/introduction-investing/investing-basics/glossary/securities-analyst-recommendations",
]


technicals_list = [
"```py\nAscending Continuation Triangle``` ```py\nAn Ascending Continuation Triangle shows two converging trendlines. The lower trendline is rising and the upper trendline is horizontal. This pattern occurs because the lows are moving increasingly higher but the highs are maintaining a constant price level. The pattern will have two highs and two lows, all touching the trendlines. This pattern is confirmed when the price breaks out of the triangle formation to close above the upper trendline.``` https://pre-social-video.webullbroker.com/us/office/fdb69d02cf1a4a37ba433e2c54984345.gif",
"```py\nInside Bar (Bullish)  An Inside Bar is a reversal formation characterized by a bar that forms totally within the trading range of the preceding bar. Inside Bars reflect a balance between buyers and sellers following a sharp up or down move, which is sometimes later resolved by a change in trend.``` https://pre-social-video.webullbroker.com/us/office/bdf7f26d2a2a4797b286587eeeaa306f.gif",
"```py\nGap Down``````py\n A Gap Down forms when the high for a period (usually a day) is lower than the previous period's low which creates a 'void' in price action, and is one of three main criteria for the core logic.```https://www.webull.com/help/faq/10640-Gap-Down https://pre-social-video.webullbroker.com/us/office/e3fc297d0ccb46f5b34059508d951b4f.gif",
"```py\nHead and Shoulders Bottom  A Head and Shoulders Bottom is considered a 'bullish signal'. It indicates a possible reversal of the current downtrend into a new uptrend.``` https://pre-social-video.webullbroker.com/us/office/e1255ee1bded47dfb1ad5b149e5ae357.gif https://www.webull.com/help/faq/10681-Head-and-Shoulders-Bottom",
"```py\nDouble Bottom``` ```py\nA Double Bottom is considered a 'bullish signal', indicating a possible reversal of the current downtrend to a new uptrend.``` https://pre-social-video.webullbroker.com/us/office/10001a318a80438184f53f87838d9786.gif https://www.webull.com/help/faq/10663-Double-Bottom",
"```py\nGap Up  Gaps usually represent important areas of support or resistance. A Gap Up will indicate different situations based on the context in which it was formed. A Gap Up in an uptrend may indicate a previous level of resistance has been broken and now forms a support level. A Gap Up in a downtrend may indicate an end to, or a reversal of, the prior downtrend. Gaps provide an indication of a financial instrument's SHORT-TERM outlook. Either way - gaps tend to occur on 'earnings cycles' except Healthcare - which tend to occur on 'mid-earnings' cycle.``` https://pre-social-video.webullbroker.com/us/office/8eb798b593d0477693474da93047eec5.gif",
"```py\nGravestone (Bullish)``` ```py\nThe Gravestone '(Bullish)' candlestick indicates a possible reversal of the current downtrend to a new uptrend. The Gravestone '(Bullish)' is mostly seen as a bottom pattern indicating the end of a downtrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook.``` https://pre-social-video.webullbroker.com/us/office/1bfb86dd27a64a3f9d26beb111d7ac6c.gif",
"```py\nEngulfing Line (Bullish)``` ```py\nAn Engulfing Line '(Bullish)' indicates a possible reversal of the current downtrend to a new uptrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook.``` https://pre-social-video.webullbroker.com/us/office/010733f807914bf9aaec620aeddf065b.gif",
"```py\nHammer``````py\n The Hammer indicates that the prior downtrend is about to end and may reverse to an uptrend or move sideways. This pattern is an indication of a financial instrument's SHORT-TERM outlook. ``` https://pre-social-video.webullbroker.com/us/office/dee6cef744494e3fb65a4f59bb932562.gif",
"```py\nFast Stochastics  'Bullish:' %K and %D lines fall below and then rise above the 20 threshold, 'indicating bullish potential', along with a %K line cross above the %D line, triggering a bullish signal event if these 3 crossovers occur within a 5-day period.```"
"```py\nBearish: %K and %D lines rise above and then fall below the 80 threshold, 'indicating bearish potential', along with a %K line cross below the %D line, triggering a bearish signal event if these 3 crossovers occur within a 5-day period.``` https://pre-social-video.webullbroker.com/us/office/961af9fdf8a348948617dddac0a5382b.gif",
"```py\nKey Reversal Bar '(Bullish)'``` ```py\nA Key Reversal Bar '(Bullish)' indicates a possible reversal of the current downtrend to a new uptrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook. One and two-bar patterns reflect changes in investor psychology that have a very short-term influence on future prices - typically less than 10 bars. Often the immediate effect is trend exhaustion, followed by a reversal. For traders looking for clear entry and exit points, these patterns serve well. They are normally not suitable as signals for long-term investors unless viewed as monthly bars.``` https://pre-social-video.webullbroker.com/us/office/b2a6a707338e49c8889ce9784d81f0c4.gif",
"```py\nTriple Moving Average Crossover  When a shorter moving average (of a security's price) crosses a medium moving average, and the medium crosses a longer moving average, a 'bullish' or 'bearish' signal is generated depending on the direction of the crossovers.``` https://u1sweb.webullfinance.com/suggestion/1902a4d52de74a4bb5a9b4b3badd3a2a.gif",
"```py\nPennant (Bearish)``` ```py\nA Pennant '(Bearish)' is considered a 'bearish signal', indicating that the current downtrend may continue.``` https://pre-social-video.webullbroker.com/us/office/32694d0d2a2e423c82fcfa211e935f88.gif",
"```py\nRounded Top  A Rounded Top is considered a 'bearish signal', indicating a possible reversal of the current uptrend to a new downtrend.``` https://pre-social-video.webullbroker.com/us/office/533f3e4bbe2e414a93f8e99a1801657e.gif",
"```py\nRounded Bottom``` ```py\nA Rounded Bottom is considered a 'bullish' signal, indicating a possible reversal of the current downtrend to a new uptrend.``` https://pre-social-video.webullbroker.com/us/office/6614b983f9cc43ebb7f50cc5ff476519.gif",
"```py\nDouble Top``````py\nA Double Top is considered a bearish signal, indicating a possible reversal of the current uptrend to a new downtrend.``` https://pre-social-video.webullbroker.com/us/office/5932f20b1c214223877b05851585ab29.gif",
"```py\nTriple Bottom``````py\nA Triple Bottom is considered a bullish signal, indicating a possible reversal of the current downtrend to a new uptrend.``` https://pre-social-video.webullbroker.com/us/office/add50eee33a54f2384578344b3b7ec15.gif",
"```py\nBollinger Bands``` ```py\nBullish: When the price closes more than 2 standard deviations below the 20 period moving average of price, a bullish event is generated.```"


"```py\nBearish: When the price closes more than 2 standard deviations above the 20 period moving average of price, a bearish event is generated.```"


"```py\nTrading Central identifies a Bollinger band event based on a condition of price over-extension leading to an expectation of reversal. Some enhanced interpretations of Bollinger bands require secondary inputs such as RSI to validate a continuation or reversal position strategy. Refer to the Trading Considerations section below for further information regarding enhanced strategies for Bollinger bands.``` https://pre-social-video.webullbroker.com/us/office/ccb1adcbe46d4b71aa8fb686b68b7b19.gif",
"```py\nHead and Shoulders Top  A Head and Shoulders Top is considered a 'bearish signal'. It indicates a possible reversal of the current uptrend to a new downtrend.``` https://pre-social-video.webullbroker.com/us/office/98b1cd5c4ec04cfbacd6c9ac3c82b3c6.gif",
"```py\nDouble Moving Average Crossover  When a shorter and longer moving average (of a security's price) cross each other (the event), a 'bullish or bearish signal' is generated depending on the direction of the crossover.``` https://u1sweb.webullfinance.com/suggestion/17aff3cf388541ba8417862b09d7a176.gif",
"```py\nPrice Crosses Moving Average``` ```py\nWhen a security's price crosses its moving average (the event), a bullish or bearish signal is generated depending on the direction of the crossover.``` https://u1sweb.webullfinance.com/suggestion/15ca404b7b1b40788fac11747d048edd.gif",
"```py\nMoving Average Convergence/Divergence (MACD)``` ```py\nWhen the MACD crosses the signal line (the event), a bullish or bearish signal is generated depending on the direction of the crossover. One of the main criteria for the core logic!``` https://pre-social-video.webullbroker.com/us/office/01745f9cf69e48a9a595d2483c06c12c.gif",
"```py\nMomentum  When the 'Momentum rises above 0', a 'bullish Technical Event® signal is generated'. 'When the Momentum falls below 0', the Technical Event® is a 'bearish signal'.``` https://pre-social-video.webullbroker.com/us/office/9336166a82f0451fba5715ad092b1308.gif",
"```py\nPennant (Bullish)  A Pennant '(Bullish)' is considered a bullish signal, indicating that the current uptrend may continue.``` https://pre-social-video.webullbroker.com/us/office/5d4dab3f68ac464bbb35961dc6182edd.gif",
"```py\nTop Triangle - Top Wedge  Top Triangles and Top Wedges are considered 'bearish signals' that indicate a possible reversal of the current uptrend to a new downtrend.``` https://pre-social-video.webullbroker.com/us/office/abbe73257fbe460e97cc9cf7fc1d72e7.gif",
"```py\nBottom Triangle - Bottom Wedge  Bottom Triangles and Bottom Wedges are considered to be 'bullish signals' that mark a possible reversal of the current downtrend.``` https://pre-social-video.webullbroker.com/us/office/8696e1d0602b45c18d9dab078874e5df.gif",
"```py\nTriple Top  A Triple Top is considered a 'bearish signal', indicating a possible reversal of the current uptrend to a new downtrend.``` https://pre-social-video.webullbroker.com/us/office/08c735d66b114ed9804ccb10303e3438.gif",
"```py\nFlag (Bullish)  A Flag '(Bullish)' is considered a bullish signal, indicating that the current uptrend may continue.``` https://pre-social-video.webullbroker.com/us/office/62ce4a5c3a4c46559dd05f269a4096e2.gif",
"```py\nEngulfing Line (Bearish)``` ```py\nAn Engulfing Line (Bearish) indicates a possible reversal of the current uptrend to a new downtrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook.``` https://pre-social-video.webullbroker.com/us/office/195f7d84aad247c283c54099097ff7cf.gif",
"```py\nUpside Breakout``` ```py\nAn Upside Breakout is considered a bullish signal, marking a breakout from a trading range to start a new uptrend.``` https://pre-social-video.webullbroker.com/us/office/4d2005ffc7a94476971d70f3dcfa6060.gif",
"```py\nIsland Top``` ```py\nAn Island Top is a 'bearish signal' indicating a possible reversal of the current uptrend to a new downtrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook.``` https://pre-social-video.webullbroker.com/us/office/1ef92c2c9dda4797b811660ceb12ea63.gif",
"```py\nContinuation Wedge (Bullish)```py\n A Continuation Wedge '(Bullish)' is considered a 'bullish signal'. It indicates a possible continuation of the current uptrend.``` https://pre-social-video.webullbroker.com/us/office/6e2f3dae75d64fe09e15eab020896fea.gif",
"```py\nMegaphone Bottom``` ```py\nA Megaphone Bottom also known as a Broadening Bottom is considered a 'bullish signal', indicating that the current downtrend may reverse to form a new uptrend.``` https://pre-social-video.webullbroker.com/us/office/269d21508a4c4ab68d5313b6b2110a73.gif",
"```py\nHanging Man``` ```py\nThe Hanging Man is a 'bearish signal' indicating that the prior uptrend is about to end and may reverse to a downtrend or move sideways. This pattern is an indication of a financial instrument's SHORT-TERM outlook.``` https://pre-social-video.webullbroker.com/us/office/b27e22b3444745a4b84504158b80a00b.gif",
"```py\nInverted Hammer``` ```py\nAn Inverted Hammer indicates that the prior downtrend is about to end and may reverse to an uptrend or move sideways. This pattern is an indication of a financial instrument's SHORT-TERM outlook.``` https://pre-social-video.webullbroker.com/us/office/495de541f6de4d1aac24d1103cb882c2.gif",
"```py\nIsland Bottom``` ```py\nAn Island Bottom is a 'bullish signal' indicating a possible reversal of the current downtrend to a new uptrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook.``` https://pre-social-video.webullbroker.com/us/office/3f93f2e5da594321b8968e8961ada42e.gif",
"```py\nShooting Star``` ```py\nA Shooting Star indicates that the prior uptrend is about to end and may reverse to a downtrend or move sideways. This pattern is an indication of a financial instrument's SHORT-TERM outlook.``` https://pre-social-video.webullbroker.com/us/office/f2345bc0139b42de9cb91322553991db.gif",
"```py\nExhaustion Bar '(Bullish)'``` ```py\nAn Exhaustion Bar '(Bullish)' indicates a possible reversal of the current downtrend to a new uptrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook. One and two-bar patterns reflect changes in investor psychology that have a very short-term influence on future prices - typically less than 10 bars. Often the immediate effect is trend exhaustion followed by reversal. For traders looking for clear entry and exit points, these patterns serve well. They are normally not suitable as signals for long-term investors unless viewed as monthly bars.```https://pre-social-video.webullbroker.com/us/office/4e78e8498fc8474da42ec6160162fca0.gif",
"```py\nContinuation Wedge '(Bearish)'``` ```py\nA Continuation Wedge (Bearish) is considered a 'bearish signal', indicating that the current downtrend may continue.  A Continuation Wedge (Bearish) consists of two converging trend lines. The trend lines are slanted upward. Unlike the Triangles where the apex is pointed to the right, the apex of this pattern is slanted upwards at an angle. This is because prices edge steadily higher in a converging pattern i.e. there are higher highs and higher lows. A bearish signal occurs when prices break below the lower trendline. Over the weeks or months that this pattern forms the trend appears upwards but the long-term range is still downward.``` https://pre-social-video.webullbroker.com/us/office/be5ffc9b61ed4ce4b37946a7ed598dc8.gif",
"```py\nMegaphone Top```py\nA Megaphone Top also known as a 'Broadening Top' is considered a 'bearish signal', indicating that the current uptrend may reverse to form a new downtrend.``` https://pre-social-video.webullbroker.com/us/office/2a05e35dc14a4faeb7c63870230681ba.gif",
"```py\nKey Reversal Bar '(Bearish)'``` ```py\nA Key Reversal Bar (Bearish) indicates a possible reversal of the current uptrend to a new downtrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook. One and two-bar patterns reflect changes in investor psychology that have a very short-term influence on future prices - typically less than 10 bars. Often the immediate effect is trend exhaustion, followed by a reversal. For traders looking for clear entry and exit points, these patterns serve well. They are normally not suitable as signals for long-term investors unless viewed as monthly bars.``` https://pre-social-video.webullbroker.com/us/office/78973b12ba32491db844fdaefa621267.gif",
"```py\nTwo Bar Reversal '(Bearish)'``` ```py\nA Two Bar Reversal (Bearish) indicates a possible reversal of the current uptrend to a new downtrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook. One and two-bar patterns reflect changes in investor psychology that have a very short-term influence on future prices - typically less than 10 bars. Often the immediate effect is trend reversal. For traders looking for clear entry and exit points, these patterns serve well. They are normally not suitable as signals for long-term investors unless viewed as monthly bars.``` https://pre-social-video.webullbroker.com/us/office/c31c5014ccaa49edb9461450a8a4a58c.gif",
"```py\nTwo Bar Reversal '(Bullish)'``` ```py\nA Two Bar Reversal (Bullish) indicates a possible reversal of the current downtrend to a new uptrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook. One and two-bar patterns reflect changes in investor psychology that have a very short-term influence on future prices - typically less than 10 bars. Often the immediate effect is trend reversal. For traders looking for clear entry and exit points, these patterns serve well. They are normally not suitable as signals for long-term investors unless viewed as monthly bars.``` https://pre-social-video.webullbroker.com/us/office/b3bb4aa4cb5144119626bc7806cad224.gif",
"```py\nWilliams %R```py\n'Bullish:' After spending time in the oversold area below –80, the %R line rises back above -80 and continues up to cross the -50 line within 14 days. Trading Central identifies an event at the -50 line crossover.```"
"```py\n'Bearish:' After spending time in the overbought area above –20, the %R falls back below -20 and continues down to cross the -50 line within 14 days. Trading Central identifies an event at the -50 line crossover.``` https://pre-social-video.webullbroker.com/us/office/b78955a5feb64278ae5e8e72acb9a430.gif",
"```py\nRelative Strength Index (RSI)``` ```py\nWhen the RSI rises above the 30 threshold after establishing a 0 - 30 oversold condition, a 'bullish' signal is generated. Conversely, when the RSI falls out of the 70 - 100 overbought zone, a 'bearish' Technical Event® is signalled.``` https://pre-social-video.webullbroker.com/us/office/158aa81f966d41d89b4e9f294f5b9ee9.gif",
"```py\nFlag '(Bearish)'```py\nA Flag '(Bearish)' is considered a 'bearish signal', indicating that the current downtrend may continue.``` https://pre-social-video.webullbroker.com/us/office/25d785328ed1428e9c86fdb8b6eec8ed.gif",
"```py\nContinuation Diamond '(Bearish)'```",
"```py\nShort-term KST``` ```py\nA 'bullish signal' is generated when the KST, 'Know Sure Thing', rises above its moving average. When the KST falls below its moving average, the Technical Event® is a 'bearish signal.'```"
"```py\nSupported 'Short-term KST' events are suitable for investors interested in a time frame of 2-6 weeks. 'Intermediate-term KST' events are suitable for those interested in 6-39 week trends. Supported 'Long-term KST' events are suitable for a 9-month to 2-year time frame.``` https://pre-social-video.webullbroker.com/us/office/83118d03c2cd4d0caefe960b7fa7b69b.gif https://www.webull.com/help/faq/10671-Short-term-KST",
"```py\nMedium-term KST``` ```py\nA 'bullish signal' is generated when the KST, 'Know Sure Thing', rises above its moving average. When the KST falls below its moving average, the Technical Event® is a 'bearish signal.'```"

"```py\nSupported 'Short-term KST' events are suitable for investors interested in a time frame of 2-6 weeks. 'Medium-term KST' events are suitable for those interested in 6-39 week trends. Supported 'Long-term KST' events are suitable for a 9-month to 2-year time frame.``` https://pre-social-video.webullbroker.com/us/office/e08b9113e2824073908c33765545099b.gif",
"```py\nDownside Breakout``` ```py\nA Downside Breakout is considered a 'bearish signal', marking a breakout from a trading range to start a new downtrend.``` https://pre-social-video.webullbroker.com/us/office/0ae44b8c686e4d6d8e2332d8f18c86f2.gif",
"```py\nOutside Bar '(Bullish)'``` ```py\nAn Outside Bar '(Bullish)' indicates a possible reversal of the current downtrend to a new uptrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook. Two-bar patterns reflect changes in investor psychology that have a very short-term influence on future prices - typically less than 10 bars. Often the immediate effect is trend exhaustion, then reversal. For traders looking for clear entry and exit points, these patterns serve well. They are normally not suitable as signals for long-term investors unless viewed as monthly bars.``` https://pre-social-video.webullbroker.com/us/office/359be57d6e684aaea20e40566849ddf6.gif",
"```py\nCommodity Channel Index (CCI)``` ```py\nA 'bullish' event when the CCI rises above the +100% line.```"
"```py\nAnother event signaling the end of the previous bullish trend occurs when the CCI subsequently falls below the +100% line.```"
"```py\nA 'bearish' event when the CCI falls below the -100% line.```"
"```py\nAnother event signaling the end of the previous bearish trend occurs when the CCI subsequently rises above the -100% line.``` https://pre-social-video.webullbroker.com/us/office/a2d2dbd8d98b4bc0a8e8ed3c37ebc953.gif",
"```py\nContinuation Diamond '(Bullish)'``` ```py\nA Continuation Diamond (Bullish) is considered a bullish signal, indicating that the current uptrend may continue.``` https://pre-social-video.webullbroker.com/us/office/c51a689703f74256b35f539dde2f001e.gif",
"```py\nSymmetrical Continuation Triangle '(Bearish)'``` ```py\nA Symmetrical Continuation Triangle '(Bearish)' is considered a bearish signal, indicating that the current downtrend may continue.``` https://pre-social-video.webullbroker.com/us/office/141f20b1f1ef48949958fdc2c6836392.gif",
"```py\nSymmetrical Continuation Triangle '(Bullish)'``` ```py\nA Symmetrical Continuation Triangle '(Bullish)' is considered a bullish signal, indicating that the current uptrend may continue.``` https://pre-social-video.webullbroker.com/us/office/da213bc32e4948ab9c5a1635f527e131.gif",
"```py\nDescending Continuation Triangle``` ```py\nA Descending Continuation Triangle is considered a 'bearish signal', indicating that the current downtrend may continue.``` https://pre-social-video.webullbroker.com/us/office/3ee55152b6c74f279cee58713918d0ba.gif",
"```py\nDiamond Bottom```py\nA Diamond Bottom is considered a 'bullish signal', indicating a possible reversal of the current downtrend to a new uptrend.``` https://pre-social-video.webullbroker.com/us/office/ba0ae0f3233f492ba5351f713fe5c1a9.gif",
"```py\nOutside Bar (Bearish)``` ```py\nAn Outside Bar '(Bearish)' indicates a possible reversal of the current uptrend to a new downtrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook. Two-bar patterns reflect changes in investor psychology that have a very short-term influence on future prices - typically less than 10 bars. Often the immediate effect is trend exhaustion, then reversal. For traders looking for clear entry and exit points, these patterns serve well. They are normally not suitable as signals for long-term investors unless viewed as monthly bars.``` https://pre-social-video.webullbroker.com/us/office/c8d3b965d650489f9446c26a22aca3ea.gif",
"```py\nDiamond Top```py\nA Diamond Top is considered a 'bearish signal', indicating a possible reversal of the current uptrend to a new downtrend.``` https://pre-social-video.webullbroker.com/us/office/a328d0c954fe465ab8a22eeb19f15b67.gif",
"```py\nGravestone '(Bearish)'``` ```py\nThe Gravestone '(Bearish)' candlestick indicates a possible reversal of the current uptrend to a new downtrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook.``` https://pre-social-video.webullbroker.com/us/office/aea898d5550c46c39f8111677d89d0dd.gif",
"```py\nExhaustion Bar '(Bearish)'``` ```py\nAn Exhaustion Bar '(Bearish)' indicates a possible reversal of the current uptrend to a new downtrend. This pattern is an indication of a financial instrument's SHORT-TERM outlook. One and two-bar patterns reflect changes in investor psychology that have a very short-term influence on future prices - typically less than 10 bars. Often the immediate effect is trend exhaustion followed by reversal. For traders looking for clear entry and exit points, these patterns serve well. They are normally not suitable as signals for long-term investors unless viewed as monthly bars.``` https://pre-social-video.webullbroker.com/us/office/f45ef2a163d9491f89229dc3b63dd67f.gif",
"```py\nSlow Stochastic 'Bullish:' %K and %D lines fall below and then rise above the 20 threshold, indicating bullish potential, along with a %K line cross above the %D line, triggering a bullish signal event if these 3 crossovers occur within a 5-day period.```"
"```py\n 'Bearish:' %K and %D lines rise above and then fall below the 80 threshold, indicating bearish potential, along with a %K line cross below the %D line, triggering a bearish signal event if these 3 crossovers occur within a 5-day period.``` https://pre-social-video.webullbroker.com/us/office/fafd3076f18f40789ed55dfc473d22ce.gif",
"```py\nLong-term KST``` ```py\nA 'bullish signal' is generated when the KST, 'Know Sure Thing', rises above its moving average. When the KST falls below its moving average, the Technical Event® is a 'bearish signal'.```"


"```py\nSupported 'Short-term KST' events are suitable for investors interested in a time frame of 2-6 weeks. 'Intermediate-term KST' events are suitable for those interested in 6-39 week trends. Supported 'Long-term KST' events are suitable for a 9-month to 2-year time frame.``` https://pre-social-video.webullbroker.com/us/office/19de6f789c8e48e6be886b38e6557322.gif",
]




command_list = {
"```py\n📈/stock commands are used to view important data metrics."
"Utilizes high-quality data from CBOE, iexcloud, and NASDAQ Datalink"
"as well as Webull.\n\nClick a command below to have it automatically"
"loaded in your command box."
"Make sure to use ALL CAPS if typing in a ticker."
"```</stock capitalflow ticker:1026912485095260191> |"
"</stock orderflow:1026912485095260191> | </stock liquidity:1026912485095260191> |"
" </stock criminals:1026912485095260191>"
" \n\n </stock leverage:1026912485095260191> | </stock company_brief:1026912485095260191> |"
" </stock insider_summary:1026912485095260191> |"
" </stock institutions:1026912485095260191>",
"```py\n🔍/analysis commands are used to identify specific criteria market-wide, "
"such as technical patterns, screeners, and analyst ratings."
"\n\nClick a command below to have it automatically loaded in your command box. "
"Make sure to use ALL CAPS if typing in a ticker. ```"
"</analysis all_52s:1025074283942248481> | </analyst:1026367610708832328> | "
"</analysis finscreen:1025074283942248481> | </analysis topshorts:1025074283942248481>"
" \n\n </analysis newlow:1025074283942248481> </analyst:1026367610708832328> |"
" </analysis newhigh:1025074283942248481> | </analysis gaps_up:1025074283942248481> |"
" </analysis gaps_down:1025074283942248481>",
"```py\n💵/earnings commands are used to find earnings dates, earnings crush,"
" earnings projections, earnings performance, and company financials."
"\n\nClick a command below to have it automatically loaded in your command box."
" Make sure to use ALL CAPS if typing in a ticker.```"
"</earnings upcoming:1026367610708832327> | </earnings crush:1026367610708832327>"
" | </earnings projection:1026367610708832327>",
"```py\n🧠/learn commands are used to help get the user up to speed with several topics"
" - including discord, market research, discord setup,"
" discord tutorials, youtube videos, technical indicators, and more."
" Also - be sure to check out the <#1016105093269045289>!"
"\n\nClick a command below to have it automatically loaded in your command box."
" Make sure to use ALL CAPS if typing in a ticker.``` "
"</learn core_logic:1026367610708832329> | </learn discord:1026367610708832329> |"
" </learn options_101:1026367610708832329> | </learn calls:1026367610708832329>"
" \n\n </learn etfs:1026367610708832329> |"
" </learn covered_calls:1026367610708832329> | </learn china:1026367610708832329> |"
" </learn filings:1026367610708832329>",
}