# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AclBindingRuleArgs', 'AclBindingRule']

@pulumi.input_type
class AclBindingRuleArgs:
    def __init__(__self__, *,
                 auth_method: pulumi.Input[_builtins.str],
                 bind_name: pulumi.Input[_builtins.str],
                 bind_type: pulumi.Input[_builtins.str],
                 bind_vars: Optional[pulumi.Input['AclBindingRuleBindVarsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 selector: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AclBindingRule resource.
        :param pulumi.Input[_builtins.str] auth_method: The name of the ACL auth method this rule apply.
        :param pulumi.Input[_builtins.str] bind_name: The name to bind to a token at login-time.
        :param pulumi.Input[_builtins.str] bind_type: Specifies the way the binding rule affects a token created at login.
        :param pulumi.Input['AclBindingRuleBindVarsArgs'] bind_vars: The variables used when binding rule type is `templated-policy`. Can be lightly templated using HIL `${foo}` syntax from available field names.
        :param pulumi.Input[_builtins.str] description: A free form human readable description of the binding rule.
        :param pulumi.Input[_builtins.str] namespace: The namespace to create the binding rule within.
        :param pulumi.Input[_builtins.str] partition: The partition the ACL binding rule is associated with.
        :param pulumi.Input[_builtins.str] selector: The expression used to match this rule against valid identities returned from an auth method validation.
        """
        pulumi.set(__self__, "auth_method", auth_method)
        pulumi.set(__self__, "bind_name", bind_name)
        pulumi.set(__self__, "bind_type", bind_type)
        if bind_vars is not None:
            pulumi.set(__self__, "bind_vars", bind_vars)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the ACL auth method this rule apply.
        """
        return pulumi.get(self, "auth_method")

    @auth_method.setter
    def auth_method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "auth_method", value)

    @_builtins.property
    @pulumi.getter(name="bindName")
    def bind_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name to bind to a token at login-time.
        """
        return pulumi.get(self, "bind_name")

    @bind_name.setter
    def bind_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bind_name", value)

    @_builtins.property
    @pulumi.getter(name="bindType")
    def bind_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the way the binding rule affects a token created at login.
        """
        return pulumi.get(self, "bind_type")

    @bind_type.setter
    def bind_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bind_type", value)

    @_builtins.property
    @pulumi.getter(name="bindVars")
    def bind_vars(self) -> Optional[pulumi.Input['AclBindingRuleBindVarsArgs']]:
        """
        The variables used when binding rule type is `templated-policy`. Can be lightly templated using HIL `${foo}` syntax from available field names.
        """
        return pulumi.get(self, "bind_vars")

    @bind_vars.setter
    def bind_vars(self, value: Optional[pulumi.Input['AclBindingRuleBindVarsArgs']]):
        pulumi.set(self, "bind_vars", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A free form human readable description of the binding rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to create the binding rule within.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The partition the ACL binding rule is associated with.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expression used to match this rule against valid identities returned from an auth method validation.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class _AclBindingRuleState:
    def __init__(__self__, *,
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_vars: Optional[pulumi.Input['AclBindingRuleBindVarsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 selector: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AclBindingRule resources.
        :param pulumi.Input[_builtins.str] auth_method: The name of the ACL auth method this rule apply.
        :param pulumi.Input[_builtins.str] bind_name: The name to bind to a token at login-time.
        :param pulumi.Input[_builtins.str] bind_type: Specifies the way the binding rule affects a token created at login.
        :param pulumi.Input['AclBindingRuleBindVarsArgs'] bind_vars: The variables used when binding rule type is `templated-policy`. Can be lightly templated using HIL `${foo}` syntax from available field names.
        :param pulumi.Input[_builtins.str] description: A free form human readable description of the binding rule.
        :param pulumi.Input[_builtins.str] namespace: The namespace to create the binding rule within.
        :param pulumi.Input[_builtins.str] partition: The partition the ACL binding rule is associated with.
        :param pulumi.Input[_builtins.str] selector: The expression used to match this rule against valid identities returned from an auth method validation.
        """
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if bind_name is not None:
            pulumi.set(__self__, "bind_name", bind_name)
        if bind_type is not None:
            pulumi.set(__self__, "bind_type", bind_type)
        if bind_vars is not None:
            pulumi.set(__self__, "bind_vars", bind_vars)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ACL auth method this rule apply.
        """
        return pulumi.get(self, "auth_method")

    @auth_method.setter
    def auth_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_method", value)

    @_builtins.property
    @pulumi.getter(name="bindName")
    def bind_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name to bind to a token at login-time.
        """
        return pulumi.get(self, "bind_name")

    @bind_name.setter
    def bind_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bind_name", value)

    @_builtins.property
    @pulumi.getter(name="bindType")
    def bind_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the way the binding rule affects a token created at login.
        """
        return pulumi.get(self, "bind_type")

    @bind_type.setter
    def bind_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bind_type", value)

    @_builtins.property
    @pulumi.getter(name="bindVars")
    def bind_vars(self) -> Optional[pulumi.Input['AclBindingRuleBindVarsArgs']]:
        """
        The variables used when binding rule type is `templated-policy`. Can be lightly templated using HIL `${foo}` syntax from available field names.
        """
        return pulumi.get(self, "bind_vars")

    @bind_vars.setter
    def bind_vars(self, value: Optional[pulumi.Input['AclBindingRuleBindVarsArgs']]):
        pulumi.set(self, "bind_vars", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A free form human readable description of the binding rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to create the binding rule within.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The partition the ACL binding rule is associated with.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expression used to match this rule against valid identities returned from an auth method validation.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "selector", value)


@pulumi.type_token("consul:index/aclBindingRule:AclBindingRule")
class AclBindingRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_vars: Optional[pulumi.Input[Union['AclBindingRuleBindVarsArgs', 'AclBindingRuleBindVarsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 selector: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Starting with Consul 1.5.0, the AclBindingRule resource can be used to managed Consul ACL binding rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        minikube = consul.AclAuthMethod("minikube",
            name="minikube",
            type="kubernetes",
            description="dev minikube cluster",
            config={
                "Host": "https://192.0.2.42:8443",
                "CACert": \"\"\"-----BEGIN CERTIFICATE-----
        ...-----END CERTIFICATE-----
        \"\"\",
                "ServiceAccountJWT": "eyJhbGciOiJSUzI1NiIsImtpZCI6IiJ9...",
            })
        test = consul.AclBindingRule("test",
            auth_method=minikube.name,
            description="foobar",
            selector="serviceaccount.namespace==default",
            bind_type="service",
            bind_name="minikube")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_method: The name of the ACL auth method this rule apply.
        :param pulumi.Input[_builtins.str] bind_name: The name to bind to a token at login-time.
        :param pulumi.Input[_builtins.str] bind_type: Specifies the way the binding rule affects a token created at login.
        :param pulumi.Input[Union['AclBindingRuleBindVarsArgs', 'AclBindingRuleBindVarsArgsDict']] bind_vars: The variables used when binding rule type is `templated-policy`. Can be lightly templated using HIL `${foo}` syntax from available field names.
        :param pulumi.Input[_builtins.str] description: A free form human readable description of the binding rule.
        :param pulumi.Input[_builtins.str] namespace: The namespace to create the binding rule within.
        :param pulumi.Input[_builtins.str] partition: The partition the ACL binding rule is associated with.
        :param pulumi.Input[_builtins.str] selector: The expression used to match this rule against valid identities returned from an auth method validation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclBindingRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Starting with Consul 1.5.0, the AclBindingRule resource can be used to managed Consul ACL binding rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        minikube = consul.AclAuthMethod("minikube",
            name="minikube",
            type="kubernetes",
            description="dev minikube cluster",
            config={
                "Host": "https://192.0.2.42:8443",
                "CACert": \"\"\"-----BEGIN CERTIFICATE-----
        ...-----END CERTIFICATE-----
        \"\"\",
                "ServiceAccountJWT": "eyJhbGciOiJSUzI1NiIsImtpZCI6IiJ9...",
            })
        test = consul.AclBindingRule("test",
            auth_method=minikube.name,
            description="foobar",
            selector="serviceaccount.namespace==default",
            bind_type="service",
            bind_name="minikube")
        ```

        :param str resource_name: The name of the resource.
        :param AclBindingRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclBindingRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_vars: Optional[pulumi.Input[Union['AclBindingRuleBindVarsArgs', 'AclBindingRuleBindVarsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 selector: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclBindingRuleArgs.__new__(AclBindingRuleArgs)

            if auth_method is None and not opts.urn:
                raise TypeError("Missing required property 'auth_method'")
            __props__.__dict__["auth_method"] = auth_method
            if bind_name is None and not opts.urn:
                raise TypeError("Missing required property 'bind_name'")
            __props__.__dict__["bind_name"] = bind_name
            if bind_type is None and not opts.urn:
                raise TypeError("Missing required property 'bind_type'")
            __props__.__dict__["bind_type"] = bind_type
            __props__.__dict__["bind_vars"] = bind_vars
            __props__.__dict__["description"] = description
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["partition"] = partition
            __props__.__dict__["selector"] = selector
        super(AclBindingRule, __self__).__init__(
            'consul:index/aclBindingRule:AclBindingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_method: Optional[pulumi.Input[_builtins.str]] = None,
            bind_name: Optional[pulumi.Input[_builtins.str]] = None,
            bind_type: Optional[pulumi.Input[_builtins.str]] = None,
            bind_vars: Optional[pulumi.Input[Union['AclBindingRuleBindVarsArgs', 'AclBindingRuleBindVarsArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            partition: Optional[pulumi.Input[_builtins.str]] = None,
            selector: Optional[pulumi.Input[_builtins.str]] = None) -> 'AclBindingRule':
        """
        Get an existing AclBindingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_method: The name of the ACL auth method this rule apply.
        :param pulumi.Input[_builtins.str] bind_name: The name to bind to a token at login-time.
        :param pulumi.Input[_builtins.str] bind_type: Specifies the way the binding rule affects a token created at login.
        :param pulumi.Input[Union['AclBindingRuleBindVarsArgs', 'AclBindingRuleBindVarsArgsDict']] bind_vars: The variables used when binding rule type is `templated-policy`. Can be lightly templated using HIL `${foo}` syntax from available field names.
        :param pulumi.Input[_builtins.str] description: A free form human readable description of the binding rule.
        :param pulumi.Input[_builtins.str] namespace: The namespace to create the binding rule within.
        :param pulumi.Input[_builtins.str] partition: The partition the ACL binding rule is associated with.
        :param pulumi.Input[_builtins.str] selector: The expression used to match this rule against valid identities returned from an auth method validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclBindingRuleState.__new__(_AclBindingRuleState)

        __props__.__dict__["auth_method"] = auth_method
        __props__.__dict__["bind_name"] = bind_name
        __props__.__dict__["bind_type"] = bind_type
        __props__.__dict__["bind_vars"] = bind_vars
        __props__.__dict__["description"] = description
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["partition"] = partition
        __props__.__dict__["selector"] = selector
        return AclBindingRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the ACL auth method this rule apply.
        """
        return pulumi.get(self, "auth_method")

    @_builtins.property
    @pulumi.getter(name="bindName")
    def bind_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name to bind to a token at login-time.
        """
        return pulumi.get(self, "bind_name")

    @_builtins.property
    @pulumi.getter(name="bindType")
    def bind_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the way the binding rule affects a token created at login.
        """
        return pulumi.get(self, "bind_type")

    @_builtins.property
    @pulumi.getter(name="bindVars")
    def bind_vars(self) -> pulumi.Output[Optional['outputs.AclBindingRuleBindVars']]:
        """
        The variables used when binding rule type is `templated-policy`. Can be lightly templated using HIL `${foo}` syntax from available field names.
        """
        return pulumi.get(self, "bind_vars")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A free form human readable description of the binding rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to create the binding rule within.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The partition the ACL binding rule is associated with.
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The expression used to match this rule against valid identities returned from an auth method validation.
        """
        return pulumi.get(self, "selector")

