# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

import types

__config__ = pulumi.Config('consul')


class _ExportableConfig(types.ModuleType):
    @_builtins.property
    def address(self) -> Optional[str]:
        """
        The HTTP(S) API address of the agent to use. Defaults to "127.0.0.1:8500".
        """
        return __config__.get('address')

    @_builtins.property
    def auth_jwt(self) -> Optional[str]:
        """
        Authenticates to Consul using a JWT authentication method.
        """
        return __config__.get('authJwt')

    @_builtins.property
    def ca_file(self) -> Optional[str]:
        """
        A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return __config__.get('caFile')

    @_builtins.property
    def ca_path(self) -> Optional[str]:
        """
        A path to a directory of PEM-encoded certificate authority files to use to check the authenticity of client and server
        connections. Can also be specified with the `CONSUL_CAPATH` environment variable.
        """
        return __config__.get('caPath')

    @_builtins.property
    def ca_pem(self) -> Optional[str]:
        """
        PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return __config__.get('caPem')

    @_builtins.property
    def cert_file(self) -> Optional[str]:
        """
        A path to a PEM-encoded certificate provided to the remote agent; requires use of `key_file` or `key_pem`.
        """
        return __config__.get('certFile')

    @_builtins.property
    def cert_pem(self) -> Optional[str]:
        """
        PEM-encoded certificate provided to the remote agent; requires use of `key_file` or `key_pem`.
        """
        return __config__.get('certPem')

    @_builtins.property
    def datacenter(self) -> Optional[str]:
        """
        The datacenter to use. Defaults to that of the agent.
        """
        return __config__.get('datacenter')

    @_builtins.property
    def headers(self) -> Optional[str]:
        """
        A configuration block, described below, that provides additional headers to be sent along with all requests to the
        Consul server. This block can be specified multiple times.
        """
        return __config__.get('headers')

    @_builtins.property
    def http_auth(self) -> Optional[str]:
        """
        HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either `user` or
        `user:pass`. This may also be specified using the `CONSUL_HTTP_AUTH` environment variable.
        """
        return __config__.get('httpAuth')

    @_builtins.property
    def insecure_https(self) -> Optional[bool]:
        """
        Boolean value to disable SSL certificate verification; setting this value to true is not recommended for production use.
        Only use this with scheme set to "https".
        """
        return __config__.get_bool('insecureHttps')

    @_builtins.property
    def key_file(self) -> Optional[str]:
        """
        A path to a PEM-encoded private key, required if `cert_file` or `cert_pem` is specified.
        """
        return __config__.get('keyFile')

    @_builtins.property
    def key_pem(self) -> Optional[str]:
        """
        PEM-encoded private key, required if `cert_file` or `cert_pem` is specified.
        """
        return __config__.get('keyPem')

    @_builtins.property
    def namespace(self) -> Optional[str]:
        return __config__.get('namespace')

    @_builtins.property
    def scheme(self) -> Optional[str]:
        """
        The URL scheme of the agent to use ("http" or "https"). Defaults to "http".
        """
        return __config__.get('scheme')

    @_builtins.property
    def token(self) -> Optional[str]:
        """
        The ACL token to use by default when making requests to the agent. Can also be specified with `CONSUL_HTTP_TOKEN` or
        `CONSUL_TOKEN` as an environment variable.
        """
        return __config__.get('token')

