# <img src="https://raw.githubusercontent.com/pylhc/pylhc.github.io/master/docs/assets/logos/OMC_logo.svg" height="28" alt="omc3 logo"> PyLHC Tools

[![Tests](https://github.com/pylhc/PyLHC/actions/workflows/coverage.yml/badge.svg?branch=master)](https://github.com/pylhc/PyLHC/actions/workflows/coverage.yml)
[![GitHub last commit](https://img.shields.io/github/last-commit/pylhc/PyLHC.svg?style=popout)](https://github.com/pylhc/PyLHC/)
[![PyPI Version](https://img.shields.io/pypi/v/PyLHC?label=PyPI&logo=pypi)](https://pypi.org/project/PyLHC/)
[![GitHub release](https://img.shields.io/github/release/pylhc/PyLHC.svg?style=popout)](https://github.com/pylhc/PyLHC/)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.5643602.svg)](https://doi.org/10.5281/zenodo.5643602)

This package provides tools for particle accelerator physics complementing the optics measurement analysis tools of the [omc3 package](https://github.com/pylhc/omc3).
It is a collection of useful scripts for the Optics Measurements and Corrections team (OMC) at CERN, with functionality for data analysis, corrections calculation, simulations management and machine information extraction.

## Documentation

- Autogenerated docs via `Sphinx` can be found at <https://pylhc.github.io/PyLHC/>.
- General documentation of the OMC-Team is located at <https://pylhc.github.io/>

## Installing

This package is `Python 3.7+` compatible, and can be installed through `pip`:

```bash
python -m pip install pylhc
```

After installing, scripts can be run with either `python -m pylhc.SCRIPT --FLAG ARGUMENT` or by calling the Python files directly.

For development purposes, we recommend creating a new virtual environment and installing from VCS in editable mode with all extra dependencies:

```bash
git clone https://github.com/pylhc/pylhc
python -m pip install --editable "pylhc[all]"
```

**Note:** Some scripts access functionality only available on the CERN Technical Network.
To use those, you should make sure to install the relevant extra dependencies with `python -m pip install "pylhc[cern]"`.

## Functionality

- `Forced DA Analysis` - Script to analyze forced DA. ([**forced_da_analysis.py**](pylhc/forced_da_analysis.py))
- `Machine Settings Info` - Prints an overview over the machine settings at a given time. ([**machine_settings_info.py**](pylhc/machine_settings_info.py))
- `KickGroup Information` - Get information about KickGroups. ([**kickgroups.py**](pylhc/kickgroups.py))
- `BSRT Logger` and `BSRT Analysis` - Saves data coming straight from LHC BSRT FESA class and allows subsequent analysis. ([**bsrt_logger.py**](pylhc/bsrt_logger.py) & [**bsrt_analysis.py**](pylhc/bsrt_analysis.py) )
- `BPM Calibration Factors` - Compute the BPM calibration factors using ballistic optics. Two methods are available: using the beta function and using the dispersion. ([**bpm_calibration.py**](pylhc/bpm_calibration.py))

## License

This project is licensed under the `MIT` License - see the [LICENSE](LICENSE) file for details.
