"""
VCell API

VCell API

The version of the OpenAPI document: 1.0.1
Contact: vcell_support@uchc.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing_extensions import Self

from pyvcell._internal.api.vcell_client.models.key_value import KeyValue


class BioModel(BaseModel):
    """
    BioModel
    """

    bm_key: Optional[StrictStr] = Field(default=None, alias="bmKey")
    name: Optional[StrictStr] = None
    privacy: Optional[StrictInt] = None
    group_users: Optional[List[StrictStr]] = Field(default=None, alias="groupUsers")
    saved_date: Optional[StrictInt] = Field(default=None, alias="savedDate")
    annot: Optional[StrictStr] = None
    branch_id: Optional[StrictStr] = Field(default=None, alias="branchID")
    phys_model_key: Optional[StrictStr] = Field(default=None, alias="physModelKey")
    owner_name: Optional[StrictStr] = Field(default=None, alias="ownerName")
    owner_key: Optional[StrictStr] = Field(default=None, alias="ownerKey")
    simulation_key_list: Optional[List[KeyValue]] = Field(default=None, alias="simulationKeyList")
    applications: Optional[List[Dict[str, Any]]] = None
    __properties: ClassVar[List[str]] = [
        "bmKey",
        "name",
        "privacy",
        "groupUsers",
        "savedDate",
        "annot",
        "branchID",
        "physModelKey",
        "ownerName",
        "ownerKey",
        "simulationKeyList",
        "applications",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BioModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in simulation_key_list (list)
        _items = []
        if self.simulation_key_list:
            for _item_simulation_key_list in self.simulation_key_list:
                if _item_simulation_key_list:
                    _items.append(_item_simulation_key_list.to_dict())
            _dict["simulationKeyList"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BioModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in BioModel) in the input: " + _key)

        _obj = cls.model_validate({
            "bmKey": obj.get("bmKey"),
            "name": obj.get("name"),
            "privacy": obj.get("privacy"),
            "groupUsers": obj.get("groupUsers"),
            "savedDate": obj.get("savedDate"),
            "annot": obj.get("annot"),
            "branchID": obj.get("branchID"),
            "physModelKey": obj.get("physModelKey"),
            "ownerName": obj.get("ownerName"),
            "ownerKey": obj.get("ownerKey"),
            "simulationKeyList": [KeyValue.from_dict(_item) for _item in obj["simulationKeyList"]]
            if obj.get("simulationKeyList") is not None
            else None,
            "applications": obj.get("applications"),
        })
        return _obj
