"""
VCell API

VCell API

The version of the OpenAPI document: 1.0.1
Contact: vcell_support@uchc.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing_extensions import Self

from pyvcell._internal.api.vcell_client.models.domain import Domain
from pyvcell._internal.api.vcell_client.models.variable_type import VariableType


class DataIdentifier(BaseModel):
    """
    DataIdentifier
    """

    name: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    variable_type: Optional[VariableType] = Field(default=None, alias="variableType")
    domain: Optional[Domain] = None
    b_function: Optional[StrictBool] = Field(default=None, alias="bFunction")
    function: Optional[StrictBool] = None
    visible: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = [
        "name",
        "displayName",
        "variableType",
        "domain",
        "bFunction",
        "function",
        "visible",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataIdentifier from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of variable_type
        if self.variable_type:
            _dict["variableType"] = self.variable_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domain
        if self.domain:
            _dict["domain"] = self.domain.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataIdentifier from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in DataIdentifier) in the input: " + _key)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "displayName": obj.get("displayName"),
            "variableType": VariableType.from_dict(obj["variableType"])
            if obj.get("variableType") is not None
            else None,
            "domain": Domain.from_dict(obj["domain"]) if obj.get("domain") is not None else None,
            "bFunction": obj.get("bFunction"),
            "function": obj.get("function"),
            "visible": obj.get("visible"),
        })
        return _obj
