"""
VCell API

VCell API

The version of the OpenAPI document: 1.0.1
Contact: vcell_support@uchc.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set, Union

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing_extensions import Self

from pyvcell._internal.api.vcell_client.models.data_identifier import DataIdentifier
from pyvcell._internal.api.vcell_client.models.extent import Extent
from pyvcell._internal.api.vcell_client.models.i_size import ISize
from pyvcell._internal.api.vcell_client.models.origin import Origin


class FieldDataShape(BaseModel):
    """
    FieldDataShape
    """

    extent: Optional[Extent] = None
    origin: Optional[Origin] = None
    isize: Optional[ISize] = None
    data_identifier: Optional[List[DataIdentifier]] = Field(default=None, alias="dataIdentifier")
    times: Optional[List[Union[StrictFloat, StrictInt]]] = None
    __properties: ClassVar[List[str]] = ["extent", "origin", "isize", "dataIdentifier", "times"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FieldDataShape from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of extent
        if self.extent:
            _dict["extent"] = self.extent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of origin
        if self.origin:
            _dict["origin"] = self.origin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of isize
        if self.isize:
            _dict["isize"] = self.isize.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in data_identifier (list)
        _items = []
        if self.data_identifier:
            for _item_data_identifier in self.data_identifier:
                if _item_data_identifier:
                    _items.append(_item_data_identifier.to_dict())
            _dict["dataIdentifier"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FieldDataShape from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in FieldDataShape) in the input: " + _key)

        _obj = cls.model_validate({
            "extent": Extent.from_dict(obj["extent"]) if obj.get("extent") is not None else None,
            "origin": Origin.from_dict(obj["origin"]) if obj.get("origin") is not None else None,
            "isize": ISize.from_dict(obj["isize"]) if obj.get("isize") is not None else None,
            "dataIdentifier": [DataIdentifier.from_dict(_item) for _item in obj["dataIdentifier"]]
            if obj.get("dataIdentifier") is not None
            else None,
            "times": obj.get("times"),
        })
        return _obj
