"""
VCell API

VCell API

The version of the OpenAPI document: 1.0.1
Contact: vcell_support@uchc.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing_extensions import Self

from pyvcell._internal.api.vcell_client.models.scheduler_status import SchedulerStatus
from pyvcell._internal.api.vcell_client.models.simulation_execution_status_record import SimulationExecutionStatusRecord
from pyvcell._internal.api.vcell_client.models.simulation_message import SimulationMessage
from pyvcell._internal.api.vcell_client.models.simulation_queue_entry_status_record import (
    SimulationQueueEntryStatusRecord,
)
from pyvcell._internal.api.vcell_client.models.vc_simulation_identifier import VCSimulationIdentifier


class SimulationJobStatusRecord(BaseModel):
    """
    SimulationJobStatusRecord
    """

    field_time_data_stamp: Optional[datetime] = Field(default=None, alias="fieldTimeDataStamp")
    field_vc_sim_id: Optional[VCSimulationIdentifier] = Field(default=None, alias="fieldVCSimID")
    field_submit_date: Optional[datetime] = Field(default=None, alias="fieldSubmitDate")
    field_scheduler_status: Optional[SchedulerStatus] = Field(default=None, alias="fieldSchedulerStatus")
    field_simulation_message: Optional[SimulationMessage] = Field(default=None, alias="fieldSimulationMessage")
    field_task_id: Optional[StrictInt] = Field(default=None, alias="fieldTaskID")
    field_server_id: Optional[StrictStr] = Field(default=None, alias="fieldServerID")
    field_job_index: Optional[StrictInt] = Field(default=None, alias="fieldJobIndex")
    field_simulation_execution_status: Optional[SimulationExecutionStatusRecord] = Field(
        default=None, alias="fieldSimulationExecutionStatus"
    )
    field_simulation_queue_entry_status: Optional[SimulationQueueEntryStatusRecord] = Field(
        default=None, alias="fieldSimulationQueueEntryStatus"
    )
    __properties: ClassVar[List[str]] = [
        "fieldTimeDataStamp",
        "fieldVCSimID",
        "fieldSubmitDate",
        "fieldSchedulerStatus",
        "fieldSimulationMessage",
        "fieldTaskID",
        "fieldServerID",
        "fieldJobIndex",
        "fieldSimulationExecutionStatus",
        "fieldSimulationQueueEntryStatus",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SimulationJobStatusRecord from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of field_vc_sim_id
        if self.field_vc_sim_id:
            _dict["fieldVCSimID"] = self.field_vc_sim_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of field_simulation_message
        if self.field_simulation_message:
            _dict["fieldSimulationMessage"] = self.field_simulation_message.to_dict()
        # override the default output from pydantic by calling `to_dict()` of field_simulation_execution_status
        if self.field_simulation_execution_status:
            _dict["fieldSimulationExecutionStatus"] = self.field_simulation_execution_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of field_simulation_queue_entry_status
        if self.field_simulation_queue_entry_status:
            _dict["fieldSimulationQueueEntryStatus"] = self.field_simulation_queue_entry_status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SimulationJobStatusRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError(
                    "Error due to additional fields (not defined in SimulationJobStatusRecord) in the input: " + _key
                )

        _obj = cls.model_validate({
            "fieldTimeDataStamp": obj.get("fieldTimeDataStamp"),
            "fieldVCSimID": VCSimulationIdentifier.from_dict(obj["fieldVCSimID"])
            if obj.get("fieldVCSimID") is not None
            else None,
            "fieldSubmitDate": obj.get("fieldSubmitDate"),
            "fieldSchedulerStatus": obj.get("fieldSchedulerStatus"),
            "fieldSimulationMessage": SimulationMessage.from_dict(obj["fieldSimulationMessage"])
            if obj.get("fieldSimulationMessage") is not None
            else None,
            "fieldTaskID": obj.get("fieldTaskID"),
            "fieldServerID": obj.get("fieldServerID"),
            "fieldJobIndex": obj.get("fieldJobIndex"),
            "fieldSimulationExecutionStatus": SimulationExecutionStatusRecord.from_dict(
                obj["fieldSimulationExecutionStatus"]
            )
            if obj.get("fieldSimulationExecutionStatus") is not None
            else None,
            "fieldSimulationQueueEntryStatus": SimulationQueueEntryStatusRecord.from_dict(
                obj["fieldSimulationQueueEntryStatus"]
            )
            if obj.get("fieldSimulationQueueEntryStatus") is not None
            else None,
        })
        return _obj
