# vcell-api

VCell API

The `pyvcell._internal.api.vcell_client` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.1
- Package version: 1.0.0
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
  For more information, please visit [http://exampleurl.com/contact](http://exampleurl.com/contact)

## Requirements.

Python 3.8+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

- urllib3 >= 1.25.3, < 3.0.0
- python-dateutil >= 2.8.2
- pydantic >= 2
- typing-extensions >= 4.7.1

## Getting Started

In your own code, to use this library to connect and interact with vcell-api,
you can run the following:

```python

import pyvcell._internal.api.vcell_client
from pyvcell._internal.api.vcell_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://vcell-dev.cam.uchc.edu
# See configuration.py for a list of all supported configuration parameters.
configuration = pyvcell._internal.api.vcell_client.Configuration(
    host="https://vcell-dev.cam.uchc.edu"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.


# Enter a context with an instance of the API client
with pyvcell._internal.api.vcell_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pyvcell._internal.api.vcell_client.AdminResourceApi(api_client)

    try:
        # Get usage summary
        api_response = api_instance.get_usage()
        print("The response of AdminResourceApi->get_usage:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AdminResourceApi->get_usage: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://vcell-dev.cam.uchc.edu*

| Class                    | Method                                                                                                                                      | HTTP request                                               | Description                                                                                                           |
| ------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------- |
| _AdminResourceApi_       | [**get_usage**](pyvcell/core/api/vcell_client/docs/AdminResourceApi.md#get_usage)                                                           | **GET** /api/v1/admin/usage                                | Get usage summary                                                                                                     |
| _BioModelResourceApi_    | [**delete_bio_model**](pyvcell/core/api/vcell_client/docs/BioModelResourceApi.md#delete_bio_model)                                          | **DELETE** /api/v1/bioModel/{bioModelID}                   | Delete the BioModel from VCell&#39;s database.                                                                        |
| _BioModelResourceApi_    | [**get_biomodel_by_id**](pyvcell/core/api/vcell_client/docs/BioModelResourceApi.md#get_biomodel_by_id)                                      | **GET** /api/v1/bioModel/{bioModelID}                      | Get BioModel information in JSON format by ID.                                                                        |
| _BioModelResourceApi_    | [**upload_bio_model**](pyvcell/core/api/vcell_client/docs/BioModelResourceApi.md#upload_bio_model)                                          | **POST** /api/v1/bioModel/upload_bioModel                  | Upload the BioModel to VCell database. Returns BioModel ID.                                                           |
| _FieldDataResourceApi_   | [**analyze_field_data_file**](pyvcell/core/api/vcell_client/docs/FieldDataResourceApi.md#analyze_field_data_file)                           | **POST** /api/v1/fieldData/analyzeFieldDataFile            | Analyze the field data from the uploaded file. Filenames must be lowercase alphanumeric, and can contain underscores. |
| _FieldDataResourceApi_   | [**create_field_data_from_analyzed_file**](pyvcell/core/api/vcell_client/docs/FieldDataResourceApi.md#create_field_data_from_analyzed_file) | **POST** /api/v1/fieldData/createFieldDataFromAnalyzedFile | Take the analyzed results of the field data, modify it to your liking, then save it on the server.                    |
| _FieldDataResourceApi_   | [**delete_field_data**](pyvcell/core/api/vcell_client/docs/FieldDataResourceApi.md#delete_field_data)                                       | **DELETE** /api/v1/fieldData/delete/{fieldDataID}          | Delete the selected field data.                                                                                       |
| _FieldDataResourceApi_   | [**get_all_field_data_ids**](pyvcell/core/api/vcell_client/docs/FieldDataResourceApi.md#get_all_field_data_ids)                             | **GET** /api/v1/fieldData/IDs                              | Get all of the ids used to identify, and retrieve field data.                                                         |
| _FieldDataResourceApi_   | [**get_field_data_shape_from_id**](pyvcell/core/api/vcell_client/docs/FieldDataResourceApi.md#get_field_data_shape_from_id)                 | **GET** /api/v1/fieldData/fieldDataShape/{fieldDataID}     | Get the shape of the field data. That is it&#39;s size, origin, extent, and data identifiers.                         |
| _HelloWorldApi_          | [**get_hello_world**](pyvcell/core/api/vcell_client/docs/HelloWorldApi.md#get_hello_world)                                                  | **GET** /api/v1/helloworld                                 | Get hello world message.                                                                                              |
| _PublicationResourceApi_ | [**create_publication**](pyvcell/core/api/vcell_client/docs/PublicationResourceApi.md#create_publication)                                   | **POST** /api/v1/publications                              | Create publication                                                                                                    |
| _PublicationResourceApi_ | [**delete_publication**](pyvcell/core/api/vcell_client/docs/PublicationResourceApi.md#delete_publication)                                   | **DELETE** /api/v1/publications/{id}                       | Delete publication                                                                                                    |
| _PublicationResourceApi_ | [**get_publication_by_id**](pyvcell/core/api/vcell_client/docs/PublicationResourceApi.md#get_publication_by_id)                             | **GET** /api/v1/publications/{id}                          | Get publication by ID                                                                                                 |
| _PublicationResourceApi_ | [**get_publications**](pyvcell/core/api/vcell_client/docs/PublicationResourceApi.md#get_publications)                                       | **GET** /api/v1/publications                               | Get all publications                                                                                                  |
| _PublicationResourceApi_ | [**update_publication**](pyvcell/core/api/vcell_client/docs/PublicationResourceApi.md#update_publication)                                   | **PUT** /api/v1/publications                               | Update publication                                                                                                    |
| _SimulationResourceApi_  | [**get_simulation_status**](pyvcell/core/api/vcell_client/docs/SimulationResourceApi.md#get_simulation_status)                              | **GET** /api/v1/Simulation/{simID}/simulationStatus        | Get the status of simulation running                                                                                  |
| _SimulationResourceApi_  | [**start_simulation**](pyvcell/core/api/vcell_client/docs/SimulationResourceApi.md#start_simulation)                                        | **POST** /api/v1/Simulation/{simID}/startSimulation        | Start a simulation.                                                                                                   |
| _SimulationResourceApi_  | [**stop_simulation**](pyvcell/core/api/vcell_client/docs/SimulationResourceApi.md#stop_simulation)                                          | **POST** /api/v1/Simulation/{simID}/stopSimulation         | Stop a simulation.                                                                                                    |
| _SolverResourceApi_      | [**get_fv_solver_input_from_sbml**](pyvcell/core/api/vcell_client/docs/SolverResourceApi.md#get_fv_solver_input_from_sbml)                  | **POST** /api/v1/solver/getFVSolverInput                   | Retrieve finite volume input from SBML spatial model.                                                                 |
| _SolverResourceApi_      | [**get_fv_solver_input_from_vcml**](pyvcell/core/api/vcell_client/docs/SolverResourceApi.md#get_fv_solver_input_from_vcml)                  | **POST** /api/v1/solver/getFVSolverInputFromVCML           | Retrieve finite volume input from SBML spatial model.                                                                 |
| _UsersResourceApi_       | [**forgot_legacy_password**](pyvcell/core/api/vcell_client/docs/UsersResourceApi.md#forgot_legacy_password)                                 | **POST** /api/v1/users/forgotLegacyPassword                | The end user has forgotten the legacy password they used for VCell, so they will be emailed it.                       |
| _UsersResourceApi_       | [**get_guest_legacy_api_token**](pyvcell/core/api/vcell_client/docs/UsersResourceApi.md#get_guest_legacy_api_token)                         | **POST** /api/v1/users/guestBearerToken                    | Method to get legacy tokens for guest users                                                                           |
| _UsersResourceApi_       | [**get_legacy_api_token**](pyvcell/core/api/vcell_client/docs/UsersResourceApi.md#get_legacy_api_token)                                     | **POST** /api/v1/users/bearerToken                         | Get token for legacy API                                                                                              |
| _UsersResourceApi_       | [**get_mapped_user**](pyvcell/core/api/vcell_client/docs/UsersResourceApi.md#get_mapped_user)                                               | **GET** /api/v1/users/mappedUser                           | Get mapped VCell identity                                                                                             |
| _UsersResourceApi_       | [**get_me**](pyvcell/core/api/vcell_client/docs/UsersResourceApi.md#get_me)                                                                 | **GET** /api/v1/users/me                                   | Get current user                                                                                                      |
| _UsersResourceApi_       | [**map_new_user**](pyvcell/core/api/vcell_client/docs/UsersResourceApi.md#map_new_user)                                                     | **POST** /api/v1/users/newUser                             | create vcell user                                                                                                     |
| _UsersResourceApi_       | [**map_user**](pyvcell/core/api/vcell_client/docs/UsersResourceApi.md#map_user)                                                             | **POST** /api/v1/users/mapUser                             | map vcell user                                                                                                        |
| _UsersResourceApi_       | [**process_magic_link**](pyvcell/core/api/vcell_client/docs/UsersResourceApi.md#process_magic_link)                                         | **GET** /api/v1/users/processMagicLink                     | Process the magic link and map the user                                                                               |
| _UsersResourceApi_       | [**request_recovery_email**](pyvcell/core/api/vcell_client/docs/UsersResourceApi.md#request_recovery_email)                                 | **POST** /api/v1/users/requestRecoveryEmail                | request a recovery email to link a VCell account.                                                                     |
| _UsersResourceApi_       | [**unmap_user**](pyvcell/core/api/vcell_client/docs/UsersResourceApi.md#unmap_user)                                                         | **PUT** /api/v1/users/unmapUser/{userName}                 | remove vcell identity mapping                                                                                         |

## Documentation For Models

- [AccesTokenRepresentationRecord](pyvcell/core/api/vcell_client/docs/AccesTokenRepresentationRecord.md)
- [AnalyzedResultsFromFieldData](pyvcell/core/api/vcell_client/docs/AnalyzedResultsFromFieldData.md)
- [BatchSystemType](pyvcell/core/api/vcell_client/docs/BatchSystemType.md)
- [BioModel](pyvcell/core/api/vcell_client/docs/BioModel.md)
- [BiomodelRef](pyvcell/core/api/vcell_client/docs/BiomodelRef.md)
- [DataIdentifier](pyvcell/core/api/vcell_client/docs/DataIdentifier.md)
- [DetailedState](pyvcell/core/api/vcell_client/docs/DetailedState.md)
- [Domain](pyvcell/core/api/vcell_client/docs/Domain.md)
- [Extent](pyvcell/core/api/vcell_client/docs/Extent.md)
- [ExternalDataIdentifier](pyvcell/core/api/vcell_client/docs/ExternalDataIdentifier.md)
- [FieldDataReference](pyvcell/core/api/vcell_client/docs/FieldDataReference.md)
- [FieldDataSaveResults](pyvcell/core/api/vcell_client/docs/FieldDataSaveResults.md)
- [FieldDataShape](pyvcell/core/api/vcell_client/docs/FieldDataShape.md)
- [HelloWorldMessage](pyvcell/core/api/vcell_client/docs/HelloWorldMessage.md)
- [HtcJobID](pyvcell/core/api/vcell_client/docs/HtcJobID.md)
- [ISize](pyvcell/core/api/vcell_client/docs/ISize.md)
- [Identity](pyvcell/core/api/vcell_client/docs/Identity.md)
- [KeyValue](pyvcell/core/api/vcell_client/docs/KeyValue.md)
- [MathmodelRef](pyvcell/core/api/vcell_client/docs/MathmodelRef.md)
- [Origin](pyvcell/core/api/vcell_client/docs/Origin.md)
- [Publication](pyvcell/core/api/vcell_client/docs/Publication.md)
- [SchedulerStatus](pyvcell/core/api/vcell_client/docs/SchedulerStatus.md)
- [SimulationExecutionStatusRecord](pyvcell/core/api/vcell_client/docs/SimulationExecutionStatusRecord.md)
- [SimulationJobStatusRecord](pyvcell/core/api/vcell_client/docs/SimulationJobStatusRecord.md)
- [SimulationMessage](pyvcell/core/api/vcell_client/docs/SimulationMessage.md)
- [SimulationQueueEntryStatusRecord](pyvcell/core/api/vcell_client/docs/SimulationQueueEntryStatusRecord.md)
- [SimulationQueueID](pyvcell/core/api/vcell_client/docs/SimulationQueueID.md)
- [SimulationStatusPersistentRecord](pyvcell/core/api/vcell_client/docs/SimulationStatusPersistentRecord.md)
- [Status](pyvcell/core/api/vcell_client/docs/Status.md)
- [StatusMessage](pyvcell/core/api/vcell_client/docs/StatusMessage.md)
- [User](pyvcell/core/api/vcell_client/docs/User.md)
- [UserIdentityJSONSafe](pyvcell/core/api/vcell_client/docs/UserIdentityJSONSafe.md)
- [UserLoginInfoForMapping](pyvcell/core/api/vcell_client/docs/UserLoginInfoForMapping.md)
- [UserRegistrationInfo](pyvcell/core/api/vcell_client/docs/UserRegistrationInfo.md)
- [VCSimulationIdentifier](pyvcell/core/api/vcell_client/docs/VCSimulationIdentifier.md)
- [VariableDomain](pyvcell/core/api/vcell_client/docs/VariableDomain.md)
- [VariableType](pyvcell/core/api/vcell_client/docs/VariableType.md)

<a id="documentation-for-authorization"></a>

## Documentation For Authorization

Authentication schemes defined for the API:
<a id="openId"></a>

### openId

## Author

vcell_support@uchc.com
