import React, { memo } from 'react'

interface PropsLogoSqlMesh extends React.SVGAttributes<SVGAElement> {}

function LogoSqlMesh({ style, className }: PropsLogoSqlMesh): JSX.Element {
  return (
    <svg
      style={style}
      className={className}
      viewBox="0 0 246 56"
      fill="none"
      role="img"
      aria-labelledby="sqlmeshTitle"
      xmlns="http://www.w3.org/2000/svg"
    >
      <title id="sqlmeshTitle">SQLMesh logo</title>
      <path
        d="M75.6874 37.4246L79.5901 34.1988C81.5814 37.3051 84.5682 39.0972 87.8338 39.0972C91.0595 39.0972 93.4888 37.6237 93.4888 34.8758C93.4888 31.9687 90.502 31.5704 86.2408 30.535C81.9398 29.4996 77.3202 28.2252 77.3202 22.6498C77.3202 17.3531 81.8601 13.9681 87.6346 13.9681C92.533 13.9681 96.3562 16.2779 98.2677 19.2647L94.5243 22.4905C92.9313 20.0214 90.8206 18.3089 87.4754 18.3089C84.4089 18.3089 82.2982 19.8621 82.2982 22.1321C82.2982 24.641 84.4885 25.1587 88.3515 26.0348C92.9711 27.0703 98.5067 28.1455 98.5067 34.3581C98.5067 39.9734 93.5685 43.4381 87.6745 43.4381C82.7761 43.4381 77.9175 41.0884 75.6874 37.4246ZM100.213 28.7031C100.213 20.0214 105.788 13.9681 113.514 13.9681C121.24 13.9681 126.816 20.0214 126.816 28.7031C126.816 34.0395 124.705 38.3804 121.28 40.969C122.435 42.4823 124.386 43.6372 126.656 44.1947L123.709 47.8187C121.081 47.0621 118.413 45.1107 117.218 42.9204C116.063 43.2788 114.828 43.4381 113.514 43.4381C105.788 43.4381 100.213 37.3848 100.213 28.7031ZM121.718 28.7031C121.718 22.4905 118.333 18.4682 113.514 18.4682C108.695 18.4682 105.31 22.4905 105.31 28.7031C105.31 34.9157 108.695 38.9379 113.514 38.9379C118.333 38.9379 121.718 34.9157 121.718 28.7031ZM130.379 43V14.4061H135.476V38.5397H148.937V43H130.379ZM168.205 43H164.063L156.576 20.8975V43H151.837V14.4061H158.846L166.214 36.3095L173.581 14.4061H180.431V43H175.692V20.8975L168.205 43ZM194.071 43.4381C188.098 43.4381 183.916 39.0176 183.916 32.566C183.916 26.4331 188.058 21.694 193.872 21.694C199.926 21.694 203.151 26.2738 203.151 32.0085V33.6015H188.496C188.854 37.1856 191.005 39.376 194.071 39.376C196.421 39.376 198.293 38.1813 198.93 36.0307L203.032 37.5839C201.558 41.2477 198.253 43.4381 194.071 43.4381ZM193.832 25.7162C191.363 25.7162 189.452 27.1897 188.735 30.0173H198.333C198.293 27.7075 196.859 25.7162 193.832 25.7162ZM204.148 39.0176L207.733 36.1502C208.967 38.1813 211.357 39.5353 213.786 39.5353C215.817 39.5353 217.689 38.8184 217.689 36.9467C217.689 35.1546 215.936 34.9555 212.631 34.2785C209.326 33.6015 205.542 32.7652 205.542 28.3048C205.542 24.4817 208.888 21.694 213.706 21.694C217.37 21.694 220.636 23.3268 222.149 25.6366L218.923 28.5438C217.729 26.672 215.737 25.5968 213.428 25.5968C211.476 25.5968 210.202 26.4729 210.202 27.8668C210.202 29.3801 211.715 29.6589 214.343 30.2164C217.888 30.9731 222.348 31.7297 222.348 36.5086C222.348 40.73 218.485 43.4381 213.746 43.4381C209.883 43.4381 206.02 41.8849 204.148 39.0176ZM225.619 43V14.4061H230.398V24.3224C231.593 22.9285 233.465 21.694 236.173 21.694C240.553 21.694 243.182 24.7206 243.182 29.2208V43H238.403V30.6146C238.403 28.0261 237.368 26.1543 234.739 26.1543C232.589 26.1543 230.398 27.7473 230.398 30.7341V43H225.619Z"
        fill="#0D0D0D"
        className="fill-prose"
      />
      <path
        opacity="0.2"
        d="M29.1758 28.2007V15.7497C29.1758 9.83436 24.3135 5.03906 18.3983 5.03906V5.03906C12.483 5.03906 7.62072 9.83436 7.62072 15.7496V26.7064"
        stroke="#0830F7"
        strokeWidth="4.30769"
      />
      <path
        opacity="0.4"
        d="M50.5964 28.2007V15.7497C50.5964 9.83436 45.8011 5.03906 39.8858 5.03906H18.3308C12.4155 5.03906 7.6202 9.83436 7.6202 15.7496V26.7064"
        stroke="#0830F7"
        strokeWidth="4.30769"
      />
      <path
        d="M29.0398 27.7988V40.2499C29.0398 46.1651 33.902 50.9604 39.8173 50.9604V50.9604C45.7326 50.9604 50.5949 46.1652 50.5949 40.2499V29.2931"
        stroke="#0830F7"
        strokeWidth="4.30769"
      />
      <path
        opacity="0.2"
        d="M7.61914 27.799V40.2501C7.61914 46.1654 12.4144 50.9607 18.3297 50.9607H39.8848C45.8001 50.9607 50.5954 46.1654 50.5954 40.2501V29.2933"
        stroke="#0830F7"
        strokeWidth="4.30769"
      />
      <path
        d="M7.61972 35.1497C11.6126 35.1497 14.8496 31.9129 14.8496 27.9201C14.8496 23.9273 11.6126 20.6904 7.61972 20.6904C3.6268 20.6904 0.389893 23.9273 0.389893 27.9201C0.389893 31.9129 3.6268 35.1497 7.61972 35.1497Z"
        fill="#0830F7"
      />
      <path
        d="M36.3908 27.9201C36.3908 31.9129 33.1539 35.1497 29.161 35.1497C25.1681 35.1497 21.9312 31.9129 21.9312 27.9201C21.9312 23.9273 25.1681 20.6904 29.161 20.6904C33.1539 20.6904 36.3908 23.9273 36.3908 27.9201Z"
        fill="#0830F7"
      />
      <path
        d="M50.5958 35.1497C54.5887 35.1497 57.8256 31.9129 57.8256 27.9201C57.8256 23.9273 54.5887 20.6904 50.5958 20.6904C46.6029 20.6904 43.366 23.9273 43.366 27.9201C43.366 31.9129 46.6029 35.1497 50.5958 35.1497Z"
        fill="#0830F7"
      />
    </svg>
  )
}

export default memo(LogoSqlMesh)
