# Stoobly Agent

[![Release Version](https://img.shields.io/github/v/release/Stoobly/stoobly-agent)](https://github.com/Stoobly/stoobly-agent/releases/latest)
![PyPI](https://img.shields.io/pypi/v/stoobly-agent?color=green)

[![CI](https://github.com/Stoobly/stoobly-agent/actions/workflows/tests.yaml/badge.svg)](https://github.com/Stoobly/stoobly-agent/actions/workflows/tests.yaml)
[![CodeQL](https://github.com/Stoobly/stoobly-agent/actions/workflows/github-code-scanning/codeql/badge.svg)](https://github.com/Stoobly/stoobly-agent/actions/workflows/github-code-scanning/codeql)

⚡ Easily create realistic API mocks by recording HTTP(S) requests.

💡 Maintaining mocks gets expensive. Streamline maintenance with stale mock detection and automated regeneration.

🔨 Minimize regressions of customer workflows with fast and reliable E2E tests.

🚀 Supercharge CI setup with ready-to-go tooling. Reduce CI setup time from two weeks to one day.

See our docs for more detailed information! https://docs.stoobly.com

## Prerequisite

- Python 3.10, 3.11, 3.12

## Installation

To install [see our guides here](https://docs.stoobly.com/getting-started/install-and-run)

## Usage

### Run with both UI and proxy

```
stoobly-agent run
```

### Run with just proxy

```
stoobly-agent run --headless
```

### See available options

```
stoobly-agent --help
```

## Next steps

Easily start creating mock APIs [with this guide](https://docs.stoobly.com/guides/how-to-record-requests)

Or integrate E2E testing [with this guide!](https://docs.stoobly.com/guides/how-to-integrate-e2e-testing)


## Having trouble?

File a new [Github issue here](https://github.com/Stoobly/stoobly-agent/issues) and we'll take a look
