import os

from stoobly_agent.app.cli.scaffold.constants import FIXTURES_FILE_NAME, PUBLIC_FOLDER_NAME

CORE_BUILD_SERVICE_NAME = 'build'
CORE_ENTRYPOINT_SERVICE_NAME = 'entrypoint'
CORE_GATEWAY_SERVICE_NAME = 'gateway'
CORE_MOCK_UI_SERVICE_NAME = 'stoobly-ui'
CORE_SERVICES = [
  CORE_BUILD_SERVICE_NAME, CORE_ENTRYPOINT_SERVICE_NAME, CORE_MOCK_UI_SERVICE_NAME, CORE_GATEWAY_SERVICE_NAME 
]

CORE_MOCK_WORKFLOW = 'mock'
CORE_RECORD_WORKFLOW = 'record'

CUSTOM_BUILD = os.path.join('bin', 'build')
CUSTOM_CONFIGURE = 'configure'
CUSTOM_DOCKER_COMPOSE = 'docker-compose.yml'
CUSTOM_INIT = 'init'
CUSTOM_FIXTURES = FIXTURES_FILE_NAME
CUSTOM_LIFECYCLE_HOOKS = os.path.join('lifecycle_hooks.py')
CUSTOM_PUBLIC_GITIGNORE = os.path.join(PUBLIC_FOLDER_NAME, '.gitignore')
CUSTOM_RUN = 'run'
MAINTAINED_CONFIGURE = '.configure'
MAINTAINED_INIT = '.init'
MAINTAINED_RUN = '.run'

MOCK_WORKFLOW_MAINTAINED_FILES = []

MOCK_WORKFLOW_CUSTOM_FILES = [
  CUSTOM_BUILD,
  CUSTOM_CONFIGURE,
  CUSTOM_FIXTURES,
  CUSTOM_INIT,
  CUSTOM_LIFECYCLE_HOOKS,
  CUSTOM_PUBLIC_GITIGNORE
]

MOCK_WORKFLOW_CUSTOM_LOCAL_FILES = [
  CUSTOM_RUN,
]

MOCK_WORKFLOW_CUSTOM_DOCKER_FILES = [
  CUSTOM_DOCKER_COMPOSE,
]

RECORD_WORKFLOW_MAINTAINED_FILES = []

RECORD_WORKFLOW_CUSTOM_FILES = [
  CUSTOM_BUILD,
  CUSTOM_CONFIGURE,
  CUSTOM_INIT,
  CUSTOM_LIFECYCLE_HOOKS,
]

RECORD_WORKFLOW_CUSTOM_LOCAL_FILES = [
  CUSTOM_RUN,
]

RECORD_WORKFLOW_CUSTOM_DOCKER_FILES = [
  CUSTOM_DOCKER_COMPOSE,
]

TEST_WORKFLOW_MAINTAINED_FILES = []

TEST_WORKFLOW_CUSTOM_FILES = [
  CUSTOM_BUILD,
  CUSTOM_CONFIGURE,
  CUSTOM_FIXTURES,
  CUSTOM_INIT,
  CUSTOM_LIFECYCLE_HOOKS,
  CUSTOM_PUBLIC_GITIGNORE
]

TEST_WORKFLOW_CUSTOM_LOCAL_FILES = [
  CUSTOM_RUN,
]

TEST_WORKFLOW_CUSTOM_DOCKER_FILES = [
  CUSTOM_DOCKER_COMPOSE,
]

SERVICE_HOSTNAME_BUILD_ARG = 'SERVICE_HOSTNAME'
