# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from toastapi.models.alternate_payment_type import AlternatePaymentType

from toastapi.api_client import ApiClient, RequestSerialized
from toastapi.api_response import ApiResponse
from toastapi.rest import RESTResponseType


class AlternatePaymentTypesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def get_alternate_payment_type_by_id(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the alternate payment type is configured for. ")],
        guid: Annotated[StrictStr, Field(description="The Toast POS GUID of the alternative form of payment.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AlternatePaymentType:
        """Get an alternative payment type 

        Returns an `AlternatePaymentType` object containing information about an alternative form of payment configured for a restaurant. Alternate payment types are forms of payment that are not standard in the Toast POS and that are configured for a particular restaurant. For example, a third-party service that processes payments might be configured as an alternate payment type. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the alternate payment type is configured for.  (required)
        :type toast_restaurant_external_id: str
        :param guid: The Toast POS GUID of the alternative form of payment. (required)
        :type guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alternate_payment_type_by_id_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            guid=guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AlternatePaymentType",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_alternate_payment_type_by_id_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the alternate payment type is configured for. ")],
        guid: Annotated[StrictStr, Field(description="The Toast POS GUID of the alternative form of payment.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AlternatePaymentType]:
        """Get an alternative payment type 

        Returns an `AlternatePaymentType` object containing information about an alternative form of payment configured for a restaurant. Alternate payment types are forms of payment that are not standard in the Toast POS and that are configured for a particular restaurant. For example, a third-party service that processes payments might be configured as an alternate payment type. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the alternate payment type is configured for.  (required)
        :type toast_restaurant_external_id: str
        :param guid: The Toast POS GUID of the alternative form of payment. (required)
        :type guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alternate_payment_type_by_id_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            guid=guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AlternatePaymentType",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_alternate_payment_type_by_id_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the alternate payment type is configured for. ")],
        guid: Annotated[StrictStr, Field(description="The Toast POS GUID of the alternative form of payment.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get an alternative payment type 

        Returns an `AlternatePaymentType` object containing information about an alternative form of payment configured for a restaurant. Alternate payment types are forms of payment that are not standard in the Toast POS and that are configured for a particular restaurant. For example, a third-party service that processes payments might be configured as an alternate payment type. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the alternate payment type is configured for.  (required)
        :type toast_restaurant_external_id: str
        :param guid: The Toast POS GUID of the alternative form of payment. (required)
        :type guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alternate_payment_type_by_id_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            guid=guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AlternatePaymentType",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_alternate_payment_type_by_id_serialize(
        self,
        toast_restaurant_external_id,
        guid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if guid is not None:
            _path_params['guid'] = guid
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/config/v2/alternatePaymentTypes/{guid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_alternate_payment_types(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the configuration applies to. ")],
        page_token: Annotated[Optional[StrictStr], Field(description="A string that identifies the set of data objects that the endpoint will return in its response data. You can use this parameter to retrieve one page of response data. You get the value that you supply in the `pageToken` parameter from the `Toast-Next-Page-Token` header field value of a previous request to the endpoint. For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. ")] = None,
        last_modified: Annotated[Optional[StrictStr], Field(description="Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[AlternatePaymentType]:
        """Get alternative payment types 

        Returns an array of `AlternatePaymentType` objects containing information about alternative forms of payment that are configured for a restaurant. Alternate payment types are forms of payment that are not standard in the Toast POS and that are configured for a particular restaurant. For example, a third-party service that processes payments might be configured as an alternate payment type. If a `lastModified` date is specified, returns all objects that were created or modified after that date. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the configuration applies to.  (required)
        :type toast_restaurant_external_id: str
        :param page_token: A string that identifies the set of data objects that the endpoint will return in its response data. You can use this parameter to retrieve one page of response data. You get the value that you supply in the `pageToken` parameter from the `Toast-Next-Page-Token` header field value of a previous request to the endpoint. For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. 
        :type page_token: str
        :param last_modified: Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. 
        :type last_modified: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_alternate_payment_types_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            page_token=page_token,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlternatePaymentType]",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_alternate_payment_types_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the configuration applies to. ")],
        page_token: Annotated[Optional[StrictStr], Field(description="A string that identifies the set of data objects that the endpoint will return in its response data. You can use this parameter to retrieve one page of response data. You get the value that you supply in the `pageToken` parameter from the `Toast-Next-Page-Token` header field value of a previous request to the endpoint. For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. ")] = None,
        last_modified: Annotated[Optional[StrictStr], Field(description="Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[AlternatePaymentType]]:
        """Get alternative payment types 

        Returns an array of `AlternatePaymentType` objects containing information about alternative forms of payment that are configured for a restaurant. Alternate payment types are forms of payment that are not standard in the Toast POS and that are configured for a particular restaurant. For example, a third-party service that processes payments might be configured as an alternate payment type. If a `lastModified` date is specified, returns all objects that were created or modified after that date. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the configuration applies to.  (required)
        :type toast_restaurant_external_id: str
        :param page_token: A string that identifies the set of data objects that the endpoint will return in its response data. You can use this parameter to retrieve one page of response data. You get the value that you supply in the `pageToken` parameter from the `Toast-Next-Page-Token` header field value of a previous request to the endpoint. For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. 
        :type page_token: str
        :param last_modified: Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. 
        :type last_modified: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_alternate_payment_types_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            page_token=page_token,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlternatePaymentType]",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_alternate_payment_types_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the configuration applies to. ")],
        page_token: Annotated[Optional[StrictStr], Field(description="A string that identifies the set of data objects that the endpoint will return in its response data. You can use this parameter to retrieve one page of response data. You get the value that you supply in the `pageToken` parameter from the `Toast-Next-Page-Token` header field value of a previous request to the endpoint. For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. ")] = None,
        last_modified: Annotated[Optional[StrictStr], Field(description="Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get alternative payment types 

        Returns an array of `AlternatePaymentType` objects containing information about alternative forms of payment that are configured for a restaurant. Alternate payment types are forms of payment that are not standard in the Toast POS and that are configured for a particular restaurant. For example, a third-party service that processes payments might be configured as an alternate payment type. If a `lastModified` date is specified, returns all objects that were created or modified after that date. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the configuration applies to.  (required)
        :type toast_restaurant_external_id: str
        :param page_token: A string that identifies the set of data objects that the endpoint will return in its response data. You can use this parameter to retrieve one page of response data. You get the value that you supply in the `pageToken` parameter from the `Toast-Next-Page-Token` header field value of a previous request to the endpoint. For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. 
        :type page_token: str
        :param last_modified: Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. 
        :type last_modified: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_alternate_payment_types_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            page_token=page_token,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlternatePaymentType]",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_alternate_payment_types_serialize(
        self,
        toast_restaurant_external_id,
        page_token,
        last_modified,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if last_modified is not None:
            
            _query_params.append(('lastModified', last_modified))
            
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/config/v2/alternatePaymentTypes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


