# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from toastapi.models.guest_reporting_data_request import GuestReportingDataRequest
from toastapi.models.guest_reporting_data_response import GuestReportingDataResponse

from toastapi.api_client import ApiClient, RequestSerialized
from toastapi.api_response import ApiResponse
from toastapi.rest import RESTResponseType


class AnalyticsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def create_guest_reporting_data_request(
        self,
        time_range: Annotated[StrictStr, Field(description="The specific time range that you are requesting reporting data for.  Valid values:  day - The request covers a one day time range.  week - The request covers a time range of seven days or fewer. ")],
        guest_reporting_data_request: Annotated[GuestReportingDataRequest, Field(description="A JSON object containing the starting and ending dates for the reporting data request and included or excluded restaurants. ")],
        only_inactive_restaurants: Annotated[Optional[StrictBool], Field(description="Specifies whether the data is for inactive restaurants only. Active restaurant data is returned by default.  Valid values:  true - The data retrieved is for inactive restaurants only.  false - The data retrieved is for active restaurants only. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """Post a guest reporting data request organized by payment for a specific time range

        Creates a guest reporting data organized by payment request for a specific time range.  Specify the time range with the timeRange path parameter.  Specify whether to include data from inactive restaurants using the onlyInactiveRestaurants query parameter.  Specify the startDate and endDate for the guest data in the message body.  Include information about which restaurants to include or exclude with the restaurantIds and excludedRestaurantIds properties. 

        :param time_range: The specific time range that you are requesting reporting data for.  Valid values:  day - The request covers a one day time range.  week - The request covers a time range of seven days or fewer.  (required)
        :type time_range: str
        :param guest_reporting_data_request: A JSON object containing the starting and ending dates for the reporting data request and included or excluded restaurants.  (required)
        :type guest_reporting_data_request: GuestReportingDataRequest
        :param only_inactive_restaurants: Specifies whether the data is for inactive restaurants only. Active restaurant data is returned by default.  Valid values:  true - The data retrieved is for inactive restaurants only.  false - The data retrieved is for active restaurants only. 
        :type only_inactive_restaurants: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_guest_reporting_data_request_serialize(
            time_range=time_range,
            guest_reporting_data_request=guest_reporting_data_request,
            only_inactive_restaurants=only_inactive_restaurants,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': "ErrorMessage",
            '500': "ErrorMessage",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_guest_reporting_data_request_with_http_info(
        self,
        time_range: Annotated[StrictStr, Field(description="The specific time range that you are requesting reporting data for.  Valid values:  day - The request covers a one day time range.  week - The request covers a time range of seven days or fewer. ")],
        guest_reporting_data_request: Annotated[GuestReportingDataRequest, Field(description="A JSON object containing the starting and ending dates for the reporting data request and included or excluded restaurants. ")],
        only_inactive_restaurants: Annotated[Optional[StrictBool], Field(description="Specifies whether the data is for inactive restaurants only. Active restaurant data is returned by default.  Valid values:  true - The data retrieved is for inactive restaurants only.  false - The data retrieved is for active restaurants only. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """Post a guest reporting data request organized by payment for a specific time range

        Creates a guest reporting data organized by payment request for a specific time range.  Specify the time range with the timeRange path parameter.  Specify whether to include data from inactive restaurants using the onlyInactiveRestaurants query parameter.  Specify the startDate and endDate for the guest data in the message body.  Include information about which restaurants to include or exclude with the restaurantIds and excludedRestaurantIds properties. 

        :param time_range: The specific time range that you are requesting reporting data for.  Valid values:  day - The request covers a one day time range.  week - The request covers a time range of seven days or fewer.  (required)
        :type time_range: str
        :param guest_reporting_data_request: A JSON object containing the starting and ending dates for the reporting data request and included or excluded restaurants.  (required)
        :type guest_reporting_data_request: GuestReportingDataRequest
        :param only_inactive_restaurants: Specifies whether the data is for inactive restaurants only. Active restaurant data is returned by default.  Valid values:  true - The data retrieved is for inactive restaurants only.  false - The data retrieved is for active restaurants only. 
        :type only_inactive_restaurants: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_guest_reporting_data_request_serialize(
            time_range=time_range,
            guest_reporting_data_request=guest_reporting_data_request,
            only_inactive_restaurants=only_inactive_restaurants,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': "ErrorMessage",
            '500': "ErrorMessage",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_guest_reporting_data_request_without_preload_content(
        self,
        time_range: Annotated[StrictStr, Field(description="The specific time range that you are requesting reporting data for.  Valid values:  day - The request covers a one day time range.  week - The request covers a time range of seven days or fewer. ")],
        guest_reporting_data_request: Annotated[GuestReportingDataRequest, Field(description="A JSON object containing the starting and ending dates for the reporting data request and included or excluded restaurants. ")],
        only_inactive_restaurants: Annotated[Optional[StrictBool], Field(description="Specifies whether the data is for inactive restaurants only. Active restaurant data is returned by default.  Valid values:  true - The data retrieved is for inactive restaurants only.  false - The data retrieved is for active restaurants only. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Post a guest reporting data request organized by payment for a specific time range

        Creates a guest reporting data organized by payment request for a specific time range.  Specify the time range with the timeRange path parameter.  Specify whether to include data from inactive restaurants using the onlyInactiveRestaurants query parameter.  Specify the startDate and endDate for the guest data in the message body.  Include information about which restaurants to include or exclude with the restaurantIds and excludedRestaurantIds properties. 

        :param time_range: The specific time range that you are requesting reporting data for.  Valid values:  day - The request covers a one day time range.  week - The request covers a time range of seven days or fewer.  (required)
        :type time_range: str
        :param guest_reporting_data_request: A JSON object containing the starting and ending dates for the reporting data request and included or excluded restaurants.  (required)
        :type guest_reporting_data_request: GuestReportingDataRequest
        :param only_inactive_restaurants: Specifies whether the data is for inactive restaurants only. Active restaurant data is returned by default.  Valid values:  true - The data retrieved is for inactive restaurants only.  false - The data retrieved is for active restaurants only. 
        :type only_inactive_restaurants: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_guest_reporting_data_request_serialize(
            time_range=time_range,
            guest_reporting_data_request=guest_reporting_data_request,
            only_inactive_restaurants=only_inactive_restaurants,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': "ErrorMessage",
            '500': "ErrorMessage",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_guest_reporting_data_request_serialize(
        self,
        time_range,
        guest_reporting_data_request,
        only_inactive_restaurants,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if time_range is not None:
            _path_params['timeRange'] = time_range
        # process the query parameters
        if only_inactive_restaurants is not None:
            
            _query_params.append(('onlyInactiveRestaurants', only_inactive_restaurants))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if guest_reporting_data_request is not None:
            _body_params = guest_reporting_data_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/era/v1/guest/payments/{timeRange}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_guest_reporting_data(
        self,
        report_request_guid: Annotated[StrictStr, Field(description="The Toast platform identifier for the reporting data request. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[GuestReportingDataResponse]:
        """Get the guest reporting data organized by payment

        Returns the guest data organized by payment for the reporting data request.  Specify the reportRequestGuid for the reporting data. 

        :param report_request_guid: The Toast platform identifier for the reporting data request.  (required)
        :type report_request_guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_guest_reporting_data_serialize(
            report_request_guid=report_request_guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[GuestReportingDataResponse]",
            '202': "GuestReportingDataInProgress",
            '404': "ErrorMessage",
            '409': "ErrorMessage",
            '500': "ErrorMessage",
            '504': "ErrorMessage",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_guest_reporting_data_with_http_info(
        self,
        report_request_guid: Annotated[StrictStr, Field(description="The Toast platform identifier for the reporting data request. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[GuestReportingDataResponse]]:
        """Get the guest reporting data organized by payment

        Returns the guest data organized by payment for the reporting data request.  Specify the reportRequestGuid for the reporting data. 

        :param report_request_guid: The Toast platform identifier for the reporting data request.  (required)
        :type report_request_guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_guest_reporting_data_serialize(
            report_request_guid=report_request_guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[GuestReportingDataResponse]",
            '202': "GuestReportingDataInProgress",
            '404': "ErrorMessage",
            '409': "ErrorMessage",
            '500': "ErrorMessage",
            '504': "ErrorMessage",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_guest_reporting_data_without_preload_content(
        self,
        report_request_guid: Annotated[StrictStr, Field(description="The Toast platform identifier for the reporting data request. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get the guest reporting data organized by payment

        Returns the guest data organized by payment for the reporting data request.  Specify the reportRequestGuid for the reporting data. 

        :param report_request_guid: The Toast platform identifier for the reporting data request.  (required)
        :type report_request_guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_guest_reporting_data_serialize(
            report_request_guid=report_request_guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[GuestReportingDataResponse]",
            '202': "GuestReportingDataInProgress",
            '404': "ErrorMessage",
            '409': "ErrorMessage",
            '500': "ErrorMessage",
            '504': "ErrorMessage",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_guest_reporting_data_serialize(
        self,
        report_request_guid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if report_request_guid is not None:
            _path_params['reportRequestGuid'] = report_request_guid
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/era/v1/guest/payments/{reportRequestGuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


