# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from toastapi.models.applicable_discount import ApplicableDiscount
from toastapi.models.applicable_discounts_request import ApplicableDiscountsRequest
from toastapi.models.applied_discount import AppliedDiscount
from toastapi.models.discount import Discount
from toastapi.models.order import Order

from toastapi.api_client import ApiClient, RequestSerialized
from toastapi.api_response import ApiResponse
from toastapi.rest import RESTResponseType


class DiscountsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def add_check_level_discounts(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are adding a discount to. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are adding a discount to. ")],
        applied_discount: Annotated[List[AppliedDiscount], Field(description="A JSON array of `AppliedDiscount` objects that identify the discounts you are adding. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Order:
        """Add check-level discounts

        Adds one or more check-level discounts to a check in an existing order. Include an array of `Discount` objects in the message body.  For more information, see  <a href=\"https://doc.toasttab.com/doc/devguide/apiDiscountingOrders.html#apiAddingDiscountsToChecks\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are adding a discount to.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are adding a discount to.  (required)
        :type check_guid: str
        :param applied_discount: A JSON array of `AppliedDiscount` objects that identify the discounts you are adding.  (required)
        :type applied_discount: List[AppliedDiscount]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_check_level_discounts_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            applied_discount=applied_discount,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_check_level_discounts_with_http_info(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are adding a discount to. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are adding a discount to. ")],
        applied_discount: Annotated[List[AppliedDiscount], Field(description="A JSON array of `AppliedDiscount` objects that identify the discounts you are adding. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Order]:
        """Add check-level discounts

        Adds one or more check-level discounts to a check in an existing order. Include an array of `Discount` objects in the message body.  For more information, see  <a href=\"https://doc.toasttab.com/doc/devguide/apiDiscountingOrders.html#apiAddingDiscountsToChecks\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are adding a discount to.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are adding a discount to.  (required)
        :type check_guid: str
        :param applied_discount: A JSON array of `AppliedDiscount` objects that identify the discounts you are adding.  (required)
        :type applied_discount: List[AppliedDiscount]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_check_level_discounts_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            applied_discount=applied_discount,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_check_level_discounts_without_preload_content(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are adding a discount to. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are adding a discount to. ")],
        applied_discount: Annotated[List[AppliedDiscount], Field(description="A JSON array of `AppliedDiscount` objects that identify the discounts you are adding. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add check-level discounts

        Adds one or more check-level discounts to a check in an existing order. Include an array of `Discount` objects in the message body.  For more information, see  <a href=\"https://doc.toasttab.com/doc/devguide/apiDiscountingOrders.html#apiAddingDiscountsToChecks\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are adding a discount to.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are adding a discount to.  (required)
        :type check_guid: str
        :param applied_discount: A JSON array of `AppliedDiscount` objects that identify the discounts you are adding.  (required)
        :type applied_discount: List[AppliedDiscount]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_check_level_discounts_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            applied_discount=applied_discount,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_check_level_discounts_serialize(
        self,
        order_guid,
        check_guid,
        applied_discount,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'AppliedDiscount': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_guid is not None:
            _path_params['orderGuid'] = order_guid
        if check_guid is not None:
            _path_params['checkGuid'] = check_guid
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if applied_discount is not None:
            _body_params = applied_discount


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/orders/v2/orders/{orderGuid}/checks/{checkGuid}/appliedDiscounts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_item_level_discounts(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are adding a discount to. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are adding a discount to. ")],
        selection_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the menu item selection that you are adding a discount to. ")],
        applied_discount: Annotated[List[AppliedDiscount], Field(description="A JSON array of `AppliedDiscount` objects that identify the discounts you are adding. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Order:
        """Add item-level discounts

        Adds one or more item-level discounts to menu item selections in a check in an existing order. Include an array of `Discount` objects in the message body.  For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiDiscountingOrders.html#apiAddingDiscountsToChecks\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are adding a discount to.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are adding a discount to.  (required)
        :type check_guid: str
        :param selection_guid: The Toast platform identifier of the menu item selection that you are adding a discount to.  (required)
        :type selection_guid: str
        :param applied_discount: A JSON array of `AppliedDiscount` objects that identify the discounts you are adding.  (required)
        :type applied_discount: List[AppliedDiscount]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_item_level_discounts_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            selection_guid=selection_guid,
            applied_discount=applied_discount,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_item_level_discounts_with_http_info(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are adding a discount to. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are adding a discount to. ")],
        selection_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the menu item selection that you are adding a discount to. ")],
        applied_discount: Annotated[List[AppliedDiscount], Field(description="A JSON array of `AppliedDiscount` objects that identify the discounts you are adding. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Order]:
        """Add item-level discounts

        Adds one or more item-level discounts to menu item selections in a check in an existing order. Include an array of `Discount` objects in the message body.  For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiDiscountingOrders.html#apiAddingDiscountsToChecks\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are adding a discount to.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are adding a discount to.  (required)
        :type check_guid: str
        :param selection_guid: The Toast platform identifier of the menu item selection that you are adding a discount to.  (required)
        :type selection_guid: str
        :param applied_discount: A JSON array of `AppliedDiscount` objects that identify the discounts you are adding.  (required)
        :type applied_discount: List[AppliedDiscount]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_item_level_discounts_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            selection_guid=selection_guid,
            applied_discount=applied_discount,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_item_level_discounts_without_preload_content(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are adding a discount to. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are adding a discount to. ")],
        selection_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the menu item selection that you are adding a discount to. ")],
        applied_discount: Annotated[List[AppliedDiscount], Field(description="A JSON array of `AppliedDiscount` objects that identify the discounts you are adding. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add item-level discounts

        Adds one or more item-level discounts to menu item selections in a check in an existing order. Include an array of `Discount` objects in the message body.  For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiDiscountingOrders.html#apiAddingDiscountsToChecks\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are adding a discount to.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are adding a discount to.  (required)
        :type check_guid: str
        :param selection_guid: The Toast platform identifier of the menu item selection that you are adding a discount to.  (required)
        :type selection_guid: str
        :param applied_discount: A JSON array of `AppliedDiscount` objects that identify the discounts you are adding.  (required)
        :type applied_discount: List[AppliedDiscount]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_item_level_discounts_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            selection_guid=selection_guid,
            applied_discount=applied_discount,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_item_level_discounts_serialize(
        self,
        order_guid,
        check_guid,
        selection_guid,
        applied_discount,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'AppliedDiscount': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_guid is not None:
            _path_params['orderGuid'] = order_guid
        if check_guid is not None:
            _path_params['checkGuid'] = check_guid
        if selection_guid is not None:
            _path_params['selectionGuid'] = selection_guid
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if applied_discount is not None:
            _body_params = applied_discount


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/orders/v2/orders/{orderGuid}/checks/{checkGuid}/selections/{selectionGuid}/appliedDiscounts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_applicable_discounts(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The identifier of the restaurant.")],
        applicable_discounts_request: Annotated[ApplicableDiscountsRequest, Field(description="A JSON `ApplicableDiscountsRequest` object containing information about an order, and an optional `promoCode`. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[ApplicableDiscount]:
        """Get applicable discounts

        Returns an array of `ApplicableDiscount` objects that contain information about the discounts that apply to the checks and menu item selections in an order.  Each `ApplicableDiscount` object contains information that you can use to determine which items and checks are eligible for the discount.  If you include a `promoCode` value in the `ApplicableDiscount` object, the `applicableDiscounts` endpoint returns the only the discounts that are associated with that promotional code. 

        :param toast_restaurant_external_id: The identifier of the restaurant. (required)
        :type toast_restaurant_external_id: str
        :param applicable_discounts_request: A JSON `ApplicableDiscountsRequest` object containing information about an order, and an optional `promoCode`.  (required)
        :type applicable_discounts_request: ApplicableDiscountsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_applicable_discounts_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            applicable_discounts_request=applicable_discounts_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ApplicableDiscount]",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_applicable_discounts_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The identifier of the restaurant.")],
        applicable_discounts_request: Annotated[ApplicableDiscountsRequest, Field(description="A JSON `ApplicableDiscountsRequest` object containing information about an order, and an optional `promoCode`. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[ApplicableDiscount]]:
        """Get applicable discounts

        Returns an array of `ApplicableDiscount` objects that contain information about the discounts that apply to the checks and menu item selections in an order.  Each `ApplicableDiscount` object contains information that you can use to determine which items and checks are eligible for the discount.  If you include a `promoCode` value in the `ApplicableDiscount` object, the `applicableDiscounts` endpoint returns the only the discounts that are associated with that promotional code. 

        :param toast_restaurant_external_id: The identifier of the restaurant. (required)
        :type toast_restaurant_external_id: str
        :param applicable_discounts_request: A JSON `ApplicableDiscountsRequest` object containing information about an order, and an optional `promoCode`.  (required)
        :type applicable_discounts_request: ApplicableDiscountsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_applicable_discounts_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            applicable_discounts_request=applicable_discounts_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ApplicableDiscount]",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_applicable_discounts_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The identifier of the restaurant.")],
        applicable_discounts_request: Annotated[ApplicableDiscountsRequest, Field(description="A JSON `ApplicableDiscountsRequest` object containing information about an order, and an optional `promoCode`. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get applicable discounts

        Returns an array of `ApplicableDiscount` objects that contain information about the discounts that apply to the checks and menu item selections in an order.  Each `ApplicableDiscount` object contains information that you can use to determine which items and checks are eligible for the discount.  If you include a `promoCode` value in the `ApplicableDiscount` object, the `applicableDiscounts` endpoint returns the only the discounts that are associated with that promotional code. 

        :param toast_restaurant_external_id: The identifier of the restaurant. (required)
        :type toast_restaurant_external_id: str
        :param applicable_discounts_request: A JSON `ApplicableDiscountsRequest` object containing information about an order, and an optional `promoCode`.  (required)
        :type applicable_discounts_request: ApplicableDiscountsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_applicable_discounts_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            applicable_discounts_request=applicable_discounts_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ApplicableDiscount]",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_applicable_discounts_serialize(
        self,
        toast_restaurant_external_id,
        applicable_discounts_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter
        if applicable_discounts_request is not None:
            _body_params = applicable_discounts_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/orders/v2/applicableDiscounts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_discount_by_id(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the configuration applies to. ")],
        guid: Annotated[StrictStr, Field(description="The Toast POS GUID of the discount.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Discount:
        """Get a discount

        Returns a `Discount` object containing information about a price deduction configured for a restaurant. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the configuration applies to.  (required)
        :type toast_restaurant_external_id: str
        :param guid: The Toast POS GUID of the discount. (required)
        :type guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_discount_by_id_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            guid=guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Discount",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_discount_by_id_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the configuration applies to. ")],
        guid: Annotated[StrictStr, Field(description="The Toast POS GUID of the discount.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Discount]:
        """Get a discount

        Returns a `Discount` object containing information about a price deduction configured for a restaurant. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the configuration applies to.  (required)
        :type toast_restaurant_external_id: str
        :param guid: The Toast POS GUID of the discount. (required)
        :type guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_discount_by_id_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            guid=guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Discount",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_discount_by_id_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the configuration applies to. ")],
        guid: Annotated[StrictStr, Field(description="The Toast POS GUID of the discount.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a discount

        Returns a `Discount` object containing information about a price deduction configured for a restaurant. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the configuration applies to.  (required)
        :type toast_restaurant_external_id: str
        :param guid: The Toast POS GUID of the discount. (required)
        :type guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_discount_by_id_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            guid=guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Discount",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_discount_by_id_serialize(
        self,
        toast_restaurant_external_id,
        guid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if guid is not None:
            _path_params['guid'] = guid
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/config/v2/discounts/{guid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_discounts(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the configuration applies to. ")],
        page_token: Annotated[Optional[StrictStr], Field(description="A string that identifies the set of data objects that the  endpoint will return in its response data. You can use this  parameter to retrieve one page of response data. You  get the value that you supply in the `pageToken` parameter  from the `Toast-Next-Page-Token` header field value of a  previous request to the endpoint. For more information, see  <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. ")] = None,
        last_modified: Annotated[Optional[StrictStr], Field(description="Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[Discount]:
        """Get discounts

        Returns an array of `Discount` objects containing information about the price deductions configured for a restaurant. If a `lastModified` date is specified, returns all objects that were created or modified after that date. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the configuration applies to.  (required)
        :type toast_restaurant_external_id: str
        :param page_token: A string that identifies the set of data objects that the  endpoint will return in its response data. You can use this  parameter to retrieve one page of response data. You  get the value that you supply in the `pageToken` parameter  from the `Toast-Next-Page-Token` header field value of a  previous request to the endpoint. For more information, see  <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. 
        :type page_token: str
        :param last_modified: Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. 
        :type last_modified: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_discounts_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            page_token=page_token,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Discount]",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_discounts_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the configuration applies to. ")],
        page_token: Annotated[Optional[StrictStr], Field(description="A string that identifies the set of data objects that the  endpoint will return in its response data. You can use this  parameter to retrieve one page of response data. You  get the value that you supply in the `pageToken` parameter  from the `Toast-Next-Page-Token` header field value of a  previous request to the endpoint. For more information, see  <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. ")] = None,
        last_modified: Annotated[Optional[StrictStr], Field(description="Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[Discount]]:
        """Get discounts

        Returns an array of `Discount` objects containing information about the price deductions configured for a restaurant. If a `lastModified` date is specified, returns all objects that were created or modified after that date. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the configuration applies to.  (required)
        :type toast_restaurant_external_id: str
        :param page_token: A string that identifies the set of data objects that the  endpoint will return in its response data. You can use this  parameter to retrieve one page of response data. You  get the value that you supply in the `pageToken` parameter  from the `Toast-Next-Page-Token` header field value of a  previous request to the endpoint. For more information, see  <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. 
        :type page_token: str
        :param last_modified: Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. 
        :type last_modified: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_discounts_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            page_token=page_token,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Discount]",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_discounts_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast POS GUID of the restaurant that the configuration applies to. ")],
        page_token: Annotated[Optional[StrictStr], Field(description="A string that identifies the set of data objects that the  endpoint will return in its response data. You can use this  parameter to retrieve one page of response data. You  get the value that you supply in the `pageToken` parameter  from the `Toast-Next-Page-Token` header field value of a  previous request to the endpoint. For more information, see  <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. ")] = None,
        last_modified: Annotated[Optional[StrictStr], Field(description="Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get discounts

        Returns an array of `Discount` objects containing information about the price deductions configured for a restaurant. If a `lastModified` date is specified, returns all objects that were created or modified after that date. 

        :param toast_restaurant_external_id: The Toast POS GUID of the restaurant that the configuration applies to.  (required)
        :type toast_restaurant_external_id: str
        :param page_token: A string that identifies the set of data objects that the  endpoint will return in its response data. You can use this  parameter to retrieve one page of response data. You  get the value that you supply in the `pageToken` parameter  from the `Toast-Next-Page-Token` header field value of a  previous request to the endpoint. For more information, see  <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>. 
        :type page_token: str
        :param last_modified: Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`. 
        :type last_modified: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_discounts_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            page_token=page_token,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Discount]",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_discounts_serialize(
        self,
        toast_restaurant_external_id,
        page_token,
        last_modified,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page_token is not None:
            
            _query_params.append(('pageToken', page_token))
            
        if last_modified is not None:
            
            _query_params.append(('lastModified', last_modified))
            
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/config/v2/discounts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


