# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from toastapi.models.applied_tax_rate import AppliedTaxRate
from toastapi.models.external_reference import ExternalReference
from toastapi.models.refund_details import RefundDetails
from typing import Optional, Set
from typing_extensions import Self

class AppliedServiceCharge(BaseModel):
    """
    A service charge that is added to a check. A service charge can represent an upcharge such as a gratuity or a delivery fee.  Whether the upcharge is taxable is defined in the restaurant-configured `serviceCharge`.  The fields on the `AppliedServiceCharge` are calculated based on the referenced `ServiceCharge` configuration. 
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is. Response only.", alias="entityType")
    external_id: Optional[StrictStr] = Field(default=None, description="External identifier string that is prefixed by the naming authority.", alias="externalId")
    charge_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The final applied amount excluding tax. Required if `chargeType` is `OPEN`.", alias="chargeAmount")
    service_charge: ExternalReference = Field(alias="serviceCharge")
    charge_type: Optional[StrictStr] = Field(default=None, description="The type of service charge. Response only.  Valid values:  * `FIXED` - The service charge is for a specific currency amount.  * `PERCENT` - The service charge is for a percentage of the check amount.  * `OPEN` - The service charge is not configured with an amount. The amount is specified by the restaurant employee. ", alias="chargeType")
    name: Optional[StrictStr] = Field(default=None, description="The configured human readable label for the service charge. Response only.")
    delivery: Optional[StrictBool] = Field(default=None, description="Whether this service charge is a delivery charge. Response only.")
    takeout: Optional[StrictBool] = Field(default=None, description="Whether this service charge is a takeout charge. Response only.")
    dine_in: Optional[StrictBool] = Field(default=None, description="Whether this service charge is a dine-in charge. Response only.", alias="dineIn")
    gratuity: Optional[StrictBool] = Field(default=None, description="Whether this service charge is a gratuity. Can be used to derive required tip amount on the check. Response only.")
    taxable: Optional[StrictBool] = Field(default=None, description="Whether this service charge is taxable. Response only.")
    applied_taxes: Optional[List[AppliedTaxRate]] = Field(default=None, description="Taxes applied to the service charge.", alias="appliedTaxes")
    service_charge_calculation: Optional[StrictStr] = Field(default=None, description="Defines whether a `PERCENT` service charge is applied before (`PRE_DISCOUNT`) or after (`POST_DISCOUNT`) discounts.  This field is `null` for `FIXED` and `OPEN` service charges. ", alias="serviceChargeCalculation")
    refund_details: Optional[RefundDetails] = Field(default=None, alias="refundDetails")
    service_charge_category: Optional[StrictStr] = Field(default=None, description="The type of service charge. Default is `SERVICE_CHARGE`. Response only.  Valid values:  * `SERVICE_CHARGE` - The default type for a service charge.  * `CREDIT_CARD_SURCHARGE` - A fee assessed _only_ on payment transactions that use a credit card.  * `FUNDRAISING_CAMPAIGN` - Service charge associated with fundraising. ", alias="serviceChargeCategory")
    payment_guid: Optional[StrictStr] = Field(default=None, description="The Toast platform unique identifier for the payment the fee is linked to. The `paymentGuid` value is always `null` unless the `serviceChargeCategory` object value is `CREDIT_CARD_SURCHARGE`. Response only.", alias="paymentGuid")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "externalId", "chargeAmount", "serviceCharge", "chargeType", "name", "delivery", "takeout", "dineIn", "gratuity", "taxable", "appliedTaxes", "serviceChargeCalculation", "refundDetails", "serviceChargeCategory", "paymentGuid"]

    @field_validator('charge_type')
    def charge_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FIXED', 'PERCENT', 'OPEN']):
            raise ValueError("must be one of enum values ('FIXED', 'PERCENT', 'OPEN')")
        return value

    @field_validator('service_charge_calculation')
    def service_charge_calculation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PRE_DISCOUNT', 'POST_DISCOUNT']):
            raise ValueError("must be one of enum values ('PRE_DISCOUNT', 'POST_DISCOUNT')")
        return value

    @field_validator('service_charge_category')
    def service_charge_category_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SERVICE_CHARGE', 'CREDIT_CARD_SURCHARGE', 'FUNDRAISING_CAMPAIGN']):
            raise ValueError("must be one of enum values ('SERVICE_CHARGE', 'CREDIT_CARD_SURCHARGE', 'FUNDRAISING_CAMPAIGN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppliedServiceCharge from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of service_charge
        if self.service_charge:
            _dict['serviceCharge'] = self.service_charge.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in applied_taxes (list)
        _items = []
        if self.applied_taxes:
            for _item_applied_taxes in self.applied_taxes:
                if _item_applied_taxes:
                    _items.append(_item_applied_taxes.to_dict())
            _dict['appliedTaxes'] = _items
        # override the default output from pydantic by calling `to_dict()` of refund_details
        if self.refund_details:
            _dict['refundDetails'] = self.refund_details.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppliedServiceCharge from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "externalId": obj.get("externalId"),
            "chargeAmount": obj.get("chargeAmount"),
            "serviceCharge": ExternalReference.from_dict(obj["serviceCharge"]) if obj.get("serviceCharge") is not None else None,
            "chargeType": obj.get("chargeType"),
            "name": obj.get("name"),
            "delivery": obj.get("delivery"),
            "takeout": obj.get("takeout"),
            "dineIn": obj.get("dineIn"),
            "gratuity": obj.get("gratuity"),
            "taxable": obj.get("taxable"),
            "appliedTaxes": [AppliedTaxRate.from_dict(_item) for _item in obj["appliedTaxes"]] if obj.get("appliedTaxes") is not None else None,
            "serviceChargeCalculation": obj.get("serviceChargeCalculation"),
            "refundDetails": RefundDetails.from_dict(obj["refundDetails"]) if obj.get("refundDetails") is not None else None,
            "serviceChargeCategory": obj.get("serviceChargeCategory"),
            "paymentGuid": obj.get("paymentGuid")
        })
        return _obj


