# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Location(BaseModel):
    """
    Information about the physical location of a restaurant.
    """ # noqa: E501
    address1: Optional[StrictStr] = Field(default=None, description="The first line of the street address of the restaurant.")
    address2: Optional[StrictStr] = Field(default=None, description="The second line of the street address of the restaurant.")
    city: Optional[StrictStr] = Field(default=None, description="The city or town of the restaurant.")
    state_code: Optional[StrictStr] = Field(default=None, description="Deprecated. Get the state or province of a restaurant in the `administrativeArea` value.  The abbreviation of the state or province of the restaurant. ", alias="stateCode")
    administrative_area: Optional[StrictStr] = Field(default=None, description="The name of the geographical division (for example, state, province, or county) that the restaurant is located in. ", alias="administrativeArea")
    zip_code: Optional[StrictStr] = Field(default=None, description="The ZIP or postal code of the restaurant.", alias="zipCode")
    country: Optional[StrictStr] = Field(default=None, description="The nation of the restaurant.")
    phone: Optional[StrictStr] = None
    phone_country_code: Optional[StrictStr] = Field(default=None, description="A numeric code corresponding to one or more countries, used as a telephone number prefix when making  international telephone calls. ", alias="phoneCountryCode")
    latitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The north/south geographic coordinate of the restaurant, in decimal degrees.")
    longitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The east/west geographic coordinate of the restaurant, in decimal degrees.")
    __properties: ClassVar[List[str]] = ["address1", "address2", "city", "stateCode", "administrativeArea", "zipCode", "country", "phone", "phoneCountryCode", "latitude", "longitude"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Location from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Location from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address1": obj.get("address1"),
            "address2": obj.get("address2"),
            "city": obj.get("city"),
            "stateCode": obj.get("stateCode"),
            "administrativeArea": obj.get("administrativeArea"),
            "zipCode": obj.get("zipCode"),
            "country": obj.get("country"),
            "phone": obj.get("phone"),
            "phoneCountryCode": obj.get("phoneCountryCode"),
            "latitude": obj.get("latitude"),
            "longitude": obj.get("longitude")
        })
        return _obj


