# phoenix-helm

![Version: 1.0.8](https://img.shields.io/badge/Version-1.0.8-informational?style=flat-square) ![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![AppVersion: 10.11.0](https://img.shields.io/badge/AppVersion-10.11.0-informational?style=flat-square)

Phoenix is an open-source AI observability platform designed for experimentation, evaluation, and troubleshooting. For instructions on how to deploy this Helm chart, see the [self-hosting docs](https://arize.com/docs/phoenix/self-hosting).
  - [**_Tracing_**](https://arize.com/docs/phoenix/tracing/llm-traces) - Trace your LLM application's runtime using OpenTelemetry-based instrumentation.
  - [**_Evaluation_**](https://arize.com/docs/phoenix/evaluation/llm-evals) - Leverage LLMs to benchmark your application's performance using response and retrieval evals.
  - [**_Datasets_**](https://arize.com/docs/phoenix/datasets-and-experiments/overview-datasets) - Create versioned datasets of examples for experimentation, evaluation, and fine-tuning.
  - [**_Experiments_**](https://arize.com/docs/phoenix/datasets-and-experiments/overview-datasets#experiments) - Track and evaluate changes to prompts, LLMs, and retrieval.
  - [**_Playground_**](https://arize.com/docs/phoenix/prompt-engineering/overview-prompts)- Optimize prompts, compare models, adjust parameters, and replay traced LLM calls.
  - [**_Prompt Management_**](https://arize.com/docs/phoenix/prompt-engineering/overview-prompts/prompt-management)- Manage and test prompt changes systematically using version control, tagging, and experimentation.

**Homepage:** <https://phoenix.arize.com/>

## Maintainers

| Name | Email | Url |
| ---- | ------ | --- |
| arize | <phoenix-devs@arize.com> | <https://phoenix.arize.com/> |

## Source Code

* <https://github.com/Arize-ai/phoenix>

## Requirements

| Repository | Name | Version |
|------------|------|---------|
| oci://registry-1.docker.io/bitnamicharts | postgresql | 16.7.8 |

## Values

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| auth.accessTokenExpiryMinutes | int | `60` | Duration in minutes before access tokens expire and require renewal (PHOENIX_ACCESS_TOKEN_EXPIRY_MINUTES) |
| auth.allowedOrigins | list | `[]` | List of allowed CORS origins for cross-origin requests to the Phoenix API (PHOENIX_ALLOWED_ORIGINS) |
| auth.csrfTrustedOrigins | list | `[]` | List of trusted origins for CSRF protection to prevent cross-site request forgery attacks (PHOENIX_CSRF_TRUSTED_ORIGINS) |
| auth.defaultAdminPassword | string | `"admin"` | Default password for the admin user on initial setup, stored securely in Secret |
| auth.enableAuth | bool | `true` | Enable authentication and authorization for Phoenix (PHOENIX_ENABLE_AUTH) |
| auth.name | string | `"phoenix-secret"` | Name of the Kubernetes secret containing authentication credentials |
| auth.passwordResetTokenExpiryMinutes | int | `60` | Duration in minutes before password reset tokens expire (PHOENIX_PASSWORD_RESET_TOKEN_EXPIRY_MINUTES) |
| auth.refreshTokenExpiryMinutes | int | `43200` | Duration in minutes before refresh tokens expire (PHOENIX_REFRESH_TOKEN_EXPIRY_MINUTES) |
| auth.secret[0] | object | `{"key":"PHOENIX_SECRET","value":""}` | Environment variable name for the main Phoenix secret key used for encryption |
| auth.secret[0].value | string | `""` | Autogenerated if empty |
| auth.secret[1] | object | `{"key":"PHOENIX_ADMIN_SECRET","value":""}` | Environment variable name for the admin secret key |
| auth.secret[1].value | string | `""` | Autogenerated if empty |
| auth.secret[2] | object | `{"key":"PHOENIX_POSTGRES_PASSWORD","value":"postgres"}` | Environment variable name for the PostgreSQL password |
| auth.secret[2].value | string | `"postgres"` | If using postgres in this chart, password must match with database.postgres.password |
| auth.secret[3] | object | `{"key":"PHOENIX_SMTP_PASSWORD","value":""}` | Environment variable name for the SMTP password |
| auth.secret[3].value | string | `""` | Autogenerated if empty |
| auth.secret[4] | object | `{"key":"PHOENIX_DEFAULT_ADMIN_INITIAL_PASSWORD","value":""}` | Environment variable name for the default admin password |
| auth.secret[4].value | string | `""` | Default password for the admin user on initial setup, uses defaultAdminPassword if empty |
| auth.useSecureCookies | bool | `false` | Enable secure cookies (should be true when using HTTPS) |
| database.allocatedStorageGiB | int | `10` | Storage allocation in GiB for the database persistent volume |
| database.postgres.db | string | `"phoenix"` | Name of the PostgreSQL database (PHOENIX_POSTGRES_DB) |
| database.postgres.host | string | `"phoenix-postgresql"` | Postgres Host (PHOENIX_POSTGRES_HOST). Default points to the built-in PostgreSQL service when postgresql.enabled=true. Change this to your external database host when using RDS, CloudSQL, etc. |
| database.postgres.password | string | `"postgres"` | PostgreSQL password (should match auth.secret."PHOENIX_POSTGRES_PASSWORD", PHOENIX_POSTGRES_PASSWORD) |
| database.postgres.port | int | `5432` | Port number for PostgreSQL connections (PHOENIX_POSTGRES_PORT) |
| database.postgres.schema | string | `""` | PostgreSQL schema to use (PHOENIX_SQL_DATABASE_SCHEMA) |
| database.postgres.user | string | `"postgres"` | PostgreSQL username (PHOENIX_POSTGRES_USER) |
| database.url | string | `""` | Full database connection URL (overrides postgres settings if provided). Use this for external databases like RDS. Example: postgresql://username:password@your-rds-endpoint.region.rds.amazonaws.com:5432/phoenix. When using this, ensure postgresql.enabled=false |
| image.pullPolicy | string | `"IfNotPresent"` | Image pull policy for Phoenix container (Always, IfNotPresent, or Never) |
| image.repository | string | `"arizephoenix/phoenix"` | Docker image repository for Phoenix |
| image.tag | string | `"version-10.11.0-nonroot"` | Docker image tag/version to deploy |
| deployment.strategy | object | `{"type":"RollingUpdate","rollingUpdate":{"maxUnavailable":"25%","maxSurge":"25%"}}` | Deployment strategy |
| healthChecks.livenessProbe | object | `{"initialDelaySeconds":0,"periodSeconds":10,"timeoutSeconds":5,"failureThreshold":3,"successThreshold":1}` | Liveness probe configuration |
| healthChecks.readinessProbe | object | `{"initialDelaySeconds":0,"periodSeconds":5,"timeoutSeconds":3,"failureThreshold":3,"successThreshold":1}` | Readiness probe configuration |
| healthChecks.startupProbe | object | `{"enabled":true,"initialDelaySeconds":1,"periodSeconds":1,"timeoutSeconds":1,"failureThreshold":30,"successThreshold":1}` | Startup probe configuration |
| ingress.annotations | object | `{}` | Annotations to add to the ingress resource |
| ingress.apiPath | string | `"/"` | Path prefix for the Phoenix API |
| ingress.enabled | bool | `true` | Enable ingress controller for external access |
| ingress.host | string | `""` | Hostname for ingress |
| ingress.labels | object | `{}` | Labels to add to the ingress resource |
| ingress.pathType | string | `"Prefix"` | Ingress path type (Prefix, Exact, or ImplementationSpecific) |
| ingress.tls.enabled | bool | `false` | Enable TLS/HTTPS for ingress |
| instrumentation.otlpTraceCollectorGrpcEndpoint | string | `""` | OpenTelemetry collector gRPC endpoint for sending traces (PHOENIX_SERVER_INSTRUMENTATION_OTLP_TRACE_COLLECTOR_GRPC_ENDPOINT) |
| instrumentation.otlpTraceCollectorHttpEndpoint | string | `""` | OpenTelemetry collector HTTP endpoint for sending traces (PHOENIX_SERVER_INSTRUMENTATION_OTLP_TRACE_COLLECTOR_HTTP_ENDPOINT) |
| logging.dbLevel | string | `"warning"` | Database logging level (debug, info, warning, error) PHOENIX_DB_LOGGING_LEVEL |
| logging.level | string | `"info"` | Application logging level (debug, info, warning, error) PHOENIX_LOGGING_LEVEL |
| logging.logMigrations | bool | `true` | Enable logging of database migration operations (PHOENIX_LOG_MIGRATIONS) |
| logging.mode | string | `"default"` | Logging mode configuration - PHOENIX_LOGGING_MODE (default or structured) |
| persistence.accessModes | list | `["ReadWriteOnce"]` | Access modes for the persistent volume |
| persistence.annotations | object | `{}` | Annotations to add to the PVC |
| persistence.enabled | bool | `false` | Enable persistent storage for Phoenix home directory |
| persistence.labels | object | `{}` | Labels to add to the PVC |
| persistence.size | string | `"20Gi"` | Size of the persistent volume for Phoenix home directory |
| persistence.storageClass | string | `""` | Kubernetes storage class for Phoenix home volume |
| postgres.image | string | `"postgres:14.5"` | Docker image for PostgreSQL (DEPRECATED for new postgresql.image) |
| postgres.persistence.enabled | bool | `true` | Enable persistent storage for PostgreSQL data (DEPRECATED for new postgresql.primary.persistence) |
| postgres.persistence.size | string | `"10Gi"` | Size of the persistent volume for PostgreSQL  (DEPRECATED for new postgresql.primary.persistence) |
| postgres.persistence.storageClass | string | `"standard"` | Kubernetes storage class for PostgreSQL volume (DEPRECATED for new postgresql.primary.persistence) |
| postgres.resources.limits.cpu | string | `"500m"` | CPU limit for PostgreSQL container (DEPRECATED for new postgresql) |
| postgres.resources.limits.memory | string | `"512Mi"` | Memory limit for PostgreSQL container (DEPRECATED for new postgresql) |
| postgres.resources.requests.cpu | string | `"100m"` | CPU request for PostgreSQL container (DEPRECATED for new postgresql) |
| postgres.resources.requests.memory | string | `"256Mi"` | Memory request for PostgreSQL container (DEPRECATED for new postgresql) |
| postgresql.auth.database | string | `"phoenix"` | Name for a custom database to create |
| postgresql.auth.existingSecret | string | `""` | Name of existing secret to use for PostgreSQL credentials. `postgresql.auth.postgresPassword`, `postgresql.auth.password`, and `postgresql.auth.replicationPassword` will be ignored and picked up from this secret. |
| postgresql.auth.password | string | `""` | Password for the custom user to create. Ignored if `postgresql.auth.existingSecret` is provided |
| postgresql.auth.postgresPassword | string | `"postgres"` | Password for the "postgres" admin user. Ignored if `postgresql.auth.existingSecret` is provided |
| postgresql.auth.secretKeys.adminPasswordKey | string | `""` | Name of key in existing secret to use for PostgreSQL credentials. Only used when `postgresql.auth.existingSecret` is set. |
| postgresql.auth.secretKeys.replicationPasswordKey | string | `""` | Name of key in existing secret to use for PostgreSQL credentials. Only used when `postgresql.auth.existingSecret` is set. |
| postgresql.auth.secretKeys.userPasswordKey | string | `""` | Name of key in existing secret to use for PostgreSQL credentials. Only used when `postgresql.auth.existingSecret` is set. |
| postgresql.auth.username | string | `""` | Name for a custom user to create |
| postgresql.enabled | bool | `true` | Enable postgres deployment. Set to false if you have your own postgres instance (e.g., RDS, CloudSQL). When disabled, you must configure database.url or database.postgres settings to point to your external database |
| postgresql.primary.persistence.enabled | bool | `true` | Enable persistent storage for PostgreSQL data |
| postgresql.primary.persistence.size | string | `"10Gi"` | Size of the persistent volume for PostgreSQL |
| postgresql.primary.persistence.storageClass | string | `""` | Kubernetes storage class for PostgreSQL volume |
| postgresql.primary.persistentVolumeClaimRetentionPolicy.enabled | bool | `false` | Set to true if you want the volume to persist helm uninstalls |
| postgresql.primary.persistentVolumeClaimRetentionPolicy.whenDeleted | string | `"Retain"` | Volume retention behavior that applies when the StatefulSet is deleted |
| postgresql.primary.persistentVolumeClaimRetentionPolicy.whenScaled | string | `"Retain"` | Volume retention behavior when the replica count of the StatefulSet is reduced |
| postgresql.primary.service.ports.postgresql | string | `"5432"` | Port to run postgres service on |
| replicaCount | int | `1` | Number of Phoenix pod replicas |
| resources | object | `{"limits":{"cpu":"1000m","memory":"2Gi"},"requests":{"cpu":"500m","memory":"1Gi"}}` | Resource configuration |
| securityContext.container | object | `{"allowPrivilegeEscalation":false,"capabilities":{"add":[],"drop":["ALL"]},"enabled":true,"privileged":false,"procMount":"Default","readOnlyRootFilesystem":true,"runAsGroup":65532,"runAsNonRoot":true,"runAsUser":65532,"seccompProfile":{"type":"RuntimeDefault"},"seLinuxOptions":{},"windowsOptions":{}}` | Container-level security context settings. When enabled=true, the entire object (excluding 'enabled') is rendered directly as the container securityContext |
| securityContext.pod | object | `{"enabled":true,"fsGroup":65532,"fsGroupChangePolicy":"OnRootMismatch","runAsGroup":65532,"runAsNonRoot":true,"runAsUser":65532,"seccompProfile":{"type":"RuntimeDefault"},"seLinuxOptions":{},"supplementalGroups":[],"sysctls":[],"windowsOptions":{}}` | Pod-level security context settings. When enabled=true, the entire object (excluding 'enabled') is rendered directly as the pod securityContext |
| serviceAccount.annotations | object | `{}` | Annotations to add to the ServiceAccount |
| serviceAccount.create | bool | `false` | Create a ServiceAccount for Phoenix |
| serviceAccount.imagePullSecrets | list | `[]` | List of image pull secrets for the ServiceAccount (if using private container registries) |
| serviceAccount.name | string | `""` | Name of the ServiceAccount to use. If not set and create is true, a name is generated using the release name. If not set and create is false, uses default ServiceAccount |
| server.annotations | object | `{}` | Annotations to add to the Phoenix service |
| server.enablePrometheus | bool | `false` | Enable Prometheus metrics endpoint on port 9090 |
| server.grpcPort | int | `4317` | Port for OpenTelemetry gRPC collector (PHOENIX_GRPC_PORT) |
| server.host | string | `"0.0.0.0"` | Host IP to bind Phoenix server (PHOENIX_HOST) |
| server.hostRootPath | string | `""` | Root path prefix for Phoenix UI and API (PHOENIX_HOST_ROOT_PATH) |
| server.labels | object | `{}` | Labels to add to the Phoenix service |
| server.port | int | `6006` | Port for Phoenix web UI and HTTP API (PHOENIX_PORT) |
| server.rootUrl | string | `""` | External root URL for Phoenix (PHOENIX_ROOT_URL) |
| server.workingDir | string | `""` | The working directory for saving, loading, and exporting datasets (PHOENIX_WORKING_DIR) |
| service.annotations | object | `{}` | Annotations to add to the Phoenix service (useful for service mesh configurations) |
| service.labels | object | `{}` | Labels to add to the Phoenix service |
| service.type | string | `"NodePort"` | Service type for Phoenix service (ClusterIP, NodePort, LoadBalancer, or ExternalName). Use ClusterIP for service mesh deployments (Istio, Linkerd, etc.). Use NodePort for direct external access without ingress |
| smtp.hostname | string | `""` | SMTP server hostname for sending emails (PHOENIX_SMTP_HOSTNAME) |
| smtp.mailFrom | string | `"noreply@arize.com"` | Email address to use as sender for system emails (PHOENIX_SMTP_MAIL_FROM) |
| smtp.password | string | `""` | SMTP authentication password (PHOENIX_SMTP_PASSWORD) |
| smtp.port | int | `587` | SMTP server port (typically 587 for TLS, PHOENIX_SMTP_PORT) |
| smtp.username | string | `""` | SMTP authentication username (PHOENIX_SMTP_USERNAME) |
| smtp.validateCerts | bool | `true` | Validate SMTP server TLS certificates (PHOENIX_SMTP_VALIDATE_CERTS) |
| tls.caFile | string | `""` | Path to CA certificate file for TLS (PHOENIX_TLS_CA_FILE) |
| tls.certFile | string | `""` | Path to TLS certificate file (PHOENIX_TLS_CERT_FILE) |
| tls.enabled | bool | `false` | Enable TLS for Phoenix server (PHOENIX_TLS_ENABLED) |
| tls.enabledForGrpc | bool | `false` | Enable TLS for gRPC endpoints (PHOENIX_TLS_ENABLED_FOR_GRPC) |
| tls.enabledForHttp | bool | `false` | Enable TLS for HTTP endpoints (PHOENIX_TLS_ENABLED_FOR_HTTP) |
| tls.keyFile | string | `""` | Path to TLS private key file (PHOENIX_TLS_KEY_FILE) |
| tls.keyFilePassword | string | `""` | Password for encrypted TLS private key (PHOENIX_TLS_KEY_FILE_PASSWORD) |
| tls.verifyClient | bool | `false` | Enable client certificate verification for mutual TLS (PHOENIX_TLS_VERIFY_CLIENT) |

----------------------------------------------
Autogenerated from chart metadata using [helm-docs v1.14.2](https://github.com/norwoodj/helm-docs/releases/v1.14.2)
