import pytest


class TestConfig:
    def test_clean_task(self, load_config):
        conf = load_config("config", "config")

        try:
            from airflow_config import DAG
        except ImportError:
            return pytest.skip("Airflow DAG not available in this environment")

        d = DAG(dag_id="test_clean", config=conf)
        assert len(d.tasks) == 1

    def test_clean_render(self, load_config):
        conf = load_config("config", "config")
        assert (
            conf.dags["test_clean"].render()
            == """# Generated by airflow-config
from airflow.models import DAG
from airflow.models.param import Param
from pendulum import Timezone, datetime as pdatetime

from airflow_pydantic.extras.common.clean import DagClean

with DAG(
    schedule="0 0 * * *",
    start_date=pdatetime(year=2025, month=1, day=1, tz=Timezone("America/New_York")),
    max_active_tasks=1,
    max_active_runs=1,
    catchup=False,
    params={
        "delete_successful": Param(True, title="Delete Successful", description=None, type="boolean"),
        "delete_failed": Param(True, title="Delete Failed", description=None, type="boolean"),
        "mark_failed_as_successful": Param(False, title="Mark Failed As Successful", description=None, type="boolean"),
        "max_dagruns": Param(10, title="Max Dagruns", description=None, type="integer"),
        "days_to_keep": Param(10, title="Days To Keep", description=None, type="integer"),
    },
    dag_id="test_clean",
    default_args={},
) as dag:
    clean_task = DagClean(task_id="clean_task", dag=dag)
"""
        )

        exec(conf.dags["test_clean"].render())
