# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ..types.return_chat_event import ReturnChatEvent
from ..types.return_chat_group import ReturnChatGroup
from ..types.return_chat_group_paged_audio_reconstructions import ReturnChatGroupPagedAudioReconstructions
from ..types.return_chat_group_paged_chats import ReturnChatGroupPagedChats
from .raw_client import AsyncRawChatGroupsClient, RawChatGroupsClient


class ChatGroupsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawChatGroupsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawChatGroupsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawChatGroupsClient
        """
        return self._raw_client

    def list_chat_groups(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        config_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ReturnChatGroup]:
        """
        Fetches a paginated list of **Chat Groups**.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        config_id : typing.Optional[str]
            The unique identifier for an EVI configuration.

            Filter Chat Groups to only include Chats that used this `config_id` in their most recent Chat.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ReturnChatGroup]
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        response = client.empathic_voice.chat_groups.list_chat_groups(
            page_number=0,
            page_size=1,
            ascending_order=True,
            config_id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_chat_groups(
            page_number=page_number,
            page_size=page_size,
            ascending_order=ascending_order,
            config_id=config_id,
            request_options=request_options,
        )

    def get_chat_group(
        self,
        id: str,
        *,
        page_size: typing.Optional[int] = None,
        page_number: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnChatGroupPagedChats:
        """
        Fetches a **ChatGroup** by ID, including a paginated list of **Chats** associated with the **ChatGroup**.

        Parameters
        ----------
        id : str
            Identifier for a Chat Group. Formatted as a UUID.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnChatGroupPagedChats
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.chat_groups.get_chat_group(
            id="697056f0-6c7e-487d-9bd8-9c19df79f05f",
            page_number=0,
            page_size=1,
            ascending_order=True,
        )
        """
        _response = self._raw_client.get_chat_group(
            id,
            page_size=page_size,
            page_number=page_number,
            ascending_order=ascending_order,
            request_options=request_options,
        )
        return _response.data

    def list_chat_group_events(
        self,
        id: str,
        *,
        page_size: typing.Optional[int] = None,
        page_number: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ReturnChatEvent]:
        """
        Fetches a paginated list of **Chat** events associated with a **Chat Group**.

        Parameters
        ----------
        id : str
            Identifier for a Chat Group. Formatted as a UUID.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ReturnChatEvent]
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        response = client.empathic_voice.chat_groups.list_chat_group_events(
            id="697056f0-6c7e-487d-9bd8-9c19df79f05f",
            page_number=0,
            page_size=3,
            ascending_order=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_chat_group_events(
            id,
            page_size=page_size,
            page_number=page_number,
            ascending_order=ascending_order,
            request_options=request_options,
        )

    def get_audio(
        self,
        id: str,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnChatGroupPagedAudioReconstructions:
        """
        Fetches a paginated list of audio for each **Chat** within the specified **Chat Group**. For more details, see our guide on audio reconstruction [here](/docs/speech-to-speech-evi/faq#can-i-access-the-audio-of-previous-conversations-with-evi).

        Parameters
        ----------
        id : str
            Identifier for a Chat Group. Formatted as a UUID.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnChatGroupPagedAudioReconstructions
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.chat_groups.get_audio(
            id="369846cf-6ad5-404d-905e-a8acb5cdfc78",
            page_number=0,
            page_size=10,
            ascending_order=True,
        )
        """
        _response = self._raw_client.get_audio(
            id,
            page_number=page_number,
            page_size=page_size,
            ascending_order=ascending_order,
            request_options=request_options,
        )
        return _response.data


class AsyncChatGroupsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawChatGroupsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawChatGroupsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawChatGroupsClient
        """
        return self._raw_client

    async def list_chat_groups(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        config_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ReturnChatGroup]:
        """
        Fetches a paginated list of **Chat Groups**.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        config_id : typing.Optional[str]
            The unique identifier for an EVI configuration.

            Filter Chat Groups to only include Chats that used this `config_id` in their most recent Chat.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ReturnChatGroup]
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.empathic_voice.chat_groups.list_chat_groups(
                page_number=0,
                page_size=1,
                ascending_order=True,
                config_id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list_chat_groups(
            page_number=page_number,
            page_size=page_size,
            ascending_order=ascending_order,
            config_id=config_id,
            request_options=request_options,
        )

    async def get_chat_group(
        self,
        id: str,
        *,
        page_size: typing.Optional[int] = None,
        page_number: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnChatGroupPagedChats:
        """
        Fetches a **ChatGroup** by ID, including a paginated list of **Chats** associated with the **ChatGroup**.

        Parameters
        ----------
        id : str
            Identifier for a Chat Group. Formatted as a UUID.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnChatGroupPagedChats
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.chat_groups.get_chat_group(
                id="697056f0-6c7e-487d-9bd8-9c19df79f05f",
                page_number=0,
                page_size=1,
                ascending_order=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_chat_group(
            id,
            page_size=page_size,
            page_number=page_number,
            ascending_order=ascending_order,
            request_options=request_options,
        )
        return _response.data

    async def list_chat_group_events(
        self,
        id: str,
        *,
        page_size: typing.Optional[int] = None,
        page_number: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ReturnChatEvent]:
        """
        Fetches a paginated list of **Chat** events associated with a **Chat Group**.

        Parameters
        ----------
        id : str
            Identifier for a Chat Group. Formatted as a UUID.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ReturnChatEvent]
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.empathic_voice.chat_groups.list_chat_group_events(
                id="697056f0-6c7e-487d-9bd8-9c19df79f05f",
                page_number=0,
                page_size=3,
                ascending_order=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list_chat_group_events(
            id,
            page_size=page_size,
            page_number=page_number,
            ascending_order=ascending_order,
            request_options=request_options,
        )

    async def get_audio(
        self,
        id: str,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnChatGroupPagedAudioReconstructions:
        """
        Fetches a paginated list of audio for each **Chat** within the specified **Chat Group**. For more details, see our guide on audio reconstruction [here](/docs/speech-to-speech-evi/faq#can-i-access-the-audio-of-previous-conversations-with-evi).

        Parameters
        ----------
        id : str
            Identifier for a Chat Group. Formatted as a UUID.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnChatGroupPagedAudioReconstructions
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.chat_groups.get_audio(
                id="369846cf-6ad5-404d-905e-a8acb5cdfc78",
                page_number=0,
                page_size=10,
                ascending_order=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_audio(
            id,
            page_number=page_number,
            page_size=page_size,
            ascending_order=ascending_order,
            request_options=request_options,
        )
        return _response.data
