# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ..types.posted_builtin_tool import PostedBuiltinTool
from ..types.posted_config_prompt_spec import PostedConfigPromptSpec
from ..types.posted_ellm_model import PostedEllmModel
from ..types.posted_event_message_specs import PostedEventMessageSpecs
from ..types.posted_language_model import PostedLanguageModel
from ..types.posted_nudge_spec import PostedNudgeSpec
from ..types.posted_timeout_specs import PostedTimeoutSpecs
from ..types.posted_user_defined_tool_spec import PostedUserDefinedToolSpec
from ..types.posted_webhook_spec import PostedWebhookSpec
from ..types.return_config import ReturnConfig
from ..types.voice_ref import VoiceRef
from .raw_client import AsyncRawConfigsClient, RawConfigsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ConfigsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConfigsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawConfigsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConfigsClient
        """
        return self._raw_client

    def list_configs(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ReturnConfig]:
        """
        Fetches a paginated list of **Configs**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            By default, `restrict_to_most_recent` is set to true, returning only the latest version of each tool. To include all versions of each tool in the list, set `restrict_to_most_recent` to false.

        name : typing.Optional[str]
            Filter to only include configs with this name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ReturnConfig]
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        response = client.empathic_voice.configs.list_configs(
            page_number=0,
            page_size=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_configs(
            page_number=page_number,
            page_size=page_size,
            restrict_to_most_recent=restrict_to_most_recent,
            name=name,
            request_options=request_options,
        )

    def create_config(
        self,
        *,
        evi_version: str,
        name: str,
        version_description: typing.Optional[str] = OMIT,
        prompt: typing.Optional[PostedConfigPromptSpec] = OMIT,
        voice: typing.Optional[VoiceRef] = OMIT,
        language_model: typing.Optional[PostedLanguageModel] = OMIT,
        ellm_model: typing.Optional[PostedEllmModel] = OMIT,
        tools: typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]] = OMIT,
        builtin_tools: typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]] = OMIT,
        event_messages: typing.Optional[PostedEventMessageSpecs] = OMIT,
        nudges: typing.Optional[PostedNudgeSpec] = OMIT,
        timeouts: typing.Optional[PostedTimeoutSpecs] = OMIT,
        webhooks: typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnConfig:
        """
        Creates a **Config** which can be applied to EVI.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        evi_version : str
            EVI version to use. Only version `3` is supported.

        name : str
            Name applied to all versions of a particular Config.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        prompt : typing.Optional[PostedConfigPromptSpec]

        voice : typing.Optional[VoiceRef]
            A voice specification associated with this Config.

        language_model : typing.Optional[PostedLanguageModel]
            The supplemental language model associated with this Config.

            This model is used to generate longer, more detailed responses from EVI. Choosing an appropriate supplemental language model for your use case is crucial for generating fast, high-quality responses from EVI.

        ellm_model : typing.Optional[PostedEllmModel]
            The eLLM setup associated with this Config.

            Hume's eLLM (empathic Large Language Model) is a multimodal language model that takes into account both expression measures and language. The eLLM generates short, empathic language responses and guides text-to-speech (TTS) prosody.

        tools : typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]]
            List of user-defined tools associated with this Config.

        builtin_tools : typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]]
            List of built-in tools associated with this Config.

        event_messages : typing.Optional[PostedEventMessageSpecs]

        nudges : typing.Optional[PostedNudgeSpec]
            Configures nudges, brief audio prompts that can guide conversations when users pause or need encouragement to continue speaking. Nudges help create more natural, flowing interactions by providing gentle conversational cues.

        timeouts : typing.Optional[PostedTimeoutSpecs]

        webhooks : typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]]
            Webhook config specifications for each subscriber.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnConfig
            Created

        Examples
        --------
        from hume import HumeClient
        from hume.empathic_voice import (
            PostedConfigPromptSpec,
            PostedEventMessageSpec,
            PostedEventMessageSpecs,
            PostedLanguageModel,
            VoiceName,
        )

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.configs.create_config(
            name="Weather Assistant Config",
            prompt=PostedConfigPromptSpec(
                id="af699d45-2985-42cc-91b9-af9e5da3bac5",
                version=0,
            ),
            evi_version="3",
            voice=VoiceName(
                provider="HUME_AI",
                name="Ava Song",
            ),
            language_model=PostedLanguageModel(
                model_provider="ANTHROPIC",
                model_resource="claude-3-7-sonnet-latest",
                temperature=1.0,
            ),
            event_messages=PostedEventMessageSpecs(
                on_new_chat=PostedEventMessageSpec(
                    enabled=False,
                    text="",
                ),
                on_inactivity_timeout=PostedEventMessageSpec(
                    enabled=False,
                    text="",
                ),
                on_max_duration_timeout=PostedEventMessageSpec(
                    enabled=False,
                    text="",
                ),
            ),
        )
        """
        _response = self._raw_client.create_config(
            evi_version=evi_version,
            name=name,
            version_description=version_description,
            prompt=prompt,
            voice=voice,
            language_model=language_model,
            ellm_model=ellm_model,
            tools=tools,
            builtin_tools=builtin_tools,
            event_messages=event_messages,
            nudges=nudges,
            timeouts=timeouts,
            webhooks=webhooks,
            request_options=request_options,
        )
        return _response.data

    def list_config_versions(
        self,
        id: str,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ReturnConfig]:
        """
        Fetches a list of a **Config's** versions.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            By default, `restrict_to_most_recent` is set to true, returning only the latest version of each config. To include all versions of each config in the list, set `restrict_to_most_recent` to false.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ReturnConfig]
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        response = client.empathic_voice.configs.list_config_versions(
            id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_config_versions(
            id,
            page_number=page_number,
            page_size=page_size,
            restrict_to_most_recent=restrict_to_most_recent,
            request_options=request_options,
        )

    def create_config_version(
        self,
        id: str,
        *,
        evi_version: str,
        version_description: typing.Optional[str] = OMIT,
        prompt: typing.Optional[PostedConfigPromptSpec] = OMIT,
        voice: typing.Optional[VoiceRef] = OMIT,
        language_model: typing.Optional[PostedLanguageModel] = OMIT,
        ellm_model: typing.Optional[PostedEllmModel] = OMIT,
        tools: typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]] = OMIT,
        builtin_tools: typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]] = OMIT,
        event_messages: typing.Optional[PostedEventMessageSpecs] = OMIT,
        timeouts: typing.Optional[PostedTimeoutSpecs] = OMIT,
        nudges: typing.Optional[PostedNudgeSpec] = OMIT,
        webhooks: typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnConfig:
        """
        Updates a **Config** by creating a new version of the **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        evi_version : str
            The version of the EVI used with this config.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        prompt : typing.Optional[PostedConfigPromptSpec]

        voice : typing.Optional[VoiceRef]
            A voice specification associated with this Config version.

        language_model : typing.Optional[PostedLanguageModel]
            The supplemental language model associated with this Config version.

            This model is used to generate longer, more detailed responses from EVI. Choosing an appropriate supplemental language model for your use case is crucial for generating fast, high-quality responses from EVI.

        ellm_model : typing.Optional[PostedEllmModel]
            The eLLM setup associated with this Config version.

            Hume's eLLM (empathic Large Language Model) is a multimodal language model that takes into account both expression measures and language. The eLLM generates short, empathic language responses and guides text-to-speech (TTS) prosody.

        tools : typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]]
            List of user-defined tools associated with this Config version.

        builtin_tools : typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]]
            List of built-in tools associated with this Config version.

        event_messages : typing.Optional[PostedEventMessageSpecs]

        timeouts : typing.Optional[PostedTimeoutSpecs]

        nudges : typing.Optional[PostedNudgeSpec]

        webhooks : typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]]
            Webhook config specifications for each subscriber.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnConfig
            Created

        Examples
        --------
        from hume import HumeClient
        from hume.empathic_voice import (
            PostedConfigPromptSpec,
            PostedEllmModel,
            PostedEventMessageSpec,
            PostedEventMessageSpecs,
            PostedLanguageModel,
            VoiceName,
        )

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.configs.create_config_version(
            id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
            version_description="This is an updated version of the Weather Assistant Config.",
            evi_version="3",
            prompt=PostedConfigPromptSpec(
                id="af699d45-2985-42cc-91b9-af9e5da3bac5",
                version=0,
            ),
            voice=VoiceName(
                provider="HUME_AI",
                name="Ava Song",
            ),
            language_model=PostedLanguageModel(
                model_provider="ANTHROPIC",
                model_resource="claude-3-7-sonnet-latest",
                temperature=1.0,
            ),
            ellm_model=PostedEllmModel(
                allow_short_responses=True,
            ),
            event_messages=PostedEventMessageSpecs(
                on_new_chat=PostedEventMessageSpec(
                    enabled=False,
                    text="",
                ),
                on_inactivity_timeout=PostedEventMessageSpec(
                    enabled=False,
                    text="",
                ),
                on_max_duration_timeout=PostedEventMessageSpec(
                    enabled=False,
                    text="",
                ),
            ),
        )
        """
        _response = self._raw_client.create_config_version(
            id,
            evi_version=evi_version,
            version_description=version_description,
            prompt=prompt,
            voice=voice,
            language_model=language_model,
            ellm_model=ellm_model,
            tools=tools,
            builtin_tools=builtin_tools,
            event_messages=event_messages,
            timeouts=timeouts,
            nudges=nudges,
            webhooks=webhooks,
            request_options=request_options,
        )
        return _response.data

    def delete_config(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a **Config** and its versions.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.configs.delete_config(
            id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
        )
        """
        _response = self._raw_client.delete_config(id, request_options=request_options)
        return _response.data

    def update_config_name(self, id: str, *, name: str, request_options: typing.Optional[RequestOptions] = None) -> str:
        """
        Updates the name of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        name : str
            Name applied to all versions of a particular Config.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.configs.update_config_name(
            id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
            name="Updated Weather Assistant Config Name",
        )
        """
        _response = self._raw_client.update_config_name(id, name=name, request_options=request_options)
        return _response.data

    def get_config_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReturnConfig:
        """
        Fetches a specified version of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnConfig
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.configs.get_config_version(
            id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
            version=1,
        )
        """
        _response = self._raw_client.get_config_version(id, version, request_options=request_options)
        return _response.data

    def delete_config_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes a specified version of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.configs.delete_config_version(
            id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
            version=1,
        )
        """
        _response = self._raw_client.delete_config_version(id, version, request_options=request_options)
        return _response.data

    def update_config_description(
        self,
        id: str,
        version: int,
        *,
        version_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnConfig:
        """
        Updates the description of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnConfig
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.configs.update_config_description(
            id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
            version=1,
            version_description="This is an updated version_description.",
        )
        """
        _response = self._raw_client.update_config_description(
            id, version, version_description=version_description, request_options=request_options
        )
        return _response.data


class AsyncConfigsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConfigsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawConfigsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConfigsClient
        """
        return self._raw_client

    async def list_configs(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ReturnConfig]:
        """
        Fetches a paginated list of **Configs**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            By default, `restrict_to_most_recent` is set to true, returning only the latest version of each tool. To include all versions of each tool in the list, set `restrict_to_most_recent` to false.

        name : typing.Optional[str]
            Filter to only include configs with this name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ReturnConfig]
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.empathic_voice.configs.list_configs(
                page_number=0,
                page_size=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list_configs(
            page_number=page_number,
            page_size=page_size,
            restrict_to_most_recent=restrict_to_most_recent,
            name=name,
            request_options=request_options,
        )

    async def create_config(
        self,
        *,
        evi_version: str,
        name: str,
        version_description: typing.Optional[str] = OMIT,
        prompt: typing.Optional[PostedConfigPromptSpec] = OMIT,
        voice: typing.Optional[VoiceRef] = OMIT,
        language_model: typing.Optional[PostedLanguageModel] = OMIT,
        ellm_model: typing.Optional[PostedEllmModel] = OMIT,
        tools: typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]] = OMIT,
        builtin_tools: typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]] = OMIT,
        event_messages: typing.Optional[PostedEventMessageSpecs] = OMIT,
        nudges: typing.Optional[PostedNudgeSpec] = OMIT,
        timeouts: typing.Optional[PostedTimeoutSpecs] = OMIT,
        webhooks: typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnConfig:
        """
        Creates a **Config** which can be applied to EVI.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        evi_version : str
            EVI version to use. Only version `3` is supported.

        name : str
            Name applied to all versions of a particular Config.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        prompt : typing.Optional[PostedConfigPromptSpec]

        voice : typing.Optional[VoiceRef]
            A voice specification associated with this Config.

        language_model : typing.Optional[PostedLanguageModel]
            The supplemental language model associated with this Config.

            This model is used to generate longer, more detailed responses from EVI. Choosing an appropriate supplemental language model for your use case is crucial for generating fast, high-quality responses from EVI.

        ellm_model : typing.Optional[PostedEllmModel]
            The eLLM setup associated with this Config.

            Hume's eLLM (empathic Large Language Model) is a multimodal language model that takes into account both expression measures and language. The eLLM generates short, empathic language responses and guides text-to-speech (TTS) prosody.

        tools : typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]]
            List of user-defined tools associated with this Config.

        builtin_tools : typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]]
            List of built-in tools associated with this Config.

        event_messages : typing.Optional[PostedEventMessageSpecs]

        nudges : typing.Optional[PostedNudgeSpec]
            Configures nudges, brief audio prompts that can guide conversations when users pause or need encouragement to continue speaking. Nudges help create more natural, flowing interactions by providing gentle conversational cues.

        timeouts : typing.Optional[PostedTimeoutSpecs]

        webhooks : typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]]
            Webhook config specifications for each subscriber.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnConfig
            Created

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient
        from hume.empathic_voice import (
            PostedConfigPromptSpec,
            PostedEventMessageSpec,
            PostedEventMessageSpecs,
            PostedLanguageModel,
            VoiceName,
        )

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.configs.create_config(
                name="Weather Assistant Config",
                prompt=PostedConfigPromptSpec(
                    id="af699d45-2985-42cc-91b9-af9e5da3bac5",
                    version=0,
                ),
                evi_version="3",
                voice=VoiceName(
                    provider="HUME_AI",
                    name="Ava Song",
                ),
                language_model=PostedLanguageModel(
                    model_provider="ANTHROPIC",
                    model_resource="claude-3-7-sonnet-latest",
                    temperature=1.0,
                ),
                event_messages=PostedEventMessageSpecs(
                    on_new_chat=PostedEventMessageSpec(
                        enabled=False,
                        text="",
                    ),
                    on_inactivity_timeout=PostedEventMessageSpec(
                        enabled=False,
                        text="",
                    ),
                    on_max_duration_timeout=PostedEventMessageSpec(
                        enabled=False,
                        text="",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_config(
            evi_version=evi_version,
            name=name,
            version_description=version_description,
            prompt=prompt,
            voice=voice,
            language_model=language_model,
            ellm_model=ellm_model,
            tools=tools,
            builtin_tools=builtin_tools,
            event_messages=event_messages,
            nudges=nudges,
            timeouts=timeouts,
            webhooks=webhooks,
            request_options=request_options,
        )
        return _response.data

    async def list_config_versions(
        self,
        id: str,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ReturnConfig]:
        """
        Fetches a list of a **Config's** versions.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            By default, `restrict_to_most_recent` is set to true, returning only the latest version of each config. To include all versions of each config in the list, set `restrict_to_most_recent` to false.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ReturnConfig]
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.empathic_voice.configs.list_config_versions(
                id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list_config_versions(
            id,
            page_number=page_number,
            page_size=page_size,
            restrict_to_most_recent=restrict_to_most_recent,
            request_options=request_options,
        )

    async def create_config_version(
        self,
        id: str,
        *,
        evi_version: str,
        version_description: typing.Optional[str] = OMIT,
        prompt: typing.Optional[PostedConfigPromptSpec] = OMIT,
        voice: typing.Optional[VoiceRef] = OMIT,
        language_model: typing.Optional[PostedLanguageModel] = OMIT,
        ellm_model: typing.Optional[PostedEllmModel] = OMIT,
        tools: typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]] = OMIT,
        builtin_tools: typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]] = OMIT,
        event_messages: typing.Optional[PostedEventMessageSpecs] = OMIT,
        timeouts: typing.Optional[PostedTimeoutSpecs] = OMIT,
        nudges: typing.Optional[PostedNudgeSpec] = OMIT,
        webhooks: typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnConfig:
        """
        Updates a **Config** by creating a new version of the **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        evi_version : str
            The version of the EVI used with this config.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        prompt : typing.Optional[PostedConfigPromptSpec]

        voice : typing.Optional[VoiceRef]
            A voice specification associated with this Config version.

        language_model : typing.Optional[PostedLanguageModel]
            The supplemental language model associated with this Config version.

            This model is used to generate longer, more detailed responses from EVI. Choosing an appropriate supplemental language model for your use case is crucial for generating fast, high-quality responses from EVI.

        ellm_model : typing.Optional[PostedEllmModel]
            The eLLM setup associated with this Config version.

            Hume's eLLM (empathic Large Language Model) is a multimodal language model that takes into account both expression measures and language. The eLLM generates short, empathic language responses and guides text-to-speech (TTS) prosody.

        tools : typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]]
            List of user-defined tools associated with this Config version.

        builtin_tools : typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]]
            List of built-in tools associated with this Config version.

        event_messages : typing.Optional[PostedEventMessageSpecs]

        timeouts : typing.Optional[PostedTimeoutSpecs]

        nudges : typing.Optional[PostedNudgeSpec]

        webhooks : typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]]
            Webhook config specifications for each subscriber.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnConfig
            Created

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient
        from hume.empathic_voice import (
            PostedConfigPromptSpec,
            PostedEllmModel,
            PostedEventMessageSpec,
            PostedEventMessageSpecs,
            PostedLanguageModel,
            VoiceName,
        )

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.configs.create_config_version(
                id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
                version_description="This is an updated version of the Weather Assistant Config.",
                evi_version="3",
                prompt=PostedConfigPromptSpec(
                    id="af699d45-2985-42cc-91b9-af9e5da3bac5",
                    version=0,
                ),
                voice=VoiceName(
                    provider="HUME_AI",
                    name="Ava Song",
                ),
                language_model=PostedLanguageModel(
                    model_provider="ANTHROPIC",
                    model_resource="claude-3-7-sonnet-latest",
                    temperature=1.0,
                ),
                ellm_model=PostedEllmModel(
                    allow_short_responses=True,
                ),
                event_messages=PostedEventMessageSpecs(
                    on_new_chat=PostedEventMessageSpec(
                        enabled=False,
                        text="",
                    ),
                    on_inactivity_timeout=PostedEventMessageSpec(
                        enabled=False,
                        text="",
                    ),
                    on_max_duration_timeout=PostedEventMessageSpec(
                        enabled=False,
                        text="",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_config_version(
            id,
            evi_version=evi_version,
            version_description=version_description,
            prompt=prompt,
            voice=voice,
            language_model=language_model,
            ellm_model=ellm_model,
            tools=tools,
            builtin_tools=builtin_tools,
            event_messages=event_messages,
            timeouts=timeouts,
            nudges=nudges,
            webhooks=webhooks,
            request_options=request_options,
        )
        return _response.data

    async def delete_config(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a **Config** and its versions.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.configs.delete_config(
                id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_config(id, request_options=request_options)
        return _response.data

    async def update_config_name(
        self, id: str, *, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> str:
        """
        Updates the name of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        name : str
            Name applied to all versions of a particular Config.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.configs.update_config_name(
                id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
                name="Updated Weather Assistant Config Name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_config_name(id, name=name, request_options=request_options)
        return _response.data

    async def get_config_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReturnConfig:
        """
        Fetches a specified version of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnConfig
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.configs.get_config_version(
                id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
                version=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_config_version(id, version, request_options=request_options)
        return _response.data

    async def delete_config_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes a specified version of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.configs.delete_config_version(
                id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
                version=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_config_version(id, version, request_options=request_options)
        return _response.data

    async def update_config_description(
        self,
        id: str,
        version: int,
        *,
        version_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnConfig:
        """
        Updates the description of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnConfig
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.configs.update_config_description(
                id="1b60e1a0-cc59-424a-8d2c-189d354db3f3",
                version=1,
                version_description="This is an updated version_description.",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_config_description(
            id, version, version_description=version_description, request_options=request_options
        )
        return _response.data
