# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .chat_message import ChatMessage
from .inference import Inference


class AssistantMessage(UniversalBaseModel):
    """
    When provided, the output is an assistant message.
    """

    type: typing.Literal["assistant_message"] = pydantic.Field(default="assistant_message")
    """
    The type of message sent through the socket; for an Assistant Message, this must be `assistant_message`.
    
    This message contains both a transcript of the assistant's response and the expression measurement predictions of the assistant's audio output.
    """

    custom_session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Used to manage conversational state, correlate frontend and backend data, and persist conversations across EVI sessions.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the assistant message. Allows the Assistant Message to be tracked and referenced.
    """

    message: ChatMessage = pydantic.Field()
    """
    Transcript of the message.
    """

    models: Inference = pydantic.Field()
    """
    Inference model results.
    """

    from_text: bool = pydantic.Field()
    """
    Indicates if this message was inserted into the conversation as text from an [Assistant Input message](/reference/speech-to-speech-evi/chat#send.AssistantInput.text).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
