# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .inference import Inference


class AssistantProsody(UniversalBaseModel):
    """
    When provided, the output is an Assistant Prosody message.
    """

    type: typing.Literal["assistant_prosody"] = pydantic.Field(default="assistant_prosody")
    """
    The type of message sent through the socket; for an Assistant Prosody message, this must be `assistant_PROSODY`.
    
    This message the expression measurement predictions of the assistant's audio output.
    """

    custom_session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Used to manage conversational state, correlate frontend and backend data, and persist conversations across EVI sessions.
    """

    models: Inference = pydantic.Field()
    """
    Inference model results.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier for the segment.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
