# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ChatMetadata(UniversalBaseModel):
    """
    When provided, the output is a chat metadata message.
    """

    type: typing.Literal["chat_metadata"] = pydantic.Field(default="chat_metadata")
    """
    The type of message sent through the socket; for a Chat Metadata message, this must be `chat_metadata`.
    
    The Chat Metadata message is the first message you receive after establishing a connection with EVI and contains important identifiers for the current Chat session.
    """

    custom_session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Used to manage conversational state, correlate frontend and backend data, and persist conversations across EVI sessions.
    """

    chat_group_id: str = pydantic.Field()
    """
    ID of the Chat Group.
    
    Used to resume a Chat when passed in the [resumed_chat_group_id](/reference/speech-to-speech-evi/chat#request.query.resumed_chat_group_id) query parameter of a subsequent connection request. This allows EVI to continue the conversation from where it left off within the Chat Group.
    
    Learn more about [supporting chat resumability](/docs/speech-to-speech-evi/faq#does-evi-support-chat-resumability) from the EVI FAQ.
    """

    chat_id: str = pydantic.Field()
    """
    ID of the Chat session. Allows the Chat session to be tracked and referenced.
    """

    request_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the initiating request.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
