# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .posted_builtin_tool_name import PostedBuiltinToolName


class PostedBuiltinTool(UniversalBaseModel):
    """
    A configuration of a built-in tool to be posted to the server
    """

    name: PostedBuiltinToolName = pydantic.Field()
    """
    Name of the built-in tool to use. Hume supports the following built-in tools:
    
    - **web_search:** enables EVI to search the web for up-to-date information when applicable.
    - **hang_up:** closes the WebSocket connection when appropriate (e.g., after detecting a farewell in the conversation).
    
    For more information, see our guide on [using built-in tools](/docs/speech-to-speech-evi/features/tool-use#using-built-in-tools).
    """

    fallback_content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional text passed to the supplemental LLM in place of the tool call result. The LLM then uses this text to generate a response back to the user, ensuring continuity in the conversation if the Tool errors.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
