# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .language_model_type import LanguageModelType
from .model_provider_enum import ModelProviderEnum


class PostedLanguageModel(UniversalBaseModel):
    """
    A LanguageModel to be posted to the server
    """

    model_provider: typing.Optional[ModelProviderEnum] = pydantic.Field(default=None)
    """
    The provider of the supplemental language model.
    """

    model_resource: typing.Optional[LanguageModelType] = pydantic.Field(default=None)
    """
    String that specifies the language model to use with `model_provider`.
    """

    temperature: typing.Optional[float] = pydantic.Field(default=None)
    """
    The model temperature, with values between 0 to 1 (inclusive).
    
    Controls the randomness of the LLM's output, with values closer to 0 yielding focused, deterministic responses and values closer to 1 producing more creative, diverse responses.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
