# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .return_builtin_tool_tool_type import ReturnBuiltinToolToolType


class ReturnBuiltinTool(UniversalBaseModel):
    """
    A specific builtin tool version returned from the server
    """

    tool_type: ReturnBuiltinToolToolType = pydantic.Field()
    """
    Type of Tool. Either `BUILTIN` for natively implemented tools, like web search, or `FUNCTION` for user-defined tools.
    """

    name: str = pydantic.Field()
    """
    Name applied to all versions of a particular Tool.
    """

    fallback_content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional text passed to the supplemental LLM in place of the tool call result. The LLM then uses this text to generate a response back to the user, ensuring continuity in the conversation if the Tool errors.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
