# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .return_chat_audio_reconstruction_status import ReturnChatAudioReconstructionStatus


class ReturnChatAudioReconstruction(UniversalBaseModel):
    """
    List of chat audio reconstructions returned for the specified page number and page size.
    """

    id: str = pydantic.Field()
    """
    Identifier for the chat. Formatted as a UUID.
    """

    user_id: str = pydantic.Field()
    """
    Identifier for the user that owns this chat. Formatted as a UUID.
    """

    status: ReturnChatAudioReconstructionStatus = pydantic.Field()
    """
    Indicates the current state of the audio reconstruction job. There are five possible statuses:
    
    - `QUEUED`: The reconstruction job is waiting to be processed.
    
    - `IN_PROGRESS`: The reconstruction is currently being processed.
    
    - `COMPLETE`: The audio reconstruction is finished and ready for download.
    
    - `ERROR`: An error occurred during the reconstruction process.
    
    - `CANCELED`: The reconstruction job has been canceled.
    """

    filename: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the chat audio reconstruction file.
    """

    modified_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The timestamp of the most recent status change for this audio reconstruction, formatted milliseconds since the Unix epoch.
    """

    signed_audio_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Signed URL used to download the chat audio reconstruction file.
    """

    signed_url_expiration_timestamp_millis: typing.Optional[int] = pydantic.Field(default=None)
    """
    The timestamp when the signed URL will expire, formatted as a Unix epoch milliseconds.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
