# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .return_chat_audio_reconstruction import ReturnChatAudioReconstruction
from .return_chat_group_paged_audio_reconstructions_pagination_direction import (
    ReturnChatGroupPagedAudioReconstructionsPaginationDirection,
)


class ReturnChatGroupPagedAudioReconstructions(UniversalBaseModel):
    """
    A paginated list of chat reconstructions for a particular chatgroup
    """

    id: str = pydantic.Field()
    """
    Identifier for the chat group. Formatted as a UUID.
    """

    user_id: str = pydantic.Field()
    """
    Identifier for the user that owns this chat. Formatted as a UUID.
    """

    num_chats: int = pydantic.Field()
    """
    Total number of chats in this chatgroup
    """

    page_number: int = pydantic.Field()
    """
    The page number of the returned list.
    
    This value corresponds to the `page_number` parameter specified in the request. Pagination uses zero-based indexing.
    """

    page_size: int = pydantic.Field()
    """
    The maximum number of items returned per page.
    
    This value corresponds to the `page_size` parameter specified in the request.
    """

    total_pages: int = pydantic.Field()
    """
    The total number of pages in the collection.
    """

    pagination_direction: ReturnChatGroupPagedAudioReconstructionsPaginationDirection = pydantic.Field()
    """
    Indicates the order in which the paginated results are presented, based on their creation date.
    
    It shows `ASC` for ascending order (chronological, with the oldest records first) or `DESC` for descending order (reverse-chronological, with the newest records first). This value corresponds to the `ascending_order` query parameter used in the request.
    """

    audio_reconstructions_page: typing.List[ReturnChatAudioReconstruction] = pydantic.Field()
    """
    List of chat audio reconstructions returned for the specified page number and page size.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
