# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ReturnEllmModel(UniversalBaseModel):
    """
    A specific eLLM Model configuration
    """

    allow_short_responses: bool = pydantic.Field()
    """
    Boolean indicating if the eLLM is allowed to generate short responses.
    
    If omitted, short responses from the eLLM are enabled by default.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
