# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .return_webhook_event_type import ReturnWebhookEventType


class ReturnWebhookSpec(UniversalBaseModel):
    """
    Collection of webhook URL endpoints to be returned from the server
    """

    url: str = pydantic.Field()
    """
    The URL where event payloads will be sent. This must be a valid https URL to ensure secure communication. The server at this URL must accept POST requests with a JSON payload.
    """

    events: typing.List[ReturnWebhookEventType] = pydantic.Field()
    """
    The list of events the specified URL is subscribed to. 
    
    See our [webhooks guide](/docs/speech-to-speech-evi/configuration/build-a-configuration#supported-events) for more information on supported events.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
