# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .bounding_box import BoundingBox
from .descriptions_score import DescriptionsScore
from .emotion_score import EmotionScore
from .facs_score import FacsScore


class FacePrediction(UniversalBaseModel):
    frame: int = pydantic.Field()
    """
    Frame number
    """

    time: float = pydantic.Field()
    """
    Time in seconds when face detection occurred.
    """

    prob: float = pydantic.Field()
    """
    The predicted probability that a detected face was actually a face.
    """

    box: BoundingBox
    emotions: typing.List[EmotionScore] = pydantic.Field()
    """
    A high-dimensional embedding in emotion space.
    """

    facs: typing.Optional[typing.List[FacsScore]] = pydantic.Field(default=None)
    """
    FACS 2.0 features and their scores.
    """

    descriptions: typing.Optional[typing.List[DescriptionsScore]] = pydantic.Field(default=None)
    """
    Modality-specific descriptive features and their scores.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
