# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .granularity import Granularity
from .unconfigurable import Unconfigurable


class Language(UniversalBaseModel):
    """
    The Emotional Language model analyzes passages of text. This also supports audio and video files by transcribing and then directly analyzing the transcribed text.

    Recommended input filetypes: `.txt`, `.mp3`, `.wav`, `.mp4`
    """

    granularity: typing.Optional[Granularity] = None
    sentiment: typing.Optional[Unconfigurable] = None
    toxicity: typing.Optional[Unconfigurable] = None
    identify_speakers: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to return identifiers for speakers over time. If `true`, unique identifiers will be assigned to spoken words to differentiate different speakers. If `false`, all speakers will be tagged with an `unknown` ID.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
