# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .emotion_score import EmotionScore
from .position_interval import PositionInterval
from .time_interval import TimeInterval


class NerPrediction(UniversalBaseModel):
    entity: str = pydantic.Field()
    """
    The recognized topic or entity.
    """

    position: PositionInterval
    entity_confidence: float = pydantic.Field()
    """
    Our NER model's relative confidence in the recognized topic or entity.
    """

    support: float = pydantic.Field()
    """
    A measure of how often the entity is linked to by other entities.
    """

    uri: str = pydantic.Field()
    """
    A URL which provides more information about the recognized topic or entity.
    """

    link_word: str = pydantic.Field()
    """
    The specific word to which the emotion predictions are linked.
    """

    time: typing.Optional[TimeInterval] = None
    confidence: typing.Optional[float] = pydantic.Field(default=None)
    """
    Value between `0.0` and `1.0` that indicates our transcription model's relative confidence in this text.
    """

    speaker_confidence: typing.Optional[float] = pydantic.Field(default=None)
    """
    Value between `0.0` and `1.0` that indicates our transcription model's relative confidence that this text was spoken by this speaker.
    """

    emotions: typing.List[EmotionScore] = pydantic.Field()
    """
    A high-dimensional embedding in emotion space.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
