# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from .....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class StreamLanguage(UniversalBaseModel):
    """
    Configuration for the language emotion model.
    """

    sentiment: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Configuration for sentiment predictions. If missing or null, no sentiment predictions will be generated.
    """

    toxicity: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Configuration for toxicity predictions. If missing or null, no toxicity predictions will be generated.
    """

    granularity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The granularity at which to generate predictions. Values are `word`, `sentence`, `utterance`, or `passage`. To get a single prediction for the entire text of your streaming payload use `passage`. Default value is `word`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
