# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TextPosition(UniversalBaseModel):
    """
    Position of a segment of text within a larger document, measured in characters. Uses zero-based indexing. The beginning index is inclusive and the end index is exclusive.
    """

    begin: typing.Optional[float] = pydantic.Field(default=None)
    """
    The index of the first character in the text segment, inclusive.
    """

    end: typing.Optional[float] = pydantic.Field(default=None)
    """
    The index of the last character in the text segment, exclusive.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
