# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .format import Format
from .posted_context import PostedContext
from .posted_utterance import PostedUtterance


class PostedTts(UniversalBaseModel):
    context: typing.Optional[PostedContext] = pydantic.Field(default=None)
    """
    Utterances to use as context for generating consistent speech style and prosody across multiple requests. These will not be converted to speech output.
    """

    utterances: typing.List[PostedUtterance] = pydantic.Field()
    """
    A list of **Utterances** to be converted to speech output.
    
    An **Utterance** is a unit of input for [Octave](/docs/text-to-speech-tts/overview), and includes input `text`, an optional `description` to serve as the prompt for how the speech should be delivered, an optional `voice` specification, and additional controls to guide delivery for `speed` and `trailing_silence`.
    """

    num_generations: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of generations of the audio to produce.
    """

    format: typing.Optional[Format] = pydantic.Field(default=None)
    """
    Specifies the output audio file format.
    """

    split_utterances: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Controls how audio output is segmented in the response.
    
    - When **enabled** (`true`), input utterances are automatically split into natural-sounding speech segments.
    
    - When **disabled** (`false`), the response maintains a strict one-to-one mapping between input utterances and output snippets. 
    
    This setting affects how the `snippets` array is structured in the response, which may be important for applications that need to track the relationship between input text and generated audio segments. When setting to `false`, avoid including utterances with long `text`, as this can result in distorted output.
    """

    strip_headers: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If enabled, the audio for all the chunks of a generation, once concatenated together, will constitute a single audio file. Otherwise, if disabled, each chunk's audio will be its own audio file, each with its own headers (if applicable).
    """

    instant_mode: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enables ultra-low latency streaming, significantly reducing the time until the first audio chunk is received. Recommended for real-time applications requiring immediate audio playback. For further details, see our documentation on [instant mode](/docs/text-to-speech-tts/overview#ultra-low-latency-streaming-instant-mode). 
    - A [voice](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.utterances.voice) must be specified when instant mode is enabled. Dynamic voice generation is not supported with this mode.
    - Instant mode is only supported for streaming endpoints (e.g., [/v0/tts/stream/json](/reference/text-to-speech-tts/synthesize-json-streaming), [/v0/tts/stream/file](/reference/text-to-speech-tts/synthesize-file-streaming)).
    - Ensure only a single generation is requested ([num_generations](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.num_generations) must be `1` or omitted).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
