# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .posted_utterance_voice import PostedUtteranceVoice


class PublishTts(UniversalBaseModel):
    """
    Input message type for the TTS stream.
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    The input text to be converted to speech output.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Natural language instructions describing how the text should be spoken by the model (e.g., `"a soft, gentle voice with a strong British accent"`).
    """

    voice: typing.Optional[PostedUtteranceVoice] = pydantic.Field(default=None)
    """
    The name or ID of the voice from the `Voice Library` to be used as the speaker for this and all subsequent utterances, until the `"voice"` field is updated again.
    """

    speed: typing.Optional[float] = pydantic.Field(default=None)
    """
    A relative measure of how fast this utterance should be spoken.
    """

    trailing_silence: typing.Optional[float] = pydantic.Field(default=None)
    """
    Duration of trailing silence (in seconds) to add to this utterance
    """

    flush: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Force the generation of audio regardless of how much text has been supplied.
    """

    close: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Force the generation of audio and close the stream.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
