# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .voice_provider import VoiceProvider


class ReturnVoice(UniversalBaseModel):
    """
    An Octave voice available for text-to-speech
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the voice in the `Voice Library`.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the voice in the `Voice Library`.
    """

    provider: typing.Optional[VoiceProvider] = pydantic.Field(default=None)
    """
    The provider associated with the created voice.
    
    Voices created through this endpoint will always have the provider set to `CUSTOM_VOICE`, indicating a custom voice stored in your account.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
