Django Add Default Value
========================

Django Migration Operation that can be used to transfer a field's default value
to the database scheme.

[![](https://img.shields.io/pypi/v/django-add-default-value.svg?branch=master)](https://pypi.python.org/pypi/django-add-default-value/)
[![](https://img.shields.io/github/license/3yourmind/django-add-default-value.svg)](./LICENSE)
[![](https://img.shields.io/badge/PR-welcome-green.svg)](https://github.com/3YOURMIND/django-add-default-value/pulls)
[![](https://img.shields.io/badge/3YOURMIND-Hiring-brightgreen.svg)](https://www.3yourmind.com/career)
[![](https://img.shields.io/github/stars/3YOURMIND/django-add-default-value.svg?style=social&label=Stars)](https://github.com/3YOURMIND/django-add-default-value/stargazers)


Dependencies
------------

* MySQL (or compatible)
* PostgreSQL

Installation
------------
``pip install django-add-default-value``

You can then use ``AddDefaultValue`` in your migration file to transfer the default
values to your database. Afterwards, it's just the usual ``./manage.py migrate``.

Usage
-----

Add this manually to a autogenerated Migration, that adds a new fiels::

    AddDefaultValue(
        model_name='my_model',
        name='my_field',
        value='my_default'
    )


Example
-------

Given the following migration::

    operations = [
        migrations.AddField(
            field=models.CharField(default='my_default', max_length=255),
            model_name='my_model',
            name='my_field',
        ),
    ]

Modify the migration to add a default value::


    +from django_add_default_value import AddDefaultValue
    +
     operations = [
         migrations.AddField(
             field=models.CharField(default='my_default', max_length=255),
             model_name='my_model',
             name='my_field',
         ),
    +    AddDefaultValue(
    +        model_name='my_model',
    +        name='my_field',
    +        value='my_default'
    +    )
     ]

If you check ``python manage.py sqlmigrate [app name] [migration]``,
you will see that the default value now gets set.

Contributing
------------

First of all, thank you very much for contributing to this project. Please base
your work on the ``master`` branch and target ``master`` in your pull request.

License
-------

``django-add-default-value`` is released under the Apache 2.0 License.


